/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.AIRWriter;
import com.ibm.ws.webservices.wsdl.toJava.DuplicateFileException;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaFaultHelperWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaFaultWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;

public class JavaDefinitionWriter
implements Generator {
    protected Emitter emitter;
    protected Definition definition;
    protected SymbolTable symbolTable;
    private boolean isDeploy = false;
    private LinkedHashSet importedFiles = new LinkedHashSet();

    public JavaDefinitionWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean deployOnly) {
        this.isDeploy = deployOnly;
    }

    public void generate() throws IOException {
        if (this.emitter.getGenJava() != GenCriteria.NO) {
            this.writeFaults();
            if (this.emitter.generateResolver()) {
                new AIRWriter(this.emitter, this.definition, this.symbolTable).generate();
            }
        }
    }

    private void writeFaults() throws IOException {
        ArrayList faults = new ArrayList();
        this.collectFaults(this.definition, faults);
        LinkedHashSet<String> generatedFaults = new LinkedHashSet<String>();
        Iterator fi = faults.iterator();
        while (fi.hasNext()) {
            BindingFaultRefEntry faultRef = (BindingFaultRefEntry)fi.next();
            MessageEntry me = faultRef.getMessageEntry();
            SymTabEntry faultEntry = (SymTabEntry)me.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
            String name = faultEntry.getName();
            if (generatedFaults.contains(name)) continue;
            generatedFaults.add(name);
            Boolean complexVar = (Boolean)me.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
            boolean emitSimpleFault = me.isFault() && (complexVar == null || complexVar == false);
            if (!emitSimpleFault) continue;
            try {
                JavaClassWriter writer;
                if (this.emitter.getRole() != Role.DEPLOY_CLIENT && this.emitter.getRole() != Role.DEPLOY_SERVER) {
                    writer = new JavaFaultWriter(this.emitter, this.symbolTable, me);
                    writer.generate();
                }
                if (this.emitter.getRole() == Role.DEVELOP_CLIENT || this.emitter.getRole() == Role.DEVELOP_SERVER) continue;
                writer = new JavaFaultHelperWriter(this.emitter, this.symbolTable, me);
                writer.generate();
            }
            catch (DuplicateFileException dfe) {
                FFDCFilter.processException((Throwable)dfe, "com.ibm.ws.webservices.wsdl.toJava.JavaDefinitionWriter.writeFaults", "159", this);
                System.err.println(Messages.getMessage("fileExistError00", dfe.getFileName()));
            }
        }
    }

    private void collectFaults(Definition def, ArrayList faults) throws IOException {
        Map imports = def.getImports();
        Object[] importValues = imports.values().toArray();
        for (int i = 0; i < importValues.length; ++i) {
            Vector v = (Vector)importValues[i];
            for (int j = 0; j < v.size(); ++j) {
                Import imp2 = (Import)v.get(j);
                if (this.importedFiles.contains(imp2.getLocationURI())) continue;
                this.importedFiles.add(imp2.getLocationURI());
                Definition importDef = imp2.getDefinition();
                if (importDef == null) continue;
                this.collectFaults(importDef, faults);
            }
        }
        Map bindings = def.getBindings();
        Iterator bindi = bindings.values().iterator();
        while (bindi.hasNext()) {
            Binding binding = (Binding)bindi.next();
            BindingEntry entry = this.symbolTable.getBindingEntry(binding.getQName());
            if (!entry.isReferenced()) continue;
            Iterator opIter = entry.getOperations();
            while (opIter.hasNext()) {
                BindingOperationEntry boe = (BindingOperationEntry)opIter.next();
                for (int j = 0; j < boe.numFaults(); ++j) {
                    faults.add(boe.getFault(j));
                }
            }
        }
    }
}

