/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.enumtype.Scope;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.Parser;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.GeneratedFileInfo;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.JavaSearchCriteria;
import com.ibm.ws.webservices.wsdl.toJava.Namespaces;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Scenario;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Emitter
extends Parser {
    private static String binaryCopyright = Version.getBinaryCopyright();
    protected static Log log = LogFactory.getLog(Emitter.class.getName());
    protected HashMap namespaceMap = new HashMap();
    protected String typeMappingVersion = "1.1";
    protected BaseTypeMapping baseTypeMapping = null;
    protected Namespaces namespaces = null;
    protected String NStoPkgFilename = "NStoPkg.properties";
    protected File NStoPkgFile = null;
    MappingMetaData inputMMD = null;
    MappingMetaData outputMMD = null;
    private CustomRegistry customRegistry;
    private String inputMappingFile = null;
    private String altOutputMappingFile = null;
    private Role role = Role.DEVELOP_CLIENT;
    private Container container = Container.NONE;
    private GenCriteria genJava = GenCriteria.IFNOTEXISTS;
    private GenCriteria genXML = GenCriteria.IFNOTEXISTS;
    private JavaSearchCriteria javaSearch = JavaSearchCriteria.FILE;
    private Scenario scenario = Scenario.NORMAL;
    private boolean bEmitTestCase = false;
    private boolean bResolver = false;
    private boolean bGenerateAll = false;
    private Scope scope = null;
    private GeneratedFileInfo fileInfo = null;
    private HashMap delayedNamespacesMap = new HashMap();
    private String outputDir = null;
    private String javaOutputDir = null;
    private boolean noDataBinding = false;
    private boolean noWrappedArrays = false;
    private boolean noWrappedOperations = false;
    private LinkedHashSet servicesToWrite = null;
    private HashMap dynamicVars = new HashMap();
    private boolean introspect = false;
    private boolean allowRelativeNamespace = false;
    private String classpath = null;
    private boolean genEquals = false;
    private boolean genImplSer = false;
    boolean jsr101v11 = true;
    private static final String EXT_OPT_DELIMITERS = " ,;{}";
    private static final String REL_NS = "allowRelativeNamespace";
    private Properties XProperties = null;
    protected String propertiesFilename = "extraOptions.properties";
    private static HashMap validOptions = new HashMap();

    public Emitter() {
        this.outputMMD = new MappingMetaData();
        this.fileInfo = new GeneratedFileInfo();
        this.setFactory(new JavaGeneratorFactory(this));
    }

    public Emitter(boolean runtimeMode) {
        if (!runtimeMode) {
            this.outputMMD = new MappingMetaData();
            this.fileInfo = new GeneratedFileInfo();
        }
        this.setFactory(new JavaGeneratorFactory(this, runtimeMode));
    }

    public Object getDynamicVar(Object key) {
        return this.dynamicVars.get(key);
    }

    public void setDynamicVar(Object key, Object value) {
        this.dynamicVars.put(key, value);
    }

    public void addServicesToBeWritten(String service) {
        if (this.servicesToWrite == null) {
            this.servicesToWrite = new LinkedHashSet();
        }
        this.servicesToWrite.add(service);
    }

    public void setServicesToBeWritten(Set services) {
        this.servicesToWrite = services == null ? null : new LinkedHashSet(services);
    }

    public static HashMap getSupportedProperties() {
        return validOptions;
    }

    public void setMETA_INF_Only(boolean value) {
        if (value) {
            this.setGenJava("No");
            this.setGenXML("IfNotExists");
        }
    }

    public boolean getMETA_INF_Only() {
        return this.getGenJava() == GenCriteria.NO && this.getGenXML() == GenCriteria.IFNOTEXISTS;
    }

    public void setTestCaseWanted(boolean value) {
        this.bEmitTestCase = value;
    }

    public boolean isTestCaseWanted() {
        return this.bEmitTestCase;
    }

    public void setGenerateResolver(boolean value) {
        if (this.getResolver() == null) {
            this.bResolver = value;
        }
    }

    public boolean generateResolver() {
        return this.bResolver;
    }

    public void setResolver(String resolverClassName, boolean wsiCheck) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!this.bResolver) {
            super.setResolver(resolverClassName, wsiCheck);
        }
    }

    public void setAllWanted(boolean all) {
        this.bGenerateAll = all;
    }

    public boolean isAllWanted() {
        return this.bGenerateAll;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(HashMap namespacesMap) {
        this.namespaces = new Namespaces(this.getJavaOutputDir(), this.env);
        this.namespaces.putAll((Map)namespacesMap);
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public boolean setJavaSearch(String option) {
        if (option == null || option.length() == 0) {
            return false;
        }
        boolean acceptable = JavaSearchCriteria.isValid(option);
        this.javaSearch = JavaSearchCriteria.getJavaSearchCriteria(option, JavaSearchCriteria.FILE);
        return acceptable;
    }

    public JavaSearchCriteria getJavaSearch() {
        return this.javaSearch;
    }

    public void setJavaOutputDir(String javaOutputDir) {
        this.javaOutputDir = javaOutputDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getJavaOutputDir() {
        if (this.javaOutputDir != null) {
            return this.javaOutputDir;
        }
        return this.outputDir;
    }

    public void setNoDataBinding(boolean value) {
        this.noDataBinding = value;
    }

    public boolean getNoDataBinding() {
        return this.noDataBinding;
    }

    public void setNoWrappedArrays(boolean value) {
        this.noWrappedArrays = value;
    }

    public boolean getNoWrappedArrays() {
        return this.noWrappedArrays;
    }

    public void setNoWrappedOperations(boolean value) {
        this.noWrappedOperations = value;
    }

    public boolean getNoWrappedOperations() {
        return this.noWrappedOperations;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setNStoPkg(String NStoPkgFilename) {
        if (NStoPkgFilename != null) {
            this.NStoPkgFilename = NStoPkgFilename;
        }
    }

    public void setNStoPkg(File NStoPkgFile) {
        this.NStoPkgFile = NStoPkgFile;
    }

    public void setNamespaceMap(HashMap map) {
        this.delayedNamespacesMap = map;
    }

    public HashMap getNamespaceMap() {
        return this.delayedNamespacesMap;
    }

    public void setFactory(String factory) {
        try {
            this.setFactory((GeneratorFactory)ClassUtils.forName(factory).newInstance());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean setContainer(String option) {
        if (option == null || option.length() == 0) {
            return true;
        }
        if (option.equalsIgnoreCase("Bean") || option.equalsIgnoreCase("servlet")) {
            option = "WEB";
        }
        boolean acceptable = Container.isValid(option);
        this.container = Container.getContainer(option, Container.NONE);
        return acceptable;
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean setRole(String option) {
        if (option == null || option.length() == 0) {
            return true;
        }
        boolean acceptable = Role.isValid(option);
        this.role = Role.getRole(option, Role.DEVELOP_CLIENT);
        return acceptable;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean setGenJava(String option) {
        if (option == null || option.length() == 0) {
            return true;
        }
        boolean acceptable = GenCriteria.isValid(option);
        this.genJava = GenCriteria.getGenCriteria(option, GenCriteria.IFNOTEXISTS);
        return acceptable;
    }

    public GenCriteria getGenJava() {
        return this.genJava;
    }

    public boolean setGenXML(String option) {
        if (option == null || option.length() == 0) {
            return true;
        }
        boolean acceptable = GenCriteria.isValid(option);
        this.genXML = GenCriteria.getGenCriteria(option, GenCriteria.IFNOTEXISTS);
        return acceptable;
    }

    public GenCriteria getGenXML() {
        return this.genXML;
    }

    public void setInputMappingFile(String name) {
        if (name != null && name.length() > 0) {
            this.inputMappingFile = name;
        }
    }

    public void setInputMapping(MappingMetaData mmd) {
        this.inputMMD = mmd;
    }

    public void setAltOutputMappingFile(String name) {
        if (name != null && name.length() > 0) {
            this.altOutputMappingFile = name;
        }
    }

    public String getAltOutputMappingFile() {
        return this.altOutputMappingFile;
    }

    public GeneratedFileInfo getGeneratedFileInfo() {
        return this.fileInfo;
    }

    public List getGeneratedClassNames() {
        return this.fileInfo.getClassNames();
    }

    public List getGeneratedFileNames() {
        return this.fileInfo.getFileNames();
    }

    public String getPackage(String namespace) {
        return this.namespaces.getCreate(namespace);
    }

    public String getPackage(QName qName) {
        return this.getPackage(qName.getNamespaceURI());
    }

    public String getJavaName(QName qName) {
        if (qName.getLocalPart().indexOf("[") > 0) {
            String localPart = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["));
            QName eQName = QNameTable.createQName(qName.getNamespaceURI(), localPart);
            return this.getJavaName(eQName) + "[]";
        }
        if (qName.getLocalPart().indexOf("(nillable)") > 0) {
            String localPart = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("(nillable)"));
            QName eQName = QNameTable.createQName(qName.getNamespaceURI(), localPart);
            String primitive = this.getJavaName(eQName);
            return Utils.getWrapperType(primitive);
        }
        if (qName.getNamespaceURI().equalsIgnoreCase("java")) {
            return qName.getLocalPart();
        }
        String fullJavaName = this.getFactory().getBaseTypeMapping().getBaseName(qName);
        if (fullJavaName != null) {
            return fullJavaName;
        }
        if (this.noDataBinding) {
            return "javax.xml.soap.SOAPElement";
        }
        String pkg = this.getPackage(qName.getNamespaceURI());
        fullJavaName = pkg != null && pkg != "" ? pkg + "." + JavaUtils.xmlNameToJavaClass(qName.getLocalPart()) : JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        return fullJavaName;
    }

    public void run(String context, Document doc) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.setup();
        super.run(context, doc);
    }

    public void run(String context, Document doc, Definition def) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.setup();
        super.run(context, doc, def);
    }

    protected void setup() throws IOException {
        boolean ndb;
        if (!(this.getRole() != Role.DEVELOP_SERVER && this.getRole() != Role.SERVER || this.getContainer() != Container.CLIENT && this.getContainer() != Container.NONE)) {
            this.getToolEnv().reportWarning(Messages.getMessage("badRoleContainer00"));
            this.container = Container.WEB;
        }
        if (this.servicesToWrite != null) {
            this.metaInfo.setProperty("servicesToWrite", this.servicesToWrite);
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        if (this.classpath != null) {
            this.env.setIntrospectionClassPath(this.classpath);
        }
        this.env.setJavaOutputDir(this.getJavaOutputDir());
        this.env.setJavaSearch(this.javaSearch);
        this.env.allowRelativeNamespace(this.allowRelativeNamespace);
        if (this.baseTypeMapping == null) {
            this.setTypeMappingVersion(this.typeMappingVersion);
        }
        this.getFactory().setBaseTypeMapping(this.baseTypeMapping);
        this.namespaces = new Namespaces(this.getJavaOutputDir(), this.env);
        this.metaInfo.setNamespaces(this.namespaces);
        this.getNStoPkgFromPropsFile(this.namespaces);
        if (this.delayedNamespacesMap != null) {
            this.namespaces.putAll((Map)this.delayedNamespacesMap);
        }
        if (this.inputMappingFile != null) {
            this.inputMMD = MappingMetaData.loadFromFile(this.inputMappingFile, this.getToolEnv());
        }
        if (this.inputMMD != null) {
            this.namespaces.putAll((Map)this.inputMMD.getPackageMappings());
            this.inputMMD.preSymbolTable(this.metaInfo);
        }
        boolean bl = ndb = this.metaInfo.getProperty("noDataBinding") == null ? false : (Boolean)this.metaInfo.getProperty("noDataBinding");
        if (this.getNoDataBinding() || ndb) {
            this.metaInfo.setProperty("noDataBinding", Boolean.TRUE);
            this.setNoDataBinding(true);
            this.setNoWrappedArrays(true);
            this.setNoWrappedOperations(true);
        }
        if (this.getNoWrappedArrays()) {
            this.metaInfo.setProperty("noWrappedArrays", Boolean.TRUE);
        }
        if (this.getNoWrappedOperations()) {
            this.metaInfo.setProperty("noWrappedOperations", Boolean.TRUE);
        }
        this.initCustomBindingRegistry();
        this.metaInfo.setCustomRegistry(this.customRegistry);
    }

    private void initCustomBindingRegistry() {
        if (this.customRegistry == null) {
            this.customRegistry = new CustomRegistry();
            List customProviders = null;
            try {
                customProviders = this.env.getCustomBindingProviders(this.classpath);
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
            }
            if (customProviders != null) {
                this.customRegistry.populate(customProviders);
            }
        }
    }

    private void getNStoPkgFromPropsFile(HashMap namespaces) {
        try {
            Properties mappings = new Properties();
            if (this.NStoPkgFile != null) {
                mappings.load(new FileInputStream(this.NStoPkgFile));
            } else {
                InputStream is = null;
                try {
                    is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return Emitter.this.env.getInputStream(Emitter.this.NStoPkgFilename);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exception thrown from AccessController" + e);
                    }
                    throw new RuntimeException(e);
                }
                mappings.load(is);
            }
            Enumeration<?> keys = mappings.propertyNames();
            while (keys.hasMoreElements()) {
                try {
                    String key = (String)keys.nextElement();
                    namespaces.put(key, mappings.getProperty(key));
                }
                catch (Throwable t) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setTypeMappingVersion(String typeMappingVersion) {
        this.baseTypeMapping = typeMappingVersion.equals("1.1") ? new BaseTypeMapping(){
            final TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

            public String getBaseName(QName qNameIn) {
                QName qName = QNameTable.createQName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                Class cls = this.defaultTM.getClassForQName(qName);
                if (cls == null) {
                    return null;
                }
                if (!Emitter.this.noDataBinding) {
                    return JavaUtils.getTextClassName(cls.getName());
                }
                return "javax.xml.soap.SOAPElement";
            }

            public TypeMapping getTypeMapping() {
                return this.defaultTM;
            }
        } : new BaseTypeMapping(){
            final TypeMapping defaultTM = DefaultSOAP12TypeMappingImpl.getSingleton();

            public String getBaseName(QName qNameIn) {
                QName qName = QNameTable.createQName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                Class cls = this.defaultTM.getClassForQName(qName);
                if (cls == null) {
                    return null;
                }
                if (!Emitter.this.noDataBinding) {
                    return JavaUtils.getTextClassName(cls.getName());
                }
                return "javax.xml.soap.SOAPElement";
            }

            public TypeMapping getTypeMapping() {
                return this.defaultTM;
            }
        };
    }

    public GeneratorFactory getWriterFactory() {
        return this.getFactory();
    }

    public void emit(String uri) throws Exception {
        this.run(uri);
    }

    public void emit(String context, Document doc) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.run(context, doc);
    }

    public void debug(boolean value) {
        this.setDebug(value);
    }

    public boolean getDebug() {
        return this.isDebug();
    }

    public void verbose(boolean value) {
        this.setVerbose(value);
    }

    public boolean getVerbose() {
        return this.isVerbose();
    }

    public void generateTestCase(boolean value) {
        this.setTestCaseWanted(value);
    }

    public void generateAll(boolean all) {
        this.setAllWanted(all);
    }

    public void setIntrospect(boolean value) {
        this.introspect = value;
    }

    public void allowRelativeNamespace(boolean value) {
        this.allowRelativeNamespace = value;
    }

    public boolean isIntrospect() {
        return this.introspect;
    }

    public void setClasspath(String value) {
        this.classpath = value;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setGenEquals(boolean value) {
        this.genEquals = value;
    }

    public boolean isGenEquals() {
        return this.genEquals;
    }

    public void setGenImplSer(boolean value) {
        this.genImplSer = value;
    }

    public boolean isGenImplSer() {
        return this.genImplSer;
    }

    public CustomRegistry getCustomRegistry() {
        return this.customRegistry;
    }

    public void setCustomRegistry(CustomRegistry registry) {
        this.customRegistry = registry;
    }

    public boolean setScenario(String option) {
        if (option == null || option.length() == 0) {
            return false;
        }
        boolean acceptable = Scenario.isValid(option);
        this.scenario = Scenario.getScenario(option, Scenario.NORMAL);
        return acceptable;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public void setPropertiesFile(String filename) {
        if (filename != null) {
            this.propertiesFilename = filename;
        }
        try {
            Properties extraOptions = new Properties();
            InputStream is = null;
            try {
                is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Emitter.this.getToolEnv().getInputStream(Emitter.this.propertiesFilename);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception thrown from AccessController" + e);
                }
                throw new RuntimeException(e);
            }
            extraOptions.load(is);
            if (extraOptions.size() > 0) {
                this.setProperties(extraOptions.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setProperties(String text) {
        if (text != null) {
            this.XProperties = new Properties();
            StringTokenizer tupleTokenizer = new StringTokenizer(text, EXT_OPT_DELIMITERS);
            while (tupleTokenizer.hasMoreTokens()) {
                String tuple = tupleTokenizer.nextToken();
                int equals = tuple.indexOf(61);
                if (equals == -1) {
                    this.XProperties.setProperty(tuple, "");
                    continue;
                }
                this.XProperties.setProperty(tuple.substring(0, equals), tuple.substring(equals + 1));
            }
            this.validateANDsetExtraOptions();
        }
    }

    private void validateANDsetExtraOptions() {
        Enumeration<?> propNames = this.XProperties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propValue;
            String propName = (String)propNames.nextElement();
            if (!validOptions.containsKey(propName)) {
                this.getToolEnv().reportWarning(Messages.getMessage("unkownOption", propName));
                continue;
            }
            if (REL_NS.equals(propName)) {
                propValue = this.XProperties.getProperty(propName);
                if ("TRUE".equalsIgnoreCase(propValue) || "".equalsIgnoreCase(propValue)) {
                    this.allowRelativeNamespace(true);
                    continue;
                }
                this.allowRelativeNamespace(false);
                continue;
            }
            if (!"genJava".equals(propName)) continue;
            propValue = this.XProperties.getProperty(propName);
            this.setGenJava(propValue);
        }
    }

    static {
        validOptions.put(REL_NS, "false");
        validOptions.put("genJava", GenCriteria.IFNOTEXISTS);
        Protocols.init();
    }
}

