/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class Entry {
    protected QName qname;
    protected String name;
    protected SymbolTable symbolTable;
    private LinkedHashMap dynamicVars = new LinkedHashMap();
    boolean inToString = false;

    protected Entry(QName qname, SymbolTable symbolTable) {
        this.qname = qname;
        this.symbolTable = symbolTable;
    }

    public final QName getQName() {
        return this.qname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getDynamicVar(Object key) {
        return this.dynamicVars.get(key);
    }

    public void setDynamicVar(Object key, Object value) {
        this.dynamicVars.put(key, value);
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String indent) {
        String string = "";
        boolean isSymTabEntry = false;
        if (this instanceof SymTabEntry) {
            isSymTabEntry = true;
        }
        if (isSymTabEntry && ((SymTabEntry)this).getSIDX() != 0) {
            string = indent + "SIDX:          " + ((SymTabEntry)this).getSIDX() + '\n';
        }
        string = string + indent + "QName:         " + this.qname + '\n' + indent + "Class:         " + this.getClass().getName() + '\n' + indent + "name:          " + this.name + '\n';
        if (this.inToString) {
            string = string + "<recursive>";
        } else {
            this.inToString = true;
            String prefix = indent + "dynamicVars:   ";
            Iterator entries = this.dynamicVars.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                string = string + prefix + key + " = ";
                if (key.equals("derivedTypes") || key.equals("nestedTypes")) {
                    string = string + "[ ";
                }
                if (entry.getValue() instanceof SymTabEntry) {
                    SymTabEntry ste = (SymTabEntry)entry.getValue();
                    if (isSymTabEntry) {
                        string = ste.getSIDX() != ((SymTabEntry)this).getSIDX() ? string + "(" + ste.getSIDX() + ')' : string + "(<recursive> " + ste.getSIDX() + ')';
                    }
                } else if (entry.getValue() instanceof Set) {
                    Set hs = (Set)entry.getValue();
                    Iterator subEntries = hs.iterator();
                    while (subEntries.hasNext()) {
                        Object subEntry = subEntries.next();
                        if (!(subEntry instanceof SymTabEntry) || !isSymTabEntry) continue;
                        if (((SymTabEntry)subEntry).getSIDX() != ((SymTabEntry)this).getSIDX()) {
                            string = string + "(" + ((SymTabEntry)subEntry).getSIDX() + ") ";
                            continue;
                        }
                        string = string + "(<recursive> " + ((SymTabEntry)subEntry).getSIDX() + ") ";
                    }
                } else {
                    string = entry.getValue() == null ? string + "null" : string + "" + entry.getValue();
                }
                if (key.equals("derivedTypes") || key.equals("nestedTypes")) {
                    string = string + "]";
                }
                string = string + "\n";
                prefix = indent + "               ";
            }
            this.inToString = false;
        }
        return string;
    }
}

