/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.mapping;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.util.Vector;
import javax.xml.namespace.QName;

public class Utils {
    public static void setJavaName(SymbolTable symbolTable, Entry entry, String javaName, boolean isMappingPass) {
        Utils.setJavaName(symbolTable, entry, javaName, null, isMappingPass, false);
    }

    public static void setJavaName(SymbolTable symbolTable, Entry entry, String javaName, String customBinder, boolean isMappingPass) {
        Utils.setJavaName(symbolTable, entry, javaName, customBinder, isMappingPass, false);
    }

    private static void setJavaName(SymbolTable symbolTable, Entry entry, String javaName, String customBinder, boolean isMappingPass, boolean isRecursive) {
        if (symbolTable.isVerbose() && !javaName.equals(entry.getName()) && entry.getQName() != null) {
            String xmlText = entry.getQName().toString();
            if (isMappingPass) {
                symbolTable.getToolEnv().report(Messages.getMessage("setJavaNameM00", entry.getName(), javaName, xmlText));
            } else if (customBinder != null) {
                symbolTable.getToolEnv().report(Messages.getMessage("setJavaNameC00", entry.getName(), javaName, xmlText));
            } else {
                symbolTable.getToolEnv().report(Messages.getMessage("setJavaNameI00", entry.getName(), javaName, xmlText));
            }
        }
        if (entry.getDynamicVar("oldName") == null && isMappingPass || entry.getDynamicVar("oldName2") == null && !isMappingPass) {
            if (isMappingPass) {
                entry.setDynamicVar("oldName", entry.getName());
            } else {
                entry.setDynamicVar("oldName2", entry.getName());
            }
            if (entry instanceof TypeEntry && !javaName.equals(entry.getName())) {
                TypeEntry te = (TypeEntry)entry;
                if (te.getRefType() == null && te.isBaseType()) {
                    Type newType = null;
                    if (javaName.equals("javax.xml.soap.SOAPElement") || javaName.equals("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement")) {
                        newType = symbolTable.getType(Constants.WEBSERVICES_SOAPELEMENT);
                    } else if (javaName.equals("org.w3c.dom.Element")) {
                        newType = symbolTable.getType(Constants.SOAP_ELEMENT);
                    }
                    if (newType != null && newType != te) {
                        te.setRefType(newType, null);
                    }
                }
                if (!isRecursive) {
                    te.setName(javaName);
                    Utils.propogateName(symbolTable, te, javaName, customBinder, isMappingPass);
                }
            }
        }
        if (customBinder != null) {
            entry.setDynamicVar("CustomBinderName", customBinder);
        }
        entry.setName(javaName);
    }

    private static void propogateName(SymbolTable symbolTable, TypeEntry typeEntry, String javaName, String customBinder, boolean isMappingPass) {
        boolean useSimpleTypeRestriction = !isMappingPass;
        TypeEntry tEntry = typeEntry;
        TypeEntry refType = Utils.getReferencedType(tEntry, useSimpleTypeRestriction);
        while (refType != null) {
            TypeEntry gEntry = tEntry;
            TypeEntry dEntry = refType;
            String gName = gEntry.getName();
            String dName = dEntry.getName();
            String dims = gEntry.getDimensions();
            if (dEntry == gEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN)) {
                dims = "[]";
            }
            dName = gName;
            if (dims.length() > 0) {
                if (dName.indexOf(91) < 0) {
                    gEntry.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
                    refType = null;
                    dName = null;
                } else {
                    dName = dName.substring(0, dName.lastIndexOf(dims));
                }
            }
            if (refType == null) continue;
            Utils.setJavaName(symbolTable, dEntry, dName, customBinder, isMappingPass, true);
            tEntry = refType;
            refType = Utils.getReferencedType(tEntry, useSimpleTypeRestriction);
        }
        Vector types2 = symbolTable.getTypes();
        for (int i = 0; i < types2.size(); ++i) {
            TypeEntry type = (TypeEntry)types2.elementAt(i);
            if (customBinder != null) {
                TypeEntry referencedType = Utils.getReferencedType(type, useSimpleTypeRestriction);
                while (referencedType != null) {
                    if (referencedType == typeEntry) {
                        TypeEntry gEntry = type;
                        TypeEntry dEntry = typeEntry;
                        String gName = gEntry.getName();
                        String dName = dEntry.getName();
                        String dims = gEntry.getDimensions();
                        if (dEntry == gEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN)) {
                            dims = "[]";
                        }
                        gName = dName + dims;
                        Utils.setJavaName(symbolTable, gEntry, gName, customBinder, isMappingPass, true);
                    }
                    referencedType = Utils.getReferencedType(referencedType, useSimpleTypeRestriction);
                }
                continue;
            }
            if (Utils.getReferencedType(type, useSimpleTypeRestriction) != typeEntry) continue;
            TypeEntry gEntry = type;
            TypeEntry dEntry = typeEntry;
            String gName = gEntry.getName();
            String dName = dEntry.getName();
            String dims = gEntry.getDimensions();
            if (dEntry == gEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN)) {
                dims = "[]";
            }
            gName = dName + dims;
            Utils.setJavaName(symbolTable, gEntry, gName, customBinder, isMappingPass, true);
        }
    }

    private static TypeEntry getReferencedType(TypeEntry tEntry, boolean useSimpleTypeRestriction) {
        return com.ibm.ws.webservices.wsdl.symbolTable.Utils.getReferencedType(tEntry, useSimpleTypeRestriction);
    }

    public static boolean QNameIsAnonymous(QName qName) {
        String localPart = qName.getLocalPart();
        return localPart.indexOf(62) >= 0 || localPart.indexOf(91) >= 0;
    }
}

