/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.CatalogManager;
import com.ibm.ws.webservices.utils.CatalogManagerFactory;
import com.ibm.ws.webservices.utils.PluginUtils;
import java.security.PrivilegedAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class CatalogManagerAccessor {
    private static final TraceComponent tc = Tr.register(CatalogManagerAccessor.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private static String defaultPrefix = "com.ibm.wsfp.main";
    private static Boolean initCalled = false;
    private static CatalogManagerFactory managerFactory;

    public static CatalogManager getCatalogManagerByFactory(ClassLoader cl) throws Exception {
        return CatalogManagerAccessor.getCatalogManagerByFactory(cl, defaultPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CatalogManager getCatalogManagerByFactory(ClassLoader cl, String epPrefix) throws Exception {
        Boolean bl = initCalled;
        synchronized (bl) {
            if (!initCalled.booleanValue()) {
                CatalogManagerAccessor.init(epPrefix + "." + "ws-xml-catalog-manager-factory");
            }
        }
        if (managerFactory != null) {
            return managerFactory.getCatalogManager(cl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(String epid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init, epid= " + epid);
        }
        try {
            IExtension[] extensions = PluginUtils.getDeclaredExtensions((String)epid);
            if (extensions != null) {
                for (int i = 0; i < extensions.length; ++i) {
                    IConfigurationElement[] extensionConfigs = extensions[i].getConfigurationElements();
                    for (int j = 0; j < extensionConfigs.length; ++j) {
                        if (!extensionConfigs[j].getName().equals("plugin")) continue;
                        final IConfigurationElement extConfig = extensionConfigs[j];
                        Object configObject = AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return extConfig.createExecutableExtension("class");
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, CatalogManagerAccessor.class.getName(), "75", CatalogManagerAccessor.class);
                                    return null;
                                }
                            }
                        });
                        managerFactory = (CatalogManagerFactory)configObject;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Retrieved CatalogManagerFactory instance: " + managerFactory);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, CatalogManagerAccessor.class.getName(), "94", CatalogManagerAccessor.class);
        }
        finally {
            initCalled = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "init, epid= " + epid);
            }
        }
    }
}

