/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ElementAlternateContent
extends AlternateContentBase {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static int implicitNamespaceFix = 999;
    protected static Log log = LogFactory.getLog(ElementAlternateContent.class.getName());

    public static ElementAlternateContent create(Element content) {
        return new ElementAlternateContent(content, AlternateContentBase.CONTENT_PLUS_TAG);
    }

    ElementAlternateContent(Element content, short contentFlag) {
        super(content, contentFlag);
        if (implicitNamespaceFix > 1) {
            implicitNamespaceFix = 1;
            String propName = "com.ibm.websphere.webservices.alternateContent.implicitNamespaces";
            String infString = System.getProperty(propName);
            boolean infValue = JavaUtils.isTrue(infString, true);
            if (!infValue) {
                implicitNamespaceFix = 0;
            }
            if (log.isDebugEnabled() && infString != null && infString != "") {
                String strSetting = infValue ? "enabled" : "disabled";
                log.debug(propName + " is " + strSetting);
            }
        }
    }

    protected Element getDOMElement() {
        return (Element)this.content;
    }

    protected void serialize(SerializationContext context, boolean includeNSDecls) throws Exception {
        MappingScope ms = null;
        if (this.owner.getParentElement() != null) {
            ms = this._getMappingScope((SOAPElement)this.owner.getParentElement()).flatten();
        }
        boolean oldPretty = context.getSerializationWriter().getPretty();
        context.getSerializationWriter().setPretty(false);
        context.getSerializationWriter().writeDOMElement((Element)this.content, ms, !includeNSDecls);
        context.getSerializationWriter().setPretty(oldPretty);
    }

    public boolean hasToEvents() {
        return true;
    }

    public void toEvents(PEventProcessor processor) throws SAXException {
        String namespace;
        MappingScope msParent = null;
        AttributesImpl attrsImpl = new AttributesImpl();
        if (this.owner.getParentElement() != null) {
            msParent = this._getMappingScope((SOAPElement)this.owner.getParentElement()).flatten();
        }
        MappingScope ms = new MappingScope();
        ms.setParent(msParent);
        NamedNodeMap attrs = ((Element)this.content).getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            namespace = attr.getNamespaceURI() == null ? "" : attr.getNamespaceURI();
            String localName = attr.getLocalName();
            String name = attr.getNodeName();
            String value = attr.getNodeValue();
            if (name.startsWith(XMLNS)) {
                if (XMLNS == name || XMLNS.equals(name)) {
                    ms.addMapping(value, "");
                    continue;
                }
                if (!name.startsWith(XMLNS_COLON)) continue;
                String prefix = name.substring(6);
                ms.addMapping(value, prefix);
                continue;
            }
            attrsImpl.addAttribute(namespace, localName, name, "CDATA", value);
        }
        if (implicitNamespaceFix == 1) {
            Mapping m;
            Element e = (Element)this.content;
            String prefix = e.getPrefix() == null ? "" : e.getPrefix();
            String string = namespace = e.getNamespaceURI() == null ? "" : e.getNamespaceURI();
            if (!("".equals(prefix) && "".equals(namespace) || (m = ms.getMappingForPrefix(prefix, false)) != null)) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding mapping for Element: prefix = {" + prefix + "} and namespace = {" + namespace + "}");
                }
                ms.addMapping(namespace, prefix);
            }
            for (int i = 0; i < attrsImpl.getLength(); ++i) {
                Mapping m2;
                int idx;
                prefix = null;
                namespace = attrsImpl.getURI(i);
                String prefixedName = attrsImpl.getQName(i);
                int n = idx = prefixedName == null ? -1 : prefixedName.indexOf(58);
                if (idx <= -1 || (m2 = ms.getMappingForPrefix(prefix = prefixedName.substring(0, idx), false)) != null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Adding mapping for Attribute: prefix = {" + prefix + "} and namespace = {" + namespace + "}");
                }
                ms.addMapping(namespace, prefix);
            }
        }
        this.toEvents(processor, (Element)this.content, ms, attrsImpl, this.owner);
    }

    private void toEvents(PEventProcessor processor, Element element, MappingScope ms, Attributes attrs, SOAPElement soapElement) throws SAXException {
        String localName = element.getLocalName();
        if (localName == null || localName.length() == 0) {
            localName = element.getNodeName();
        }
        String pre = element.getPrefix();
        String fullName = localName;
        if (pre != null && pre.length() != 0) {
            fullName = pre + ":" + localName;
        }
        String namespace = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
        processor.startElement(namespace, localName, fullName, attrs, ms, soapElement);
        this.toContainedEvents(processor, element, ms);
        processor.endElement(namespace, localName, fullName);
    }

    private void toContainedEvents(PEventProcessor processor, Element parent, MappingScope ms) throws SAXException {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            String text;
            if (node instanceof Element) {
                Element element = (Element)node;
                String localName = element.getLocalName();
                if (localName == null || localName.length() == 0) {
                    localName = element.getNodeName();
                }
                String pre = element.getPrefix();
                String fullName = localName;
                if (pre != null && pre.length() != 0) {
                    fullName = pre + ":" + localName;
                }
                String namespace = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
                Attributes attrs = this.toPrefixEvents(processor, element, ms);
                processor.startElement(namespace, localName, fullName, attrs);
                this.toContainedEvents(processor, element, ms);
                processor.endElement(namespace, localName, fullName);
                continue;
            }
            if (node instanceof Comment) {
                text = ((CharacterData)node).getData();
                if (text == null) continue;
                processor.comment(text.toCharArray(), 0, text.length());
                continue;
            }
            if (node instanceof Text) {
                text = ((Text)node).getData();
                if (text == null) continue;
                processor.characters(text);
                continue;
            }
            if (!(node instanceof CDATASection) || (text = "<![CDATA[" + ((Text)node).getData() + "]]>") == null) continue;
            processor.characters(text);
        }
    }

    private Attributes toPrefixEvents(PEventProcessor processor, Element element, MappingScope ms) throws SAXException {
        AttributesImpl attrImpl = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node node;
            if (attrImpl == null) {
                attrImpl = new AttributesImpl();
            }
            String namespace = (node = attrs.item(i)).getNamespaceURI() == null ? "" : node.getNamespaceURI();
            String localName = node.getLocalName();
            String value = node.getNodeValue();
            String prefixedName = ((Attr)node).getName();
            if (XMLNS.equals(prefixedName) || prefixedName.startsWith(XMLNS_COLON)) {
                String prefix = "";
                if (prefixedName.startsWith(XMLNS_COLON)) {
                    prefix = prefixedName.substring(prefixedName.indexOf(":") + 1);
                }
                processor.startPrefixMapping(prefix, value);
                continue;
            }
            attrImpl.addAttribute(namespace, localName, prefixedName, "CDATA", value);
        }
        if (attrImpl != null && implicitNamespaceFix == 1) {
            int length = attrImpl.getLength();
            for (int i = 0; i < length; ++i) {
                int idx;
                String prefix = null;
                String namespace = attrImpl.getURI(i);
                String prefixedName = attrImpl.getQName(i);
                int n = idx = prefixedName == null ? -1 : prefixedName.indexOf(58);
                if (idx <= -1) continue;
                boolean mapPrefix = true;
                prefix = prefixedName.substring(0, idx);
                Mapping m = ms.getMappingForPrefix(prefix, false);
                if (m != null) {
                    String namespaceFromMap = m.getNamespaceURI();
                    boolean bl = namespaceFromMap == null ? true : (mapPrefix = !namespaceFromMap.equals(namespace));
                }
                if (!mapPrefix || !(processor instanceof P2DConverter)) continue;
                P2DConverter p2dconverter = (P2DConverter)processor;
                p2dconverter.startPrefixMappingNS(prefix, namespace);
            }
        }
        if (attrImpl != null) {
            return attrImpl;
        }
        return NullAttributes.singleton;
    }
}

