/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.MethodTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RequestResponseProcessor
extends DEventProcessor {
    protected static Log log = LogFactory.getLog(RequestResponseProcessor.class.getName());
    private RequestResponse reqResp;
    private ParamValue currentParam = null;
    private boolean isResponse;
    private OperationDesc operation;
    private boolean isHeaderElement;
    private boolean legacyTestMode = false;
    private QName evilQName = null;
    private ParameterDesc evilParamDesc = null;
    private static boolean ignoreUnknownElement = (Boolean)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.ignoreUnknownElements");
    private boolean needSecondaryLookup = true;

    public RequestResponseProcessor(RequestResponse reqResp, boolean isResponse) throws SAXException {
        this.reqResp = reqResp;
        this.isResponse = isResponse;
    }

    public void setOperation(OperationDesc myOperation) {
        this.operation = myOperation;
        this.evilQName = null;
        this.evilParamDesc = null;
    }

    public void setLegacyTestMode(boolean value) {
        this.legacyTestMode = value;
    }

    public void startElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        this.currentParam = null;
    }

    public DEventProcessor onStartChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: RequestResponseProcessor.onStartChild()");
        }
        context.setSimpleEventOptimization(true);
        QName type = AttributeUtils.getTypeFromAttributes(namespace, localPart, attributes, mappingScope);
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("typeFromAttr00", "" + type));
        }
        Class<?> destClass = null;
        QName qName = QNameTable.createQName(namespace, localPart);
        ParameterDesc paramDesc = this.getParameterDesc(qName);
        if (paramDesc != null) {
            destClass = paramDesc.getJavaSigType();
            if (paramDesc.getMode() != 1 && !paramDesc.getIsReturn()) {
                destClass = JavaUtils.getHolderValueType(destClass);
            }
            if (this.currentParam == null || this.currentParam.getParamDesc() != paramDesc) {
                this.currentParam = new ParamValue(namespace, localPart, null);
                this.reqResp.addParam(this.currentParam);
            }
            this.currentParam.setParamDesc(paramDesc);
            if (type == null) {
                type = paramDesc.getTypeQName();
            }
        } else if (this.legacyTestMode) {
            if (this.currentParam == null || !this.currentParam.getQName().getNamespaceURI().equals(namespace) || !this.currentParam.getQName().getLocalPart().equals(localPart)) {
                this.currentParam = new ParamValue(namespace, localPart, null);
                this.reqResp.addParam(this.currentParam);
            }
        } else {
            if (ignoreUnknownElement) {
                if (log.isDebugEnabled()) {
                    log.debug("Will ignore unknown element " + localPart);
                }
                return new NOOPProcessor();
            }
            throw new SAXException(Messages.getMessage("noParmDesc", this.operation == null ? "???" : this.operation.getElementQName().toString(), qName.toString(), this.operation == null ? "???" : this.getParameterList(this.operation, "    ")));
        }
        if (attributes.getValue("href") != null) {
            DefaultDeserializer dser = new DefaultDeserializer();
            dser.registerValueTarget(new MethodTarget(this.currentParam, ParamValue.getValueSetMethod()));
            dser.setDefaultType(type);
            return dser;
        }
        if (AttributeUtils.isNil(attributes)) {
            DefaultDeserializer nilDSer = new DefaultDeserializer();
            nilDSer.registerValueTarget(new MethodTarget(this.currentParam, ParamValue.getValueSetMethod()));
            return nilDSer;
        }
        Deserializer dser = null;
        dser = type == null && namespace != null && !namespace.equals("") ? context.getDeserializer(null, qName) : context.getDeserializer(destClass, type);
        if (dser == null) {
            if (type != null) {
                dser = context.getDeserializer(null, type);
                if (paramDesc != null && paramDesc.getJavaSigType() != null) {
                    Class xsiClass = context.getTypeMapping().getClassForQName(type);
                    Class<?> expectedClass = destClass;
                    if (!paramDesc.isMaxOccursIs1() && expectedClass.getComponentType() != null) {
                        expectedClass = expectedClass.getComponentType();
                    }
                    if (null != xsiClass && !JavaUtils.isConvertable(xsiClass, expectedClass)) {
                        throw new SAXException("Bad types (" + xsiClass + " -> " + expectedClass + ")");
                    }
                }
            } else {
                dser = new DefaultDeserializer();
            }
        }
        if (dser == null) {
            throw new SAXException(Messages.getMessage("noDeser01", localPart, "" + type));
        }
        if (this.shouldDisableSimpleEvent(paramDesc, dser)) {
            context.setSimpleEventOptimization(false);
        }
        dser.setDefaultType(type);
        dser.registerValueTarget(new MethodTarget(this.currentParam, ParamValue.getValueSetMethod()));
        if (log.isDebugEnabled()) {
            log.debug("Exit: RequestResponseProcessor.onStartChild()");
        }
        return dser;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) throws SAXException {
        context.setSimpleEventOptimization(false);
        super.onEndChild(namespace, localName, context);
    }

    public void endElement(String namespace, String localPart, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("setProp00", "MessageContext", "RequestResponseProcessor.endElement()."));
        }
        if (this.needHeaderProcessing()) {
            this.processHeaders(context);
        }
        this.processAttachments(context);
        this.adjustParamsForMinOccurs0();
    }

    private void adjustParamsForMinOccurs0() throws SAXException {
        if (this.operation != null) {
            Vector params = this.reqResp.getParams();
            for (int i = -1; i < this.operation.getNumParams(); ++i) {
                ParameterDesc paramDesc = null;
                paramDesc = i >= 0 ? this.operation.getParameter(i) : this.operation.getReturnParamDesc();
                boolean tolerate = RequestResponseProcessor.tolerate_missing_isMinOccurs0(this.isResponse, paramDesc);
                if (paramDesc == null || !paramDesc.isMinOccursIs0() && !tolerate || (!this.isResponse || paramDesc.getMode() == 1) && (this.isResponse || paramDesc.getMode() == 2)) continue;
                boolean found = false;
                for (int j = 0; j < params.size() && !found; ++j) {
                    ParamValue pv = (ParamValue)params.elementAt(j);
                    found = pv.getQName().equals(paramDesc.getQName());
                    if (found) continue;
                    found = paramDesc.equals(pv.getParamDesc());
                }
                if (found) continue;
                if (log.isDebugEnabled()) {
                    if (tolerate) {
                        log.debug("The xml for the following parameter descriptor does not specify minOccurs=0.This will be tolerated.  The parameter is set to null");
                    }
                    log.debug("!add ParamValue for MinOccurs:" + paramDesc);
                }
                ParamValue pv = new ParamValue(paramDesc.getQName(), null);
                pv.setParamDesc(paramDesc);
                params.add(pv);
            }
        }
    }

    public void processNoDataBinding(SOAPElement operationElement, DeserializationContext context) throws SAXException {
        this.currentParam = null;
        if (log.isDebugEnabled()) {
            log.debug("Enter: processingForNoDataBinding");
        }
        for (Node node = operationElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            this.processNoDataBindingParameter((SOAPElement)((Object)node));
        }
        if (this.needHeaderProcessing()) {
            this.processHeaders(context);
        }
        this.processAttachments(context);
        this.adjustParamsForMinOccurs0();
    }

    private String getParameterList(OperationDesc op, String indent) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < op.getNumParams(); ++i) {
            buf.append(indent);
            buf.append(op.getParameter(i).getQName().toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    private void processNoDataBindingParameter(SOAPElement pElement) throws SAXException {
        QName qName = pElement.getQName();
        ParameterDesc paramDesc = this.getParameterDesc(qName);
        if (paramDesc == null) {
            throw new SAXException(Messages.getMessage("noParmDesc", this.operation == null ? "???" : this.operation.getElementQName().toString(), qName.toString(), this.operation == null ? "???" : this.getParameterList(this.operation, "    ")));
        }
        if (this.currentParam == null || this.currentParam.getParamDesc() != paramDesc) {
            this.currentParam = new ParamValue(qName.getNamespaceURI(), qName.getLocalPart(), null);
            this.reqResp.addParam(this.currentParam);
        }
        this.currentParam.setParamDesc(paramDesc);
        this.currentParam.setValue(pElement);
    }

    public void setEnableSecondaryLookup(boolean value) {
        this.needSecondaryLookup = value;
    }

    public boolean isEnableSecondaryLookup() {
        return this.needSecondaryLookup;
    }

    private ParameterDesc getParameterDesc(QName qName) throws SAXException {
        ParameterDesc paramDesc = null;
        Vector params = this.reqResp.getParams();
        if (this.operation != null) {
            paramDesc = this.isResponse ? this.operation.getOutputParamByQName(qName) : this.operation.getInputParamByQName(qName);
            QName opQName = this.operation.getElementQName();
            if (paramDesc == null && opQName != null && (opQName.getNamespaceURI() == qName.getNamespaceURI() || opQName.getNamespaceURI().equals(qName.getNamespaceURI()))) {
                QName uQName = QNameTable.createQName("", qName.getLocalPart());
                paramDesc = this.isResponse ? this.operation.getOutputParamByQName(uQName) : this.operation.getInputParamByQName(uQName);
            }
            if (paramDesc == null) {
                if (log.isDebugEnabled()) {
                    log.debug("getParameterDesc(): Did not find a parameter with the name " + qName.toString() + " in operation desc " + this.operation.toString());
                }
                if (this.isResponse && ignoreUnknownElement) {
                    if (log.isDebugEnabled()) {
                        log.debug("ignoring unknown element and returning null paramDesc ");
                    }
                    return null;
                }
                if (this.isResponse) {
                    paramDesc = this.operation.getReturnParamDesc();
                    if (paramDesc == null) {
                        paramDesc = new ParameterDesc();
                        paramDesc.setMode((byte)2);
                        paramDesc.setIsReturn(true);
                    }
                } else if (this.isEnableSecondaryLookup()) {
                    if (qName.equals(this.evilQName)) {
                        paramDesc = this.evilParamDesc;
                    } else {
                        this.evilQName = qName;
                        int n = params.size();
                        if (n >= this.operation.getNumParams() && this.operation.getNumParams() > 0) {
                            n = this.operation.getNumParams() - 1;
                        }
                        paramDesc = this.evilParamDesc = this.operation.getParameter(n);
                    }
                }
            }
            if (paramDesc == null) {
                throw new SAXException(Messages.getMessage("noParmDesc", this.operation.getElementQName().toString(), qName.toString(), this.getParameterList(this.operation, "    ")));
            }
            if (!this.isHeaderElement && (this.isResponse && paramDesc.isOutHeader() || !this.isResponse && paramDesc.isInHeader())) {
                throw new SAXException(Messages.getMessage("expectedHeaderParam", paramDesc.getQName().toString()));
            }
        }
        return paramDesc;
    }

    private boolean needHeaderProcessing() {
        if (this.operation == null) {
            return false;
        }
        ArrayList paramDescs = this.operation.getParameters();
        if (paramDescs != null) {
            for (int j = 0; j < paramDescs.size(); ++j) {
                ParameterDesc paramDesc = (ParameterDesc)paramDescs.get(j);
                if ((this.isResponse || !paramDesc.isInHeader()) && (!this.isResponse || !paramDesc.isOutHeader())) continue;
                return true;
            }
        }
        return this.isResponse && this.operation.getReturnParamDesc() != null && this.operation.getReturnParamDesc().isOutHeader();
    }

    private void processHeaders(DeserializationContext context) throws SAXException {
        try {
            try {
                javax.xml.soap.SOAPElement envelope;
                this.isHeaderElement = true;
                boolean isNoDataBinding = RequestResponse.isNoDataBindingOperation(this.operation);
                for (envelope = this.reqResp.getBody().getParentElement(); envelope != null && !(envelope instanceof SOAPEnvelope); envelope = envelope.getParentElement()) {
                }
                if (envelope == null) {
                    Object var12_5 = null;
                    this.isHeaderElement = false;
                    context.freeEventConverter();
                    return;
                }
                context.createEventConverter(new WrapperProcessor(new NOOPProcessor()));
                P2DConverter converter = context.getEventConverter();
                ArrayList paramDescs = this.operation.getParameters();
                if (paramDescs != null) {
                    for (int j = 0; j < paramDescs.size(); ++j) {
                        ParameterDesc paramDesc = (ParameterDesc)paramDescs.get(j);
                        if ((this.isResponse || !paramDesc.isInHeader()) && (!this.isResponse || !paramDesc.isOutHeader())) continue;
                        SOAPHeader sh = (SOAPHeader)((SOAPEnvelope)envelope).getHeader();
                        Iterator headers = sh.getChildElements(paramDesc.getQName().getNamespaceURI(), paramDesc.getQName().getLocalPart());
                        while (headers != null && headers.hasNext()) {
                            SOAPElement el = (SOAPElement)headers.next();
                            if (isNoDataBinding) {
                                this.processNoDataBindingParameter(el);
                                continue;
                            }
                            converter.pushDEventProcessor(this);
                            el.toEvents(converter);
                            converter.popDEventProcessor();
                            el.removeContents();
                            el.setAlternateContent(this.currentParam);
                        }
                    }
                }
                if (this.isResponse && this.operation.getReturnParamDesc() != null && this.operation.getReturnParamDesc().isOutHeader()) {
                    ParameterDesc paramDesc = this.operation.getReturnParamDesc();
                    SOAPHeader sh = (SOAPHeader)((SOAPEnvelope)envelope).getHeader();
                    Iterator headers = sh.getChildElements(paramDesc.getQName().getNamespaceURI(), paramDesc.getQName().getLocalPart());
                    while (headers != null && headers.hasNext()) {
                        SOAPElement el = (SOAPElement)headers.next();
                        if (isNoDataBinding) {
                            this.processNoDataBindingParameter(el);
                            continue;
                        }
                        converter.pushDEventProcessor(this);
                        el.toEvents(converter);
                        converter.popDEventProcessor();
                        el.removeContents();
                        el.setAlternateContent(this.currentParam);
                    }
                }
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor.processHeaders", "507", this);
                throw new SAXException((Exception)((Object)se));
            }
        }
        catch (Throwable throwable) {
            Object var12_7 = null;
            this.isHeaderElement = false;
            context.freeEventConverter();
            throw throwable;
        }
        Object var12_6 = null;
        this.isHeaderElement = false;
        context.freeEventConverter();
    }

    private void processAttachments(DeserializationContext context) {
        if (context == null) {
            return;
        }
        MessageContext msgContext = context.getMessageContext();
        if (msgContext == null) {
            return;
        }
        Message msg = msgContext.getCurrentMessage();
        if (msg == null) {
            return;
        }
        Iterator attachments = msg.getAttachments();
        while (attachments.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachments.next();
            String partName = attachment.getContentIdPartName();
            if (partName == null) continue;
            ParameterDesc param = null;
            QName partQName = QNameTable.createQName("", partName);
            if (this.isResponse) {
                param = this.operation.getOutputParamByQName(partQName);
                if (param == null) {
                    param = this.getAttachmentParamByName(partName);
                }
                if (param == null && !partName.equals((param = this.operation.getReturnParamDesc()).getName())) {
                    param = null;
                }
            } else {
                param = this.operation.getInputParamByQName(partQName);
                if (param == null) {
                    param = this.getAttachmentParamByName(partName);
                }
            }
            if (param == null) continue;
            this.processAttachment(attachment, param, context);
        }
    }

    private ParameterDesc getAttachmentParamByName(String partName) {
        ArrayList parameters = this.operation.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)parameters.get(i);
            String PN = null;
            PN = (String)param.getOption(ParameterDesc.PART_NAME);
            if (PN == null || !param.isWSDL11MIME() || (!this.isResponse || param.getMode() == 1) && (this.isResponse || param.getMode() == 2) || !PN.equals(partName)) continue;
            return param;
        }
        return null;
    }

    private void processAttachment(AttachmentPart attachment, ParameterDesc param, DeserializationContext context) {
        QName paramType = param.getTypeQName();
        if (!Constants.WSI_SWAREF.equals(paramType) && !Constants.WEBSERVICES_VOID.equals(paramType)) {
            try {
                JAFDataHandlerDeserializer dser = (JAFDataHandlerDeserializer)context.getTypeMapping().getDeserializer(paramType).getDeserializerAs("WebServices SAX Mechanism");
                DataHandler dataHandler = AttachmentUtils.getActivationDataHandler((Part)attachment);
                ParamValue pv = new ParamValue(param.getQName(), dser.makeValue(dataHandler));
                pv.setParamDesc(param);
                this.reqResp.addParam(pv);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.xmlsoap.builder.RequestResponseProcessor", "225", this);
            }
        }
    }

    private boolean shouldDisableSimpleEvent(ParameterDesc paramDesc, Deserializer dser) {
        if (paramDesc == null || paramDesc.getJavaSigType() == null) {
            return false;
        }
        if (dser instanceof CustomDeserializer) {
            return false;
        }
        return javax.xml.soap.SOAPElement.class.isAssignableFrom(paramDesc.getJavaType());
    }

    private static boolean tolerate_missing_isMinOccurs0(boolean isResponse, ParameterDesc paramDesc) {
        if (!isResponse) {
            return false;
        }
        if (paramDesc == null || paramDesc.isMinOccursIs0() || paramDesc.getQName() == null) {
            return false;
        }
        if (paramDesc.getMode() == 1) {
            return false;
        }
        if (Constants.WEBSERVICES_VOID.equals(paramDesc.getTypeQName())) {
            return false;
        }
        Class cls = paramDesc.getJavaType();
        return cls == null || cls.isArray();
    }
}

