/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPElement;
import com.ibm.websphere.webservices.soap.IBMSOAPFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.ProtectionChecker;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.AsSOAPElementProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMElementImpl_MS;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Document;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import com.ibm.ws.webservices.utils.BufferedWriter;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPElement
extends DOMElementImpl_MS
implements Serializable,
IBMSOAPElement {
    private static Log log;
    protected SOAPFactory soapFactory;
    boolean isProtect = false;
    transient AlternateContentBase altContent;
    protected static int CONTEXT_CONTENT;
    protected static int CONTEXT_ATTRS;
    protected static int CONTEXT_TAG;
    protected boolean inAsSOAPElement = false;
    protected boolean rebuildTagQName = false;
    protected boolean rebuildAttributesAndMapping = false;
    public static boolean disableSOAPNamespaceValidation;
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";
    private String deferredMimeType = null;
    private Object deferredAttachment = null;

    SOAPElement(String namespace, String localName, SOAPFactory soapFactory) {
        super(soapFactory.getOwnerDocument(), namespace, localName);
        this.soapFactory = soapFactory;
    }

    public SOAPElement(Element domElement, SOAPFactory soapFactory) {
        super(soapFactory.getOwnerDocument(), domElement.getNamespaceURI(), domElement.getLocalName() == null || domElement.getLocalName().length() == 0 ? domElement.getNodeName() : domElement.getLocalName());
        this.setPrefix(domElement.getPrefix());
        this.soapFactory = soapFactory;
        try {
            this.setAlternateContent(domElement);
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.init", "210", this);
            throw new RuntimeException(se);
        }
    }

    public final javax.xml.soap.SOAPElement addAttribute(javax.xml.soap.Name name, String value) throws SOAPException {
        QName encStyle = this.soapFactory.getSOAPConstants().getEncodingStyleQName();
        if (encStyle.getNamespaceURI().equals(name.getURI()) && encStyle.getLocalPart().equals(name.getLocalName())) {
            this.setEncodingStyle(value);
        } else {
            this.addAttribute(name.getURI(), name.getPrefix(), name.getLocalName(), value);
        }
        return this;
    }

    public final javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.Name name) throws SOAPException {
        return this.addChildElement(name.getLocalName(), name.getPrefix(), name.getURI());
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.SOAPElement element) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        element = (javax.xml.soap.SOAPElement)this.insertBefore((org.w3c.dom.Node)element, null);
        try {
            element.setParentElement((javax.xml.soap.SOAPElement)this);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addChildElement", "313", this);
            this.removeChild((org.w3c.dom.Node)element);
            element = null;
        }
        return element;
    }

    public final javax.xml.soap.SOAPElement addChildElement(String localName) throws SOAPException {
        boolean origInterpretation = false;
        if (origInterpretation) {
            SOAPElement child = this.createChildElement(EMPTY_STRING, localName, this.soapFactory);
            return this.addChildElement(child);
        }
        String ns = this.getNamespaceURI(EMPTY_STRING);
        ns = ns == null ? EMPTY_STRING : ns;
        SOAPElement child = this.createChildElement(ns, localName, this.soapFactory);
        return this.addChildElement(child);
    }

    public final javax.xml.soap.SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String uri = this.getNamespaceURI(prefix);
        if (uri == null) {
            throw new SOAPException(Messages.getMessage("addChildUnboundPrefix", prefix, localName));
        }
        return this.addChildElement(localName, prefix, this.getNamespaceURI(prefix));
    }

    public final javax.xml.soap.SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        SOAPElement child = this.createChildElement(uri, localName, this.soapFactory);
        child.setPrefix(prefix);
        return this.addChildElement(child);
    }

    public final javax.xml.soap.SOAPElement addNamespaceDeclaration(String prefix, String uri) {
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        Utils.addXMLNSAttribute((Element)((Object)this), prefix, uri);
        return this;
    }

    public javax.xml.soap.SOAPElement addTextNode(String text) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        if (SAAJ12Text.isCommentValue(text)) {
            this.addComment(text);
        } else {
            this.insertBefore((org.w3c.dom.Node)((Object)new Text((SOAPDocument)this.ownerDocument, text)), null);
        }
        return this;
    }

    public javax.xml.soap.SOAPElement addComment(String text) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        this.insertBefore(new Comment((SOAPDocument)this.ownerDocument, text), null);
        return this;
    }

    public final Iterator getAllAttributes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<javax.xml.soap.Name> attrList = new ArrayList<javax.xml.soap.Name>();
        NamedNodeMap attributes = this.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            org.w3c.dom.Node nd = attributes.item(i);
            String nameSpace = nd.getNamespaceURI();
            String localName = nd.getLocalName();
            String prefix = nd.getPrefix();
            try {
                attrList.add(this.soapFactory.createName(localName, prefix, nameSpace));
                continue;
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getAllAttributes", "443", this);
                throw new InternalException((Exception)((Object)se));
            }
        }
        return attrList.iterator();
    }

    public final Iterator getAllAttributesAsQNames() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<QName> attrList = new ArrayList<QName>();
        NamedNodeMap attributes = this.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            org.w3c.dom.Node nd = attributes.item(i);
            String nameSpace = nd.getNamespaceURI();
            String localName = nd.getLocalName();
            String prefix = nd.getPrefix();
            attrList.add(QNameTable.createQName(nameSpace, localName));
        }
        return attrList.iterator();
    }

    public final String getAttributeValue(javax.xml.soap.Name name) {
        this.asSOAPElement(CONTEXT_ATTRS);
        String value = null;
        String nameSpace = this.domifyNamespace(name.getURI());
        String localName = name.getLocalName();
        value = nameSpace == null ? this.getAttribute(name.getQualifiedName()) : this.getAttributeNS(nameSpace, localName);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value;
    }

    public final Iterator getChildElements() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return new CEIterator((org.w3c.dom.Node)((Object)this), "javax.xml.soap.SOAPElement.getChildElements");
    }

    public final Iterator getChildElements(javax.xml.soap.Name name) {
        return this.getChildElements(name.getURI(), name.getLocalName());
    }

    public final javax.xml.soap.Name getElementName() {
        try {
            return this.soapFactory.createName(this.getLocalName(), this.getPrefix(), this.getNamespaceURI());
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getElementName", "534", this);
            throw new InternalException((Exception)((Object)se));
        }
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        QName encodingStyleQName;
        this.asSOAPElement(CONTEXT_ATTRS);
        if (encodingStyle == null) {
            encodingStyle = EMPTY_STRING;
        }
        if (this.hasAttributeNS((encodingStyleQName = this.soapFactory.getSOAPConstants().getEncodingStyleQName()).getNamespaceURI(), encodingStyleQName.getLocalPart())) {
            throw new IllegalArgumentException("illegalArgumentException01");
        }
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String prefix = mappingScope.getOrCreatePrefix(encodingStyleQName.getNamespaceURI(), null, false);
        String qualifiedName = encodingStyleQName.getLocalPart();
        if (prefix != null && prefix.length() > 0) {
            qualifiedName = prefix + ":" + qualifiedName;
        }
        this.setAttributeNS(encodingStyleQName.getNamespaceURI(), qualifiedName, encodingStyle);
    }

    public final Iterator getNamespacePrefixes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<String> prefixes = new ArrayList<String>();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        if (mappingScope != null) {
            for (int i = 0; i < mappingScope.size(); ++i) {
                Mapping mapping = mappingScope.get(i);
                prefixes.add(mapping.getPrefix());
            }
        }
        return prefixes.iterator();
    }

    public final String getNamespaceURI(String prefix) {
        this.asSOAPElement(CONTEXT_TAG);
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        Mapping mapping = mappingScope.getMappingForPrefix(prefix, false);
        return mapping != null ? mapping.getNamespaceURI() : null;
    }

    public final Iterator getVisibleNamespacePrefixes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<String> prefixes = new ArrayList<String>();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        if (mappingScope != null) {
            MappingScope scope = mappingScope.flatten();
            for (int i = 0; i < scope.size(); ++i) {
                Mapping mapping = scope.get(i);
                prefixes.add(mapping.getPrefix());
            }
        }
        return prefixes.iterator();
    }

    public final boolean removeAttribute(javax.xml.soap.Name name) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        String namespace = this.domifyNamespace(name.getURI());
        String localName = name.getLocalName();
        boolean removed = false;
        if (this.hasAttributeNS(namespace, localName)) {
            this.removeAttributeNS(namespace, localName);
            removed = true;
        }
        return removed;
    }

    public final void removeContents() {
        if (this.getAlternateContent() != null) {
            this.altContent.removeChildNodes();
        } else {
            Iterator it = this.getChildElements();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
    }

    public final boolean removeNamespaceDeclaration(String prefix) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        return Utils.removeXMLNSAttribute((Element)((Object)this), prefix);
    }

    public final String getEncodingStyle() {
        javax.xml.soap.SOAPElement parent;
        this.asSOAPElement(CONTEXT_ATTRS);
        QName encodingStyleQName = this.soapFactory.getSOAPConstants().getEncodingStyleQName();
        String encodingStyle = null;
        if (super.hasAttributeNS(encodingStyleQName.getNamespaceURI(), encodingStyleQName.getLocalPart())) {
            encodingStyle = super.getAttributeNS(encodingStyleQName.getNamespaceURI(), encodingStyleQName.getLocalPart());
        }
        if (encodingStyle == null && (parent = this.getParentElement()) != null) {
            encodingStyle = parent.getEncodingStyle();
        }
        return encodingStyle;
    }

    public final javax.xml.soap.SOAPElement getParentElement() {
        org.w3c.dom.Node node = this.getParentNode();
        return node instanceof Document ? null : (javax.xml.soap.SOAPElement)node;
    }

    public void setParentElement(javax.xml.soap.SOAPElement parent) throws SOAPException {
        SOAPElement _currParent;
        SOAPElement _parent = (SOAPElement)parent;
        if (_parent == null) {
            throw new SOAPException(Messages.getMessage("nullParent00"));
        }
        if (this.getAlternateContent() != null) {
            this.soapFactory = _parent.getSOAPFactory();
        }
        if (_parent != (_currParent = (SOAPElement)this.getParentElement())) {
            if (_currParent != null) {
                ProtectionChecker.protectionCheck_removeChildElement(_currParent);
            }
            ProtectionChecker.protectionCheck_addChildElement(_parent);
            ProtectionChecker.protectionCheck_removeElement(this);
            _parent.addChildElement(this);
        }
    }

    public final void detachNode() {
        SOAPElement parent = (SOAPElement)this.getParentElement();
        if (parent != null) {
            parent.removeChild((org.w3c.dom.Node)((Object)this));
        }
    }

    public void recycleNode() {
        this.detachNode();
        this.soapFactory = null;
        if (this.altContent != null) {
            this.altContent.detach();
        }
        this.enableMappingScopeOptimization(false);
    }

    public final String getValue() {
        org.w3c.dom.Node node;
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node firstChild = this.getFirstChild();
        if (firstChild != null && firstChild.getNextSibling() == null) {
            if (firstChild instanceof CharacterData && !(firstChild instanceof org.w3c.dom.Comment)) {
                return ((CharacterData)firstChild).getData();
            }
            return null;
        }
        org.w3c.dom.Node textNode = null;
        for (node = firstChild; node != null && textNode == null; node = node.getNextSibling()) {
            if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) continue;
            textNode = (CharacterData)node;
        }
        if (textNode == null) {
            return null;
        }
        node = textNode.getNextSibling();
        if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) {
            return textNode.getData();
        }
        super.normalize();
        for (node = firstChild = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) continue;
            return ((CharacterData)node).getData();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setValue(String value) {
        this.asSOAPElement(CONTEXT_CONTENT);
        javax.xml.soap.Text text = null;
        boolean hasChild = false;
        int count = 0;
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            hasChild = true;
            Object child = it.next();
            if (!(child instanceof javax.xml.soap.Text)) continue;
            text = (javax.xml.soap.Text)child;
            count = (short)(count + 1);
        }
        if (hasChild) {
            if (count == 1) {
                text.setValue(value);
                return;
            }
            if (!log.isDebugEnabled()) throw new IllegalStateException(Messages.getMessage("badTextNode00"));
            log.debug("can not set value");
            throw new IllegalStateException(Messages.getMessage("badTextNode00"));
        }
        try {
            this.addTextNode(value);
            return;
        }
        catch (SOAPException se) {
            throw new IllegalStateException(Messages.getMessage("badTextNode00"));
        }
    }

    public final String getAttribute(String name) {
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.getAttribute(name);
    }

    public final Attr getAttributeNode(String name) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_accessAttributes(this);
        return super.getAttributeNode(name);
    }

    public final Attr getAttributeNodeNS(String namespaceURI, String localName) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_accessAttributes(this);
        namespaceURI = this.domifyNamespace(namespaceURI);
        return super.getAttributeNodeNS(namespaceURI, localName);
    }

    public final String getAttributeNS(String namespaceURI, String localName) {
        this.asSOAPElement(CONTEXT_ATTRS);
        namespaceURI = this.domifyNamespace(namespaceURI);
        return super.getAttributeNS(namespaceURI, localName);
    }

    public final NodeList getElementsByTagName(String name) {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getElementsByTagName(name);
    }

    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        this.asSOAPElement(CONTEXT_CONTENT);
        namespaceURI = this.domifyNamespace(namespaceURI);
        return super.getElementsByTagNameNS(namespaceURI, localName);
    }

    public final String getTagName() {
        return this.getNodeName();
    }

    public final boolean hasAttribute(String name) {
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.hasAttribute(name);
    }

    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        this.asSOAPElement(CONTEXT_ATTRS);
        namespaceURI = this.domifyNamespace(namespaceURI);
        return super.hasAttributeNS(namespaceURI, localName);
    }

    public final void removeAttribute(String s) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        super.removeAttribute(s);
    }

    public final Attr removeAttributeNode(Attr attr) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        return super.removeAttributeNode(attr);
    }

    public final void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        namespaceURI = this.domifyNamespace(namespaceURI);
        super.removeAttributeNS(namespaceURI, localName);
    }

    public final void setAttribute(String name, String value) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        super.setAttribute(name, value);
    }

    public final Attr setAttributeNode(Attr attr) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        attr = this.importAttr(attr);
        return super.setAttributeNode(attr);
    }

    public final void setAttributeNS(String namespace, String qualifiedName, String value) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        namespace = this.domifyNamespace(namespace);
        super.setAttributeNS(namespace, qualifiedName, value);
    }

    public final Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        attr = this.importAttr(attr);
        return super.setAttributeNodeNS(attr);
    }

    public final org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        return super.appendChild(node);
    }

    public final org.w3c.dom.Node removeChild(org.w3c.dom.Node node) throws DOMException {
        this.asSOAPElement(CONTEXT_CONTENT);
        ProtectionChecker.protectionCheck_removeChildElement(this);
        org.w3c.dom.Node rc = super.removeChild(node);
        if (rc instanceof SOAPElement) {
            ((SOAPElement)((Object)rc)).changedParent();
        }
        return rc;
    }

    public final org.w3c.dom.Node cloneNode(boolean deep) {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.cloneNode(deep);
    }

    public final NamedNodeMap getAttributes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_accessAttributes(this);
        return super.getAttributes();
    }

    public final NodeList getChildNodes() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getChildNodes();
    }

    public final org.w3c.dom.Node getFirstChild() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getFirstChild();
    }

    public final org.w3c.dom.Node getLastChild() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getLastChild();
    }

    public final String getLocalName() {
        this.asSOAPElement(CONTEXT_TAG);
        return super.getLocalName();
    }

    public final String getNamespaceURI() {
        this.asSOAPElement(CONTEXT_TAG);
        String namespace = this.domifyNamespace(super.getNamespaceURI());
        return namespace;
    }

    public final org.w3c.dom.Node getNextSibling() {
        return super.getNextSibling();
    }

    public final String getNodeName() {
        this.asSOAPElement(CONTEXT_TAG);
        return super.getNodeName();
    }

    public final short getNodeType() {
        return super.getNodeType();
    }

    public final String getNodeValue() {
        return super.getNodeValue();
    }

    public final Document getOwnerDocument() {
        return super.getOwnerDocument();
    }

    public final org.w3c.dom.Node getParentNode() {
        return super.getParentNode();
    }

    public final String getPrefix() {
        this.asSOAPElement(CONTEXT_TAG);
        if (this.getNamespaceURI() == null) {
            return null;
        }
        return super.getPrefix();
    }

    public final org.w3c.dom.Node getPreviousSibling() {
        return super.getPreviousSibling();
    }

    public final boolean hasAttributes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.hasAttributes();
    }

    public final boolean hasChildNodes() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.hasChildNodes();
    }

    public final org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        SOAPElement parent;
        this.asSOAPElement(CONTEXT_CONTENT);
        MappingScope oldAncestorMS = null;
        if (newChild instanceof SOAPElement && (parent = (SOAPElement)((SOAPElement)((Object)newChild)).getParentElement()) != null) {
            oldAncestorMS = parent._getMappingScope();
            oldAncestorMS.flatten();
        }
        org.w3c.dom.Node child = null;
        child = this.isValidSAAJChild(newChild) ? newChild : this.wrapChildDOMNode(newChild);
        child = super.insertBefore(child, refChild);
        if (newChild instanceof SOAPElement && ((SOAPElement)((Object)newChild)).getAlternateContent() == null) {
            ((SOAPElement)((Object)child)).changedParent();
            Utils.addImplicitNamespaceDeclarations((SOAPElement)((Object)child));
            if (oldAncestorMS != null) {
                MappingScope ms = this._getMappingScope();
                for (int i = 0; i < oldAncestorMS.size(); ++i) {
                    Mapping mapping = oldAncestorMS.get(i);
                    Mapping findMapping = ms.getMappingForPrefix(mapping.getPrefix(), false);
                    if (findMapping != null && findMapping.getNamespaceURI().equals(mapping.getNamespaceURI())) continue;
                    Utils.addXMLNSAttribute((Element)((Object)((SOAPElement)((Object)child))), mapping.getPrefix(), mapping.getNamespaceURI());
                }
            }
        }
        return child;
    }

    public final boolean isSupported(String feature, String version) {
        return super.isSupported(feature, version);
    }

    public final void normalize() {
        this.asSOAPElement(CONTEXT_CONTENT);
        super.normalize();
    }

    public final void setNodeValue(String value) {
        super.setNodeValue(value);
    }

    public final void setPrefix(String prefix) throws DOMException {
        this.asSOAPElement(CONTEXT_TAG);
        super.setPrefix(prefix);
    }

    public final Attributes getSAXAttributes() {
        AttributesImpl attrImpl = null;
        NamedNodeMap attrs = this.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrImpl == null) {
                attrImpl = new AttributesImpl();
            }
            org.w3c.dom.Node node = attrs.item(i);
            String namespace = this.domifyNamespace(node.getNamespaceURI());
            String localName = node.getLocalName();
            String value = node.getNodeValue();
            String prefixedName = ((Attr)node).getName();
            if (XMLNS.equals(prefixedName) || prefixedName.startsWith(XMLNS_COLON)) continue;
            attrImpl.addAttribute(namespace, localName, prefixedName, "CDATA", value);
        }
        if (attrImpl != null) {
            return attrImpl;
        }
        return NullAttributes.singleton;
    }

    public final void setAttributes(Attributes attributes) {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        NamedNodeMap attrs = this.getAttributes();
        Document doc = this.getOwnerDocument();
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = doc.createAttributeNS(attributes.getURI(i), attributes.getQName(i));
                attr.setValue(attributes.getValue(i));
                attrs.setNamedItem(attr);
            }
        }
    }

    public final void setAttribute(String namespace, String localName, String value) {
        this.addAttribute(namespace, localName, value);
    }

    public final String getAttributeValue(String namespace, String localName) {
        this.asSOAPElement(CONTEXT_ATTRS);
        return this.getAttributeNS(namespace, localName);
    }

    public final void setMappingScope(MappingScope ms) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        if (ms != null) {
            for (int i = 0; i < ms.size(); ++i) {
                Mapping mapping = ms.get(i);
                Utils.addXMLNSAttribute((Element)((Object)this), mapping.getPrefix(), mapping.getNamespaceURI());
            }
        }
    }

    public final String getLocalPart() {
        return this.getLocalName();
    }

    public final int getNumChildren() {
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node firstChild = this.getFirstChild();
        int num = 0;
        for (org.w3c.dom.Node node = firstChild; node != null; node = node.getNextSibling()) {
            if (node instanceof CharacterData) continue;
            ++num;
        }
        return num;
    }

    public final SOAPElement getChildElement(int n) {
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node firstChild = this.getFirstChild();
        int index = -1;
        for (org.w3c.dom.Node node = firstChild; node != null; node = node.getNextSibling()) {
            if (!(node instanceof CharacterData)) {
                ++index;
            }
            if (index != n) continue;
            return (SOAPElement)((Object)node);
        }
        return null;
    }

    public final SOAPElement getChildElement(String namespaceURI, String localPart) throws SOAPException {
        Iterator it = this.getChildElements(namespaceURI, localPart);
        if (it == null || !it.hasNext()) {
            return null;
        }
        SOAPElement element = (SOAPElement)it.next();
        if (it.hasNext()) {
            throw new SOAPException(Messages.getMessage("getChildElementErr00", namespaceURI, localPart));
        }
        return element;
    }

    public final void output(SerializationContext context) throws Exception {
        this.outputImpl(context, true);
    }

    protected void outputImpl(SerializationContext context, boolean includeNSDecls) throws Exception {
        this.soapFactory.setMessageContext(context.getMessageContext());
        if (this.deferredAttachment != null) {
            this.addSwaRefTextNode(this.deferredMimeType, this.deferredAttachment, context.getCurrentMessage());
            this.deferredAttachment = null;
        }
        if (this.getAlternateContent() != null) {
            this.altContent.serialize(context, includeNSDecls);
            return;
        }
        MappingScope mappingScope = null;
        if (this.getParentElement() == null && !(this.getFirstChild() instanceof SOAPElement)) {
            Utils.addImplicitNamespaceDeclarations(this);
        }
        if (includeNSDecls) {
            mappingScope = this._getMappingScope();
            MappingScope msAncestors = this.getMappingScopeForAncestorsNotWritten(context);
            mappingScope.setParent(msAncestors);
            mappingScope = mappingScope.flatten();
        } else {
            mappingScope = this._getMappingScope();
        }
        String text = this.getValue();
        org.w3c.dom.Node firstChild = this.getFirstChild();
        if (text != null && this.altContent == null && firstChild != null && firstChild.getNextSibling() == null) {
            context.getSerializationWriter().simpleElement(this.getQName(), this.getPrefix(), this.getSAXAttributes(), mappingScope, text);
        } else {
            context.getSerializationWriter().startElement(this.getQName(), this.getPrefix(), this.getSAXAttributes(), mappingScope);
            this.outputContentsImpl(context);
            if (this instanceof SOAPBody) {
                context.outputMultiRefs();
            }
            context.getSerializationWriter().endElement();
        }
    }

    protected void outputContentsImpl(SerializationContext context) throws Exception {
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof SOAPElement) {
                ((SOAPElement)((Object)node)).outputImpl(context, false);
                continue;
            }
            short type = node.getNodeType();
            String text = node.getNodeValue();
            if (type == 8) {
                context.getSerializationWriter().writeComment(text);
                continue;
            }
            if (text == null) continue;
            context.getSerializationWriter().writeSafeString(text);
        }
    }

    MappingScope getMappingScopeForAncestorsNotWritten(SerializationContext context) {
        MappingScope ms = new MappingScope();
        SOAPElement parent = (SOAPElement)this.getParentElement();
        SerializationWriter writer = context.getSerializationWriter();
        if (parent != null && writer != null) {
            ms = parent._getMappingScope();
            ms = ms.flatten();
            int i = 0;
            while (i < ms.size()) {
                String prefix = ms.get(i).getPrefix();
                String namespaceURI = writer.getNamespaceURI(prefix);
                if (ms.get(i).getNamespaceURI().equals(namespaceURI)) {
                    ms.removeMappingForPrefix(prefix);
                    continue;
                }
                ++i;
            }
        }
        return ms;
    }

    private final String getAsString(boolean includeNSDecls) throws Exception {
        byte[] tmpBytes;
        Object tmpContents;
        String value;
        if (this.altContent != null && !includeNSDecls && (value = this.altContent.getXMLString()) != null) {
            return value;
        }
        SerializationContextImpl serializeContext = null;
        StringWriter writer = null;
        int tmp_len = 1024;
        if (this.altContent != null && (tmpContents = this.altContent.getContent()) instanceof WebServicesInputSource && (tmpBytes = ((WebServicesInputSource)this.altContent.getContent()).getBytes()) != null) {
            tmp_len += tmpBytes.length;
        }
        writer = new StringWriter(tmp_len);
        MessageContext msgContext = this.soapFactory.getMessageContext();
        serializeContext = new SerializationContextImpl(writer, msgContext, false);
        if (includeNSDecls) {
            this.output(serializeContext);
        } else {
            this.outputImpl(serializeContext, false);
        }
        writer.close();
        String rc = writer.getBuffer().toString();
        return rc;
    }

    public final String toString() {
        return this.toXMLString(true);
    }

    public final void toEvents(PEventProcessor processor) throws SAXException {
        this.asSOAPElement(CONTEXT_ATTRS);
        if (this.getAlternateContent() != null && this.altContent.hasToEvents()) {
            this.altContent.toEvents(processor);
            return;
        }
        Utils.addImplicitNamespaceDeclarations(this);
        String fullName = this.getLocalPart();
        String pre = this.getPrefix();
        if (pre != null && pre.length() != 0) {
            fullName = pre + ":" + fullName;
        }
        processor.startElement(this.getNamespaceURI(), this.getLocalPart(), fullName, this.getSAXAttributes(), this._getMappingScope(), this);
        this.toContainedEvents(processor);
        processor.endElement(this.getNamespaceURI(), this.getLocalPart(), fullName);
    }

    protected final void toContainedEvents(PEventProcessor processor) throws SAXException {
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof SOAPElement) {
                ((SOAPElement)((Object)node)).toEvents(processor);
                continue;
            }
            short _nodeType = node.getNodeType();
            String textContent = node.getNodeValue();
            if (_nodeType == 8) {
                processor.comment(textContent.toCharArray(), 0, textContent.length());
                continue;
            }
            processor.characters(textContent);
        }
    }

    public final Element getAsDOM() throws Exception {
        return this.getAsDOM(true);
    }

    public final Element getAsDOM(boolean includeNSDecls) throws Exception {
        return this.getAsDocument(includeNSDecls).getDocumentElement();
    }

    public final Document getAsDocument() throws Exception {
        return this.getAsDocument(true);
    }

    public final Document getAsDocument(boolean includeNSDecls) throws Exception {
        String elementString = this.getAsString(includeNSDecls);
        StringReader reader = new StringReader(elementString);
        Document doc = XMLUtils.newDocument(new InputSource(reader));
        if (doc == null) {
            throw new Exception(Messages.getMessage("noDoc00", elementString));
        }
        return doc;
    }

    public void setAlternateContent(Object newValue) throws SOAPException {
        ProtectionChecker.protectionCheck_setAlternateContent(this);
        if (newValue == null) {
            if (this.altContent != null) {
                this.altContent.detach();
            }
            this.enableMappingScopeOptimization(false);
            return;
        }
        AlternateContentBase ac = AlternateContentBase.create(newValue);
        if (ac.affectsTagAttributes() || ac.affectsTagQName()) {
            this.enableMappingScopeOptimization(false);
        }
        ac.attach(this);
        Element domElement = this._getDOMElement();
        if (domElement != null && domElement.getOwnerDocument() != this.getOwnerDocument()) {
            if (log.isDebugEnabled()) {
                log.debug("setAlternateContent: immediate transformation because documents are different");
            }
            this.asSOAPElement(CONTEXT_TAG);
        }
    }

    public final void expand() {
        this.asSOAPElement(CONTEXT_TAG);
    }

    protected final void asSOAPElement(int context) {
        if (this.getAlternateContent() == null || context == CONTEXT_TAG && !this.altContent.affectsTagQName() || context == CONTEXT_ATTRS && !this.altContent.affectsTagAttributes()) {
            return;
        }
        if (this.inAsSOAPElement) {
            throw new InternalException(Messages.getMessage("exception01", "Error in SOAPElement.asSOAPElement"));
        }
        this._asSOAPElement(context);
    }

    /*
     * Loose catch block
     */
    protected final void _asSOAPElement(int context) {
        block23: {
            boolean saveException;
            this.inAsSOAPElement = true;
            this.rebuildTagQName = this.altContent.affectsTagQName();
            AlternateContentBase ac = this.altContent;
            this.rebuildAttributesAndMapping = ac.affectsTagAttributes();
            boolean toEventsSupported = ac.hasToEvents();
            if (log.isDebugEnabled()) {
                log.debug("transforming to SOAPElement with alternate content " + ac.getClass());
            }
            DeserializationContext deserContext = this.soapFactory.getDeserializationContext();
            deserContext.createEventConverter(new WrapperProcessor(new NOOPProcessor()));
            P2DConverter converter = deserContext.getEventConverter();
            WebServicesParser parser2 = null;
            String xmlText = null;
            MappingScope ms = null;
            InputSource is = null;
            if (!toEventsSupported) {
                xmlText = "<XXX>" + this.getAsString(true) + "</XXX>";
                ms = this._getStrippedMappingScope();
                is = new InputSource(new StringReader(xmlText));
                parser2 = (WebServicesParser)XMLUtils.getSAXParser();
            }
            SOAPBuilder builder = this.createBuilder();
            builder.setMyElement(this);
            if (xmlText != null) {
                SOAPElement parent;
                for (parent = (SOAPElement)this.getParentElement(); parent != null && !(parent instanceof SOAPBody); parent = (SOAPElement)parent.getParentElement()) {
                }
                SOAPBody body = parent == null ? null : (SOAPBody)parent;
                converter.pushDEventProcessor(new WrapperProcessor(new AsSOAPElementProcessor(builder, body)));
            } else {
                converter.pushDEventProcessor(new WrapperProcessor(builder));
            }
            MessageContext msgContext = this.soapFactory.getMessageContext();
            boolean bl = saveException = msgContext != null && msgContext.getProperty(MessageContext.SAAJ_TRANSFORMATION) == null && (msgContext.isPropertyTrue(MessageContext.FAULT_ON_SAAJ_TRANSFORMATION) || log.isDebugEnabled() || !msgContext.isHighFidelity() && (msgContext.isRequestPath() && msgContext.isServer() || !msgContext.isRequestPath() && !msgContext.isServer()));
            if (saveException) {
                RuntimeException re2 = new RuntimeException(Messages.getMessage("saajtransform00", xmlText));
                if (msgContext.isPropertyTrue(MessageContext.FAULT_ON_SAAJ_TRANSFORMATION)) {
                    throw re2;
                }
                if (msgContext.getProperty(MessageContext.SAAJ_TRANSFORMATION) == null) {
                    msgContext.setProperty(MessageContext.SAAJ_TRANSFORMATION, re2);
                }
                if (log.isDebugEnabled()) {
                    log.debug(re2);
                }
            }
            SOAPDocument doc = (SOAPDocument)this.getOwnerDocument();
            boolean errorChecking = doc.getErrorChecking();
            doc.setErrorChecking(false);
            converter.startDocument();
            if (!toEventsSupported) {
                ac.detach();
                parser2.parse(is, (DefaultHandler)converter);
            } else {
                this.altContent = null;
                ac.toEvents(converter);
            }
            converter.endDocument();
            doc.setErrorChecking(errorChecking);
            converter.popDEventProcessor();
            if (!toEventsSupported && ms != null) {
                for (int i = 0; i < ms.size(); ++i) {
                    Mapping mapping = ms.get(i);
                    String prefix = mapping.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        prefix = XMLNS;
                    }
                    String ns = this.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix);
                    if (!mapping.getNamespaceURI().equals(ns)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("removing namespace declaration for " + prefix + " with namespace " + ns);
                    }
                    this.removeAttributeNS("http://www.w3.org/2000/xmlns/", prefix);
                }
            }
            this.setProtect(this.isProtect);
            Object var20_21 = null;
            this.inAsSOAPElement = false;
            this.rebuildTagQName = false;
            this.rebuildAttributesAndMapping = false;
            deserContext.freeEventConverter();
            if (parser2 == null) break block23;
            try {
                parser2.setProperty("http://xml.org/sax/properties/lexical-handler", null);
            }
            catch (Throwable e) {
                // empty catch block
            }
            parser2.recycle();
            parser2 = null;
            {
                break block23;
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.asSOAPElement", "1675", this);
                    throw new InternalException(e);
                }
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                this.inAsSOAPElement = false;
                this.rebuildTagQName = false;
                this.rebuildAttributesAndMapping = false;
                deserContext.freeEventConverter();
                if (parser2 != null) {
                    try {
                        parser2.setProperty("http://xml.org/sax/properties/lexical-handler", null);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    parser2.recycle();
                    parser2 = null;
                }
                throw throwable;
            }
        }
        this.enableMappingScopeOptimization(true);
    }

    private MappingScope _getStrippedMappingScope() {
        MappingScope ms = null;
        if (this.getParentElement() != null) {
            ms = ((SOAPElement)this.getParentElement())._getMappingScope();
            ms = ms.flatten();
        }
        return ms;
    }

    public final boolean isInAsSOAPElement() {
        return this.inAsSOAPElement;
    }

    public final boolean rebuildTagQName() {
        return this.rebuildTagQName && this.inAsSOAPElement;
    }

    public final boolean rebuildAttributesAndMapping() {
        return this.rebuildAttributesAndMapping && this.inAsSOAPElement;
    }

    public final Object asObject() throws Exception {
        QName type = this.getType();
        if (type == null) {
            type = QNameTable.createQName(this.namespaceURI, ">" + this.getLocalName());
        }
        try {
            return this.asObject(type);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("exception01", JavaUtils.stackToString(e)));
            }
            return this;
        }
    }

    private void removeChildren() {
        while (this.getFirstChild() != null) {
            this.removeChild((org.w3c.dom.Node)((Node)this.getFirstChild()));
        }
    }

    public final Object asObject(QName type) throws Exception {
        if (this.isObjectContent()) {
            return this.getAlternateContent();
        }
        Object objectValue = this.convertToObject(type);
        this.removeChildren();
        if (this.altContent != null) {
            this.altContent.detach();
        }
        this.setAlternateContent(objectValue);
        return objectValue;
    }

    protected final QName getType() {
        SOAPElement referent;
        String href;
        this.asSOAPElement(CONTEXT_ATTRS);
        Utils.addImplicitNamespaceDeclarations(this);
        Attributes attributes = this.getSAXAttributes();
        QName typeQName = AttributeUtils.getTypeFromAttributes(this.getNamespaceURI(), this.getLocalName(), attributes, this._getMappingScope());
        if (attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
            typeQName = Constants.SOAP_ARRAY;
        }
        if (typeQName == null && this.soapFactory.getDeserializationContext() != null && (href = AttributeUtils.getHref(attributes)) != null && (referent = this.soapFactory.getDeserializationContext().getHrefTable().getElementByHref(href)) != null) {
            typeQName = referent.getType();
        }
        return typeQName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object convertToObject(QName type) throws Exception {
        if (this.soapFactory.getDeserializationContext() == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer dser = this.soapFactory.getDeserializationContext().getDeserializer(null, type);
        if (dser == null) {
            throw new Exception(Messages.getMessage("noDeser00", EMPTY_STRING + type));
        }
        DeserializationContext context = this.soapFactory.getDeserializationContext();
        context.createEventConverter(new WrapperProcessor(dser));
        P2DConverter converter = context.getEventConverter();
        try {
            this.toEvents(converter);
            Object var6_5 = null;
            context.freeEventConverter();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.freeEventConverter();
            throw throwable;
        }
        return dser.getValue();
    }

    protected boolean isObjectContent() throws Exception {
        return this.altContent != null && this.altContent.isBusinessObject();
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPBuilder();
    }

    protected SOAPElement createChildElement(String namespaceURI, String localName, SOAPFactory factory) throws SOAPException {
        namespaceURI = this.domifyNamespace(namespaceURI);
        return new SOAPElement(namespaceURI, localName, factory);
    }

    protected boolean isValidSAAJChild(org.w3c.dom.Node node) {
        Class<?> cls = node.getClass();
        return (cls.equals(SOAPElement.class) || cls.equals(Text.class) || cls.equals(Comment.class) || cls.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public final void setProtect(boolean protect) {
        this.isProtect = protect;
        if (this.getAlternateContent() == null) {
            for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof SOAPElement)) continue;
                SOAPElement child = (SOAPElement)((Object)node);
                if (child.isProtect == protect) continue;
                child.setProtect(protect);
            }
        }
    }

    private final Node wrapChildDOMNode(org.w3c.dom.Node node) {
        if (node instanceof CharacterData) {
            String value = ((CharacterData)node).getNodeValue();
            if (SAAJ12Text.isCommentValue(value)) {
                return new Comment((SOAPDocument)this.ownerDocument, value);
            }
            return new Text((SOAPDocument)this.ownerDocument, value);
        }
        try {
            SOAPElement wrapperSE = this.createChildElement(node.getNamespaceURI(), node.getLocalName() == null || node.getLocalName().length() == 0 ? node.getNodeName() : node.getLocalName(), this.soapFactory);
            wrapperSE.setPrefix(node.getPrefix());
            wrapperSE.setAlternateContent(node);
            return wrapperSE;
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.wrapChildDOMNode", "2799", this);
            throw new RuntimeException(se);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public Object getAlternateContent() {
        return this.altContent == null ? null : this.altContent.getContent();
    }

    public final SOAPFactory getSOAPFactory() {
        return this.soapFactory;
    }

    public final IBMSOAPFactory getIBMSOAPFactory() {
        return this.getSOAPFactory();
    }

    public final void setQName(String namespace, String qualifiedName) {
        String localName = SOAPElement.extractLocalNameFromQName(qualifiedName);
        this.namespaceURI = namespace;
        this.localName = localName;
        this.setPrefix(SOAPElement.extractPrefixFromQName(qualifiedName));
    }

    public final QName getQName() {
        return QNameTable.createQName(this.getNamespaceURI(), this.getLocalName());
    }

    public final void addAttribute(String namespace, String localPart, String value) {
        this.addAttribute(namespace, null, localPart, value);
    }

    public final void addAttribute(String namespace, String prefix, String localPart, String value) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        if (namespace == null) {
            this.setAttribute(localPart, value);
        } else {
            if (prefix == null || prefix.length() == 0) {
                if (namespace.equals("http://www.w3.org/2000/xmlns/")) {
                    prefix = XMLNS;
                    if (localPart.equals(XMLNS)) {
                        prefix = EMPTY_STRING;
                    }
                } else if (prefix == null) {
                    Utils.addImplicitNamespaceDeclarations(this);
                    prefix = this._getMappingScope().getOrCreatePrefix(namespace, null, true);
                }
            }
            String prefixedName = prefix.length() > 0 ? prefix + ":" + localPart : localPart;
            this.setAttributeNS(namespace, prefixedName, value);
        }
    }

    public final Iterator getChildElements(String uri, String localPart) {
        this.asSOAPElement(CONTEXT_CONTENT);
        if (uri == null) {
            uri = EMPTY_STRING;
        }
        ArrayList<javax.xml.soap.SOAPElement> children = new ArrayList<javax.xml.soap.SOAPElement>();
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof javax.xml.soap.SOAPElement)) continue;
            javax.xml.soap.SOAPElement child = (javax.xml.soap.SOAPElement)node;
            String namespace = child.getNamespaceURI();
            String localName = child.getLocalName();
            if (namespace == null) {
                namespace = EMPTY_STRING;
            }
            if (localName == null) {
                localName = SOAPElement.extractLocalNameFromQName(child.getNodeName());
            }
            if (!uri.equals(namespace) || !localPart.equals(localName)) continue;
            children.add(child);
        }
        return children.iterator();
    }

    private final String domifyNamespace(String namespace) {
        return namespace == null || namespace.length() == 0 ? null : namespace;
    }

    private final Element _getDOMElement() {
        return this.altContent == null ? null : this.altContent.getDOMElement();
    }

    protected final SAAJ12Document getSAAJ12Document() {
        return (SAAJ12Document)this.ownerDocument;
    }

    protected final SOAPDocument getSOAPDocument() {
        return (SOAPDocument)this.ownerDocument;
    }

    final Attr importAttr(Attr attr) {
        Document oldDocument;
        Document document = this.getOwnerDocument();
        if (!document.equals(oldDocument = attr.getOwnerDocument())) {
            attr = (Attr)document.importNode(attr, true);
        }
        return attr;
    }

    protected static String extractPrefixFromQName(String qname) {
        int idx = qname.indexOf(58);
        if (idx > 0) {
            return qname.substring(0, idx);
        }
        return null;
    }

    protected static String extractLocalNameFromQName(String qname) {
        int idx = qname.indexOf(58);
        if (idx > 0) {
            return qname.substring(idx + 1);
        }
        return qname;
    }

    protected final MappingScope _getMappingScope() {
        this.asSOAPElement(CONTEXT_TAG);
        return super._getMappingScope();
    }

    public final String toXMLString() {
        return this.toXMLString(true);
    }

    public final String toXMLString(boolean includeNSDecls) {
        try {
            return this.getAsString(includeNSDecls);
        }
        catch (Exception exp) {
            FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.toXMLString", "3265", this);
            if (log.isDebugEnabled()) {
                log.error(Messages.getMessage("exception00"), exp);
            }
            throw new InternalException(exp);
        }
    }

    public InputSource toInputSource(boolean includeNSDecls) throws SAXException {
        try {
            InputSource value;
            if (this.altContent != null && !includeNSDecls && (value = this.altContent.getXMLInputSource()) != null) {
                return value;
            }
            MessageContext mc = this.soapFactory.getMessageContext();
            Message m = mc != null ? mc.getCurrentMessage() : null;
            String encoding = m != null ? m.getCharacterEncoding() : null;
            byte[] bytes = this.getContentAsBytes(mc, encoding, includeNSDecls);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            InputSource inputSource = new InputSource(is);
            if (encoding != null) {
                inputSource.setEncoding(encoding);
            }
            return inputSource;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.toInputSource", "2999", this);
            throw new SAXException(e);
        }
    }

    private byte[] getContentAsBytes(MessageContext msgContext, String encoding, boolean includeNSDecls) throws Exception {
        byte[] tmpBytes;
        Object tmpContents;
        int tmp_len = 1024;
        if (this.altContent != null && (tmpContents = this.altContent.getContent()) instanceof WebServicesInputSource && (tmpBytes = ((WebServicesInputSource)tmpContents).getBytes()) != null) {
            tmp_len += tmpBytes.length;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(tmp_len);
        Writer writer = encoding == null ? new OutputStreamWriter(baos) : new OutputStreamWriter((OutputStream)baos, encoding);
        writer = new BufferedWriter(writer, baos, "utf-8");
        SerializationContextImpl serializecontext = new SerializationContextImpl(writer, msgContext, false);
        if (includeNSDecls) {
            this.output(serializecontext);
        } else {
            this.outputImpl(serializecontext, false);
        }
        writer.close();
        return baos.toByteArray();
    }

    public boolean hasAlternateContent() {
        return this.getAlternateContent() != null;
    }

    public List getNamespaceDeclarations(boolean above, boolean on, boolean below) {
        return Utils.getNamespaceDeclarations(this, above, on, below);
    }

    public List getAttributes(boolean above, boolean on, boolean below) {
        return Utils.getAttributes(this, above, on, below);
    }

    public javax.xml.soap.Name getNameFromText(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        int colon = text.indexOf(58);
        String prefix = colon == -1 ? EMPTY_STRING : text.substring(0, colon);
        String localPart = colon == -1 ? text : text.substring(colon + 1);
        String namespace = this.getNamespaceURI(prefix);
        if (namespace == null) {
            if (prefix.length() > 0) {
                return null;
            }
            namespace = EMPTY_STRING;
        }
        return new Name(namespace, localPart, prefix);
    }

    public String getTextFromName(javax.xml.soap.Name name, boolean autoGenPrefix) {
        if (name == null) {
            return null;
        }
        String prefix = name.getPrefix() == null ? EMPTY_STRING : name.getPrefix();
        String namespace = name.getURI() == null ? EMPTY_STRING : name.getURI();
        String localPart = name.getLocalName();
        if (autoGenPrefix) {
            prefix = namespace.length() == 0 ? EMPTY_STRING : "ns" + namespace.hashCode();
        }
        if (namespace.length() == 0 && prefix.length() > 0) {
            return null;
        }
        String definedNS = this.getNamespaceURI(prefix);
        if (!(definedNS != null && definedNS.equals(namespace) || prefix.length() == 0 && definedNS == null && namespace.length() == 0)) {
            this.addNamespaceDeclaration(prefix, namespace);
        }
        if (prefix.length() == 0) {
            return localPart;
        }
        return prefix + ":" + localPart;
    }

    public javax.xml.soap.SOAPElement addSwaRefTextNode(String mimeType, Object attachment) throws SOAPException {
        boolean deferAttach;
        SOAPMessage msg;
        if (log.isDebugEnabled()) {
            log.debug("Enter: addSwaRefTextNode(mimeType, attachment)");
        }
        MessageContext msgContext = this.soapFactory.getMessageContext();
        MessageContext currentMsgContext = MessageContext.getCurrentThreadsContext();
        SOAPMessage sOAPMessage = msg = msgContext != null ? msgContext.getMessage() : null;
        if (log.isDebugEnabled()) {
            if (msgContext != currentMsgContext) {
                log.debug("WARNING: This SOAPElement was created with a static SOAPFactory");
            }
            log.debug("msgContext.getMessage() is " + (msg == null ? "null" : "not null"));
            log.debug("isServer=" + currentMsgContext.isServer());
            log.debug("isInvokingTarget=" + currentMsgContext.isInvokingTarget());
        }
        boolean bl = deferAttach = msg == null || msgContext != currentMsgContext || msgContext.isServer() && msgContext.isInvokingTarget();
        if (deferAttach) {
            if (log.isDebugEnabled()) {
                log.debug("Adding a deferred attachment for " + mimeType);
            }
            this.deferredMimeType = mimeType;
            this.deferredAttachment = attachment;
            if (log.isDebugEnabled()) {
                log.debug("Exit: addSwaRefTextNode(mimeType, attachment)");
            }
            return this;
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding an attachment on the message context for " + mimeType);
        }
        javax.xml.soap.SOAPElement se = this.addSwaRefTextNode(mimeType, attachment, msg);
        if (log.isDebugEnabled()) {
            log.debug("Exit: addSwaRefTextNode(mimeType, attachment)");
        }
        return se;
    }

    private javax.xml.soap.SOAPElement addSwaRefTextNode(String mimeType, Object attachment, SOAPMessage msg) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: addSwaRefTextNode(mimeType, attachment, msg)");
            log.debug("mimeType=" + mimeType);
        }
        DataHandler dh = AttachmentUtils.dataHandlerForObject((String)mimeType, (Object)attachment);
        Attachments attachments = ((Message)msg).getAttachmentsImpl();
        try {
            Part part = attachments.createAttachmentPart((Object)dh);
            javax.xml.soap.SOAPElement se = this.addTextNode(part.getContentIdRef());
            if (log.isDebugEnabled()) {
                log.debug("Exit: addSwaRefTextNode(mimeType, attachment, msg)");
            }
            return se;
        }
        catch (WebServicesFault wsf) {
            FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addSwaRefTextNode", "2994", this);
            throw new SOAPException(wsf.getMessage());
        }
    }

    public boolean isSwaRef() {
        try {
            this.getSwaRefAttachment();
            return true;
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.isSwaRef", "3026", this);
            return false;
        }
    }

    public Object getSwaRefAttachment() throws SOAPException {
        if (this.deferredAttachment != null) {
            return this.deferredAttachment;
        }
        MessageContext msgContext = this.soapFactory.getMessageContext();
        if (msgContext != null) {
            SOAPMessage msg = msgContext.getMessage();
            return this.getSwaRefAttachment(msg);
        }
        throw new SOAPException(Messages.getMessage("notSwaRef00"));
    }

    public Object getSwaRefAttachment(SOAPMessage message) throws SOAPException {
        String value;
        if (this.deferredAttachment != null) {
            return this.deferredAttachment;
        }
        if (message != null && (value = this.getValue()) != null) {
            Iterator attachments = message.getAttachments();
            while (attachments.hasNext()) {
                AttachmentPart attachment = (AttachmentPart)attachments.next();
                if (!value.equals(attachment.getContentIdRef())) continue;
                return AttachmentUtils.objectForDataHandler((DataHandler)attachment.getDataHandler());
            }
        }
        throw new SOAPException(Messages.getMessage("notSwaRef00"));
    }

    protected boolean isSOAP12() {
        return this.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals("SOAP 1.2 Protocol");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.asSOAPElement(CONTEXT_TAG);
        this.enableMappingScopeOptimization(false);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public javax.xml.soap.SOAPElement addChildElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addChildElement(QName)", "javax.xml.soap.SOAPElement"));
        }
        return this.addChildElement(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }

    public javax.xml.soap.SOAPElement addAttribute(QName qName, String value) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addAttribute(QName, value)", "javax.xml.soap.SOAPElement"));
        }
        QName encStyle = this.soapFactory.getSOAPConstants().getEncodingStyleQName();
        if (encStyle.equals(qName)) {
            this.setEncodingStyle(value);
        } else {
            this.addAttribute(qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalPart(), value);
        }
        return this;
    }

    public String getAttributeValue(QName qName) {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getAttributeValue(QName)", "javax.xml.soap.SOAPElement"));
        }
        String value = null;
        String nameSpace = this.domifyNamespace(qName.getNamespaceURI());
        String localName = qName.getLocalPart();
        value = nameSpace == null ? this.getAttribute(localName) : this.getAttributeNS(nameSpace, localName);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value;
    }

    public QName createQName(String localName, String prefix) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "creaeQName(String localName, String prefix)", "javax.xml.soap.SOAPElement"));
        }
        String namespace = this.getNamespaceURI(prefix);
        if (namespace == null) {
            throw new SOAPException(Messages.getMessage("exception01", "Null namespaceURI"));
        }
        return new QName(namespace, localName, prefix);
    }

    public QName getElementQName() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getElementQName()", "javax.xml.soap.SOAPElement"));
        }
        String namespace = this.getNamespaceURI();
        namespace = namespace == null ? EMPTY_STRING : namespace;
        String prefix = this.getPrefix();
        prefix = prefix == null ? EMPTY_STRING : prefix;
        String localName = this.getLocalName();
        return new QName(namespace, localName, prefix);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName newQName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPElement"));
        }
        this.setQName(newQName.getNamespaceURI(), newQName.getLocalPart());
        this.setPrefix(newQName.getPrefix());
        return this;
    }

    public boolean removeAttribute(QName qName) {
        String namespace = this.domifyNamespace(qName.getNamespaceURI());
        String localName = qName.getLocalPart();
        boolean removed = false;
        if (this.hasAttributeNS(namespace, localName)) {
            this.removeAttributeNS(namespace, localName);
            removed = true;
        }
        return removed;
    }

    public Iterator getChildElements(QName qname) {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getChildElements(QName)", "javax.xml.soap.SOAPElement"));
        }
        return this.getChildElements(qname.getNamespaceURI(), qname.getLocalPart());
    }

    static {
        block3: {
            log = LogFactory.getLog(SOAPElement.class.getName());
            CONTEXT_CONTENT = 1;
            CONTEXT_ATTRS = 2;
            CONTEXT_TAG = 3;
            disableSOAPNamespaceValidation = false;
            String propName = "com.ibm.ws.webservices.disableSOAPNamespaceValidation";
            try {
                disableSOAPNamespaceValidation = MCUtils.isPropertyEnabled(propName);
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg(propName, disableSOAPNamespaceValidation));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception occurred obtaining and evaluating system property {" + propName + "}", e);
            }
        }
    }

    class CEIterator
    implements Iterator {
        org.w3c.dom.Node parent;
        org.w3c.dom.Node prev;
        boolean first = true;
        boolean safeRemove = false;
        String methodName;

        CEIterator(org.w3c.dom.Node parent, String methodName) {
            this.parent = parent;
            this.methodName = methodName;
            this.prev = parent;
        }

        public boolean hasNext() {
            if (this.prev == null) {
                return false;
            }
            if (this.first) {
                return this.prev.getFirstChild() != null;
            }
            return this.prev.getNextSibling() != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(Messages.getMessage("exception00"));
            }
            this.safeRemove = true;
            if (this.first) {
                this.prev = this.prev.getFirstChild();
                this.first = false;
            } else {
                this.prev = this.prev.getNextSibling();
            }
            return this.prev;
        }

        public void remove() {
            if (!this.safeRemove || this.prev == null) {
                throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
            }
            this.safeRemove = false;
            org.w3c.dom.Node se = this.prev.getPreviousSibling();
            this.parent.removeChild(this.prev);
            if (se == null) {
                this.first = true;
                this.prev = this.parent;
            } else {
                this.prev = se;
            }
        }
    }
}

