/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils.bytecode;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class ParamNameExtractor {
    protected static Log log = LogFactory.getLog(ParamNameExtractor.class.getName());

    public static String[] getParameterNamesFromDebugInfo(Method method2) {
        int numParams = method2.getParameterTypes().length;
        if (numParams == 0) {
            return null;
        }
        Class<?> c = method2.getDeclaringClass();
        try {
            ParamReader pr = new ParamReader(c);
            String[] names = pr.getParameterNames(method2);
            return names;
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor.getParameterNamesFromDebugInfo", "98");
            log.info(Messages.getMessage("error00") + ":" + e);
            return null;
        }
    }

    public static String[] getParameterNamesFromDebugInfo(Constructor constructor) {
        int numParams = constructor.getParameterTypes().length;
        if (numParams == 0) {
            return null;
        }
        Class c = constructor.getDeclaringClass();
        try {
            ParamReader pr = new ParamReader(c);
            String[] names = pr.getParameterNames(constructor);
            return names;
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor.getParameterNamesFromDebugInfo", "98");
            log.info(Messages.getMessage("error00") + ":" + e);
            return null;
        }
    }
}

