/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.utils;

import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;

public class BeanDesc {
    private static Log log = LogFactory.getLog(BeanDesc.class.getName());
    protected Class javaClass = null;
    protected ArrayList fields = new ArrayList();
    protected HashMap fieldDescMap = new HashMap();
    protected HashMap fieldNameMap = new HashMap();
    protected BeanPropertyDescriptor[] propertyDescriptors = null;
    protected Map propertyMap = null;
    protected boolean _hasAttributes = false;
    protected String buildNumber = null;

    protected BeanDesc() {
    }

    public static BeanDesc getBeanDescForClass(Class cls) {
        TypeDesc typeDesc = TypeDesc.getTypeDescForClass(cls);
        if (typeDesc == null) {
            return null;
        }
        BeanDesc bd = new BeanDesc();
        bd.javaClass = cls;
        bd.buildNumber = (String)typeDesc.getOption("buildNum");
        if (bd.buildNumber == null) {
            bd.buildNumber = "pre-WAS 6.0 build";
        } else if (bd.buildNumber.equals(Version.getRawBuildNum())) {
            bd.buildNumber = null;
        }
        com.ibm.ws.webservices.engine.description.FieldDesc[] fields = typeDesc.getFields();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                FieldDesc fieldDesc = new FieldDesc(fields[i]);
                bd.addFieldDesc(fieldDesc);
                bd.fields.add(fieldDesc);
            }
        }
        bd._prime();
        return bd;
    }

    public final BeanPropertyDescriptor getAnyDesc() {
        return (BeanPropertyDescriptor)this.propertyMap.get("_any");
    }

    public final ArrayList getFields() {
        return this.fields;
    }

    public final FieldDesc getFieldByName(String name) {
        return (FieldDesc)this.fieldNameMap.get(name);
    }

    public final boolean hasAttributes() {
        return this._hasAttributes;
    }

    public final BeanPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = BeanUtils.getPd(this.javaClass, this);
            this.propertyMap = null;
            this.getPropertyDescriptorMap();
        }
        return this.propertyDescriptors;
    }

    public final synchronized BeanPropertyDescriptor[] setBeanPropertyDescriptors(Class proxy) {
        this.propertyDescriptors = BeanUtils.getPd(proxy, this);
        this.propertyMap = null;
        this.getPropertyDescriptorMap();
        return this.propertyDescriptors;
    }

    public final Map getPropertyDescriptorMap() {
        if (this.propertyMap != null) {
            return this.propertyMap;
        }
        if (this.propertyDescriptors == null) {
            this.getPropertyDescriptors();
        }
        this.propertyMap = new HashMap();
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            BeanPropertyDescriptor descriptor = this.propertyDescriptors[i];
            this.propertyMap.put(descriptor.getName(), descriptor);
            FieldDesc field = this.getFieldByName(descriptor.getName());
            if (field == null) continue;
            this.setJavaType(field, descriptor);
            field.setPropertyDescriptor(descriptor);
        }
        return this.propertyMap;
    }

    protected void setJavaType(FieldDesc fieldDesc, BeanPropertyDescriptor bpd) {
        Class javaType = bpd.getFullType();
        if (!javaType.isArray()) {
            fieldDesc.setJavaType(javaType);
        } else {
            if (!fieldDesc.isMaxOccurs() && ("pre-WAS 6.0 build".equals(this.buildNumber) || Constants.equals(Constants.XSD_ANY, fieldDesc.getXmlType())) && bpd.isIndexed()) {
                fieldDesc.setMaxOccurs(true);
            }
            if (!fieldDesc.isMaxOccurs()) {
                fieldDesc.setJavaType(javaType);
            } else {
                fieldDesc.setJavaType(javaType.getComponentType());
            }
        }
    }

    public final synchronized void addFieldDesc(FieldDesc fieldDesc) {
        BeanPropertyDescriptor descriptor;
        String localPart = fieldDesc.getXmlName().getLocalPart();
        String namespaceURI = fieldDesc.getXmlName().getNamespaceURI();
        Object value = this.fieldDescMap.get(localPart);
        if (value == null) {
            this.fieldDescMap.put(localPart, fieldDesc);
        } else if (value instanceof FieldDesc) {
            FieldDesc f = (FieldDesc)value;
            if (!f.getXmlName().getNamespaceURI().equals(namespaceURI)) {
                HashMap<String, FieldDesc> table2 = new HashMap<String, FieldDesc>();
                this.fieldDescMap.put(localPart, table2);
                table2.put(namespaceURI, fieldDesc);
                table2.put(f.getXmlName().getNamespaceURI(), f);
            }
        } else {
            HashMap table2 = (HashMap)value;
            FieldDesc f = (FieldDesc)table2.get(namespaceURI);
            if (f == null) {
                table2.put(namespaceURI, fieldDesc);
            }
        }
        this.fieldNameMap.put(fieldDesc.getFieldName(), fieldDesc);
        if (!fieldDesc.isElement()) {
            this._hasAttributes = true;
        }
        if (this.propertyMap != null && (descriptor = (BeanPropertyDescriptor)this.propertyMap.get(fieldDesc.getFieldName())) != null) {
            this.setJavaType(fieldDesc, descriptor);
            fieldDesc.setPropertyDescriptor(descriptor);
        }
    }

    public final FieldDesc getFieldDesc(String namespaceURI, String localPart) {
        Object value;
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if ((value = this.fieldDescMap.get(localPart)) == null) {
            return null;
        }
        if (value.getClass() == FieldDesc.class) {
            String namespace = ((FieldDesc)value).getXmlName().getNamespaceURI();
            if (namespace == namespaceURI || namespace.equals(namespaceURI)) {
                return (FieldDesc)value;
            }
            return null;
        }
        return (FieldDesc)((HashMap)value).get(namespaceURI);
    }

    protected void _prime() {
        BeanDesc superDesc;
        this.getPropertyDescriptorMap();
        Class cls = this.javaClass.getSuperclass();
        if (cls != null && !cls.getName().startsWith("java.") && (superDesc = BeanDesc.getBeanDescForClass(cls)) != null) {
            this.fields.addAll(0, superDesc.fields);
            superDesc.getFieldDesc("", "");
            Iterator it = superDesc.fieldDescMap.values().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof FieldDesc) {
                    this.addFieldDesc((FieldDesc)next);
                    continue;
                }
                Map map = (Map)next;
                Iterator it2 = map.values().iterator();
                while (it2.hasNext()) {
                    FieldDesc fieldDesc = (FieldDesc)it2.next();
                    this.addFieldDesc(fieldDesc);
                }
            }
        }
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }
}

