/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import javax.xml.namespace.QName;

public abstract class ComponentDeserializer
extends Deserializer {
    protected SimpleDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;
    protected DefaultDeserializer cacheDefaultDSer = null;

    public ComponentDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    protected Deserializer getDeserializer(QName xmlType, Class javaType, String href, DeserializationContext context) {
        if (this.cacheStringDSer != null && String.class.equals(javaType) && href == null && (this.cacheXMLType == null && xmlType == null || this.cacheXMLType != null && this.cacheXMLType.equals(xmlType)) && this.cacheStringDSer.recycle()) {
            return this.cacheStringDSer;
        }
        Deserializer dSer = null;
        if (xmlType != null && href == null) {
            dSer = context.getDeserializer(javaType, xmlType);
            if (dSer == null) {
                dSer = context.getDeserializer(null, xmlType);
            }
        } else {
            TypeMapping tm = context.getTypeMapping();
            QName defaultXMLType = xmlType;
            if (xmlType == null) {
                defaultXMLType = tm.getTypeQName(javaType);
            }
            if (href == null) {
                dSer = context.getDeserializer(javaType, defaultXMLType);
            } else {
                if (this.cacheDefaultDSer == null) {
                    this.cacheDefaultDSer = new DefaultDeserializer();
                    dSer = this.cacheDefaultDSer;
                } else {
                    dSer = this.cacheDefaultDSer.recycle() ? this.cacheDefaultDSer : new DefaultDeserializer();
                }
                dSer.setDefaultType(defaultXMLType);
            }
        }
        if (String.class.equals(javaType) && dSer instanceof SimpleDeserializer) {
            this.cacheStringDSer = (SimpleDeserializer)dSer;
            this.cacheXMLType = xmlType;
        }
        return dSer;
    }
}

