/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.utils.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public final class SerializationWriter {
    protected static Log log = LogFactory.getLog(SerializationWriter.class.getName());
    private Scopes scopes = new Scopes();
    private boolean writingStartTag = false;
    private boolean startOfDocument = true;
    private String charEncoding;
    private int indent = 0;
    private boolean onlyXML = true;
    private boolean pretty = false;
    private Stack stack = new Stack();
    private Mapping xsiMapping = null;
    private int xsiDepth = 100000000;
    private final BufferedWriter writer;
    private char[] workChars = new char[1000];
    private int depth = 0;
    boolean forceRealPrefix = true;

    public SerializationWriter(Writer writer, String charEncoding, boolean startOfDocument) {
        this(writer, charEncoding, startOfDocument, null);
    }

    public SerializationWriter(Writer writer, String charEncoding, boolean startOfDocument, OutputStream os2) {
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, os2, charEncoding);
        this.charEncoding = charEncoding;
        this.startOfDocument = startOfDocument;
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public void startElement(QName qName, Attributes attributes, MappingScope mappingScope) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._startElement(qName, null, attributes, true);
    }

    public void startElement(QName qName, String prefix, Attributes attributes, MappingScope mappingScope) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._startElement(qName, prefix, attributes, false);
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        this._startElement(qName, null, attributes, true);
    }

    public void startElement(QName qName, String prefix, Attributes attributes) throws IOException {
        this._startElement(qName, prefix, attributes, false);
    }

    public void _startElement(QName qName, String prefix, Attributes attributes, boolean autoGenPrefix) throws IOException {
        ++this.depth;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.charEncoding + "\"?>\n");
            this.startOfDocument = false;
        }
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(62);
                ++this.indent;
            }
        } else {
            if (this.writingStartTag) {
                this.writer.write(62, 10);
                ++this.indent;
            }
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        MappingScope mappingScope = this.scopes.getMappingScope();
        if (autoGenPrefix) {
            prefix = !mappingScope.hasMappings() ? this.scopes.getOrCreatePrefix_Fast(qName.getNamespaceURI()) : this.scopes.getOrCreatePrefix(qName.getNamespaceURI(), null, this.forceRealPrefix);
        }
        prefix = prefix == null ? "" : prefix;
        this.stack.push(qName.getLocalPart());
        this.stack.push(prefix);
        if (prefix.length() > 0) {
            this.writer.write(60, prefix);
            this.writer.write(58, qName.getLocalPart());
        } else {
            this.writer.write(60, qName.getLocalPart());
        }
        ArrayList xmlnsAttrs = null;
        if (attributes != null && attributes.getLength() > 0) {
            xmlnsAttrs = this.writeAttributes(attributes, autoGenPrefix);
        }
        if (mappingScope.hasMappings()) {
            this.writePrefixMappings(mappingScope, xmlnsAttrs);
        }
        this.scopes.push();
        this.writingStartTag = true;
        this.onlyXML = true;
    }

    private ArrayList writeAttributes(Attributes attributes, boolean autoGenPrefix) throws IOException {
        ArrayList<String> xmlnsAttrs = null;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                int idx;
                String uri = attributes.getURI(i);
                String prefix = "";
                String prefixedName = attributes.getQName(i);
                if (prefixedName.length() == 0) {
                    prefixedName = attributes.getLocalName(i);
                }
                if (uri == SchemaVersion.SCHEMA_2001.getXsiURI() && prefixedName.startsWith("xsi:") && this.depth > this.xsiDepth) {
                    this.writer.write(32, prefixedName);
                    this.writer.write(61, 34);
                    this.writer.write(attributes.getValue(i), 34);
                    continue;
                }
                if (autoGenPrefix && uri != null && uri.length() > 0 && (idx = prefixedName.indexOf(58)) > -1) {
                    String newPrefix = null;
                    prefix = prefixedName.substring(0, idx);
                    if (!prefix.equals("xmlns")) {
                        newPrefix = this.scopes.getOrCreatePrefix(uri, prefix, true);
                    }
                    if (newPrefix != null && !newPrefix.equals(prefix)) {
                        prefixedName = newPrefix.length() > 0 ? newPrefix + ':' + attributes.getLocalName(i) : attributes.getLocalName(i);
                    }
                }
                if (prefixedName.startsWith("xmlns")) {
                    if (xmlnsAttrs == null) {
                        xmlnsAttrs = new ArrayList<String>();
                    }
                    if (xmlnsAttrs.indexOf(attributes.getLocalName(i)) >= 0) continue;
                    xmlnsAttrs.add(attributes.getLocalName(i));
                }
                this.writer.write(32, prefixedName);
                this.writer.write(61, 34);
                this.writer.write(this.xmlEncodeString(attributes.getValue(i)), 34);
            }
        }
        return xmlnsAttrs;
    }

    private String xmlEncodeString(String value) {
        if (value != null && value.length() >= this.workChars.length) {
            this.workChars = new char[value.length() + 100];
        }
        return XMLUtils.xmlEncodeString(value, this.workChars);
    }

    private void writePrefixMappings(MappingScope mappingScope, ArrayList xmlnsAttrs) throws IOException {
        for (int i = 0; i < mappingScope.size(); ++i) {
            Mapping map = mappingScope.get(i);
            if ("http://www.w3.org/XML/1998/namespace".equals(map.getNamespaceURI()) || xmlnsAttrs != null && xmlnsAttrs.indexOf(map.getPrefix()) >= 0) continue;
            this.writer.write(" xmlns");
            if (map.getPrefix().length() > 0) {
                this.writer.write(58, map.getPrefix());
            }
            this.writer.write(61, 34);
            this.writer.write(map.getNamespaceURI(), 34);
            if (map.getNamespaceURI() != SchemaVersion.SCHEMA_2001.getXsiURI() || !map.getPrefix().equals("xsi")) continue;
            this.xsiMapping = map;
            this.xsiDepth = this.depth;
        }
    }

    public void endElement() throws IOException {
        --this.depth;
        String prefix = (String)this.stack.pop();
        String localPart = (String)this.stack.pop();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("endElem00", "" + prefix + ":" + localPart));
        }
        this.scopes.pop();
        this.scopes.clearTop();
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(47, 62);
                this.writingStartTag = false;
            } else {
                this.indent = this.onlyXML ? this.indent - 1 : this.indent;
                this.writer.write(60, 47);
                if (prefix.length() > 0) {
                    this.writer.write(prefix, 58);
                }
                this.writer.write(localPart, 62);
            }
        } else if (this.writingStartTag) {
            this.writer.write(47, 62);
            this.writer.write(10);
            this.writingStartTag = false;
        } else {
            if (this.onlyXML) {
                --this.indent;
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(32);
                }
            }
            this.writer.write(60, 47);
            if (prefix.length() > 0) {
                this.writer.write(prefix, 58);
            }
            this.writer.write(localPart, 62);
            if (this.indent > 0) {
                this.writer.write(10);
            }
        }
        this.onlyXML = true;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
    }

    public void simpleElement(QName qName, Attributes attributes, MappingScope mappingScope, String value) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._simpleElement(qName, null, attributes, value, true);
    }

    public void simpleElement(QName qName, String prefix, Attributes attributes, MappingScope mappingScope, String value) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._simpleElement(qName, prefix, attributes, value, false);
    }

    public void simpleElement(QName qName, Attributes attributes, String value) throws IOException {
        if (qName == null && attributes == null) {
            this._simplestElement(value);
        } else {
            this._simpleElement(qName, null, attributes, value, true);
        }
    }

    private void _simplestElement(String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.writeSafeString(value);
        }
    }

    public void simpleElement(QName qName, String prefix, Attributes attributes, String value) throws IOException {
        this._simpleElement(qName, prefix, attributes, value, false);
    }

    private void _simpleElement(QName qName, String prefix, Attributes attributes, String value, boolean autoGenPrefix) throws IOException {
        if (this.startOfDocument) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(62);
                ++this.indent;
            }
        } else {
            if (this.writingStartTag) {
                this.writer.write(62, 10);
                ++this.indent;
            }
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        MappingScope mappingScope = this.scopes.getMappingScope();
        if (autoGenPrefix) {
            prefix = this.scopes.getOrCreatePrefix_Fast(qName.getNamespaceURI());
        }
        String string = prefix = prefix == null ? "" : prefix;
        if (prefix.length() > 0) {
            this.writer.write(60, prefix);
            this.writer.write(58, qName.getLocalPart());
        } else {
            this.writer.write(60, qName.getLocalPart());
        }
        ArrayList xmlnsAttrs = null;
        if (attributes != null && attributes.getLength() > 0) {
            xmlnsAttrs = this.writeAttributes(attributes, autoGenPrefix);
        }
        if (mappingScope.hasMappings()) {
            this.writePrefixMappings(mappingScope, xmlnsAttrs);
        }
        this.writingStartTag = true;
        this.onlyXML = true;
        if (value != null && value.length() > 0) {
            this.writeSafeString(value);
        }
        this.scopes.clearTop();
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(47, 62);
                this.writingStartTag = false;
            } else {
                this.indent = this.onlyXML ? this.indent - 1 : this.indent;
                this.writer.write(60, 47);
                if (prefix.length() > 0) {
                    this.writer.write(prefix, 58);
                }
                this.writer.write(qName.getLocalPart(), 62);
            }
        } else if (this.writingStartTag) {
            this.writer.write(47, 62);
            this.writer.write(10);
            this.writingStartTag = false;
        } else {
            if (this.onlyXML) {
                --this.indent;
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(32);
                }
            }
            this.writer.write(60, 47);
            if (prefix.length() > 0) {
                this.writer.write(prefix, 58);
            }
            this.writer.write(qName.getLocalPart(), 62);
            if (this.indent > 0) {
                this.writer.write(10);
            }
        }
        this.onlyXML = true;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
    }

    public void writeChars(char[] p1, int p2, int p3) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(p1, p2, p3));
        this.onlyXML = false;
    }

    public void write(byte[] b, int start, int len, String enc) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(b, start, len, enc);
        this.onlyXML = false;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
    }

    public void write(byte[] b, String enc) throws IOException {
        this.write(b, 0, b.length, enc);
    }

    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62, string);
            this.writingStartTag = false;
        } else {
            this.writer.write(string);
        }
        this.onlyXML = false;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
    }

    public void writeSnippet(String string, MappingScope mappingScope) throws IOException {
        int endOfTag = string.indexOf(">");
        if (mappingScope == null || !mappingScope.hasMappings() || endOfTag <= 0) {
            this.writeString(string);
            return;
        }
        if (string.charAt(endOfTag - 1) == '/') {
            --endOfTag;
        }
        String tag = string.substring(0, endOfTag);
        String rest = string.substring(endOfTag);
        for (int i = 0; i < mappingScope.size(); ++i) {
            Mapping mapping = mappingScope.get(i);
            String pref = mapping.getPrefix();
            String search = pref.length() == 0 ? "xmlns=" : "xmlns:" + pref + "=";
            int index = tag.indexOf(search);
            if (index >= 0) continue;
            tag = tag + " " + search + "\"" + mapping.getNamespaceURI() + "\"";
        }
        this.writeString(tag + rest);
    }

    public void writeSafeString(String string) throws IOException {
        if (string.length() > 9 && string.startsWith("<![") && string.substring(0, 9).toUpperCase().equals("<![CDATA[")) {
            this.writeString(string);
        } else {
            this.writeString(this.xmlEncodeString(string));
        }
    }

    public void writeComment(String text) throws IOException {
        this.writeString("<!--");
        this.writeSafeString(text);
        this.writeString("-->");
    }

    public void writeDOMElement(Element el, MappingScope ms, boolean msForParent) throws IOException {
        this.scopes.push();
        if (ms == null) {
            this.writeDOMElement(el);
            return;
        }
        this.scopes.replaceMappingScope(ms);
        if (msForParent) {
            this.scopes.push();
        }
        this.writeDOMElement(el);
        if (msForParent) {
            this.scopes.pop();
        }
        this.scopes.pop();
    }

    public void writeDOMElement(Element el) throws IOException {
        AttributesImpl attributes = null;
        NamedNodeMap attrMap = el.getAttributes();
        if (attrMap.getLength() > 0) {
            attributes = new AttributesImpl();
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                String ns = attr.getNamespaceURI() == null ? "" : attr.getNamespaceURI();
                boolean has_xmlns = attr.getName().startsWith("xmlns:");
                boolean is_xmlns = attr.getName().equals("xmlns");
                if (ns.equals("http://www.w3.org/2000/xmlns/") || has_xmlns || is_xmlns) {
                    String namespaceURI = attr.getValue();
                    String prefix = null;
                    if (has_xmlns) {
                        prefix = attr.getName().substring(attr.getName().indexOf(":") + 1);
                    } else if (is_xmlns) {
                        prefix = "";
                    } else {
                        prefix = attr.getLocalName();
                        if (prefix.equals("xmlns")) {
                            prefix = "";
                        }
                    }
                    this.addMapping(prefix, namespaceURI);
                    continue;
                }
                attributes.addAttribute(ns, attr.getLocalName(), attr.getName(), "CDATA", attr.getValue());
            }
        }
        String namespaceURI = el.getNamespaceURI();
        String localPart = el.getLocalName();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            localPart = el.getNodeName();
        }
        QName qName = QNameTable.createQName(namespaceURI, localPart);
        String prefix = el.getPrefix();
        if (log.isDebugEnabled() && namespaceURI != null && namespaceURI.length() > 0) {
            String pre;
            String string = pre = prefix == null ? "" : prefix;
            if (!namespaceURI.equals(this.getNamespaceURI(pre))) {
                log.debug("Potential User Problem :Missing namespace/prefix declaration for element:" + qName.toString() + " with prefix (" + prefix + ")");
            }
        }
        this.startElement(qName, prefix, attributes);
        for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                this.writeDOMElement((Element)child);
                continue;
            }
            if (child instanceof CDATASection) {
                this.writeString("<![CDATA[");
                this.writeString(((Text)child).getData());
                this.writeString("]]>");
                continue;
            }
            if (child instanceof Comment) {
                this.writeString("<!--");
                this.writeString(((CharacterData)child).getData());
                this.writeString("-->");
                continue;
            }
            if (!(child instanceof Text)) continue;
            this.writeSafeString(((Text)child).getData());
        }
        this.endElement();
    }

    public String getOrCreatePrefix(String namespace, String defaultPrefix, boolean noDefault) {
        return this.scopes.getOrCreatePrefix(namespace, defaultPrefix, noDefault);
    }

    public String getNamespaceURI(String prefix) {
        String namespace = null;
        MappingScope ms = this.scopes.getMappingScope();
        Mapping mapping = ms.getMappingForPrefix(prefix, false);
        if (mapping != null) {
            namespace = mapping.getNamespaceURI();
        }
        return namespace;
    }

    public void addMapping(String prefix, String uri) {
        if (prefix == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "prefix"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "namespaceURI"));
        }
        if (uri.length() == 0 && prefix.length() > 0) {
            throw new IllegalArgumentException(Messages.getMessage("mapUnqualNamespace00", prefix));
        }
        this.scopes.getMappingScope().addMapping(uri, prefix);
    }

    public String qName2String(QName qName) {
        return this.qName2String(qName, true);
    }

    public String qName2String(QName qName, boolean noDefault) {
        String prefix = this.scopes.getOrCreatePrefix(qName.getNamespaceURI(), null, noDefault);
        if (prefix.length() == 0) {
            return qName.getLocalPart();
        }
        StringBuffer sb = new StringBuffer(prefix);
        sb.append(':');
        sb.append(qName.getLocalPart());
        return sb.toString();
    }

    public void setForceRealPrefix(boolean value) {
        this.forceRealPrefix = value;
    }

    class Scopes {
        private MappingScope[] mArray = new MappingScope[10];
        int top = -1;
        boolean cacheValid = false;
        boolean uCacheValid = false;
        String cachePrefix = null;
        String cacheNamespaceURI = null;

        public Scopes() {
            this.push();
        }

        public MappingScope getMappingScope() {
            if (this.top < 0) {
                return null;
            }
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope == null) {
                mappingScope = new MappingScope();
                if (this.top > 0) {
                    mappingScope.setParent(this.mArray[this.top - 1]);
                }
                this.mArray[this.top] = mappingScope;
            }
            return mappingScope;
        }

        public void replaceMappingScope(MappingScope mappingScope) {
            if (mappingScope != this.mArray[this.top]) {
                if (!mappingScope.hasMappings()) {
                    this.getMappingScope().clear();
                    if (this.top > 0) {
                        this.getMappingScope().setParent(this.mArray[this.top - 1]);
                    }
                } else {
                    this.cacheValid = false;
                    this.uCacheValid = false;
                    this.mArray[this.top] = (MappingScope)mappingScope.clone();
                    if (this.top > 0) {
                        this.getMappingScope().setParent(this.mArray[this.top - 1]);
                    }
                }
            }
        }

        public void push() {
            MappingScope ms = null;
            if (this.top >= 0) {
                ms = this.mArray[this.top];
            }
            boolean noMappings = ms != null && !ms.hasMappings();
            this.cacheValid = this.cacheValid && noMappings;
            this.uCacheValid = this.uCacheValid && noMappings;
            ++this.top;
            if (this.top >= this.mArray.length) {
                MappingScope[] newstack = new MappingScope[this.mArray.length * 2];
                System.arraycopy(this.mArray, 0, newstack, 0, this.mArray.length);
                this.mArray = newstack;
            }
            this.getMappingScope().clear();
        }

        public void pop() {
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope != null) {
                boolean noMappings = !mappingScope.hasMappings();
                this.cacheValid = this.cacheValid && noMappings;
                this.uCacheValid = this.uCacheValid && noMappings;
            }
            --this.top;
        }

        public void clearTop() {
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope != null) {
                boolean noMappings = !mappingScope.hasMappings();
                this.cacheValid = this.cacheValid && noMappings;
                this.uCacheValid = this.uCacheValid && noMappings;
                mappingScope.clear();
            }
        }

        public String getOrCreatePrefix_Fast(String namespaceURI) {
            if (namespaceURI.length() == 0) {
                return this.getOrCreatePrefix_FastU();
            }
            MappingScope mappingScope = this.getMappingScope();
            if (this.cacheValid && namespaceURI.equals(this.cacheNamespaceURI) && !mappingScope.hasMappings()) {
                return this.cachePrefix;
            }
            this.cacheNamespaceURI = namespaceURI;
            this.cachePrefix = mappingScope.getOrCreatePrefix(this.cacheNamespaceURI, null, SerializationWriter.this.forceRealPrefix);
            this.cacheValid = !mappingScope.hasMappings();
            return this.cachePrefix;
        }

        private String getOrCreatePrefix_FastU() {
            MappingScope mappingScope = this.getMappingScope();
            if (this.uCacheValid && !mappingScope.hasMappings()) {
                return "";
            }
            if (mappingScope.getMappingForPrefix("", false) == null) {
                this.uCacheValid = !mappingScope.hasMappings();
                return "";
            }
            String prefix = mappingScope.getOrCreatePrefix("", null, false);
            this.uCacheValid = !mappingScope.hasMappings();
            return prefix;
        }

        public String getOrCreatePrefix(String namespace, String preferredPrefix, boolean noDefault) {
            Mapping mapping;
            if (namespace == null || namespace.length() == 0) {
                Mapping mapping2 = this.getMappingScope().getMappingForPrefix("", false);
                if (mapping2 != null && mapping2.getNamespaceURI().length() != 0) {
                    this.getMappingScope().addMapping("", "");
                }
                return "";
            }
            if (preferredPrefix != null && (mapping = this.getMappingScope().getMappingForPrefix(preferredPrefix, false)) != null && (mapping.getNamespaceURI() == namespace || mapping.getNamespaceURI().equals(namespace))) {
                return mapping.getPrefix();
            }
            String prefix = this.getMappingScope().getOrCreatePrefix(namespace, preferredPrefix, noDefault);
            return prefix;
        }
    }
}

