/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WSDDEngineConfiguration;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configuration.SimpleEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGlobalConfiguration;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.session.SimpleSession;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public abstract class WebServicesEngine
extends ConfigurableImpl {
    private static String binaryCopyright = Version.getBinaryCopyright();
    protected static Log log = LogFactory.getLog(WebServicesEngine.class.getName());
    public static final String PROP_DEBUG_LEVEL = "debugLevel";
    public static final String PROP_DEBUG_FILE = "debugFile";
    public static final String PROP_XML_DECL = "sendXMLDeclaration";
    public static final String PROP_DOMULTIREFS = "sendMultiRefs";
    public static final String PROP_SYNC_CONFIG = "syncConfiguration";
    public static final String PROP_SEND_XSI = "sendXsiTypes";
    public static final String PROP_ATTACHMENT_DIR = "attachments.Directory";
    public static final String PROP_ATTACHMENT_IMPLEMENTATION = "attachments.implementation";
    public static final String PROP_ATTACHMENT_CLEANUP = "attachment.DirectoryCleanUp";
    public static final String PROP_SOAP_VERSION = "defaultSOAPVersion";
    public static final String DEFAULT_ATTACHMENT_IMPL = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
    public static final String ENV_ATTACHMENT_DIR = "webservices.attachments.Directory";
    public static final String ENV_SERVLET_REALPATH = "servlet.realpath";
    public static final String ENV_SERVLET_CONTEXT = "servletContext";
    public static final String ENV_TEMP_DIR = "java.io.tmpdir";
    private final EngineConfiguration config;
    private Session session = new SimpleSession();
    private static final Set booleanOptions = new HashSet<String>(Arrays.asList("sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration"));

    protected WebServicesEngine(EngineConfiguration cfg) {
        this.config = cfg;
        this.init();
    }

    public EngineConfiguration getConfiguration() {
        return this.config;
    }

    private void init() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesEngine::init");
        }
        this.config.init();
        try {
            Map options = this.config.getGlobalOptions();
            this.setOptions(options);
        }
        catch (ConfigurationException ce) {
            String translatedMessage = Messages.getMessage("unloadable.configuration");
            log.error(translatedMessage, ce);
            throw new InternalException(ce);
        }
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, WebServicesProperties.getProperty("webservices.attachments.implementation"));
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, DEFAULT_ATTACHMENT_IMPL);
        if (log.isDebugEnabled()) {
            log.debug("Exit: WebServicesEngine::init");
        }
    }

    public void destroy() {
        Enumeration keys = this.session.getKeys();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object obj = this.session.get(key);
                if (obj != null && obj instanceof ServiceLifecycle) {
                    ((ServiceLifecycle)obj).destroy();
                }
                this.session.remove(key);
            }
        }
        this.config.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesEngine::invoke");
        }
        MessageContext previousContext = MessageContext.getCurrentThreadsContext();
        try {
            try {
                MessageContext.setCurrentThreadsContext(msgContext);
                msgContext.setResponseMessage(null);
                msgContext.setProperty("com.ibm.ws.webservices.engine.SimpleChain.caughtFaultInResponse", Boolean.FALSE);
                Handler handler = this.getMessageFlow(msgContext);
                if (handler.getOwner() == null) {
                    handler.init();
                }
                try {
                    msgContext.setPastPivot(false);
                    msgContext.setMessagePath(0);
                    handler.invoke(msgContext);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (handler.getOwner() != null) throw throwable;
                    handler.destroy();
                    throw throwable;
                }
                if (handler.getOwner() == null) {
                    handler.destroy();
                }
                Object var7_9 = null;
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.invoke", "265", this);
                throw e;
            }
            catch (ConfigurationException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.invoke", "268", this);
                throw WebServicesFault.makeFault(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            MessageContext.setCurrentThreadsContext(previousContext);
            if (!log.isDebugEnabled()) throw throwable;
            log.debug("Exit: WebServicesEngine::invoke");
            throw throwable;
        }
        MessageContext.setCurrentThreadsContext(previousContext);
        if (!log.isDebugEnabled()) return;
        log.debug("Exit: WebServicesEngine::invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateWSDL(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesEngine::generateWSDL");
        }
        MessageContext previousContext = MessageContext.getCurrentThreadsContext();
        try {
            try {
                MessageContext.setCurrentThreadsContext(msgContext);
                Handler handler = this.getMessageFlow(msgContext);
                if (handler.getOwner() == null) {
                    handler.init();
                }
                try {
                    msgContext.setPastPivot(false);
                    handler.generateWSDL(msgContext);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (handler.getOwner() != null) throw throwable;
                    handler.destroy();
                    throw throwable;
                }
                if (handler.getOwner() == null) {
                    handler.destroy();
                }
                Object var7_9 = null;
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.generateWSDL", "315", this);
                throw e;
            }
            catch (ConfigurationException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.generateWSDL", "318", this);
                throw WebServicesFault.makeFault(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            MessageContext.setCurrentThreadsContext(previousContext);
            if (!log.isDebugEnabled()) throw throwable;
            log.debug("Exit: WebServicesEngine::generateWSDL");
            throw throwable;
        }
        MessageContext.setCurrentThreadsContext(previousContext);
        if (!log.isDebugEnabled()) return;
        log.debug("Exit: WebServicesEngine::generateWSDL");
    }

    protected Handler getMessageFlow(MessageContext msgContext) throws WebServicesFault, ConfigurationException {
        Handler engineHandler;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("defaultLogic00"));
        }
        if ((engineHandler = this.createMessageFlow(msgContext)) == null) {
            throw new WebServicesFault(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("noHandler00", "(engine message flow)"), null, null);
        }
        return engineHandler;
    }

    protected abstract Handler createMessageFlow(MessageContext var1) throws WebServicesFault, ConfigurationException;

    public SOAPPort getPort(QName qname) throws WebServicesFault {
        try {
            return this.config.getPort(qname);
        }
        catch (ConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.getPort", "378", this);
            throw new WebServicesFault(e);
        }
    }

    public SOAPPort getPort(String name) throws WebServicesFault {
        return this.getPort(QNameTable.createQName(null, name));
    }

    public SOAPPort getPortByNamespaceURI(String namespaceURI) throws WebServicesFault {
        try {
            return this.config.getPortByNamespaceURI(namespaceURI);
        }
        catch (ConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.getPortByNamespaceURI", "393", this);
            throw new WebServicesFault(e);
        }
    }

    public Iterator getDeployedPorts() throws WebServicesFault {
        try {
            return this.config.getDeployedPorts();
        }
        catch (ConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.getDeployedPorts", "403", this);
            throw new WebServicesFault(e);
        }
    }

    public Handler getTransport(String name) throws WebServicesFault {
        if (name == null) {
            return null;
        }
        try {
            return this.config.getTransport(QNameTable.createQName(null, name));
        }
        catch (ConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.getTransport", "417", this);
            throw new WebServicesFault(e);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry tmr = null;
        try {
            tmr = this.config.getTypeMappingRegistry();
        }
        catch (ConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesEngine.getTypeMappingRegistry", "428", this);
            log.error(Messages.getMessage("webServicesConfigurationException00"), e);
        }
        return tmr;
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        return this.config.getGlobalHandler();
    }

    public List getProtectedHeaders() {
        List returnList = null;
        WSDDGlobalConfiguration globalConfig = this.getGlobalConfig();
        if (globalConfig != null) {
            returnList = globalConfig.getProtectedHeaders();
        }
        return returnList;
    }

    private WSDDGlobalConfiguration getGlobalConfig() {
        WSDDGlobalConfiguration globalConfig = null;
        EngineConfiguration cfg = this.config;
        while (cfg != null && globalConfig == null) {
            if (cfg instanceof WSDDDeployment) {
                globalConfig = ((WSDDDeployment)cfg).getGlobalConfig();
                cfg = null;
                continue;
            }
            if (cfg instanceof SimpleEngineConfigurationProvider) {
                cfg = ((SimpleEngineConfigurationProvider)cfg).getDefaultEngineConfiguration();
                continue;
            }
            cfg = null;
        }
        return globalConfig;
    }

    public Document getConfigurationDocument() {
        if (this.config instanceof WSDDEngineConfiguration) {
            try {
                return ((WSDDEngineConfiguration)this.config).getDocument();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract WebServicesEngine getClientEngine();

    public Session getApplicationSession() {
        return this.session;
    }

    public boolean isContainerManaged() {
        return this.config.isContainerManaged();
    }

    public abstract boolean isServer();

    public Set getOptionsBooleanNames() {
        return booleanOptions;
    }
}

