/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.client.Stub;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class MessageContext
implements SOAPMessageContext,
RPCContext,
Cloneable {
    protected static Log log = LogFactory.getLog(MessageContext.class.getName());
    private static final Boolean disableSOAPElementLazyParseValue = (Boolean)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.disableSOAPElementLazyParse");
    private static ThreadLocal currentThreadMessageContext = new ThreadLocal();
    private Message requestMessage;
    private Message responseMessage;
    private String targetPortName;
    private String transportName;
    private WebServicesEngine engine;
    private Session session;
    private boolean havePassedPivot = false;
    private boolean highFidelity = false;
    private boolean disableSOAPElementLazyParse = disableSOAPElementLazyParseValue;
    private List cachedProtectedHeaderQNames = null;
    public static final int MESSAGE_PATH_PREINVOKE = 0;
    public static final int MESSAGE_PATH_REQUEST = 1;
    public static final int MESSAGE_PATH_RESPONSE = 2;
    public static final int MESSAGE_PATH_FALSE = 3;
    public static final int MESSAGE_PATH_FAULT = 4;
    public static final int MESSAGE_PATH_CLOSURE = 5;
    private int messagePath = 1;
    private static final Set beenDir = new HashSet();
    private static String systemTempDirName = null;
    public static final String PARAM_MINOCCURS_0 = "PARAM_MINOCCURS_0";
    public static final String PARAM_MAXOCCURS_NOT1 = "PARAM_MAXOCCURS_NOT1";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String PRP_IGNORE_SOAPBODY_ELEMENT = "IGNORE_SOAPBODY";
    private TypeMappingRegistry mappingRegistry = null;
    private LockableHashtable bag = new LockableHashtable();
    private SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
    private SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    private SOAPPort _port;
    private OperationDesc currentOperation = null;
    private String characterEncoding = null;
    private boolean invokingTarget = false;
    public static String TRANS_URL;
    public static String TRANS_URL_HTTP_REDIRECTED;
    public static String QUIT_REQUESTED;
    public static String AUTHUSER;
    public static String ATTACHMENTS_DIR;
    public static String HTTP_TRANSPORT_VERSION;
    public static String SAAJ_TRANSFORMATION;
    public static String FAULT_ON_SAAJ_TRANSFORMATION;
    private BagCache bagCache = new BagCache();
    private List oneWayListeners = null;

    public MessageContext(WebServicesEngine engine2) {
        this.engine = engine2;
        if (null != engine2) {
            String defaultSOAPVersion;
            Map opts = engine2.getOptions();
            String attachmentsdir = null;
            if (null != opts) {
                attachmentsdir = (String)opts.get("attachments.Directory");
            }
            if (null != attachmentsdir) {
                MessageContext.createDir(attachmentsdir);
            } else {
                attachmentsdir = systemTempDirName;
            }
            if (attachmentsdir != null) {
                this.setProperty(ATTACHMENTS_DIR, attachmentsdir);
            }
            if ((defaultSOAPVersion = (String)opts.get("defaultSOAPVersion")) != null && "1.2".equals(defaultSOAPVersion)) {
                this.setSOAPConstants(SOAPConstants.SOAP12_CONSTANTS);
            }
        }
    }

    public static void setCurrentThreadsContext(MessageContext context) {
        currentThreadMessageContext.set(context);
    }

    public static MessageContext getCurrentThreadsContext() {
        return (MessageContext)currentThreadMessageContext.get();
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(Message reqMsg) {
        this.requestMessage = reqMsg;
        if (this.requestMessage != null) {
            this.requestMessage.setMessageContext(this);
        }
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(Message respMsg) {
        this.responseMessage = respMsg;
        if (this.responseMessage != null) {
            this.responseMessage.setMessageContext(this);
            Message reqMsg = this.getRequestMessage();
            if (null != reqMsg) {
                Attachments reqAttch = reqMsg.getAttachmentsImpl();
                Attachments respAttch = respMsg.getAttachmentsImpl();
                if (null != reqAttch && null != respAttch && respAttch.getSendType() == 1) {
                    respAttch.setSendType(reqAttch.getSendType());
                }
            }
        }
    }

    public void setOperation(OperationDesc operation) {
        this.currentOperation = operation;
    }

    public OperationDesc getOperation() {
        return this.currentOperation;
    }

    public OperationDesc resolveOperation() {
        OperationDesc opDesc = this.getOperation();
        if (opDesc == null) {
            SOAPEnvelope se = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("MessageContext:resolveOperation: Get the SOAPEnvelope");
                }
                se = this.getCurrentMessage().getSOAPEnvelope();
            }
            catch (WebServicesFault wsf) {
                FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.MessageContext.resolveOperation", "420", this);
                throw new RuntimeException(wsf);
            }
            opDesc = this.getOperation();
            if (opDesc == null && se != null) {
                RequestResponse rr = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("MessageContext:resolveOperation: Get the RequestResponse object");
                    }
                    rr = ((SOAPBody)se.getBody()).getRequestResponse();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.MessageContext.resolveOperation", "449", this);
                }
                if (rr != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("MessageContext:resolveOperation: Invoke RequestResponse.resolveOperation ");
                    }
                    if ((opDesc = rr.resolveOperation(this, this.getRequestMessage())) != null) {
                        this.setOperation(opDesc);
                    }
                }
            }
        }
        return opDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMappingRegistry(TypeMappingRegistry reg) {
        if (this.getPortDesc() != null) {
            PortDesc portDesc = this.getPortDesc();
            synchronized (portDesc) {
                this.getPortDesc().setTypeMappingRegistry(reg);
                this.mappingRegistry = null;
            }
        } else {
            this.mappingRegistry = reg;
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.getPortDesc() != null) {
            return this.getPortDesc().getTypeMappingRegistry();
        }
        if (this.mappingRegistry == null) {
            this.mappingRegistry = this.engine.getTypeMappingRegistry();
        }
        return this.mappingRegistry;
    }

    public TypeMapping getTypeMapping() {
        TypeMapping tm = (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        return tm;
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSOAPConstants(SOAPConstants soapConstants) {
        if (this.soapConstants.getEncodingURI().equals(this.getEncodingStyle())) {
            this.setEncodingStyle(soapConstants.getEncodingURI());
        }
        this.soapConstants = soapConstants;
    }

    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isEncoded() {
        return this.getOperationUse().getName().equals("encoded");
    }

    public Message getCurrentMessage() {
        return this.havePassedPivot ? this.responseMessage : this.requestMessage;
    }

    public SOAPMessage getMessage() {
        return this.getCurrentMessage();
    }

    public void setCurrentMessage(Message curMsg) {
        curMsg.setMessageContext(this);
        if (this.havePassedPivot) {
            this.responseMessage = curMsg;
        } else {
            this.requestMessage = curMsg;
        }
    }

    public void setMessage(SOAPMessage message) {
        this.setCurrentMessage((Message)message);
    }

    public boolean getPastPivot() {
        return this.havePassedPivot;
    }

    public void setPastPivot(boolean pastPivot) {
        this.havePassedPivot = pastPivot;
    }

    public boolean isRequestPath() {
        return !this.havePassedPivot;
    }

    public boolean isReponsePath() {
        return this.isResponsePath();
    }

    public boolean isResponsePath() {
        return this.havePassedPivot;
    }

    public String getTargetPortName() {
        return this.targetPortName;
    }

    public WebServicesEngine getEngine() {
        return this.engine;
    }

    public void setTargetPort(String portName) throws WebServicesFault {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("MessageContext: setTargetPort(" + portName + ")");
            }
            if (portName == null) {
                this.setPort(null);
            } else {
                try {
                    this.setPort(this.getEngine().getPort(portName));
                }
                catch (WebServicesFault fault) {
                    FFDCFilter.processException((Throwable)fault, "com.ibm.ws.webservices.engine.MessageContext.setTargetPort", "626", this);
                    this.setPort(null);
                    if (this.isClient()) break block5;
                    throw fault;
                }
            }
        }
        this.targetPortName = portName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(SOAPPort port) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("MessageContext: setPort(" + port + ")");
        }
        TypeMappingRegistry oldTMR = this.getTypeMappingRegistry();
        this._port = port;
        if (this._port != null) {
            this.targetPortName = this._port.getName();
            if (this.getOperation() != null) {
                if (this.isClient() && !this._port.getPortDesc().getOperations().contains(this.getOperation())) {
                    PortDesc portDesc = this.getPortDesc();
                    synchronized (portDesc) {
                        this.getPortDesc().addOperationDesc(this.getOperation());
                        this.getPortDesc().setTypeMappingRegistry(oldTMR);
                    }
                } else {
                    this.setOperationStyle(this.getOperation().getStyle());
                    this.setOperationUse(this.getOperation().getUse());
                    this.setEncodingStyle(this.getOperation().getUse().getEncoding());
                }
            }
            this.setParent(this.bag, port.getOptions());
            if (this.getPortDesc().needsHighFidelityRecording()) {
                this.highFidelity = true;
            }
            port.getInitializedPortDesc(this);
        }
        this.patchProperties();
    }

    private void setParent(LockableHashtable bag, Map parent) {
        Map currentParent = bag.getParent();
        if (currentParent instanceof LockableHashtable && currentParent != parent) {
            this.setParent((LockableHashtable)currentParent, parent);
        } else {
            bag.setParent(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchProperties() {
        ParameterDesc paramDesc;
        QName qName;
        Iterator it;
        OperationDesc operationDesc;
        Object value = this.getProperty(PARAM_MINOCCURS_0);
        if (value != null && this.currentOperation != null) {
            operationDesc = this.currentOperation;
            synchronized (operationDesc) {
                it = ((Set)value).iterator();
                while (it.hasNext()) {
                    qName = (QName)it.next();
                    paramDesc = this.currentOperation.getParamByQName(qName);
                    if (paramDesc != null) {
                        paramDesc.setMinOccursIs0(true);
                    }
                    if ((paramDesc = this.currentOperation.getReturnParamDesc()) == null || !qName.equals(paramDesc.getQName())) continue;
                    paramDesc.setMinOccursIs0(true);
                }
            }
        }
        if ((value = this.getProperty(PARAM_MAXOCCURS_NOT1)) != null && this.currentOperation != null) {
            operationDesc = this.currentOperation;
            synchronized (operationDesc) {
                it = ((Set)value).iterator();
                while (it.hasNext()) {
                    qName = (QName)it.next();
                    paramDesc = this.currentOperation.getParamByQName(qName);
                    if (paramDesc != null) {
                        paramDesc.setMaxOccursIs1(false);
                    }
                    if ((paramDesc = this.currentOperation.getReturnParamDesc()) == null || !qName.equals(paramDesc.getQName())) continue;
                    paramDesc.setMaxOccursIs1(false);
                }
            }
        }
        if ((value = this.getProperty("com.ibm.ws.webservices.disableSOAPElementLazyParse")) != null) {
            if (log.isDebugEnabled()) {
                log.debug("disableSOAPElementLazyParse MC property: " + value);
            }
            if (JavaUtils.isTrueExplicitly((String)value)) {
                this.disableSOAPElementLazyParse = true;
            } else if (JavaUtils.isFalseExplicitly((String)value)) {
                this.disableSOAPElementLazyParse = false;
            }
            if (log.isDebugEnabled()) {
                log.debug("disableSOAPElementLazyParse using MC property: " + this.disableSOAPElementLazyParse);
            }
        }
    }

    public SOAPPort getPort() {
        return this._port;
    }

    public PortDesc getPortDesc() {
        return this.getPort() == null ? null : this.getPort().getPortDesc();
    }

    public boolean isClient() {
        return !this.isServer();
    }

    public boolean isServer() {
        return this.getEngine().isServer();
    }

    public Object getPortProperty(String name) {
        if (this._port != null) {
            return this._port.getOption(name);
        }
        return null;
    }

    public String getStrProp(String propName) {
        return (String)this.getProperty(propName);
    }

    public boolean isPropertyTrue(String propName) {
        return this.isPropertyTrue(propName, false);
    }

    public boolean isPropertyTrue(String propName, boolean defaultVal) {
        return JavaUtils.isTrue(this.getProperty(propName), defaultVal);
    }

    public void setProperty(String name, Object value) {
        if (name == null || value == null) {
            throw new JAXRPCException(Messages.getMessage(name == null ? "badProp03" : "badProp04"));
        }
        if (name.equals("javax.xml.rpc.security.auth.username") || name.equals("javax.xml.rpc.security.auth.password") || name.equals("http.proxyHost") || name.equals("http.proxyPort") || name.equals("http.proxyUser") || name.equals("http.proxyPassword") || name.equals("https.proxyHost") || name.equals("https.proxyPort") || name.equals("https.proxyUser") || name.equals("https.proxyPassword") || name.equals("ssl.configName") || name.equals("javax.xml.rpc.soap.http.soapaction.uri") || name.equals("jaxrpcMappingFile") || name.equals("transport_name")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
        } else if (name.equals("javax.xml.rpc.session.maintain") || name.equals("http.redirect.enabled") || name.equals("noDataBinding") || name.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            if (!(value instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
        } else if (name.equals("javax.xml.rpc.soap.operation.style")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            value = Style.getStyle((String)((Object)value), Style.DEFAULT);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle((Style)((Object)value));
            }
            if (value == Style.DOCUMENT || value == Style.WRAPPED) {
                this.setProperty("operation_use", "literal");
            } else if (value == Style.RPC) {
                this.setProperty("operation_use", "encoded");
            }
        } else if (name.equals("operation_use")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            value = Use.getUse((String)((Object)value), Use.DEFAULT);
        } else if (name.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            if (Constants.isSOAP_ENC((String)((Object)value))) {
                value = this.soapConstants.getEncodingURI();
            }
        } else if (name.equals("javax.xml.rpc.service.endpoint.address") || name.equals(TRANS_URL)) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            if (name.equals(TRANS_URL)) {
                if (log.isDebugEnabled()) {
                    log.debug("Deprecated MessageContext property TRANS_URL used. The property javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY will be set on the MessageContext instead.  Call stack: ", new Exception("Call stack for deprecated MessageContext.TRANS_URL usage"));
                }
                name = "javax.xml.rpc.service.endpoint.address";
            }
            try {
                value = new URL((String)((Object)value));
            }
            catch (MalformedURLException mue) {
                FFDCFilter.processException((Throwable)mue, "com.ibm.ws.webservices.engine.MessageContext.setProperty", "874", this);
                throw new JAXRPCException(mue);
            }
            if (!this.validateEndpointAddress((URL)((Object)value))) {
                throw new JAXRPCException("Attempt to set property " + name + " to an invalid target endpoint address: " + value);
            }
        } else if (name.equals("attachment_encapsulation_format")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            if (!value.equals("webservices.attachment.style.mime") && !value.equals("webservices.attachment.style.dime")) {
                throw new JAXRPCException(Messages.getMessage("badattachmenttypeerr", new String[]{(String)((Object)value), "webservices.attachment.style.mime webservices.attachment.style.dime"}));
            }
        } else if (name.equals(SAAJ_TRANSFORMATION)) {
            if (!(value instanceof RuntimeException)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.RuntimeException", value.getClass().getName()}));
            }
        } else if (name.equals("com.ibm.ws.webservices.engine.session.context") || name.equals("com.ibm.websphere.webservices.requestTransportProperties") || name.equals("com.ibm.websphere.webservices.responseTransportProperties")) {
            boolean enableMultiThreadedSession = false;
            Object o = this.getProperty("enableMultiThreadedSession");
            if (o != null) {
                enableMultiThreadedSession = (Boolean)o;
            }
            if (!(value instanceof ThreadLocal) && !enableMultiThreadedSession) {
                ThreadLocal tl;
                if (name.equals("com.ibm.websphere.webservices.requestTransportProperties") || name.equals("com.ibm.websphere.webservices.responseTransportProperties")) {
                    Stub.validateTransportPropertiesHashMap((Object)value, (String)name);
                }
                if ((tl = (ThreadLocal)this.bag.get(name)) == null) {
                    tl = new ThreadLocal();
                }
                tl.set(value);
                value = tl;
            }
        } else if (name.equals("com.ibm.websphere.webservices.requestSoapHeaders") || name.equals("com.ibm.websphere.webservices.responseSoapHeaders")) {
            HashMap checkValue = null;
            if (!(value instanceof ThreadLocal)) {
                Stub.validateSoapHeadersHashMap((Object)value, (String)name);
                checkValue = (HashMap)((Object)value);
                ThreadLocal tl = (ThreadLocal)this.bag.get(name);
                if (tl == null) {
                    tl = new ThreadLocal();
                }
                tl.set(value);
                value = tl;
            } else {
                checkValue = (HashMap)((ThreadLocal)value).get();
            }
            this.checkForProtectedSOAPHeaders(checkValue, name);
        } else if (name.equals("enableTransactionalOneWay")) {
            if (!(value instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
        } else if (name.equals("com.ibm.ws.webservices.wlmselectioncriteria")) {
            if (!(value instanceof Map)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.util.Map", value.getClass().getName()}));
            }
        } else if (name.startsWith("java.") || name.startsWith("javax.")) {
            throw new JAXRPCException(Messages.getMessage("badProp05", name));
        }
        if (name.equals("message.character-set-encoding")) {
            this.characterEncoding = (String)((Object)value);
        } else {
            this.bag.put(name, value);
        }
    }

    public boolean containsProperty(String name) {
        Object propertyValue = this.getProperty(name);
        return propertyValue != null;
    }

    public Iterator getPropertyNames() {
        return this.bag.keySet().iterator();
    }

    public Object getProperty(String name) {
        Object prop = null;
        if (name != null) {
            if (name.equals(TRANS_URL)) {
                if (log.isDebugEnabled()) {
                    log.debug("Deprecated MessageContext property TRANS_URL used. The property javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY will be set on the MessageContext instead.  Call stack: ", new Exception("Call stack for deprecated MessageContext.TRANS_URL usage"));
                }
                name = "javax.xml.rpc.service.endpoint.address";
            }
            if ((prop = this.bag.get(name)) != null) {
                if (name.equals("javax.xml.rpc.soap.operation.style")) {
                    prop = ((Style)prop).getName();
                } else if (name.equals("operation_use")) {
                    prop = ((Use)prop).getName();
                } else if (name.equals("javax.xml.rpc.service.endpoint.address")) {
                    prop = ((URL)prop).toString();
                } else if (name.equals("com.ibm.ws.webservices.engine.session.context") || name.equals("com.ibm.websphere.webservices.requestTransportProperties") || name.equals("com.ibm.websphere.webservices.responseTransportProperties") || name.equals("com.ibm.websphere.webservices.requestSoapHeaders") || name.equals("com.ibm.websphere.webservices.responseSoapHeaders")) {
                    boolean enableMultiThreadedSession = false;
                    Object o = this.getProperty("enableMultiThreadedSession");
                    if (o != null) {
                        enableMultiThreadedSession = (Boolean)o;
                    }
                    if (!enableMultiThreadedSession) {
                        prop = ((ThreadLocal)prop).get();
                    }
                }
            } else if (name.equals("message.character-set-encoding")) {
                prop = this.characterEncoding;
            }
        }
        return prop;
    }

    public void setUsername(String username) {
        if (username != null) {
            this.setProperty("javax.xml.rpc.security.auth.username", username);
        }
    }

    public String getUsername() {
        return (String)this.getProperty("javax.xml.rpc.security.auth.username");
    }

    public void setPassword(String password) {
        if (password != null) {
            this.setProperty("javax.xml.rpc.security.auth.password", password);
        }
    }

    public String getPassword() {
        return (String)this.getProperty("javax.xml.rpc.security.auth.password");
    }

    public void setMaintainSession(boolean yesno) {
        this.setProperty("javax.xml.rpc.session.maintain", new Boolean(yesno));
    }

    public boolean getMaintainSession() {
        Boolean bool = (Boolean)this.getProperty("javax.xml.rpc.session.maintain");
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public void setOperationStyle(String operationStyle) {
        if (operationStyle != null) {
            this.setProperty("javax.xml.rpc.soap.operation.style", operationStyle);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(this.getOperationStyle());
            }
        }
    }

    public void setOperationStyle(Style operationStyle) {
        if (operationStyle != null) {
            this.bag.put("javax.xml.rpc.soap.operation.style", operationStyle);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(operationStyle);
            }
        }
    }

    public void setOperationStyle(com.ibm.ws.webservices.engine.enum.Style operationStyle) {
        if (operationStyle != null) {
            this.bag.put("javax.xml.rpc.soap.operation.style", operationStyle);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(operationStyle);
            }
        }
    }

    public com.ibm.ws.webservices.engine.enum.Style getOperationStyle() {
        Style style = null;
        if (this.bag.get("javax.xml.rpc.soap.operation.style") != null) {
            style = Style.getStyle(this.bag.get("javax.xml.rpc.soap.operation.style").toString());
        }
        Style odStyle = null;
        if (this.currentOperation != null) {
            odStyle = this.currentOperation.getStyle();
        }
        if (style == null && odStyle == null) {
            return com.ibm.ws.webservices.engine.enum.Style.DEFAULT;
        }
        if (style != null && odStyle != null) {
            if (!style.equals(odStyle)) {
                // empty if block
            }
            return com.ibm.ws.webservices.engine.enum.Style.getStyle((String)style.toString());
        }
        return odStyle == null ? com.ibm.ws.webservices.engine.enum.Style.getStyle((String)style.toString()) : com.ibm.ws.webservices.engine.enum.Style.getStyle((String)odStyle.toString());
    }

    public String getOperationStyleString() {
        Style style = null;
        if (this.bag.get("javax.xml.rpc.soap.operation.style") != null) {
            style = Style.getStyle(this.bag.get("javax.xml.rpc.soap.operation.style").toString());
        }
        Style odStyle = null;
        if (this.currentOperation != null) {
            odStyle = this.currentOperation.getStyle();
        }
        if (style == null && odStyle == null) {
            return Style.DEFAULT.toString();
        }
        if (style != null && odStyle != null) {
            if (!style.equals(odStyle)) {
                // empty if block
            }
            return style.toString();
        }
        return odStyle == null ? style.toString() : odStyle.toString();
    }

    public void setOperationUse(String operationUse) {
        if (operationUse != null) {
            this.setProperty("operation_use", operationUse);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(this.getOperationUse());
            }
        }
    }

    public void setOperationUse(Use operationUse) {
        if (operationUse != null) {
            this.bag.put("operation_use", operationUse);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(operationUse);
            }
        }
    }

    public void setOperationUse(com.ibm.ws.webservices.engine.enum.Use operationUse) {
        if (operationUse != null) {
            this.bag.put("operation_use", operationUse);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(operationUse);
            }
        }
    }

    public com.ibm.ws.webservices.engine.enum.Use getOperationUse() {
        Use use = null;
        if (this.bag.get("operation_use") != null) {
            use = Use.getUse(this.bag.get("operation_use").toString());
        }
        Use odUse = null;
        if (this.currentOperation != null) {
            odUse = this.currentOperation.getUse();
        }
        if (use == null && odUse == null) {
            return com.ibm.ws.webservices.engine.enum.Use.DEFAULT;
        }
        if (use != null && odUse != null) {
            if (!use.equals(odUse)) {
                // empty if block
            }
            return com.ibm.ws.webservices.engine.enum.Use.getUse((String)use.toString());
        }
        return odUse == null ? com.ibm.ws.webservices.engine.enum.Use.getUse((String)use.toString()) : com.ibm.ws.webservices.engine.enum.Use.getUse((String)odUse.toString());
    }

    public String getOperationUseString() {
        Use use = null;
        if (this.bag.get("operation_use") != null) {
            use = Use.getUse(this.bag.get("operation_use").toString());
        }
        Use odUse = null;
        if (this.currentOperation != null) {
            odUse = this.currentOperation.getUse();
        }
        if (use == null && odUse == null) {
            return Use.DEFAULT.toString();
        }
        if (use != null && odUse != null) {
            if (!use.equals(odUse)) {
                // empty if block
            }
            return use.toString();
        }
        return odUse == null ? use.toString() : odUse.toString();
    }

    public void setUseSOAPAction(boolean useSOAPAction) {
        this.setProperty("javax.xml.rpc.soap.http.soapaction.use", new Boolean(useSOAPAction));
    }

    public boolean useSOAPAction() {
        Boolean bool = this.useSOAPActionMimeHeader();
        if (!bool.booleanValue()) {
            bool = (Boolean)this.getProperty("javax.xml.rpc.soap.http.soapaction.use");
        }
        return bool != null && bool != false;
    }

    private Boolean useSOAPActionMimeHeader() {
        String[] temp;
        Boolean b = new Boolean(false);
        if (this.getRequestMessage() != null && (temp = this.getRequestMessage().getMimeHeaders().getHeader("SOAPAction")) != null) {
            b = true;
        }
        return b;
    }

    public void setSOAPActionURI(String SOAPActionURI) {
        if (SOAPActionURI != null) {
            this.setProperty("javax.xml.rpc.soap.http.soapaction.uri", SOAPActionURI);
        } else {
            this.removeProperty("javax.xml.rpc.soap.http.soapaction.uri");
        }
    }

    public String getSOAPActionURI() {
        String[] arr = this.getRequestMessage().getMimeHeaders().getHeader("SOAPAction");
        String actionURI = arr != null ? arr[0] : (String)this.getProperty("javax.xml.rpc.soap.http.soapaction.uri");
        return actionURI;
    }

    public Boolean usingAddressing() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            String usingAddressingRequired = (String)op.getOption(OperationDesc.USING_ADDRESSING_ELEMENT);
            if (usingAddressingRequired == null) {
                return null;
            }
            return new Boolean(usingAddressingRequired);
        }
        return null;
    }

    public void setEncodingStyle(String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = "";
        } else if (Constants.isSOAP_ENC(namespaceURI)) {
            namespaceURI = this.soapConstants.getEncodingURI();
        }
        if (this.currentOperation != null) {
            this.currentOperation.setOption(OperationDesc.OUTPUT_ENCODING_STYLE, namespaceURI);
            this.currentOperation.setOption(OperationDesc.INPUT_ENCODING_STYLE, namespaceURI);
        }
        this.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", namespaceURI);
    }

    public String getEncodingStyle() {
        String encoding = null;
        if (this.currentOperation != null) {
            encoding = this.havePassedPivot ? (String)this.currentOperation.getOption(OperationDesc.OUTPUT_ENCODING_STYLE) : (String)this.currentOperation.getOption(OperationDesc.INPUT_ENCODING_STYLE);
        }
        if (encoding == null) {
            encoding = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
        }
        if (encoding == null) {
            encoding = this.getOperationUse().getEncoding();
        }
        if (encoding == null) {
            if (log.isDebugEnabled()) {
                log.debug("MessageContext: getEncodingStyle: encoding is null");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("MessageContext: getEncodingStyle: encoding is [" + encoding + "].");
            }
            if (encoding != "" && !encoding.equals("http://schemas.xmlsoap.org/soap/encoding/") && log.isDebugEnabled()) {
                log.debug("MessageContext: getEncodingStyle: encoding not supported[" + encoding + "].");
            }
        }
        return encoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getCharacterEncoding(String defaultCharset) {
        String charset = this.characterEncoding;
        if (charset == null || charset.length() == 0) {
            charset = defaultCharset;
        }
        return charset;
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    public void setTimeout(Integer timeout) {
        if (timeout != null) {
            this.setProperty("timeout", timeout);
        }
    }

    public void setTimeout(int timeout) {
        this.setProperty("timeout", new Integer(timeout));
    }

    public void setReadTimeout(Integer timeout) {
        if (timeout != null) {
            this.setProperty("read_timeout", timeout);
        }
    }

    public void setReadTimeout(int timeout) {
        this.setProperty("read_timeout", new Integer(timeout));
    }

    public void setWriteTimeout(Integer timeout) {
        if (timeout != null) {
            this.setProperty("write_timeout", timeout);
        }
    }

    public void setWriteTimeout(int timeout) {
        this.setProperty("write_timeout", new Integer(timeout));
    }

    public int getTimeout() {
        return this.getTimeoutProperty("timeout", 0);
    }

    public int getWriteTimeout() {
        return this.getTimeoutProperty("write_timeout", 0);
    }

    private int getTimeoutProperty(String propName, int defaultValue) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("getTimeoutProperty: propName[" + propName + "]  defaultValue[" + defaultValue + "]");
        }
        if ((object = this.getProperty(propName)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("getProperty returned null for " + propName);
            }
            return defaultValue;
        }
        if (log.isDebugEnabled()) {
            log.debug("getTimeoutProperty: " + propName + " = " + object);
        }
        if (object instanceof String) {
            int retValue = JavaUtils.convertStringToInt((String)object, defaultValue);
            this.setProperty(propName, new Integer(retValue));
            if (log.isDebugEnabled()) {
                log.debug("getTimeoutProperty: replaced String with Integer in MessageContext for " + propName + ", retValue = " + retValue);
            }
            return retValue;
        }
        if (object instanceof Integer) {
            if (log.isDebugEnabled()) {
                log.debug("getTimeoutProperty: Integer type: " + object);
            }
            return (Integer)object;
        }
        if (log.isDebugEnabled()) {
            log.debug("getTimeoutProperty: invalid class in MessageContext");
        }
        return defaultValue;
    }

    public QName getPortName() {
        return (QName)this.getProperty("wsdl.portName");
    }

    public void setPortName(QName portName) {
        if (portName != null) {
            this.setProperty("wsdl.portName", portName);
        }
    }

    public String getTransportName() {
        return (String)this.getProperty("transport_name");
    }

    public void setTransportName(String transportName) {
        if (transportName != null) {
            this.setProperty("transport_name", transportName);
        }
    }

    public void setTargetEndpointAddress(String address) {
        URL urlAddress;
        try {
            urlAddress = new URL(address);
        }
        catch (MalformedURLException mue) {
            FFDCFilter.processException((Throwable)mue, "com.ibm.ws.webservices.engine.MessageContext.setTargetEndpointAddress", "1364", this);
            throw new JAXRPCException(mue);
        }
        this.setTargetEndpointAddress(urlAddress);
    }

    public void setTargetEndpointAddress(URL address) {
        if (address != null) {
            this.bag.put("javax.xml.rpc.service.endpoint.address", address);
        }
    }

    public String getTargetEndpointAddress() {
        return (String)this.getProperty("javax.xml.rpc.service.endpoint.address");
    }

    public URL getTargetEndpointAddressAsURL() {
        return (URL)this.bag.get("javax.xml.rpc.service.endpoint.address");
    }

    public void removeProperty(String propName) {
        if (this.bag != null) {
            if ("com.ibm.ws.webservices.engine.session.context".equals(propName) || "com.ibm.websphere.webservices.requestTransportProperties".equals(propName) || "com.ibm.websphere.webservices.responseTransportProperties".equals(propName) || "com.ibm.websphere.webservices.requestSoapHeaders".equals(propName) || "com.ibm.websphere.webservices.responseSoapHeaders".equals(propName)) {
                ThreadLocal tl = (ThreadLocal)this.bag.get(propName);
                if (tl != null) {
                    tl.set(null);
                }
            } else {
                this.bag.remove(propName);
            }
        }
    }

    public synchronized void protectProperties() {
        LockableHashtable newBag = this.bagCache.getBag();
        newBag.setParent(this.bag);
        this.bag = newBag;
    }

    public synchronized void resetProperties() {
        Map parent = this.bag.getParent();
        if (parent != null && parent instanceof LockableHashtable) {
            this.bagCache.storeBag(this.bag);
            this.bag = (LockableHashtable)parent;
        } else {
            this.bag.clear();
        }
    }

    public boolean isClientFlow() {
        return !this.isServer();
    }

    public boolean isServerFlow() {
        return this.isServer();
    }

    public boolean isHighFidelity() {
        return this.highFidelity;
    }

    public void setHighFidelity(boolean highFidelity) {
        this.highFidelity = highFidelity;
    }

    public boolean isDisableSOAPElementLazyParse() {
        return this.disableSOAPElementLazyParse;
    }

    public void setDisableSOAPElementLazyParse(boolean disableSOAPElementLazyParse) {
        this.disableSOAPElementLazyParse = disableSOAPElementLazyParse;
    }

    public String[] getRoles() {
        Collection rolesCollection;
        String[] roles = null;
        if (this.getPort() != null && this.getPort().getHandlerChain() != null && (rolesCollection = this.getPort().getHandlerChain().getRoles()) != null) {
            roles = new String[rolesCollection.size()];
            roles = rolesCollection.toArray(roles);
        }
        return roles;
    }

    public Object clone() throws CloneNotSupportedException {
        MessageContext clone = (MessageContext)super.clone();
        clone.bag = (LockableHashtable)this.bag.clone();
        return clone;
    }

    public boolean isOneWay() {
        return this.getOperation() == null ? false : this.getOperation().isOneway();
    }

    public void addOneWayListener(OneWayListener listener) {
        if (this.oneWayListeners == null) {
            this.oneWayListeners = new ArrayList();
        }
        this.oneWayListeners.add(listener);
    }

    public void removeOneWayListener(OneWayListener listener) {
        if (this.oneWayListeners != null) {
            this.oneWayListeners.remove(listener);
        }
    }

    public void oneWayEvent() {
        if (this.oneWayListeners != null) {
            for (int i = 0; i < this.oneWayListeners.size(); ++i) {
                ((OneWayListener)this.oneWayListeners.get(i)).oneWay(this);
            }
        }
    }

    public int getMessagePath() {
        return this.messagePath;
    }

    public void setMessagePath(int i) {
        this.messagePath = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createDir(final String name) {
        Set set = beenDir;
        synchronized (set) {
            if (name != null && !beenDir.contains(name)) {
                beenDir.add(name);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            File dir = new File(name);
                            if (!dir.isDirectory()) {
                                dir.mkdirs();
                            }
                            return name;
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.MessageContext", "318");
                            return null;
                        }
                    }
                });
            }
        }
    }

    public RPCContext getRPCContext() {
        return this;
    }

    public QName[] getWSDLParameters() {
        OperationDesc op = this.resolveOperation();
        if (op == null) {
            return null;
        }
        ArrayList params = op.getParameters();
        QName[] qnames = new QName[params.size()];
        for (int idx = 0; idx < qnames.length; ++idx) {
            qnames[idx] = ((ParameterDesc)params.get(idx)).getQName();
        }
        return qnames;
    }

    public QName getWSDLPort() {
        QName qName;
        QName wsdlPortQName = null;
        if (this.getPort() != null) {
            wsdlPortQName = this.getPort().getPortDesc().getWSDLPort();
        }
        if (wsdlPortQName == null && (qName = this.getPortName()) != null) {
            wsdlPortQName = QNameTable.createQName(qName.getNamespaceURI(), ClientModuleMetaData.unravelPortName((String)qName.getLocalPart()));
        }
        return wsdlPortQName;
    }

    public QName getWSDLService() {
        QName serviceName = null;
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            serviceName = (QName)op.getOption(OperationDesc.SERVICE_QNAME);
            if (log.isDebugEnabled()) {
                log.debug("Service name from OperationDesc = " + serviceName);
            }
        }
        return serviceName;
    }

    public Boolean getWSDLUnavailable() {
        Boolean retVal = Boolean.FALSE;
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            String boolStr = (String)op.getOption(OperationDesc.WSDL_UNAVAILABLE);
            if (log.isDebugEnabled()) {
                log.debug("WSDL_UNAVAILABLE from OperationDesc = " + boolStr);
            }
            if (boolStr != null && boolStr.equals("true")) {
                retVal = Boolean.TRUE;
            }
        }
        return retVal;
    }

    public String getWSDLOperation() {
        OperationDesc op = this.resolveOperation();
        return op != null ? op.getElementQName().getLocalPart() : null;
    }

    public QName getWSDLPortType() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (QName)op.getOption(OperationDesc.PORT_TYPE_QNAME);
        }
        return null;
    }

    public String getWSDLTargetNamespace() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (String)op.getOption(OperationDesc.TARGET_NAMESPACE);
        }
        return null;
    }

    public String getWSDLInputName() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (String)op.getOption(OperationDesc.INPUT_NAME);
        }
        return null;
    }

    public String getWSDLOutputName() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (String)op.getOption(OperationDesc.OUTPUT_NAME);
        }
        return null;
    }

    public String getWSDLFaultName() {
        return (String)this.getProperty(OperationDesc.FAULT_NAME);
    }

    public QName getWSDLInputMessageName() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (QName)op.getOption(OperationDesc.INPUT_MESSAGE_QNAME);
        }
        return null;
    }

    public QName getWSDLOutputMessageName() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (QName)op.getOption(OperationDesc.OUTPUT_MESSAGE_QNAME);
        }
        return null;
    }

    public String getWSDLLocation() {
        return this.getPort() != null ? this.getPort().getPortDesc().getWSDLFile() : null;
    }

    public String getPortPath() {
        return this.getTargetPortName();
    }

    public String getServiceRefName() {
        QName mangledName;
        if (this.isClient() && (mangledName = this.getPortName()) != null) {
            return ClientModuleMetaData.unravelServiceRefName((String)mangledName.getLocalPart());
        }
        return null;
    }

    public String getInputWSAAction() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (String)op.getOption(OperationDesc.INPUT_WSA_ACTION);
        }
        return null;
    }

    public String getOutputWSAAction() {
        OperationDesc op = this.resolveOperation();
        if (op != null) {
            return (String)op.getOption(OperationDesc.OUTPUT_WSA_ACTION);
        }
        return null;
    }

    public String getFaultWSAAction() {
        return (String)this.getProperty(OperationDesc.FAULT_WSA_ACTION);
    }

    private boolean validateEndpointAddress(URL newEndpointAddress) {
        boolean endpointValid = true;
        URL currentURL = this.getTargetEndpointAddressAsURL();
        if (newEndpointAddress == null) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid endpoint address specified.  URL is null");
            }
            endpointValid = false;
        } else if (currentURL != null && !currentURL.getProtocol().equals(newEndpointAddress.getProtocol())) {
            if (this.isHTTP(newEndpointAddress.getProtocol()) && this.isHTTP(currentURL.getProtocol())) {
                if (log.isDebugEnabled()) {
                    log.debug("New protocol [" + newEndpointAddress.getProtocol() + "] is different than existing protocol [" + currentURL.getProtocol() + "].  Both are http.  Processing continues.");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid endpoint address specified.  New protocol [" + newEndpointAddress.getProtocol() + "] is different than existing protocol [" + currentURL.getProtocol() + "]");
                }
                endpointValid = false;
            }
        }
        return endpointValid;
    }

    private boolean isHTTP(String protocol) {
        String p = protocol.toLowerCase();
        return "http".equals(p) || "https".equals(p);
    }

    public void addImplicitSOAPHeadersToRequest() throws WebServicesFault {
        HashMap reqHdrs = (HashMap)this.getProperty("com.ibm.websphere.webservices.requestSoapHeaders");
        if (reqHdrs == null) {
            return;
        }
        this.checkForProtectedSOAPHeaders(reqHdrs, "com.ibm.websphere.webservices.requestSoapHeaders");
        try {
            Message reqMsg = this.getRequestMessage();
            SOAPEnvelope se = reqMsg.getSOAPEnvelope();
            SOAPHeader sh = se.getHeader();
            if (sh == null) {
                sh = se.addHeader();
            }
            Iterator shIter = reqHdrs.entrySet().iterator();
            while (shIter.hasNext()) {
                Map.Entry headerMapEntry = shIter.next();
                QName headerName = (QName)headerMapEntry.getKey();
                Object headerValue = headerMapEntry.getValue();
                SOAPElement headerSE = null;
                if (headerValue instanceof String) {
                    headerSE = ((SOAPFactory)SOAPFactory.newInstance()).createElementFromXMLString((String)headerValue);
                } else if (headerValue instanceof SOAPElement) {
                    headerSE = (SOAPElement)headerValue;
                } else {
                    WebServicesFault wsf = new WebServicesFault(Messages.getMessage("hashMapValidationError"));
                    FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.MessageContext.addImplicitSOAPHeadersToRequest", "2209", this);
                    throw wsf;
                }
                sh.addChildElement(headerSE);
            }
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.MessageContext.addImplicitSOAPHeadersToRequest", "2218", this);
            throw WebServicesFault.makeFault(se);
        }
    }

    public void getImplicitSOAPHeadersFromResponse() throws WebServicesFault {
        HashMap responseHeaders = (HashMap)this.getProperty("com.ibm.websphere.webservices.responseSoapHeaders");
        if (responseHeaders == null) {
            return;
        }
        try {
            Message respMsg = this.getResponseMessage();
            if (respMsg == null) {
                return;
            }
            SOAPEnvelope se = respMsg.getSOAPEnvelope();
            SOAPHeader sh = se.getHeader();
            if (sh == null) {
                return;
            }
            if (responseHeaders.isEmpty()) {
                Iterator i = sh.examineAllHeaderElements();
                while (i.hasNext()) {
                    SOAPHeaderElement hdrElement = (SOAPHeaderElement)i.next();
                    Name elementName = hdrElement.getElementName();
                    boolean isProtected = false;
                    Iterator j = this.getProtectedSOAPHeaderQNames();
                    while (j.hasNext() && !isProtected) {
                        QName hdrName = (QName)j.next();
                        if (!hdrName.getLocalPart().equals(elementName.getLocalName()) || !hdrName.getNamespaceURI().equals(elementName.getURI())) continue;
                        isProtected = true;
                    }
                    if (isProtected) continue;
                    responseHeaders.put(new QName(elementName.getURI(), elementName.getLocalName()), hdrElement);
                }
            } else {
                Iterator i = sh.examineAllHeaderElements();
                while (i.hasNext()) {
                    SOAPHeaderElement hdrElement = (SOAPHeaderElement)i.next();
                    Name elementName = hdrElement.getElementName();
                    QName elementQName = new QName(elementName.getURI(), elementName.getLocalName());
                    if (!responseHeaders.containsKey(elementQName)) continue;
                    responseHeaders.put(elementQName, hdrElement);
                }
            }
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.MessageContext.addImplicitSOAPHeadersToRequest", "2267", this);
            throw WebServicesFault.makeFault(se);
        }
    }

    private Iterator getProtectedSOAPHeaderQNames() {
        if (this.cachedProtectedHeaderQNames == null) {
            this.cachedProtectedHeaderQNames = this.engine.getProtectedHeaders();
            if (this.cachedProtectedHeaderQNames == null) {
                this.cachedProtectedHeaderQNames = new ArrayList();
            }
            if (log.isDebugEnabled()) {
                log.debug("MessageContext.getProtectedSOAPHeaderQNames: Contents of 'cachedProtectedHeaderQNames':\n" + this.cachedProtectedHeaderQNames.toString());
            }
        }
        return this.cachedProtectedHeaderQNames.iterator();
    }

    private void checkForProtectedSOAPHeaders(HashMap hm, String propertyName) {
        if (hm == null) {
            return;
        }
        Iterator iter = this.getProtectedSOAPHeaderQNames();
        while (iter.hasNext()) {
            QName hdrQName = (QName)iter.next();
            if (!hm.containsKey(hdrQName)) continue;
            throw new IllegalArgumentException(Messages.getMessage("protSoapHdr", new String[]{hdrQName.toString()}));
        }
    }

    public void setInvokingTarget(boolean value) {
        if (log.isDebugEnabled()) {
            log.debug("setInvokingTarget(" + value + ")");
        }
        this.invokingTarget = value;
    }

    public boolean isInvokingTarget() {
        return this.invokingTarget;
    }

    static {
        systemTempDirName = WebServicesProperties.getProperty("webservices.attachments.Directory");
        if (systemTempDirName == null) {
            systemTempDirName = WebServicesProperties.getProperty("java.io.tmpdir");
        }
        if (systemTempDirName != null) {
            MessageContext.createDir(systemTempDirName);
        }
        TRANS_URL = "transport.url";
        TRANS_URL_HTTP_REDIRECTED = "transport.url.http.redirected";
        QUIT_REQUESTED = "quit.requested";
        AUTHUSER = "authenticatedUser";
        ATTACHMENTS_DIR = "attachments.directory";
        HTTP_TRANSPORT_VERSION = "webservices.transport.version";
        SAAJ_TRANSFORMATION = "webservices.not.optimal.saaj.transformation";
        FAULT_ON_SAAJ_TRANSFORMATION = "webservices.fault.on.saaj.transformation";
    }

    public static interface OneWayListener {
        public void oneWay(MessageContext var1);
    }

    private class BagCache {
        private ArrayList cache = new ArrayList();

        private BagCache() {
        }

        void storeBag(LockableHashtable bag) {
            bag.clear();
            bag.setParent(null);
            this.cache.add(bag);
        }

        LockableHashtable getBag() {
            return this.cache.size() == 0 ? new LockableHashtable() : (LockableHashtable)this.cache.remove(0);
        }
    }
}

