/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.WSDeployOptions;
import java.util.Hashtable;
import java.util.Vector;

public class WSDeployOptionsHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(WSDeployOptionsHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        return new WSDeployOptions(appController);
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        Hashtable<String, String> deployWSOptions = (Hashtable<String, String>)appInstallInfo.getAppOptions().get("deployws.options");
        if (deployWSOptions == null) {
            deployWSOptions = new Hashtable<String, String>();
            deployWSOptions.put("deployws.classpath", "");
            deployWSOptions.put("deployws.jardirs", "");
            appInstallInfo.getAppOptions().put("deployws.options", deployWSOptions);
        }
        if (deployWSOptions != null) {
            for (int i = 0; i < colNames.length; ++i) {
                Object option = deployWSOptions.get(colNames[i]);
                if (option == null) continue;
                if (option.getClass().getName().equals("java.lang.Boolean")) {
                    if (((Boolean)option).booleanValue()) {
                        data.addElement("AppDeploymentOption.Yes");
                        continue;
                    }
                    data.addElement("AppDeploymentOption.No");
                    continue;
                }
                data.addElement((String)option);
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty() && !t.isTaskDisabled()) {
            Hashtable appOptions = appInstallInfo.getAppOptions();
            String[][] taskData = t.getTaskData();
            Hashtable<String, Object> deployWSOptions = new Hashtable<String, Object>();
            for (int i = 0; i < taskData[0].length; ++i) {
                if (taskData[1][i] != null) {
                    if (taskData[1][i].equals("AppDeploymentOption.Yes")) {
                        deployWSOptions.put(taskData[0][i], Boolean.TRUE);
                        continue;
                    }
                    if (taskData[1][i].equals("AppDeploymentOption.No")) {
                        deployWSOptions.put(taskData[0][i], Boolean.FALSE);
                        continue;
                    }
                    deployWSOptions.put(taskData[0][i], taskData[1][i]);
                    continue;
                }
                deployWSOptions.put(taskData[0][i], taskData[1][i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deployws options", deployWSOptions);
            }
            appOptions.put("deployws.options", deployWSOptions);
            appInstallInfo.setAppOptions(appOptions);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

