/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.ws.runtime.config.InternalConfigService;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetaDataChannelHelper {
    protected static final TraceComponent tc = Tr.register(MetaDataChannelHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private ConfigObject transportChannelService;
    public static final String secure_http_protocol = "https";
    public static final String http_protocol = "http";
    public static final String WC_INBOUND_ADMIN = "WCInboundAdmin";
    public static final String WC_INBOUND_ADMIN_SECURE = "WCInboundAdminSecure";

    public MetaDataChannelHelper(TransportChannelService tcs) {
        this.transportChannelService = ((InternalConfigService)DeployUtils.getConfigService()).getConfigObject(tcs);
    }

    public MetaDataChannelHelper(ConfigObject tcs) {
        this.transportChannelService = tcs;
    }

    public Map getEndPointMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPointMap");
        }
        HashMap<String, String> endPointMap = new HashMap<String, String>();
        List chains = this.transportChannelService.getObjectList("chains");
        for (int ii = 0; ii < chains.size(); ++ii) {
            ConfigObject aChain = (ConfigObject)chains.get(ii);
            if (!this.isTCPInbound(aChain) || !this.isWebContainerInbound(aChain) || this.isAdminChannel(aChain)) continue;
            if (this.isSSLInbound(aChain)) {
                endPointMap.put(this.getEndPointName(aChain), secure_http_protocol);
                continue;
            }
            endPointMap.put(this.getEndPointName(aChain), http_protocol);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPointMap");
        }
        return endPointMap;
    }

    boolean isAdminChannel(ConfigObject chain) {
        String name = chain.getString("name", "__null__");
        return WC_INBOUND_ADMIN.equals(name) || WC_INBOUND_ADMIN_SECURE.equals(name);
    }

    private ConfigObject getFirstChannel(ConfigObject chain) {
        if (chain == null) {
            return null;
        }
        List transportChannels = chain.getObjectList("transportChannels");
        if (transportChannels.isEmpty()) {
            return null;
        }
        return (ConfigObject)transportChannels.get(0);
    }

    private ConfigObject getLastChannel(ConfigObject chain) {
        if (chain == null) {
            return null;
        }
        List transportChannels = chain.getObjectList("transportChannels");
        if (transportChannels.isEmpty()) {
            return null;
        }
        return (ConfigObject)transportChannels.get(transportChannels.size() - 1);
    }

    private boolean isTCPInbound(ConfigObject chain) {
        ConfigObject first = this.getFirstChannel(chain);
        return first != null && first.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "TCPInboundChannel");
    }

    private boolean isWebContainerInbound(ConfigObject chain) {
        ConfigObject last = this.getLastChannel(chain);
        return last != null && last.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "WebContainerInboundChannel");
    }

    private String getEndPointName(ConfigObject tcpChain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPointName");
        }
        String endPointName = "";
        ConfigObject first = this.getFirstChannel(tcpChain);
        if (first != null && first.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "TCPInboundChannel")) {
            endPointName = first.getString("endPointName", "__null__");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPointName", "endPointName=" + endPointName);
        }
        return endPointName;
    }

    private boolean isSSLInbound(ConfigObject chain) {
        if (chain == null) {
            return false;
        }
        List channels = chain.getObjectList("transportChannels");
        if (channels.isEmpty()) {
            return false;
        }
        Iterator iChannels = channels.iterator();
        while (iChannels.hasNext()) {
            ConfigObject aChannel = (ConfigObject)iChannels.next();
            if (!aChannel.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "SSLInboundChannel")) continue;
            return true;
        }
        return false;
    }
}

