/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DeployMessages
implements AppDeploymentMessages {
    private static TraceComponent tc = Tr.register(DeployMessages.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private ResourceBundle messageBundle = null;
    private ResourceBundle textBundle = null;
    private ResourceBundle englishTextBundle = null;

    public DeployMessages() {
        this("com.ibm.ws.webservices.deploy.resources.deployMessages", Locale.getDefault());
    }

    public DeployMessages(String bundleName) {
        this(bundleName, Locale.getDefault());
    }

    public DeployMessages(Locale locale) {
        this("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
    }

    public DeployMessages(String bundleName, Locale locale) {
        this.getBundle(bundleName, locale);
    }

    private void getBundle(String bundleName, Locale locale) {
        Locale loc = locale == null ? Locale.getDefault() : locale;
        try {
            this.messageBundle = ResourceBundle.getBundle(bundleName, loc);
            this.textBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.deploy.resources.deployText", loc);
            this.englishTextBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.deploy.resources.deploy", loc);
        }
        catch (MissingResourceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.deploy.DeployMessages.getBundle", "60", this);
            this.messageBundle = null;
            this.textBundle = null;
            this.englishTextBundle = null;
            Object[] params = new Object[]{bundleName, locale, e};
            Tr.warning(tc, "WSWS0019E", params);
            throw new RuntimeException("WSWS0019E: The resource bundle for this locale was not found.");
        }
    }

    private String getString(String key) {
        try {
            return this.getString(key, this.messageBundle);
        }
        catch (Exception f) {
            try {
                return this.getString(key, this.textBundle);
            }
            catch (Exception e) {
                try {
                    return this.getString(key, this.englishTextBundle);
                }
                catch (Exception d) {
                    return key + " " + d.getMessage();
                }
            }
        }
    }

    private String getString(String key, ResourceBundle bund) throws Exception {
        if (bund != null) {
            return bund.getString(key);
        }
        throw new Exception("The ResourceBundle is null.");
    }

    public String getGoalTitle(String key) {
        return this.getString(key + ".goalTitle");
    }

    public String getGoalTitle(String key, Locale locale) {
        this.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
        return this.getGoalTitle(key);
    }

    public String getGoalMessage(String key) {
        return this.getString(key + ".goalMessage");
    }

    public String getGoalMessage(String key, Locale locale) {
        this.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
        return this.getGoalMessage(key);
    }

    public String getEmptyTaskMessage(String key) {
        return this.getString(key + ".emptyMessage");
    }

    public String getEmptyTaskMessage(String key, Locale locale) {
        this.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
        return this.getEmptyTaskMessage(key);
    }

    public String getDisableTaskMessage(String key) {
        return this.getString(key + ".disableMessage");
    }

    public String getDisableTaskMessage(String key, Locale locale) {
        this.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
        return this.getDisableTaskMessage(key);
    }

    public String getColumnName(String key) {
        return this.getString(key + ".column");
    }

    public String getColumnName(String key, Locale locale) {
        this.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
        return this.getColumnName(key);
    }

    public String getColumnName(String key, String taskName, Locale locale) {
        this.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
        return this.getColumnName(key);
    }

    public String getColumnName(String key, String taskName) {
        return this.getColumnName(key);
    }

    public String getMessage(String key) {
        return this.getString(key);
    }

    public String getMessage(String key, Locale locale) {
        this.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages", locale);
        return this.getMessage(key);
    }
}

