/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SSLConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.WscbndFactory;
import com.ibm.etools.webservice.wscbnd.WscbndPackage;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.ClientBindPortInfo;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class ClientBindPortInfoTaskHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(ClientBindPortInfoTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        return new ClientBindPortInfo(appController);
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        String[][] newTaskData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (task.getTaskData() != null) {
            return;
        }
        Vector<String> dataForTwoDimensionalArray = new Vector<String>();
        String[] columnNames = task.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            dataForTwoDimensionalArray.addElement(columnNames[i]);
        }
        Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector combined = new Vector();
        combined.addAll(ejbJars);
        combined.addAll(wars);
        boolean webServiceEnabled = false;
        boolean firstRowFilled = false;
        Iterator iter = combined.iterator();
        while (iter.hasNext()) {
            WSDeploymentDescriptorAccessor ddAccessor;
            EObject refObject = (EObject)iter.next();
            String moduleURI = util.formUriString(appDeploymentInfo, refObject);
            String[] pieces = util.separateUriString(moduleURI);
            String moduleName = pieces[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareTask: working on module " + moduleURI);
            }
            if ((ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabledClient()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: module " + moduleURI + " is Web Service enabled");
                }
                webServiceEnabled = true;
                WSBindingsFileAccessor bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo);
                ClientBinding clientBinding = bindingAccessor.getClientBinding();
                if (clientBinding == null) continue;
                String ejbName = "";
                if (bindingAccessor.isWebType(null)) {
                    EList services = clientBinding.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    firstRowFilled = this.fillServicesRows(dataForTwoDimensionalArray, moduleName, ejbName, services);
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    firstRowFilled = this.fillServicesRows(dataForTwoDimensionalArray, moduleName, ejbName, services);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "prepareTask: module " + moduleURI + " is NOT Web Service enabled");
        }
        if (webServiceEnabled) {
            if (!firstRowFilled) {
                for (int i = 0; i < columnNames.length; ++i) {
                    dataForTwoDimensionalArray.addElement("");
                }
            }
            newTaskData = util.buildTaskData(dataForTwoDimensionalArray, columnNames.length);
            task.setTaskData(newTaskData);
        } else {
            newTaskData = null;
            task.setTaskData(newTaskData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private boolean fillServicesRows(Vector dataForTwoDimensionalArray, String moduleName, String ejbName, EList services) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillServicesRows", new Object[]{moduleName, ejbName});
        }
        int size = services.size();
        boolean firstRowFilled = false;
        for (int i = 0; i < size; ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            EList ports = sr.getPortQnameBindings();
            if (ports == null || ports.isEmpty()) continue;
            int ports_size = ports.size();
            for (int j = 0; j < ports_size; ++j) {
                PortQnameBinding aPort = (PortQnameBinding)ports.get(j);
                dataForTwoDimensionalArray.addElement(moduleName);
                dataForTwoDimensionalArray.addElement(ejbName);
                dataForTwoDimensionalArray.addElement(serviceName);
                String portLocalName = aPort.getPortQnameLocalNameLink();
                String portNamespace = aPort.getPortQnameNamespaceLink();
                QName aPortQName = new QName(portNamespace, portLocalName);
                String aPortQNameString = aPortQName.toString();
                dataForTwoDimensionalArray.addElement(aPortQNameString);
                String timeout = aPort.getSyncTimeout();
                if (timeout == null) {
                    timeout = "";
                }
                dataForTwoDimensionalArray.addElement(timeout);
                BasicAuth ba = aPort.getBasicAuth();
                if (ba != null) {
                    dataForTwoDimensionalArray.addElement(aPort.getBasicAuth().getUserid());
                    dataForTwoDimensionalArray.addElement(aPort.getBasicAuth().getPassword());
                } else {
                    dataForTwoDimensionalArray.addElement("");
                    dataForTwoDimensionalArray.addElement("");
                }
                if (aPort.getSslConfig() != null) {
                    dataForTwoDimensionalArray.addElement(aPort.getSslConfig().getName());
                } else {
                    dataForTwoDimensionalArray.addElement("");
                }
                String uri = aPort.getOverriddenEndpointURI();
                if (uri == null) {
                    uri = "";
                }
                dataForTwoDimensionalArray.addElement(uri);
                String namespace = aPort.getOverriddenBindingNamespace();
                if (namespace == null) {
                    namespace = "";
                }
                dataForTwoDimensionalArray.addElement(namespace);
                firstRowFilled = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillServicesRows", new Boolean(firstRowFilled));
        }
        return firstRowFilled;
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!task.isTaskEmpty() && !task.isTaskDisabled()) {
            Hashtable appOptions = appDeploymentInfo.getAppOptions();
            String[][] taskData = task.getTaskData();
            Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector combined = new Vector();
            combined.addAll(ejbJars);
            combined.addAll(wars);
            Iterator iter = combined.iterator();
            while (iter.hasNext()) {
                WSBindingsFileAccessor bindingAccessor;
                ClientBinding clientBinding;
                WSDeploymentDescriptorAccessor ddAccessor;
                EObject refObject = (EObject)iter.next();
                String moduleURI = util.formUriString(appDeploymentInfo, refObject);
                String[] pieces = util.separateUriString(moduleURI);
                String moduleName = pieces[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: working on module " + moduleURI);
                }
                if (!(ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabledClient()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: module " + moduleURI + " is Web Service enabled");
                }
                if ((clientBinding = (bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo)).getClientBinding()) == null) continue;
                String ejbName = "";
                if (bindingAccessor.isWebType(null)) {
                    EList services = clientBinding.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetPortInfo(moduleName, ejbName, services, taskData);
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetPortInfo(moduleName, ejbName, services, taskData);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void searchServicesAndSetPortInfo(String moduleMatch, String ejbMatch, EList services, String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchServicesAndSetPortInfo", new Object[]{moduleMatch, ejbMatch});
        }
        int size = services.size();
        for (int i = 0; i < size; ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            EList ports = sr.getPortQnameBindings();
            if (ports == null || ports.isEmpty()) continue;
            int ports_size = ports.size();
            for (int j = 0; j < ports_size; ++j) {
                PortQnameBinding aPort = (PortQnameBinding)ports.get(j);
                String portLocalName = aPort.getPortQnameLocalNameLink();
                String portNamespace = aPort.getPortQnameNamespaceLink();
                QName aPortQName = new QName(portNamespace, portLocalName);
                String aPortQNameString = aPortQName.toString();
                for (int jj = 1; jj < taskData.length; ++jj) {
                    String newNamespace;
                    String newEndpoint;
                    String newSslcfg;
                    String[] taskRow = taskData[jj];
                    if (!moduleMatch.equals(taskRow[0]) || !ejbMatch.equals(taskRow[1]) || !serviceName.equals(taskRow[2]) || !aPortQNameString.equals(taskRow[3])) continue;
                    String newTimeout = taskRow[4];
                    if (newTimeout != null && !newTimeout.equals("")) {
                        if (newTimeout.equals(" ")) {
                            aPort.eUnset(aPort.eClass().getEStructuralFeature("syncTimeout"));
                        } else {
                            aPort.setSyncTimeout(newTimeout);
                        }
                    }
                    BasicAuth basicAuth = aPort.getBasicAuth();
                    String newId = taskRow[5];
                    String newPwd = taskRow[6];
                    if (newId != null && !newId.equals("") || newPwd != null && !newPwd.equals("")) {
                        if (basicAuth == null) {
                            String uri = "http://www.ibm.com/websphere/appserver/schemas/5.0.2/wscbnd.xmi";
                            WscbndPackage pkg = (WscbndPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
                            WscbndFactory factory = pkg.getWscbndFactory();
                            basicAuth = factory.createBasicAuth();
                            aPort.setBasicAuth(basicAuth);
                        }
                        if (newId.equals(" ")) {
                            basicAuth.eUnset(basicAuth.eClass().getEStructuralFeature("userid"));
                        } else {
                            basicAuth.setUserid(newId);
                        }
                        if (newPwd.equals(" ")) {
                            basicAuth.eUnset(basicAuth.eClass().getEStructuralFeature("password"));
                        } else {
                            basicAuth.setPassword(newPwd);
                        }
                    }
                    if ((newSslcfg = taskRow[7]) != null && !newSslcfg.equals("")) {
                        SSLConfig sslcfg = aPort.getSslConfig();
                        if (sslcfg == null) {
                            String uri = "http://www.ibm.com/websphere/appserver/schemas/5.0.2/wscbnd.xmi";
                            WscbndPackage pkg = (WscbndPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
                            WscbndFactory factory = pkg.getWscbndFactory();
                            sslcfg = factory.createSSLConfig();
                            aPort.setSslConfig(sslcfg);
                        }
                        if (newSslcfg.equals(" ")) {
                            sslcfg.eUnset(sslcfg.eClass().getEStructuralFeature("name"));
                        } else {
                            sslcfg.setName(newSslcfg);
                        }
                    }
                    if ((newEndpoint = taskRow[8]) != null && !newEndpoint.equals("")) {
                        if (newEndpoint.equals(" ")) {
                            aPort.eUnset(aPort.eClass().getEStructuralFeature("overriddenEndpointURI"));
                        } else {
                            aPort.setOverriddenEndpointURI(newEndpoint);
                        }
                    }
                    if ((newNamespace = taskRow[9]) == null || newNamespace.equals("")) continue;
                    if (newNamespace.equals(" ")) {
                        aPort.eUnset(aPort.eClass().getEStructuralFeature("overriddenBindingNamespace"));
                        continue;
                    }
                    aPort.setOverriddenBindingNamespace(newNamespace);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchServicesAndSetPortInfo");
        }
    }
}

