/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.custom;

import com.ibm.ws.webservices.custom.CustomPropertyDescriptor;
import com.ibm.ws.webservices.custom.CustomPropertyValidator;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import org.apache.commons.logging.Log;

public class CustomPropertyStringValidator
implements CustomPropertyValidator {
    private Log log = LogFactory.getLog(CustomPropertyStringValidator.class.getName());
    private boolean ignoreCase = false;
    private String[] validStrings = null;

    CustomPropertyStringValidator(boolean _ignoreCase) {
        this.ignoreCase = _ignoreCase;
    }

    CustomPropertyStringValidator(boolean _ignoreCase, String[] _validStrings) {
        this.ignoreCase = _ignoreCase;
        this.validStrings = _validStrings;
    }

    public Object validate(Object value, CustomPropertyDescriptor desc) {
        block8: {
            try {
                String stringValue = (String)value;
                if (this.validStrings != null && this.validStrings.length > 0) {
                    int i;
                    for (i = 0; i < this.validStrings.length; ++i) {
                        if (!this.matches(stringValue, this.validStrings[i])) continue;
                        return stringValue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failure occured during String validation.  Value " + stringValue + " ");
                        this.log.debug("does not match valid values, which are: ");
                        for (i = 0; i < this.validStrings.length; ++i) {
                            this.log.debug("   " + this.validStrings[i] + " ");
                        }
                    }
                    break block8;
                }
                return stringValue;
            }
            catch (ClassCastException cce) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failure occured during String validation.  ");
                    this.log.debug("Object passed to validator is not type " + String.class.getName() + ".");
                }
            }
            catch (NullPointerException npe) {
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug("Failure occured during String validation.  ");
                this.log.debug("Object passed to validator is null.");
            }
        }
        return desc.getValue();
    }

    private boolean matches(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (this.ignoreCase) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }
}

