/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.combined.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.combined.deploy.URLPrefixHolder;
import com.ibm.ws.webservices.deploy.BindingChoices;
import com.ibm.ws.webservices.deploy.BindingChoicesHelper;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import com.ibm.ws.websvcs.deploy.URLPrefixMapHelper;
import com.ibm.wsspi.webservices.models.WSModels;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingChoicesTaskHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent _tc = Tr.register(BindingChoicesTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private boolean isForAppInstall;

    public BindingChoicesTaskHelper() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "BindingChoicesTaskHelper default ctor, this=" + this.toString());
        }
        this.isForAppInstall = false;
    }

    public BindingChoicesTaskHelper(boolean forAppInstall) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "BindingChoicesTaskHelper ctor, this=" + this.toString() + ", isForAppInstall=" + (forAppInstall ? "true" : "false"));
        }
        this.isForAppInstall = forAppInstall;
    }

    @Override
    public AppDeploymentTask createTask(AppDeploymentController controller, String taskName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createTask, this=" + this.toString());
        }
        BindingChoices task = null;
        try {
            task = new BindingChoices(controller);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.getClass().getName(), "109");
            Tr.error(_tc, "WSWS0020E", ex);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createTask, returning BindingChoices:" + (task == null ? "<null>" : task));
        }
        return task;
    }

    @Override
    public void prepareTask(AppDeploymentInfo info, AppDeploymentTask task) throws AppDeploymentException {
        String[][] taskData;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "prepareTask, this=" + this.toString());
        }
        if (task.getTaskData() != null) {
            return;
        }
        task.setIsSufficientlyDone(true);
        HashMap<String, URLPrefixHolder> holderMap = new HashMap<String, URLPrefixHolder>();
        URLPrefixHolder.setAppUrlHolderMap(info.getAppDisplayName(), holderMap);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Created holderMap for application " + info.getAppDisplayName());
        }
        if ((taskData = this.createTaskData(holderMap, info, task)) == null) {
            task.setIsTaskDisabled(true);
            ArrayList<String> data = new ArrayList<String>();
            String[] colNames = task.getColumnNames();
            for (int j = 0; j < colNames.length; ++j) {
                data.add(colNames[j]);
            }
            taskData = util.buildTaskData(new Vector(data), task.getColumnNames().length);
            task.setTaskData(taskData);
        } else {
            task.setIsTaskDisabled(false);
            task.setTaskData(taskData);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "taskData:\n" + DeployUtils.taskDataToString(taskData));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "prepareTask");
        }
    }

    @Override
    public void completeTask(AppDeploymentInfo info, AppDeploymentTask task) throws AppDeploymentException {
        String[][] taskData;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeTask, this=" + this.toString());
        }
        if ((taskData = task.getTaskData()) == null) {
            return;
        }
        HashMap<String, URLPrefixHolder> holderMap = URLPrefixHolder.getAppUrlHolderMap(info.getAppDisplayName());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieved holderMap for application " + info.getAppDisplayName() + ": " + (holderMap == null ? "<null>" : holderMap));
        }
        if (holderMap == null) {
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "taskData contains:\n" + DeployUtils.taskDataToString(task.getTaskData()));
        }
        for (int i = 1; i < taskData.length; ++i) {
            String moduleName = taskData[i][0];
            String protocol = taskData[i][1];
            String userInput = taskData[i][2];
            URLPrefixHolder holderObj = holderMap.get(moduleName);
            if (holderObj != null) {
                holderObj.getUrlPrefixMap().put(protocol, userInput);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Applying task data to URL prefix map: " + protocol + "-->" + userInput);
                continue;
            }
            throw new AppDeploymentException("Internal error searching for URLPrefixHolder object for module " + moduleName, null);
        }
        if (!this.isForAppInstall) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Since this is NOT an app install, we'll save the URLPrefixMap info now.");
            }
            for (Map.Entry<String, URLPrefixHolder> entry : holderMap.entrySet()) {
                String moduleName = entry.getKey();
                URLPrefixHolder holder = entry.getValue();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saving URL prefix information for module " + moduleName + ": " + holder.getUrlPrefixMap().toString());
                }
                try {
                    holder.getUrlPrefixMapHelper().save(holder.getUrlPrefixMap());
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.getClass().getName(), "263");
                    throw new AppDeploymentException("Error saving URL prefix information for module: " + moduleName, t);
                }
            }
            URLPrefixHolder.setAppUrlHolderMap(info.getAppDisplayName(), null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Cleared the holder map for application: " + info.getAppDisplayName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "completeTask");
        }
    }

    private String[][] createTaskData(HashMap<String, URLPrefixHolder> holderMap, AppDeploymentInfo info, AppDeploymentTask task) throws AppDeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createTaskData");
        }
        Vector ejbJars = info.getModuleConfig("JAR_DD");
        Iterator iter = ejbJars.iterator();
        while (iter.hasNext()) {
            HashMap<String, String> urlPrefixMap = null;
            URLPrefixMapHelper helper = null;
            EObject refObject = (EObject)iter.next();
            ModuleFile modFile = info.getModuleFileForDD(refObject);
            if (modFile.isEJBJarFile()) {
                block26: {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Processing EJB jar module " + modFile.getName());
                    }
                    WSBinding wsBinding = null;
                    try {
                        wsBinding = WSModels.getWSBinding(modFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                        if (wsBinding == null) break block26;
                        EList routers = wsBinding.getRouterModules();
                        for (RouterModule rm : routers) {
                            if (!rm.getTransport().equalsIgnoreCase("jms")) continue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found a JMS router module: " + rm.getName());
                            }
                            helper = new URLPrefixMapHelper(info.getAppDisplayName(), modFile, task.getAppDeploymentController().getConfigSession());
                            try {
                                urlPrefixMap = helper.get();
                            }
                            catch (Throwable t) {
                                FFDCFilter.processException(t, this.getClass().getName(), "342");
                                urlPrefixMap = new HashMap();
                            }
                            String jmsPrefix = urlPrefixMap.get("jms");
                            if (jmsPrefix == null) {
                                urlPrefixMap.put("jms", "");
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                WSDeploymentDescriptorAccessor ddAccessor = new WSDeploymentDescriptorAccessor(refObject, info, task);
                if (ddAccessor.isModuleWebServiceEnabled(task)) {
                    boolean foundEJBEndpoint = false;
                    String moduleURI = util.formUriString(info, refObject);
                    String tmpDirForModule = DeployUtils.createWorkingDirectory(task);
                    BindingChoicesHelper.extractModulesFilesToTmpDir(task, moduleURI, modFile, tmpDirForModule);
                    String[] webserviceDescriptionNames = ddAccessor.getWebserviceDescriptionNames();
                    for (int i = 0; !foundEJBEndpoint && i < webserviceDescriptionNames.length; ++i) {
                        String nameOfWSDLFile = ddAccessor.getWsdlFileForWebserviceDescriptionName(webserviceDescriptionNames[i]);
                        BindingChoicesHelper.verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(task, moduleURI, modFile, nameOfWSDLFile);
                        String contextURI = "file:" + tmpDirForModule + "/";
                        int lastForwardSlash = nameOfWSDLFile.lastIndexOf(47);
                        int lastBackSlash = nameOfWSDLFile.lastIndexOf(92);
                        int lastSlash = lastForwardSlash > lastBackSlash ? lastForwardSlash : lastBackSlash;
                        String m_contextURI = contextURI;
                        String m_nameOfInputWSDLFile = nameOfWSDLFile;
                        if (lastSlash >= 0 && nameOfWSDLFile.length() > lastSlash) {
                            String prefix = nameOfWSDLFile.substring(0, lastSlash + 1);
                            m_nameOfInputWSDLFile = nameOfWSDLFile.substring(lastSlash + 1);
                            m_contextURI = contextURI + prefix;
                        }
                        WSDLFactoryImpl factory = new WSDLFactoryImpl();
                        WSDLReader reader = ((WSDLFactory)factory).newWSDLReader();
                        Definition definition = null;
                        try {
                            definition = reader.readWSDL(null, m_contextURI + m_nameOfInputWSDLFile);
                        }
                        catch (WSDLException e) {
                            FFDCFilter.processException(e, this.getClass().getName(), "413");
                            throw new AppDeploymentException(MessageFormat.format(util.getMessage(task, "WSWS0020E"), task.getName()), null);
                        }
                        Map services = definition.getServices();
                        Iterator iter2 = services.values().iterator();
                        while (!foundEJBEndpoint && iter2.hasNext()) {
                            Service service = (Service)iter2.next();
                            Map ports = service.getPorts();
                            Iterator iter3 = ports.values().iterator();
                            block12: while (!foundEJBEndpoint && iter3.hasNext()) {
                                Port p = (Port)iter3.next();
                                Binding binding = p.getBinding();
                                List ees = binding.getExtensibilityElements();
                                String bindingNameSpace = null;
                                Iterator iter4 = ees.iterator();
                                while (!foundEJBEndpoint && iter4.hasNext()) {
                                    String ejbPrefix;
                                    ExtensibilityElement ee = (ExtensibilityElement)iter4.next();
                                    QName qname = ee.getElementType();
                                    if (!qname.getLocalPart().equals("binding") || !(bindingNameSpace = qname.getNamespaceURI()).equals("http://www.ibm.com/ns/2003/06/wsdl/mp/ejb")) continue;
                                    foundEJBEndpoint = true;
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Found an EJB endpoint in module: " + modFile.getName());
                                    }
                                    if (helper == null) {
                                        helper = new URLPrefixMapHelper(info.getAppDisplayName(), modFile, task.getAppDeploymentController().getConfigSession());
                                        try {
                                            urlPrefixMap = helper.get();
                                        }
                                        catch (Throwable t) {
                                            FFDCFilter.processException(t, this.getClass().getName(), "463", this);
                                            urlPrefixMap = new HashMap();
                                        }
                                    }
                                    if ((ejbPrefix = urlPrefixMap.get("ejb")) != null) continue block12;
                                    urlPrefixMap.put("ejb", "");
                                    if (!_tc.isDebugEnabled()) continue block12;
                                    Tr.debug(_tc, "Added empty URL prefix for EJB protocol...");
                                    continue block12;
                                }
                            }
                        }
                    }
                    DeployUtils.deleteWorkingDirectory(tmpDirForModule);
                }
            }
            if (helper == null) continue;
            URLPrefixHolder holder = new URLPrefixHolder(urlPrefixMap, helper);
            holderMap.put(modFile.getName(), holder);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Added URLPrefixHolder to map. Module=" + modFile.getName() + ", holder=" + holder.toString());
        }
        String[][] taskData = null;
        if (!holderMap.isEmpty()) {
            ArrayList<String> data = new ArrayList<String>();
            String[] colNames = task.getColumnNames();
            for (int j = 0; j < colNames.length; ++j) {
                data.add(colNames[j]);
            }
            Set<Map.Entry<String, URLPrefixHolder>> entrySet = holderMap.entrySet();
            this.addRowsForTransport(data, "jms", entrySet);
            this.addRowsForTransport(data, "ejb", entrySet);
            taskData = util.buildTaskData(new Vector(data), task.getColumnNames().length);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createTaskData, final taskData:\n" + (taskData == null ? "NULL" : DeployUtils.taskDataToString(taskData)));
        }
        return taskData;
    }

    private void addRowsForTransport(List data, String transport, Set entrySet) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addRowsForTransport, transport=" + transport);
        }
        for (Map.Entry entry : entrySet) {
            URLPrefixHolder holder = (URLPrefixHolder)entry.getValue();
            String prefix = holder.getUrlPrefixMap().get(transport);
            if (prefix == null) continue;
            data.add(entry.getKey());
            data.add(transport);
            data.add(prefix);
            data.add("no");
            data.add("");
            data.add("");
        }
    }
}

