/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.NullRefAddrException;
import com.ibm.ws.util.MessageDestinationInfo;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDestinationObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = MessageDestinationObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "Injection", "com.ibm.wsspi.injectionengine.injection");

    public MessageDestinationObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "MessageDestinationObjectFactory.<init>");
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance : " + obj);
        }
        Object retObj = null;
        if (!(obj instanceof Reference)) {
            InjectionException inex = new InjectionException("Binding object is not a Reference : " + obj);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + (Object)((Object)inex));
            }
            throw inex;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(CLASS_NAME)) {
            InjectionException inex = new InjectionException("Incorrect factory for Reference : " + obj);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + (Object)((Object)inex));
            }
            throw inex;
        }
        RefAddr addr = ref.get("MessageDestinationInfo");
        if (addr == null) {
            NullRefAddrException ne = new NullRefAddrException("The address for this Reference is empty (null)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + ne);
            }
            throw ne;
        }
        MessageDestinationInfo info = (MessageDestinationInfo)addr.getContent();
        String destJndiName = InjectionEngineAccessor.getMessageDestinationLinkInstance().findDestinationByName(info.ivApplication, info.ivModule, info.ivLink);
        Tr.debug(tc, "destJndiName : " + destJndiName);
        if (destJndiName == null) {
            Tr.error(tc, "MSG_DEST_NOT_FOUND_ON_NODE_CWNEN0055E", new Object[]{info.ivLink, info.ivModule, info.ivApplication});
            String exMsg = "The " + info.ivLink + " message destination in the " + info.ivModule + " module of the " + info.ivApplication + " application cannot be found on this node.";
            throw new RuntimeException(exMsg);
        }
        InitialContext ctx = new InitialContext();
        retObj = ctx.lookup(destJndiName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance : " + retObj);
        }
        return retObj;
    }
}

