/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

public class BoundedBuffer {
    private int waitingThreads = 0;
    private static final int SPINS_TAKE_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.spins_take", 16);
    private static final int SPINS_PUT_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.spins_put", 4);
    private static final boolean YIELD_TAKE_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_take");
    private static final boolean YIELD_PUT_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_put");
    private static final long WAIT_SLICE_ = Long.getLong("com.ibm.ws.util.BoundedBuffer.wait", 1000L);
    private final PutQueueLock putQueue_ = new PutQueueLock();
    private int putQueueLen_ = 0;
    private final GetQueueLock getQueue_ = new GetQueueLock();
    private int getQueueLen_ = 0;
    private Object[] buffer;
    private int takeIndex = 0;
    private int putIndex = 0;
    private AtomicInteger numberOfUsedSlots = new AtomicInteger(0);
    private final BoundedBufferLock lock = new BoundedBufferLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGet_() {
        if (this.getQueueLen_ > 0) {
            GetQueueLock getQueueLock = this.getQueue_;
            synchronized (getQueueLock) {
                this.getQueue_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitGet_(long timeout) throws InterruptedException {
        GetQueueLock getQueueLock = this.getQueue_;
        synchronized (getQueueLock) {
            try {
                ++this.getQueueLen_;
                if (this.numberOfUsedSlots.get() <= 0) {
                    this.getQueue_.wait(timeout);
                }
            }
            catch (InterruptedException ex) {
                this.getQueue_.notify();
                throw ex;
            }
            finally {
                --this.getQueueLen_;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPut_() {
        if (this.putQueueLen_ > 0) {
            PutQueueLock putQueueLock = this.putQueue_;
            synchronized (putQueueLock) {
                this.putQueue_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPut_(long timeout) throws InterruptedException {
        PutQueueLock putQueueLock = this.putQueue_;
        synchronized (putQueueLock) {
            try {
                ++this.putQueueLen_;
                if (this.numberOfUsedSlots.get() >= this.buffer.length) {
                    this.putQueue_.wait(timeout);
                }
            }
            catch (InterruptedException ex) {
                this.putQueue_.notify();
                throw ex;
            }
            finally {
                --this.putQueueLen_;
            }
        }
    }

    public BoundedBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[capacity];
    }

    public int size() {
        return this.numberOfUsedSlots.get();
    }

    public int capacity() {
        return this.buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.numberOfUsedSlots.get() > 0) {
                return this.buffer[this.takeIndex];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        boolean ret = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = true;
                }
            }
            if (ret) {
                this.notifyGet_();
                return;
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                    continue;
                }
                this.waitPut_(WAIT_SLICE_);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object x, long timeoutInMillis) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        long start = timeoutInMillis <= 0L ? 0L : -1L;
        long waitTime = timeoutInMillis;
        Object ret = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = x;
                }
            }
            if (ret != null) {
                this.notifyGet_();
                return ret;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    return null;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(timeoutInMillis);
                }
                waitTime = timeoutInMillis - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object x, long timeoutInMillis, int maximumCapacity) throws InterruptedException {
        if (x == null || maximumCapacity > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        long start = timeoutInMillis <= 0L ? 0L : -1L;
        long waitTime = timeoutInMillis;
        Object ret = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < maximumCapacity) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = x;
                }
            }
            if (ret != null) {
                this.notifyGet_();
                return ret;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    return null;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(timeoutInMillis);
                }
                waitTime = timeoutInMillis - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object x, long timeout) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        long start = timeout <= 0L ? 0L : -1L;
        long waitTime = timeout;
        boolean ret = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = true;
                }
            }
            if (ret) {
                this.notifyGet_();
                return true;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    return false;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(waitTime);
                }
                waitTime = timeout - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object old = null;
        block3: while (true) {
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                if (this.numberOfUsedSlots.get() > 0) {
                    old = this.extract();
                    this.numberOfUsedSlots.getAndDecrement();
                }
                if (old != null) {
                    --this.waitingThreads;
                }
            }
            if (old != null) {
                this.notifyPut_();
                return old;
            }
            int spinctr = SPINS_TAKE_;
            while (true) {
                if (this.numberOfUsedSlots.get() > 0) continue block3;
                if (spinctr > 0) {
                    if (YIELD_TAKE_) {
                        Thread.yield();
                    }
                    --spinctr;
                    continue;
                }
                this.waitGet_(WAIT_SLICE_);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long timeout) throws InterruptedException {
        Object old = null;
        long start = timeout <= 0L ? 0L : -1L;
        long waitTime = timeout;
        block3: while (true) {
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                if (this.numberOfUsedSlots.get() > 0) {
                    old = this.extract();
                    this.numberOfUsedSlots.getAndDecrement();
                }
                if (old != null) {
                    --this.waitingThreads;
                }
            }
            if (old != null) {
                this.notifyPut_();
                return old;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_TAKE_;
            while (true) {
                if (this.numberOfUsedSlots.get() > 0) continue block3;
                if (waitTime <= 0L) {
                    return null;
                }
                if (spinctr > 0) {
                    if (YIELD_TAKE_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitGet_(waitTime);
                }
                waitTime = timeout - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    public synchronized void incrementWaitingThreads() {
        ++this.waitingThreads;
    }

    public synchronized void decrementWaitingThreads() {
        --this.waitingThreads;
    }

    public synchronized int excessWaitingThreads() {
        return this.waitingThreads - this.size();
    }

    private final void insert(Object x) {
        this.buffer[this.putIndex] = x;
        if (++this.putIndex >= this.buffer.length) {
            this.putIndex = 0;
        }
    }

    private final Object extract() {
        Object old = this.buffer[this.takeIndex];
        this.buffer[this.takeIndex] = null;
        if (++this.takeIndex >= this.buffer.length) {
            this.takeIndex = 0;
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expand(int additionalCapacity) {
        if (additionalCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            Object[] newBuffer = new Object[this.buffer.length + additionalCapacity];
            if (this.putIndex > this.takeIndex) {
                int used = this.putIndex - this.takeIndex;
                System.arraycopy(this.buffer, this.takeIndex, newBuffer, 0, used);
                this.putIndex = used;
            } else if (this.putIndex != this.takeIndex || this.buffer[this.takeIndex] != null) {
                int used = this.buffer.length - this.takeIndex;
                System.arraycopy(this.buffer, this.takeIndex, newBuffer, 0, used);
                System.arraycopy(this.buffer, 0, newBuffer, used, this.putIndex);
                this.putIndex += used;
            } else {
                this.putIndex = 0;
            }
            this.takeIndex = 0;
            this.buffer = newBuffer;
        }
    }

    private static class BoundedBufferLock {
        private BoundedBufferLock() {
        }
    }

    private static class GetQueueLock {
        private GetQueueLock() {
        }
    }

    private static class PutQueueLock {
        private PutQueueLock() {
        }
    }

    private static class AtomicInteger {
        private int val_;

        public AtomicInteger(int v) {
            this.val_ = v;
        }

        final synchronized int get() {
            return this.val_;
        }

        final synchronized int getAndIncrement() {
            return this.val_++;
        }

        final synchronized int getAndDecrement() {
            return this.val_--;
        }
    }
}

