/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.uow;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ActivitySession.ActivitySessionAlreadyActiveException;
import com.ibm.websphere.ActivitySession.TransactionPendingException;
import com.ibm.websphere.csi.GlobalTranConfigData;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.websphere.csi.ResRefList;
import com.ibm.ws.ActivitySession.ActivitySession;
import com.ibm.ws.ActivitySession.ActivitySessionManager;
import com.ibm.ws.ActivitySession.ActivitySessionManagerFactory;
import com.ibm.ws.ActivitySession.ActivitySessionService;
import com.ibm.ws.ActivitySession.UserActivitySessionFactory;
import com.ibm.ws.LocalTransaction.LocalTranCoordImpl;
import com.ibm.ws.LocalTransaction.LocalTranCurrentSet;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UtxFactory;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityToken;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.naming.java.javaNameSpace;
import com.ibm.ws.runtime.component.EnvironmentType;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.tx.jta.TransactionImpl;
import com.ibm.ws.uow.ComponentContextSynchronizationWrapper;
import com.ibm.ws.uow.SynchronizationRegistryUOWScope;
import com.ibm.ws.uow.SystemException;
import com.ibm.ws.uow.UOWCallbackManager;
import com.ibm.ws.uow.UOWExtTokenImpl;
import com.ibm.ws.uow.UOWManager;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.ws.uow.UOWScopeCallbackManager;
import com.ibm.ws.uow.UOWToken;
import com.ibm.ws.uow.UOWTokenImpl;
import com.ibm.wsspi.uow.UOWAction;
import com.ibm.wsspi.uow.UOWActionException;
import com.ibm.wsspi.uow.UOWException;
import javax.naming.Context;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public class UOWManagerImpl
implements UOWManager,
UOWScopeCallback {
    private static final TraceComponent tc = Tr.register(UOWManagerImpl.class, "Transaction", null);
    private static ActivitySessionManager _activitySessionManager;
    private UOWScopeCallbackManager _callbackManager;
    private UOWCallbackManager _runUnderUOWCallbackManager;

    public UOWToken suspend() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        ActivitySession activitySession = null;
        Transaction transaction = null;
        LocalTransactionCoordinator localTranCoord = null;
        if (ActivitySessionService.isStarted() && EnvironmentType.getEnvironmentType() == 0) {
            try {
                activitySession = UOWManagerImpl.getActivitySessionManager().suspend();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.suspend", "87", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught suspending ActivitySession", e);
                }
                SystemException se = new SystemException(e);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspend", se);
                }
                throw se;
            }
        }
        if (activitySession == null) {
            try {
                transaction = TransactionManagerFactory.getTransactionManager().suspend();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.suspend", "109", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught suspending transaction", e);
                }
                SystemException se = new SystemException(e);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspend", se);
                }
                throw se;
            }
        }
        if (transaction == null && EnvironmentType.getEnvironmentType() == 0) {
            localTranCoord = TransactionManagerFactory.getLocalTransactionCurrent().suspend();
        }
        UOWTokenImpl uowToken = null;
        if (activitySession != null || transaction != null || localTranCoord != null) {
            uowToken = new UOWTokenImpl(activitySession, transaction, localTranCoord);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", uowToken);
        }
        return uowToken;
    }

    public UOWToken suspendAll() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendAll");
        }
        ActivityToken activityToken = null;
        UOWToken uowToken = this.suspend();
        try {
            activityToken = ActivityService.suspendAll();
        }
        catch (Exception e) {
            block8: {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.suspendAll", "127", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught suspending Activities", e);
                }
                try {
                    this.resume(uowToken);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.uow.UOWManagerImpl.suspendAll", "134", this);
                    if (!tc.isEventEnabled()) break block8;
                    Tr.event(tc, "Exception caught resuming tx context", t);
                }
            }
            SystemException se = new SystemException(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAll", se);
            }
            throw se;
        }
        uowToken = new UOWExtTokenImpl(uowToken, activityToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendAll", uowToken);
        }
        return uowToken;
    }

    public void resume(UOWToken uowToken) throws IllegalThreadStateException, IllegalArgumentException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", new Object[]{uowToken});
        }
        if (uowToken != null && uowToken instanceof UOWTokenImpl) {
            LocalTransactionCoordinator localTranCoord;
            Transaction transaction;
            ActivitySession activitySession;
            UOWTokenImpl uowTokenImpl = (UOWTokenImpl)uowToken;
            if (ActivitySessionService.isStarted() && (activitySession = uowTokenImpl.getActivitySession()) != null) {
                try {
                    UOWManagerImpl.getActivitySessionManager().resume(activitySession);
                }
                catch (TransactionPendingException tpe) {
                    FFDCFilter.processException((Throwable)tpe, "com.ibm.ws.uow.UOWManagerImpl.resume", "158", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "TransactionPendingException caught resuming ActivitySession", (Object)tpe);
                    }
                    IllegalThreadStateException itse = new IllegalThreadStateException();
                    itse.initCause(tpe);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", itse);
                    }
                    throw itse;
                }
                catch (ActivitySessionAlreadyActiveException asaae) {
                    FFDCFilter.processException((Throwable)asaae, "com.ibm.ws.uow.UOWManagerImpl.resume", "169", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "ActivitySessionAlreadyActiveException caught resuming ActivitySession", (Object)asaae);
                    }
                    IllegalThreadStateException itse = new IllegalThreadStateException();
                    itse.initCause(asaae);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", itse);
                    }
                    throw itse;
                }
                catch (InvalidActivityException iae) {
                    FFDCFilter.processException((Throwable)iae, "com.ibm.ws.uow.UOWManagerImpl.resume", "180", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "InvalidActivityException caught resuming ActivitySession", iae);
                    }
                    IllegalArgumentException iae2 = new IllegalArgumentException();
                    iae2.initCause(iae);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", iae2);
                    }
                    throw iae2;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.resume", "191", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught resuming ActivitySession", e);
                    }
                    SystemException se = new SystemException(e);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", se);
                    }
                    throw se;
                }
            }
            if ((transaction = uowTokenImpl.getTransaction()) != null) {
                try {
                    TransactionManagerFactory.getTransactionManager().resume(transaction);
                }
                catch (InvalidTransactionException ite) {
                    FFDCFilter.processException((Throwable)ite, "com.ibm.ws.uow.UOWManagerImpl.resume", "212", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "InvalidTransactionException caught resuming transaction", ite);
                    }
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(ite);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", ite);
                    }
                    throw iae;
                }
                catch (IllegalStateException ise) {
                    FFDCFilter.processException((Throwable)ise, "com.ibm.ws.uow.UOWManagerImpl.resume", "223", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "IllegalStateException caught resuming transaction", ise);
                    }
                    IllegalThreadStateException itse = new IllegalThreadStateException();
                    itse.initCause(itse);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", itse);
                    }
                    throw itse;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.resume", "234", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught resuming transaction", e);
                    }
                    SystemException se = new SystemException(e);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", se);
                    }
                    throw se;
                }
            }
            if ((localTranCoord = uowTokenImpl.getLocalTransactionCoordinator()) != null) {
                try {
                    TransactionManagerFactory.getLocalTransactionCurrent().resume(localTranCoord);
                }
                catch (IllegalStateException ise) {
                    ActivitySession activitySession2;
                    FFDCFilter.processException((Throwable)ise, "com.ibm.ws.uow.UOWManagerImpl.resume", "254", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "IllegalStateException caught resuming LTC", ise);
                    }
                    if ((activitySession2 = uowTokenImpl.getActivitySession()) != null) {
                        try {
                            UOWManagerImpl.getActivitySessionManager().suspend();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.resume", "274", this);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Exception caught suspending ActivitySession following LTC resume failure", e);
                            }
                            SystemException se = new SystemException(e);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "resume", se);
                            }
                            throw se;
                        }
                    }
                    IllegalThreadStateException itse = new IllegalThreadStateException();
                    itse.initCause(ise);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", itse);
                    }
                    throw itse;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public void resumeAll(UOWToken uowToken) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeAll", new Object[]{uowToken});
        }
        if (uowToken instanceof UOWExtTokenImpl) {
            UOWExtTokenImpl uowTokenImpl = (UOWExtTokenImpl)uowToken;
            ActivityToken activityToken = uowTokenImpl.getActivityToken();
            try {
                ActivityService.resumeAll(activityToken);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.uow.UOWManagerImpl.resumeAll", "151", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught resuming Activities", ex);
                }
                SystemException se = new SystemException(ex);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeAll", se);
                }
                throw se;
            }
            try {
                this.resume(uowTokenImpl.getUOWToken());
            }
            catch (Exception ex) {
                block15: {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.uow.UOWManagerImpl.resumeAll", "159", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught resuming transactions/activitysessions", ex);
                    }
                    try {
                        ActivityService.suspendAll();
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, "com.ibm.ws.uow.UOWManagerImpl.resumeAll", "166", this);
                        if (!tc.isEventEnabled()) break block15;
                        Tr.event(tc, "Exception caught suspending activities", t);
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeAll", ex);
                }
                throw ex;
            }
        }
        if (uowToken != null) {
            IllegalArgumentException ex = new IllegalArgumentException("Incompatible UOWToken passed to UOWManagerImpl.resumeAll");
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.uow.UOWManagerImpl.resumeAll", "178", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeAll", ex);
            }
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeAll");
        }
    }

    public synchronized void registerCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCallback", new Object[]{callback, this});
        }
        if (this._callbackManager == null) {
            this._callbackManager = new UOWScopeCallbackManager();
            ActivitySessionService.registerCallback((UOWScopeCallback)this);
            TransactionManagerFactory.getTransactionManager().registerCallback(this);
            if (EnvironmentType.getEnvironmentType() == 0) {
                TransactionManagerFactory.getLocalTransactionCurrent().registerCallback(this);
            }
        }
        this._callbackManager.addCallback(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCallback");
        }
    }

    public synchronized void registerRunUnderUOWCallback(UOWCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerRunUnderUOWCallback", new Object[]{callback, this});
        }
        if (this._runUnderUOWCallbackManager == null) {
            this._runUnderUOWCallbackManager = new UOWCallbackManager();
        }
        this._runUnderUOWCallbackManager.addCallback(callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerRunUnderUOWCallback");
        }
    }

    public UOWScope getUOWScope() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWScope", this);
        }
        Object uowScope = null;
        LocalTranCoordImpl localTranCoord = (LocalTranCoordImpl)TransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord();
        if (localTranCoord != null) {
            uowScope = localTranCoord.isASScoped() && localTranCoord.isContainerResolved() ? (UOWScope)localTranCoord.getActivitySession() : localTranCoord;
        }
        if (uowScope == null) {
            try {
                uowScope = (UOWScope)((Object)TransactionManagerFactory.getTransactionManager().getTransaction());
            }
            catch (javax.transaction.SystemException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.uow.UOWManagerImpl.getUOWScope", "364", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught checking for transaction", se);
                }
                SystemException systemException = new SystemException(se);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUOWScope", systemException);
                }
                throw systemException;
            }
            if (uowScope == null && ActivitySessionService.isStarted()) {
                try {
                    uowScope = (UOWScope)UOWManagerImpl.getActivitySessionManager().getActivitySession();
                }
                catch (com.ibm.websphere.ActivitySession.SystemException se) {
                    FFDCFilter.processException((Throwable)se, "com.ibm.ws.uow.UOWManagerImpl.getUOWScope", "381", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SystemException caught getting current ActivitySession", (Object)se);
                    }
                    SystemException systemException = new SystemException(se);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getUOWScope", systemException);
                    }
                    throw systemException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWScope", uowScope);
        }
        return uowScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnderUOW(int uowType, boolean join, UOWAction uowAction) throws UOWActionException, UOWException {
        UOWScope initialUOWScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "runUnderUOW", new Object[]{new Integer(uowType), join, uowAction});
        }
        try {
            initialUOWScope = this.getUOWScope();
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.runUnderUOW", "96", this);
            UOWException uowe = new UOWException(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runUnderUOW", e);
            }
            throw uowe;
        }
        UOWToken uowt = null;
        if (!(initialUOWScope == null || join && uowType != 0 && uowType == this.getUOWType())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Need to suspend current UOW");
            }
            try {
                uowt = this.suspend();
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderUOW", "81", this);
                UOWException uowe = new UOWException(t);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "runUnderUOW", uowe);
                }
                throw uowe;
            }
        }
        Throwable toThrow = null;
        try {
            try {
                toThrow = this.getUOWScope() == null ? this.runUnderNewUOW(uowType, uowAction) : this.runUnderCurrentUOW(uowAction);
            }
            catch (SystemException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.PreviewUOWManagerImpl.run", "138", this);
                toThrow = new UOWException(e);
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            block25: {
                Object var9_13 = null;
                try {
                    this.resume(uowt);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderUOW", "107", this);
                    if (toThrow != null) break block25;
                    toThrow = new UOWException(t);
                }
            }
            throw throwable;
        }
        try {
            this.resume(uowt);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderUOW", "107", this);
            if (toThrow == null) {
                toThrow = new UOWException(t);
            }
        }
        if (toThrow instanceof UOWException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runUnderUOW", toThrow);
            }
            throw (UOWException)toThrow;
        }
        if (toThrow instanceof UOWActionException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runUnderUOW", toThrow);
            }
            throw (UOWActionException)toThrow;
        }
        if (toThrow instanceof RuntimeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "runUnderUOW");
            }
            throw (RuntimeException)toThrow;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "runUnderUOW");
        }
    }

    public int getUOWTimeout() throws IllegalStateException {
        int timeout;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWTimeout", this);
        }
        int uowType = this.getUOWType();
        switch (uowType) {
            case 1: {
                try {
                    timeout = ((TransactionImpl)this.getUOWScope()).getTimeout();
                    break;
                }
                catch (SystemException e) {
                    IllegalStateException ise = new IllegalStateException(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getUOWTimeout", ise);
                    }
                    throw ise;
                }
            }
            case 2: {
                try {
                    timeout = ((ActivitySession)this.getUOWScope()).getTimeout();
                    break;
                }
                catch (Exception e) {
                    IllegalStateException ise = new IllegalStateException(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getUOWTimeout", ise);
                    }
                    throw ise;
                }
            }
            default: {
                IllegalStateException ise = new IllegalStateException("Invalid UOW type: " + uowType);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUOWTimeout", ise);
                }
                throw ise;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWTimeout", new Integer(timeout));
        }
        return timeout;
    }

    public void setUOWTimeout(int uowType, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setUOWTimeout", new Object[]{uowType, timeout});
        }
        switch (uowType) {
            case 1: {
                try {
                    TransactionManagerFactory.getTransactionManager().setTransactionTimeout(timeout);
                    break;
                }
                catch (Exception e) {
                    IllegalArgumentException iae = new IllegalArgumentException(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "setUOWTimeout", iae);
                    }
                    throw iae;
                }
            }
            case 2: {
                try {
                    UOWManagerImpl.getActivitySessionManager().setSessionTimeout(timeout);
                    break;
                }
                catch (Exception e) {
                    IllegalArgumentException iae = new IllegalArgumentException(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "setUOWTimeout", iae);
                    }
                    throw iae;
                }
            }
            default: {
                IllegalArgumentException iae = new IllegalArgumentException("Invalid UOW type: " + uowType);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "setUOWTimeout", iae);
                }
                throw iae;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setUOWTimeout");
        }
    }

    public long getLocalUOWId() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalUOWId", this);
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            throw new IllegalStateException();
        }
        long localId = uowScope.getLocalId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalUOWId", new Long(localId));
        }
        return localId;
    }

    public Object getResource(Object key) throws NullPointerException {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{key, this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResource", "IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResource", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
        Object resource = uowScope.getResource(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    public boolean getRollbackOnly() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRollbackOnly", this);
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRollbackOnly", "IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRollbackOnly", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
        boolean rollbackOnly = uowScope.getRollbackOnly();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRollbackOnly", rollbackOnly);
        }
        return rollbackOnly;
    }

    public int getUOWStatus() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWStatus", this);
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getUOWStatus", "IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        int uowStatus = uowScope == null ? 5 : uowScope.getUOWStatus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWStatus", this.getUOWStatusAsString(uowStatus));
        }
        return uowStatus;
    }

    public int getUOWType() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWType", this);
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getUOWType", "IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getUOWType", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
        int uowType = uowScope.getUOWType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWType", new Integer(uowType));
        }
        return uowType;
    }

    public void putResource(Object key, Object value) {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putResource", new Object[]{key, value, this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "putResource", "IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "putResource", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
        uowScope.putResource(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "putResource");
        }
    }

    public void registerInterposedSynchronization(Synchronization sync2) {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerInterposedSynchronization", new Object[]{sync2, this});
        }
        if (sync2 == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerInterposedSynchronization", "NullPointerException");
            }
            throw new NullPointerException();
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerInterposedSynchronization", "IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerInterposedSynchronization", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
        ComponentContextSynchronizationWrapper wrappedSync = new ComponentContextSynchronizationWrapper(sync2);
        uowScope.registerInterposedSynchronization(wrappedSync);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerInterposedSynchronization");
        }
    }

    public void setRollbackOnly() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly", this);
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setRollbackOnly", "IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setRollbackOnly", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
        if (uowScope instanceof LocalTranCoordImpl) {
            ((LocalTranCoordImpl)uowScope).setRollbackOnlyFromApplicationCode();
        } else {
            uowScope.setRollbackOnly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnly");
        }
    }

    public void contextChange(int changeType, UOWScope uowScope) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contextChange", new Object[]{new Integer(changeType), uowScope, this});
        }
        if (changeType == 1) {
            this._callbackManager.notifyCallbacks(changeType, uowScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contextChange");
        }
    }

    private static ActivitySessionManager getActivitySessionManager() throws com.ibm.websphere.ActivitySession.SystemException {
        if (_activitySessionManager == null) {
            try {
                _activitySessionManager = ActivitySessionManagerFactory.getActivitySessionManager();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ActivitySessionManager reference initialized", _activitySessionManager);
                }
            }
            catch (com.ibm.websphere.ActivitySession.SystemException se) {
                FFDCFilter.processException(se, "com.ibm.ws.uow.UOWManagerImpl.getActivitySessionManager", "333");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught getting ActivitySessionManager", (Object)se);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getActivitySessionManager", (Object)se);
                }
                throw se;
            }
        }
        return _activitySessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Throwable runUnderNewUOW(int uowType, UOWAction uowAction) {
        Exception toThrow;
        block16: {
            UOWScope uowScope;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "runUnderNewUOW", new Object[]{new Integer(uowType), uowAction, this});
            }
            toThrow = null;
            try {
                uowScope = this.uowBegin(uowType);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.uow.UOWManagerImpl.runUnderNewUOW", "922", this);
                if (!tc.isEntryEnabled()) return new UOWException(t);
                Tr.exit(tc, "runUnderNewUOW", t);
                return new UOWException(t);
            }
            try {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Running UOWAction");
                    }
                    uowAction.run();
                }
                catch (RuntimeException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.runUnderNewUOW", "934", this);
                    this.setRollbackOnly();
                    toThrow = e;
                    Object var7_10 = null;
                    try {
                        this.uowEnd(uowScope, uowType);
                    }
                    catch (Throwable t2) {
                        FFDCFilter.processException(t2, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", "175", this);
                        UOWException uowe = new UOWException(t2);
                        if (!tc.isEntryEnabled()) return uowe;
                        Tr.exit(tc, "runUnderNewUOW", uowe);
                        return uowe;
                    }
                }
                catch (Exception e) {
                    toThrow = new UOWActionException(e);
                    Object var7_11 = null;
                    try {}
                    catch (Throwable t2) {
                        FFDCFilter.processException(t2, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", "175", this);
                        UOWException uowe = new UOWException(t2);
                        if (!tc.isEntryEnabled()) return uowe;
                        Tr.exit(tc, "runUnderNewUOW", uowe);
                        return uowe;
                    }
                    this.uowEnd(uowScope, uowType);
                    break block16;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.uow.UOWManagerImpl.runUnderNewUOW", "944", this);
                    this.setRollbackOnly();
                    toThrow = new UOWException(t);
                    Object var7_12 = null;
                    try {}
                    catch (Throwable t2) {
                        FFDCFilter.processException(t2, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", "175", this);
                        UOWException uowe = new UOWException(t2);
                        if (!tc.isEntryEnabled()) return uowe;
                        Tr.exit(tc, "runUnderNewUOW", uowe);
                        return uowe;
                    }
                    this.uowEnd(uowScope, uowType);
                    break block16;
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                try {}
                catch (Throwable t2) {
                    FFDCFilter.processException(t2, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", "175", this);
                    UOWException uowe = new UOWException(t2);
                    if (!tc.isEntryEnabled()) return uowe;
                    Tr.exit(tc, "runUnderNewUOW", uowe);
                    return uowe;
                }
                this.uowEnd(uowScope, uowType);
                throw throwable;
            }
            try {}
            catch (Throwable t2) {
                FFDCFilter.processException(t2, "com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", "175", this);
                UOWException uowe = new UOWException(t2);
                if (!tc.isEntryEnabled()) return uowe;
                Tr.exit(tc, "runUnderNewUOW", uowe);
                return uowe;
            }
            this.uowEnd(uowScope, uowType);
        }
        if (!tc.isEntryEnabled()) return toThrow;
        Tr.exit(tc, "runUnderNewUOW", toThrow);
        return toThrow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uowEnd(UOWScope uowScope, int uowType) throws Exception {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "uowEnd", new Object[]{uowScope, new Integer(uowType), this});
            }
            UOWCoordinator uow = TransactionManagerFactory.getUOWCurrent().getUOWCoord();
            try {
                if (this.getRollbackOnly()) {
                    boolean timedOut = false;
                    if (uowType == 1) {
                        timedOut = ((TransactionImpl)uowScope).isTimedOut();
                    }
                    this.uowRollback(uowType);
                    if (timedOut) {
                        RollbackException rbe = new RollbackException("Global transaction timed out after " + ((TransactionImpl)uowScope).getTimeout() + " seconds");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "uowEnd", rbe);
                        }
                        throw rbe;
                    }
                } else {
                    this.uowCommit(uowType);
                }
                Object var7_6 = null;
                if (this._runUnderUOWCallbackManager != null) {
                    this._runUnderUOWCallbackManager.notifyCallbacks(3, uow);
                }
                if (uowType != 2) break block12;
                ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this._runUnderUOWCallbackManager != null) {
                    this._runUnderUOWCallbackManager.notifyCallbacks(3, uow);
                }
                if (uowType == 2) {
                    ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
                }
                throw throwable;
            }
            {
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "uowEnd");
        }
    }

    private void uowCommit(int uowType) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "uowCommit", uowType);
        }
        switch (uowType) {
            case 1: {
                TransactionManagerFactory.getTransactionManager().commit();
                break;
            }
            case 0: {
                LocalTranCurrentSet.instance().end(0);
                break;
            }
            case 2: {
                UserActivitySessionFactory.createUserActivitySession().endSession(0);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uowCommit");
        }
    }

    private void uowRollback(int uowType) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "uowRollback", uowType);
        }
        switch (uowType) {
            case 1: {
                TransactionManagerFactory.getTransactionManager().rollback();
                break;
            }
            case 0: {
                LocalTranCurrentSet.instance().end(1);
                break;
            }
            case 2: {
                UserActivitySessionFactory.createUserActivitySession().endSession(1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uowRollback");
        }
    }

    private UOWScope uowBegin(int uowType) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "uowBegin", uowType);
        }
        switch (uowType) {
            case 1: {
                UtxFactory.createUserTransaction().begin();
                break;
            }
            case 0: {
                LocalTranCurrentSet.instance().begin(false, false, false);
                break;
            }
            case 2: {
                ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(new RunUnderUOWComponentMetaData());
                UserActivitySessionFactory.createUserActivitySession().beginSession();
            }
        }
        UOWScope uows = this.getUOWScope();
        if (this._runUnderUOWCallbackManager != null) {
            this._runUnderUOWCallbackManager.notifyCallbacks(1, TransactionManagerFactory.getUOWCurrent().getUOWCoord());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "uowBegin", uows);
        }
        return uows;
    }

    private Throwable runUnderCurrentUOW(UOWAction uowAction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "runUnderCurrentUOW", new Object[]{uowAction, this});
        }
        Exception toThrow = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Running UOWAction");
            }
            uowAction.run();
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.uow.UOWManagerImpl.runUnderCurrentUOW", "1130", this);
            this.setRollbackOnly();
            toThrow = e;
        }
        catch (Exception e) {
            toThrow = new UOWActionException(e);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.uow.UOWManagerImpl.runUnderCurrentUOW", "1140", this);
            this.setRollbackOnly();
            toThrow = new UOWException(t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "runUnderCurrentUOW", toThrow);
        }
        return toThrow;
    }

    private String getUOWStatusAsString(int status) {
        String uowStatus;
        switch (status) {
            case 0: {
                uowStatus = "active";
                break;
            }
            case 5: {
                uowStatus = "none";
                break;
            }
            case 3: {
                uowStatus = "committed";
                break;
            }
            case 1: {
                uowStatus = "rollback only";
                break;
            }
            case 4: {
                uowStatus = "rolled back";
                break;
            }
            default: {
                uowStatus = "undefined";
            }
        }
        return uowStatus;
    }

    public String getUOWName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWName", this);
        }
        String uowName = null;
        try {
            SynchronizationRegistryUOWScope uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
            uowName = uowScope.getUOWName();
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.uow.UOWManagerImpl.getUOWName", "1311", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWName", uowName);
        }
        return uowName;
    }

    private class RunUnderUOWComponentMetaData
    implements ContainerComponentMetaData {
        private final LocalTranConfigData _localTranConfigData = new RunUnderUOWLocalTranConfigDataImpl();
        private final ContainerComponentMetaData _containerComponentMetaData = (ContainerComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();

        private RunUnderUOWComponentMetaData() {
        }

        public GlobalTranConfigData getGlobalTranConfigData() {
            return this._containerComponentMetaData.getGlobalTranConfigData();
        }

        public javaNameSpace getJavaNameSpace() {
            return this._containerComponentMetaData.getJavaNameSpace();
        }

        public Context getJavaNameSpaceContext() {
            return this._containerComponentMetaData.getJavaNameSpaceContext();
        }

        public LocalTranConfigData getLocalTran() {
            return this._containerComponentMetaData.getLocalTran();
        }

        public LocalTranConfigData getLocalTranConfigData() {
            return this._localTranConfigData;
        }

        public ResRefList getResourceRefList() {
            return this._containerComponentMetaData.getResourceRefList();
        }

        public J2EEName getJ2EEName() {
            return this._containerComponentMetaData.getJ2EEName();
        }

        public ModuleMetaData getModuleMetaData() {
            return this._containerComponentMetaData.getModuleMetaData();
        }

        public Object getMetaData(MetaDataSlot slot) {
            return this._containerComponentMetaData.getMetaData(slot);
        }

        public String getName() {
            return this._containerComponentMetaData.getName();
        }

        public void release() {
            this._containerComponentMetaData.release();
        }

        public void setMetaData(MetaDataSlot slot, Object metadata2) {
            this._containerComponentMetaData.setMetaData(slot, metadata2);
        }

        public class RunUnderUOWLocalTranConfigDataImpl
        implements LocalTranConfigData {
            public int getValueBoundary() {
                return 1;
            }

            public int getValueResolver() {
                return 1;
            }

            public int getValueUnresolvedAction() {
                return 0;
            }

            public boolean isShareable() {
                return false;
            }
        }
    }
}

