/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.wsspi.profile.WSProfile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class RetrieveSigners {
    private static final String DEFAULT_TRACE_FILE = "retrieveSigners.log";
    private static final String DEFAULT_CONNECTOR_TYPE_PROP = "com.ibm.ws.scripting.connectionType";
    private static final String DEFAULT_SCRIPTING_PORT_PROP = "com.ibm.ws.scripting.port";
    private static final String DEFAULT_SCRIPTING_HOST_PROP = "com.ibm.ws.scripting.host";
    private static final String[] ARG_LIST = new String[]{"-profileName", "-help", "-replacelog", "-logfile", "-quiet", "-trace", "-password", "-user", "-username", "-conntype", "-port", "-host", "-localAlias", "-remoteAlias", "-upload", "-listLocalKeyStoreNames", "-listRemoteKeyStoreNames", "-autoAcceptBootstrapSigner", "-uploadSigners"};
    private static final String DEFAULT_APPCLIENT_CONNECTOR_TYPE_PROP = "SOAP";
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    boolean trace = false;
    boolean replacelog = false;
    boolean quiet = false;
    boolean help = false;
    boolean upload = false;
    String remoteKeyStoreName = null;
    String remoteAlias = null;
    String localAlias = null;
    String localKeyStoreName = null;
    boolean listRemoteKeyStoreNames = false;
    boolean listLocalKeyStoreNames = false;
    Properties props = new Properties();
    String logfile = null;
    boolean isDoubleByteSystem = false;
    String profileName = null;
    String userRoot = null;
    private static final TraceComponent tc = Tr.register(RetrieveSigners.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public static int mainForInProcess(String[] args) {
        return new RetrieveSigners().retrieveSigners(args);
    }

    public static void main(String[] args) {
        System.exit(new RetrieveSigners().retrieveSigners(args));
    }

    private int retrieveSigners(String[] args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSigners");
        }
        AdminClient adminClient = null;
        ObjectName sslAdmin = null;
        try {
            adminClient = this.createAdminClient(args);
            if (this.upload) {
                return this.uploadSigners(adminClient);
            }
            if (adminClient != null) {
                String processName = this.getProcessName(adminClient);
                ObjectName queryString = new ObjectName("WebSphere:type=SSLAdmin,process=" + processName + ",*");
                Set s = adminClient.queryNames(queryString, null);
                if (s.isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "retrieveSigners (can't get SSLAdmin)");
                    }
                    return 1;
                }
                sslAdmin = (ObjectName)s.iterator().next();
                HashMap map = null;
                if (this.listRemoteKeyStoreNames || this.listLocalKeyStoreNames) {
                    String[] keyStoreAliases;
                    int i;
                    StringBuffer sb;
                    if (this.listRemoteKeyStoreNames) {
                        map = (HashMap)adminClient.invoke(sslAdmin, "retrieveSigners", new Object[]{null, null}, new String[]{"java.lang.String", "java.lang.String"});
                        String[] remoteAliases = (String[])map.get("remoteAliases");
                        sb = new StringBuffer();
                        if (remoteAliases != null) {
                            for (i = 0; i < remoteAliases.length; ++i) {
                                sb.append(remoteAliases[i]);
                                if (i >= remoteAliases.length - 1) continue;
                                sb.append(", ");
                            }
                        }
                        this.issueMessage("ssl.signer.remote.truststore.list.CWPKI0306I", new Object[]{sb.toString()}, "The following remote keystores exist on the specified server: " + sb.toString());
                    }
                    if (this.listLocalKeyStoreNames && (keyStoreAliases = KeyStoreManager.getInstance().getKeyStoreAliases()) != null) {
                        sb = new StringBuffer();
                        for (i = 0; i < keyStoreAliases.length; ++i) {
                            sb.append(keyStoreAliases[i]);
                            sb.append(", ");
                        }
                        String localAliases = sb.toString();
                        if (localAliases.endsWith(", ")) {
                            localAliases = localAliases.substring(0, localAliases.length() - 2);
                        }
                        this.issueMessage("ssl.signer.local.truststore.list.CWPKI0307I", new Object[]{localAliases}, "The following local keystores exist on the client: " + localAliases);
                    }
                    return 0;
                }
                map = (HashMap)adminClient.invoke(sslAdmin, "retrieveSigners", new Object[]{this.remoteKeyStoreName, this.remoteAlias}, new String[]{"java.lang.String", "java.lang.String"});
                if (map != null) {
                    WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(this.localKeyStoreName);
                    if (wsks != null) {
                        boolean ksmodified = false;
                        String localFile = wsks.getProperty("com.ibm.ssl.keyStore");
                        KeyStore ks = wsks.getKeyStore(false, false);
                        if (ks != null) {
                            for (String alias : map.keySet()) {
                                Certificate signer = (Certificate)map.get(alias);
                                if (signer == null) continue;
                                boolean exists = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)signer, ks);
                                if (!exists && !ks.containsAlias(alias)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding alias \"" + alias + "\" to keystore \"" + localFile + "\".");
                                    }
                                    ks.setCertificateEntry(alias, signer);
                                    String digest = KeyStoreManager.getInstance().generateDigest("SHA", (X509Certificate)signer);
                                    this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{alias, this.localKeyStoreName, digest}, "CWPKI0308I: Adding signer alias \"" + alias + "\" to local keystore \"" + this.localKeyStoreName + "\" with the following SHA digest: " + digest);
                                    ksmodified = true;
                                    continue;
                                }
                                if (exists) continue;
                                int num = 1;
                                String newAlias = null;
                                while (ks.containsAlias(newAlias = alias + "_" + num++)) {
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding alias \"" + newAlias + "\" to keystore \"" + localFile + "\".");
                                }
                                if (ks.containsAlias(newAlias)) continue;
                                ks.setCertificateEntry(newAlias, signer);
                                String digest = KeyStoreManager.getInstance().generateDigest("SHA", (X509Certificate)signer);
                                this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{newAlias, this.localKeyStoreName, digest}, "CWPKI0308I: Adding signer alias \"" + newAlias + "\" to local keystore \"" + this.localKeyStoreName + "\" with the following SHA digest: " + digest);
                                ksmodified = true;
                            }
                            if (ksmodified) {
                                wsks.store();
                            } else {
                                this.issueMessage("ssl.signer.no.signers.added.CWPKI0309I", "CWPKI0309I: All signers from remote keystore already exist in local keystore.");
                            }
                        }
                    } else {
                        this.issueMessage("ssl.signer.local.truststore.not.found.CWPKI0310E", new Object[]{this.localKeyStoreName}, "CWPKI0310E: The <localKeyStoreName> specified as \"" + this.localKeyStoreName + "\" was not found on the client.");
                    }
                    return 0;
                }
            }
            return 0;
        }
        catch (MalformedObjectNameException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "280", this);
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{e.getMessage()}, "CWPKI0314E: The following error is returned from an exception: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "286", this);
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{e.getMessage()}, "CWPKI0314E: The following error is returned from an exception: " + e.getMessage());
        }
        catch (MBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "287", this);
            String cause = e.getCause().toString();
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{e.getMessage() + "\n" + cause.substring(cause.indexOf("CWP"))}, "CWPKI0314E: The following error is returned from an exception: " + e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "292", this);
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{e.getMessage()}, "CWPKI0314E: The following error is returned from an exception: " + e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSigners");
        }
        return 3;
    }

    private int uploadSigners(AdminClient adminClient) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uploadSigners");
        }
        ObjectName sslAdmin = null;
        try {
            if (adminClient != null) {
                KeyStore ks;
                String processName = this.getProcessName(adminClient);
                ObjectName queryString = new ObjectName("WebSphere:type=SSLAdmin,process=" + processName + ",*");
                Set s = adminClient.queryNames(queryString, null);
                if (s.isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "uploadSigners (can't get SSLAdmin)");
                    }
                    return 1;
                }
                sslAdmin = (ObjectName)s.iterator().next();
                WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(this.localKeyStoreName);
                if (wsks != null && (ks = wsks.getKeyStore(false, false)) != null) {
                    Enumeration<String> aliases = ks.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        Certificate signer = ks.getCertificate(alias);
                        if (signer == null) continue;
                        Object[] parms = new Object[]{alias, signer};
                        adminClient.invoke(sslAdmin, "invokeRemoteKeyStoreCommand", new Object[]{this.remoteKeyStoreName, "setCertificateEntry", parms}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "uploadSigners (success)");
                    }
                    return 0;
                }
            }
        }
        catch (MalformedObjectNameException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "372", this);
        }
        catch (InstanceNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "377", this);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "382", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uploadSigners");
        }
        return 3;
    }

    private AdminClient createAdminClient(String[] args) throws Exception {
        boolean traceOK;
        List<String> totalArgList = Arrays.asList(ARG_LIST);
        ArrayList<String> argList = new ArrayList<String>();
        boolean invalid_option = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null && (!args[i].startsWith("-") || totalArgList.contains(args[i]) && (i + 1 == args.length || i + 1 < args.length && args[i + 1] != null))) {
                argList.add(args[i]);
                continue;
            }
            if (args[i] == null || totalArgList.contains(args[i])) continue;
            invalid_option = true;
            this.issueMessage("ssl.signer.invalid.option.CWPKI0313W", new Object[]{args[i]}, "CWPKI0313W: The following option is not valid: " + args[i]);
        }
        if (invalid_option) {
            this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName>] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
        }
        if (argList != null) {
            int index = 0;
            index = argList.indexOf("-profileName");
            if (index != -1) {
                this.profileName = (String)argList.get(index + 1);
                this.userRoot = this.getConfigRootForProfileName(this.profileName);
                if (this.userRoot == null) {
                    this.userRoot = System.getProperty("user.install.root");
                }
            } else {
                this.userRoot = System.getProperty("user.install.root");
            }
            if ((index = argList.indexOf("-autoAcceptBootstrapSigner")) != -1) {
                ThreadManager.getInstance().setAutoAcceptBootstrapSigner(true);
            }
            if ((index = argList.indexOf("-listRemoteKeyStoreNames")) != -1) {
                this.listRemoteKeyStoreNames = true;
            }
            if ((index = argList.indexOf("-listLocalKeyStoreNames")) != -1) {
                this.listLocalKeyStoreNames = true;
            }
            if ((index = argList.indexOf("-uploadSigners")) != -1) {
                this.upload = true;
            }
            if ((index = argList.indexOf("-upload")) != -1) {
                this.upload = true;
            }
            if ((index = argList.indexOf("-remoteAlias")) != -1) {
                this.remoteAlias = (String)argList.get(index + 1);
            }
            if ((index = argList.indexOf("-localAlias")) != -1) {
                this.localAlias = (String)argList.get(index + 1);
            }
            String wsadminPath = "file:" + this.userRoot + "/properties/wsadmin.properties";
            Properties defaultAdminProps = null;
            defaultAdminProps = this.loadPropertiesFile(wsadminPath);
            String defaultConnectorType = "";
            String defaultPort = "";
            String defaultHost = "";
            if (defaultAdminProps != null) {
                defaultConnectorType = defaultAdminProps.getProperty(DEFAULT_CONNECTOR_TYPE_PROP);
                defaultPort = defaultAdminProps.getProperty(DEFAULT_SCRIPTING_PORT_PROP);
                defaultHost = defaultAdminProps.getProperty(DEFAULT_SCRIPTING_HOST_PROP);
            }
            if ((index = argList.indexOf("-host")) != -1) {
                this.props.setProperty("host", (String)argList.get(index + 1));
            } else if (defaultHost != null && !defaultHost.equals("")) {
                this.props.setProperty("host", defaultHost);
            }
            index = argList.indexOf("-port");
            if (index != -1) {
                this.props.setProperty("port", (String)argList.get(index + 1));
            } else if (defaultPort != null && !defaultPort.equals("")) {
                this.props.setProperty("port", defaultPort);
            }
            index = argList.indexOf("-conntype");
            if (index != -1) {
                this.props.setProperty("type", (String)argList.get(index + 1));
            } else if (defaultConnectorType != null && !defaultConnectorType.equals("")) {
                this.props.setProperty("type", defaultConnectorType);
            } else {
                this.props.setProperty("type", DEFAULT_APPCLIENT_CONNECTOR_TYPE_PROP);
            }
            index = argList.indexOf("-username");
            if (index != -1) {
                this.props.setProperty("username", (String)argList.get(index + 1));
            }
            if ((index = argList.indexOf("-user")) != -1) {
                this.props.setProperty("username", (String)argList.get(index + 1));
            }
            if ((index = argList.indexOf("-password")) != -1) {
                this.props.setProperty("password", (String)argList.get(index + 1));
            }
            if ((index = argList.indexOf("-trace")) != -1) {
                this.props.setProperty("-trace", "true");
                this.trace = true;
            }
            if ((index = argList.indexOf("-quiet")) != -1) {
                this.props.setProperty("-quiet", "true");
                this.quiet = true;
            }
            if ((index = argList.indexOf("-logfile")) != -1) {
                this.props.setProperty("-logfile", (String)argList.get(index + 1));
                this.logfile = (String)argList.get(index + 1);
            }
            if ((index = argList.indexOf("-replacelog")) != -1) {
                this.props.setProperty("-replacelog", "true");
                this.replacelog = true;
            }
            if ((index = argList.indexOf("-help")) != -1) {
                this.props.setProperty("help", "true");
                this.help = true;
            }
        }
        if (this.help) {
            this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName>] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
            return null;
        }
        if (this.props.getProperty("-trace") != null && (traceOK = this.setTrace())) {
            this.issueMessage("ssl.signer.retrieval.tracemodeon.CWPKI0301I", null, "Trace mode is on.");
        }
        if (args.length >= 2 || this.help || this.listRemoteKeyStoreNames || this.listLocalKeyStoreNames) {
            if (this.help) {
                this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
                return null;
            }
            if (args.length >= 2 && args[0] != null && !args[0].startsWith("-")) {
                this.remoteKeyStoreName = args[0];
                this.localKeyStoreName = args[1];
            } else {
                this.remoteKeyStoreName = "CellDefaultTrustStore";
                this.localKeyStoreName = "ClientDefaultTrustStore";
            }
        } else {
            this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName>] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
            return null;
        }
        return AdminClientFactory.createAdminClient(this.props);
    }

    private String getProcessName(AdminClient client) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessName");
        }
        ObjectName mbean = null;
        String name = null;
        try {
            mbean = client.getServerMBean();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.utils.RetrieveSigners.getProcessName", "607", this);
        }
        if (mbean != null) {
            name = ObjectNameHelper.getProcessName(mbean);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessName -> " + name);
        }
        return name;
    }

    private boolean setTrace() {
        String spec = null;
        if (this.trace) {
            spec = "com.ibm.ws.management.*=all=enabled:com.ibm.websphere.management.*=all=enabled:com.ibm.ws.ssl.*=all=enabled:SSL=all=enabled:com.ibm.ws.security.*=all=enabled:SASRas=all=enabled";
            Tr.info(tc, "ssl.signer.retrieval.tracemodeon.CWPKI0301I");
        } else {
            spec = "";
        }
        if (this.logfile == null) {
            this.logfile = this.getDefaultTraceFile();
        }
        boolean writeToFile = true;
        if (!ManagerAdmin.isLogFileWriteable(this.logfile)) {
            this.issueMessage("ssl.signer.retrieval.logfile.error.CWPKI0302E", new Object[]{new File(this.logfile).getAbsolutePath()}, "Cannot write to the trace logfile at the following location: " + new File(this.logfile).getAbsolutePath());
            writeToFile = false;
        }
        if (writeToFile) {
            this.issueMessage("ssl.signer.retrieval.logfile.location.CWPKI0303I", new Object[]{new File(this.logfile).getAbsolutePath()}, "Trace is being logged to the following location: " + new File(this.logfile).getAbsolutePath());
            ManagerAdmin.configureClientTrace(spec, "named file", this.logfile, this.replacelog, "basic", false);
        }
        return true;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected void issueMessage(String key, Object[] args, String defaultMsg) {
        String msg = TraceNLSHelper.getInstance().getFormattedMessage(key, args, defaultMsg);
        if (!this.quiet) {
            this.printMessage(msg);
        }
    }

    protected void issueMessage(String key, String defaultMsg) {
        String msg = TraceNLSHelper.getInstance().getString(key, defaultMsg);
        if (!this.quiet) {
            this.printMessage(msg);
        }
    }

    protected void printMessage(String msg) {
        int maxLength = 79;
        if (this.isDoubleByteSystem(msg)) {
            maxLength /= 2;
        }
        this.printMessage(msg, maxLength, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String sampleStr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(sampleStr);
            dos.flush();
        }
        catch (IOException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException exc) {}
        }
        byte[] bytes = baos.toByteArray();
        this.isDoubleByteSystem = (double)bytes.length > (double)sampleStr.length() + (double)sampleStr.length() * 0.1;
        return this.isDoubleByteSystem;
    }

    private void printMessage(String msg, int maxLength, boolean indent) {
        int maxLocalLength = maxLength;
        if (indent) {
            System.out.print(INDENT);
            maxLocalLength -= INDENT.length();
        }
        if (msg.length() <= maxLocalLength) {
            System.out.println(msg);
        } else {
            int i = msg.lastIndexOf(32, maxLocalLength);
            if (i == -1 && (i = msg.indexOf(32)) == -1) {
                System.out.println(msg);
                return;
            }
            this.printMessage(msg.substring(0, i), maxLength, false);
            this.printMessage(msg.substring(i + 1), maxLength, true);
        }
    }

    private Properties loadPropertiesFile(final String propertiesURL) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFile", new Object[]{propertiesURL});
        }
        if (propertiesURL == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile (null URL)");
            }
            return null;
        }
        try {
            Properties props = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Properties adminProps = new Properties();
                    InputStream istream = null;
                    try {
                        URL url = new URL(propertiesURL);
                        istream = url.openStream();
                        adminProps.load(istream);
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    finally {
                        if (istream != null) {
                            istream.close();
                        }
                    }
                    return adminProps;
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile", new Object[]{props});
            }
            return props;
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.RetrieveSigners.loadPropertiesFile", "801", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadPropertiesFile exception: ", new Object[]{e.getException()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile (null)");
            }
            return null;
        }
    }

    private String getConfigRootForProfileName(String profileName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRootForProfileName", new Object[]{profileName});
        }
        String profileConfigRoot = null;
        File registryFile = WSProfile.getRegistryFile();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using profile registry: " + registryFile);
        }
        List profiles = WSProfile.listProfileNames((File)registryFile);
        for (String existingProfileName : profiles) {
            if (existingProfileName == null || !existingProfileName.equals(profileName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found profile: " + existingProfileName);
            }
            File profileLoc = WSProfile.getProfileLocation((String)existingProfileName, (File)registryFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   Profile location: " + profileLoc);
            }
            profileConfigRoot = profileLoc.getAbsolutePath();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRootForProfileName", new Object[]{profileConfigRoot});
        }
        return profileConfigRoot;
    }
}

