/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.X509KeyManager;

public class CertMappingKeyManager
implements X509KeyManager,
KeyManagerExtendedInfo {
    private static final TraceComponent tc = Tr.register(CertMappingKeyManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    public static final String PROTOCOL_HTTPS_CERT_MAPPING_FILE = "com.ibm.ssl.cert.mapping.file";
    public static final String PROTOCOL_HTTPS_CERT_DEFAULT_LABEL = "com.ibm.ssl.cert.default.label";
    private static final String PROTOCOL_HTTPS_CERT_TAG = "SSLServerCert";
    private static final String SINGLE_QUOTE_STRING = "'";
    private static final char[] DOUBLE_QUOTE = new char[]{'\"'};
    private static final String DOUBLE_QUOTE_STRING = new String(DOUBLE_QUOTE);
    private Properties certMapping;
    private Properties customProperties;
    private String certDefaultLabel;
    private X509KeyManager defaultX509KeyManager;
    private Map connectionInfo;

    public CertMappingKeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.certMapping = new Properties();
        this.certDefaultLabel = null;
        this.defaultX509KeyManager = null;
        this.parseSSLCertFile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return null;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        String[] serverAliases = this.certMapping.values().toArray(new String[0]);
        return serverAliases;
    }

    public String chooseServerAlias(String ipAddress, Principal[] issuers, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{ipAddress, issuers, socket});
        }
        String alias = null;
        String tmpIpAddress = null;
        Map connectionInfo = JSSEHelper.getInstance().getInboundConnectionInfo();
        if (connectionInfo != null) {
            tmpIpAddress = (String)connectionInfo.get("com.ibm.ssl.certMappingHost");
            alias = this.certMapping.getProperty(tmpIpAddress, this.certDefaultLabel);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseServerAlias", alias);
        }
        return alias;
    }

    public X509Certificate[] getCertificateChain(String arg0) {
        return null;
    }

    public PrivateKey getPrivateKey(String arg0) {
        return null;
    }

    public void setCustomProperties(Properties customProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCustomProperties", customProperties);
        }
        this.customProperties = customProperties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCustomProperties");
        }
    }

    public void setSSLConfig(Properties config) {
    }

    public void setDefaultX509KeyManager(X509KeyManager defaultX509KeyManager) {
        this.defaultX509KeyManager = defaultX509KeyManager;
    }

    public void setKeyStore(KeyStore keyStore) {
    }

    public void setKeyStoreServerAlias(String serverAlias) {
    }

    public void setKeyStoreClientAlias(String clientAlias) {
    }

    public String getProperty(String name) {
        String property = null;
        if (this.customProperties != null) {
            property = this.customProperties.getProperty(name);
        }
        if (property == null) {
            property = System.getProperty(name);
        }
        if (property == null) {
            property = SSLConfigManager.getInstance().getGlobalProperty(name);
        }
        return property;
    }

    private void parseSSLCertFile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSSLCertFile");
        }
        String fileName = null;
        String lineRead = null;
        BufferedReader bufferReader = null;
        this.certDefaultLabel = this.getProperty(PROTOCOL_HTTPS_CERT_DEFAULT_LABEL);
        try {
            fileName = this.getProperty(PROTOCOL_HTTPS_CERT_MAPPING_FILE);
            if (fileName != null && !fileName.equals("")) {
                bufferReader = new BufferedReader(new FileReader(fileName));
                lineRead = bufferReader.readLine();
                while (lineRead != null) {
                    this.extractSSLServerCert(lineRead.trim());
                    lineRead = bufferReader.readLine();
                }
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "The following exception occurred in parseSSLCertFile().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.CustomX509KeyManager.getProperties", "280", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSSLCertFile");
        }
    }

    private void extractSSLServerCert(String lineRead) {
        String ipAddressString;
        char delimeterChar;
        String certLabelString;
        String tmpString;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractSSLServerCert", lineRead);
        }
        if (lineRead.startsWith(PROTOCOL_HTTPS_CERT_TAG) && ((tmpString = lineRead.substring(PROTOCOL_HTTPS_CERT_TAG.length()).trim()).startsWith(SINGLE_QUOTE_STRING) || tmpString.startsWith(DOUBLE_QUOTE_STRING)) && (certLabelString = tmpString.substring(1, tmpString.lastIndexOf(delimeterChar = tmpString.charAt(0)))) != null && certLabelString.length() != 0 && (ipAddressString = tmpString.substring(tmpString.lastIndexOf(delimeterChar) + 1).trim()) != null && ipAddressString.length() != 0) {
            this.certMapping.setProperty(ipAddressString, certLabelString);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractSSLServerCert");
        }
    }
}

