/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.security.keystoreutil.KeyStoreUtil;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.properties.DescriptiveProperty;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.emf.common.util.EList;

public class WSKeyStore
extends Properties {
    private static final TraceComponent tc = Tr.register(WSKeyStore.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private String name = null;
    private KeyStore ks = null;
    public static boolean defaultKeyStoreWarningIssued = false;

    public WSKeyStore(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyStore <init>");
        }
        this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        this.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        this.setProperty("com.ibm.ssl.keyStoreType", "PKCS12");
        this.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
        this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
        this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
        if (SSLConfigManager.getInstance().isServerProcess()) {
            this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
        }
        boolean tokenEnabled = false;
        String alias = null;
        Object wsks_key = null;
        if (keyStore != null && keyStore.getLocation() != null) {
            String hostList;
            String keyStoreType;
            String keyStoreLocation;
            String keyStorePassword;
            String keyStoreName;
            String keyStoreProvider = keyStore.getProvider();
            if (keyStoreProvider != null) {
                if (keyStoreProvider.equals("IBMPKCS11Impl")) {
                    tokenEnabled = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
                this.setProperty("com.ibm.ssl.keyStoreProvider", keyStoreProvider);
            }
            if ((keyStoreName = keyStore.getName()) != null) {
                alias = keyStoreName;
                this.setProperty("com.ibm.ssl.keyStoreName", keyStoreName);
            }
            if ((keyStorePassword = keyStore.getPassword()) != null) {
                if (!defaultKeyStoreWarningIssued && keyStorePassword.equals("WebAS")) {
                    Tr.warning(tc, "ssl.default.password.in.use.CWPKI0041W");
                    defaultKeyStoreWarningIssued = true;
                }
                this.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
            }
            if ((keyStoreLocation = keyStore.getLocation()) != null) {
                this.setProperty("com.ibm.ssl.keyStore", KeyStoreManager.getInstance().expand(keyStoreLocation));
            }
            if ((keyStoreType = keyStore.getType()) != null) {
                this.setProperty("com.ibm.ssl.keyStoreType", keyStoreType);
                if (!(keyStoreType.equals("JKS") || keyStoreType.equals("JCEKS") || keyStoreType.equals("PKCS12"))) {
                    this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                }
                if (keyStoreType.equals("PKCS11")) {
                    tokenEnabled = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
            }
            if (tokenEnabled) {
                String slot = Integer.toString(keyStore.getSlot());
                this.setProperty("com.ibm.ssl.keyStoreSlot", slot);
            }
            if ((hostList = keyStore.getHostList()) != null && !hostList.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreHostList", hostList);
            }
            if (keyStore.getManagementScope() != null) {
                this.setProperty("com.ibm.ssl.keyStoreScope", keyStore.getManagementScope().getScopeName());
            } else {
                this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            }
            String customClass = keyStore.getCustomProviderClass();
            if (customClass != null && !customClass.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreCustomClass", customClass);
            }
            this.setProperty("com.ibm.ssl.keyStoreFileBased", keyStore.isFileBased() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreReadOnly", keyStore.isReadOnly() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", keyStore.isInitializeAtStartup() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", keyStore.isCreateStashFileForCMS() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", keyStore.isUseForAcceleration() ? "true" : "false");
            EList otherProps = keyStore.getAdditionalKeyStoreAttrs();
            if (otherProps != null) {
                for (DescriptiveProperty prop : otherProps) {
                    if (prop == null) continue;
                    this.setProperty(prop.getName(), prop.getValue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStore(SecurityConfigObject keyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyStore <init>");
        }
        this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        this.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        this.setProperty("com.ibm.ssl.keyStoreType", "PKCS12");
        this.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
        this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
        this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
        if (SSLConfigManager.getInstance().isServerProcess()) {
            this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
        }
        boolean tokenEnabled = false;
        String alias = null;
        Object wsks_key = null;
        if (keyStore != null && keyStore.getUnexpandedString("location") != null) {
            SecurityConfigObject mgmtScope;
            String hostList;
            String keyStoreType;
            String keyStoreLocation;
            String keyStorePassword;
            String keyStoreName;
            String keyStoreProvider = keyStore.getString("provider");
            if (keyStoreProvider != null) {
                if (keyStoreProvider.equals("PKCS11")) {
                    tokenEnabled = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
                this.setProperty("com.ibm.ssl.keyStoreProvider", keyStoreProvider);
            }
            if ((keyStoreName = keyStore.getString("name")) != null) {
                alias = keyStoreName;
                this.setProperty("com.ibm.ssl.keyStoreName", keyStoreName);
            }
            if ((keyStorePassword = keyStore.getDecodedString("password")) != null) {
                if (!defaultKeyStoreWarningIssued && keyStorePassword.equals("WebAS")) {
                    Tr.warning(tc, "ssl.default.password.in.use.CWPKI0041W");
                    defaultKeyStoreWarningIssued = true;
                }
                this.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
            }
            if ((keyStoreLocation = keyStore.getUnexpandedString("location")) != null) {
                this.setProperty("com.ibm.ssl.keyStore", KeyStoreManager.getInstance().expand(keyStoreLocation));
            }
            if ((keyStoreType = keyStore.getString("type")) != null) {
                this.setProperty("com.ibm.ssl.keyStoreType", keyStoreType);
                if (!(keyStoreType.equals("JKS") || keyStoreType.equals("JCEKS") || keyStoreType.equals("PKCS12"))) {
                    this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                }
            }
            if (tokenEnabled) {
                String slot = keyStore.getInteger("slot").toString();
                this.setProperty("com.ibm.ssl.keyStoreSlot", slot);
            }
            if ((hostList = keyStore.getString("hostList")) != null && !hostList.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreHostList", hostList);
            }
            if ((mgmtScope = keyStore.getObject("managementScope")) != null) {
                this.setProperty("com.ibm.ssl.keyStoreScope", mgmtScope.getString("scopeName"));
            } else {
                this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            }
            String customClass = keyStore.getString("customProviderClass");
            if (customClass != null && !customClass.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreCustomClass", customClass);
            }
            this.setProperty("com.ibm.ssl.keyStoreFileBased", keyStore.getBoolean("fileBased") != false ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreReadOnly", keyStore.getBoolean("readOnly") != false ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", keyStore.getBoolean("initializeAtStartup") != false ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", keyStore.getBoolean("createStashFileForCMS") != false ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", keyStore.getBoolean("useForAcceleration") != false ? "true" : "false");
            SecurityConfigObjectList otherProps = keyStore.getObjectList("additionalKeyStoreAttrs");
            if (otherProps != null) {
                for (int i = 0; i < otherProps.size(); ++i) {
                    SecurityConfigObject prop = otherProps.get(i);
                    if (prop == null) continue;
                    this.setProperty(prop.getString("name"), prop.getString("value"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStore(KeyStoreInfo keyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyStoreInfo <init>");
        }
        boolean tokenEnabled = false;
        String alias = null;
        Object wsks_key = null;
        if (keyStore != null && keyStore.getLocation() != null) {
            List otherProps;
            String customClass;
            String hostList;
            String keyStoreType;
            String keyStoreLocation;
            String keyStorePassword;
            String keyStoreName;
            String keyStoreProvider = keyStore.getProvider();
            if (keyStoreProvider != null) {
                if (keyStoreProvider.equals("IBMPKCS11Impl")) {
                    tokenEnabled = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
                this.setProperty("com.ibm.ssl.keyStoreProvider", keyStoreProvider);
            }
            if ((keyStoreName = keyStore.getName()) != null) {
                alias = keyStoreName;
                this.setProperty("com.ibm.ssl.keyStoreName", keyStoreName);
            }
            if ((keyStorePassword = keyStore.getPassword()) != null) {
                if (!defaultKeyStoreWarningIssued && keyStorePassword.equals("WebAS")) {
                    Tr.warning(tc, "ssl.default.password.in.use.CWPKI0041W");
                    defaultKeyStoreWarningIssued = true;
                }
                this.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
            }
            if ((keyStoreLocation = keyStore.getLocation()) != null) {
                this.setProperty("com.ibm.ssl.keyStore", KeyStoreManager.getInstance().expand(keyStoreLocation));
            }
            if ((keyStoreType = keyStore.getType()) != null) {
                this.setProperty("com.ibm.ssl.keyStoreType", keyStoreType);
                if (!(keyStoreType.equals("JKS") || keyStoreType.equals("JCEKS") || keyStoreType.equals("PKCS12"))) {
                    this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                }
                if (keyStoreType.equals("PKCS11")) {
                    tokenEnabled = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
            }
            if (tokenEnabled) {
                String slot = keyStore.getSlot().toString();
                this.setProperty("com.ibm.ssl.keyStoreSlot", slot);
            }
            if ((hostList = keyStore.getHostList()) != null && !hostList.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreHostList", hostList);
            }
            if (keyStore.getScopeNameString() != null) {
                this.setProperty("com.ibm.ssl.keyStoreScope", keyStore.getScopeNameString());
            }
            if ((customClass = keyStore.getCustomProvider()) != null && !customClass.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreCustomClass", customClass);
            }
            if (keyStore.getFileBased() != null) {
                this.setProperty("com.ibm.ssl.keyStoreFileBased", keyStore.getFileBased() != false ? "true" : "false");
            }
            if (keyStore.getReadOnly() != null) {
                this.setProperty("com.ibm.ssl.keyStoreReadOnly", keyStore.getReadOnly() != false ? "true" : "false");
            }
            if (keyStore.getInitializeAtStartup() != null) {
                this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", keyStore.getInitializeAtStartup() != false ? "true" : "false");
            }
            if (keyStore.getStashFile() != null) {
                this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", keyStore.getStashFile() != false ? "true" : "false");
            }
            if (keyStore.getAccelerator() != null) {
                this.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", keyStore.getAccelerator() != false ? "true" : "false");
            }
            if ((otherProps = keyStore.getCustomProps()) != null) {
                for (DescriptiveProperty prop : otherProps) {
                    if (prop == null) continue;
                    this.setProperty(prop.getName(), prop.getValue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStore() {
        this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        this.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        this.setProperty("com.ibm.ssl.keyStoreType", "PKCS12");
        this.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
        this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
        this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
        if (SSLConfigManager.getInstance().isServerProcess()) {
            this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
        }
    }

    public String getLocation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocation");
        }
        String location = this.getProperty("com.ibm.ssl.keyStore");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocation -> " + location);
        }
        return location;
    }

    public String getManagementScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagementScope");
        }
        String managementScope = this.getProperty("com.ibm.ssl.keyStoreScope");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagementScope -> " + managementScope);
        }
        return managementScope;
    }

    public synchronized KeyStore do_getKeyStore(boolean reinitialize, boolean createIfNotPresent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "do_getKeyStore", new Object[]{reinitialize, createIfNotPresent});
        }
        String SSLKeyFile = this.getProperty("com.ibm.ssl.keyStore");
        final boolean create = createIfNotPresent;
        try {
            this.ks = (KeyStore)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String SSLKeyFile = null;
                    KeyStore ks1 = null;
                    String name = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initializing KeyStore " + name);
                    }
                    SSLKeyFile = WSKeyStore.this.getProperty("com.ibm.ssl.keyStore");
                    String SSLKeyPassword = WSKeyStore.this.getProperty("com.ibm.ssl.keyStorePassword");
                    String SSLKeyStoreType = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreType");
                    String SSLKeyStoreFileBased = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreFileBased");
                    String SSLKeyStoreProvider = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreProvider");
                    String SSLKeyStoreSlot = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreSlot");
                    if (SSLKeyStoreSlot == null || SSLKeyStoreSlot.length() == 0) {
                        SSLKeyStoreSlot = WSKeyStore.this.getProperty("com.ibm.ssl.tokenSlot");
                    }
                    String tokenEnabled = WSKeyStore.this.getProperty("com.ibm.ssl.tokenEnabled");
                    String SSLKeyStoreStash = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
                    String keyStoreLocation = null;
                    if (SSLKeyStoreFileBased != null && SSLKeyStoreFileBased.equals("true")) {
                        Class<?> cl1;
                        File kFile;
                        try {
                            URL conversionURL = new URL(SSLKeyFile);
                            keyStoreLocation = conversionURL.getFile();
                            String osName = System.getProperty("os.name");
                            if (osName != null && osName.indexOf("Windows") != -1) {
                                while (keyStoreLocation.startsWith("/")) {
                                    keyStoreLocation = keyStoreLocation.substring(1);
                                }
                            } else {
                                while (keyStoreLocation.startsWith("//")) {
                                    keyStoreLocation = keyStoreLocation.substring(1);
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            keyStoreLocation = SSLKeyFile;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "File path for OutputStream: " + keyStoreLocation);
                        }
                        if ((kFile = new File(keyStoreLocation)).exists()) {
                            if (SSLKeyStoreType != null && (SSLKeyStoreType.equals("CMSKS") || SSLKeyStoreType.equals("IBMi5OSKeyStore"))) {
                                cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                                Method theMethod1 = cl1.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                                ks1 = (KeyStore)theMethod1.invoke(cl1.newInstance(), kFile, keyStoreLocation, SSLKeyPassword, SSLKeyStoreType, SSLKeyStoreProvider, SSLKeyStoreStash);
                            } else {
                                boolean exists = true;
                                try {
                                    InputStream is = null;
                                    is = WSKeyStore.openKeyStore(SSLKeyFile);
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                                catch (Exception e) {
                                    Tr.debug(tc, "KeyStore does not exist");
                                    Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.WSKeyStore.getKeyStore", "666", this);
                                    exists = false;
                                }
                                Tr.debug(tc, "Creating new keyStore");
                                JSSEProvider jsseProvider = JSSEProviderFactory.getInstance();
                                ks1 = jsseProvider.getKeyStoreInstance(SSLKeyStoreType, SSLKeyStoreProvider);
                                File fileLocation = new File(keyStoreLocation);
                                InputStream is = null;
                                if (fileLocation.exists()) {
                                    is = WSKeyStore.openKeyStore(keyStoreLocation);
                                }
                                ks1.load(is, SSLKeyPassword.toCharArray());
                                if (is != null) {
                                    is.close();
                                }
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getKeyStore (initialized)");
                            }
                            return ks1;
                        }
                        if (SSLKeyStoreType != null && (SSLKeyStoreType.equals("CMSKS") || SSLKeyStoreType.equals("IBMi5OSKeyStore"))) {
                            cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                            Method theMethod1 = cl1.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                            ks1 = (KeyStore)theMethod1.invoke(cl1.newInstance(), null, keyStoreLocation, SSLKeyPassword, SSLKeyStoreType, SSLKeyStoreProvider, SSLKeyStoreStash);
                        } else if (create || name != null && (name.endsWith("DefaultKeyStore") || name.endsWith("DefaultTrustStore") || name.endsWith("DefaultRootStore") || name.endsWith("DefaultDeletedStore") || name.endsWith("DefaultSignersStore") || name.endsWith("LTPAKeys"))) {
                            JSSEProvider jsseProvider = JSSEProviderFactory.getInstance();
                            ks1 = jsseProvider.getKeyStoreInstance(SSLKeyStoreType, SSLKeyStoreProvider);
                            ks1.load(null, SSLKeyPassword.toCharArray());
                        } else {
                            throw new SSLException("KeyStore \"" + keyStoreLocation + "\" does not exist.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getKeyStore (loaded)");
                        }
                        return ks1;
                    }
                    if (tokenEnabled != null && tokenEnabled.equals("true")) {
                        boolean pureAcceleration = false;
                        String useForAcceleration = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
                        WSPKCSInKeyStore pKS = null;
                        if (useForAcceleration != null && useForAcceleration.equals("true")) {
                            pureAcceleration = true;
                            pKS = pkcsStoreList.insert(SSLKeyStoreType, SSLKeyFile, null, true, SSLKeyStoreProvider, pureAcceleration);
                        } else {
                            pKS = pkcsStoreList.insert(SSLKeyStoreType, SSLKeyFile, SSLKeyPassword, true, SSLKeyStoreProvider, pureAcceleration);
                        }
                        if (pKS != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getKeyStore (created and initialized)");
                            }
                            ks1 = pKS.getKS();
                            return ks1;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getKeyStore (Could not get KeyStore from pkcsStoreList)");
                        }
                        throw new SSLException("Could not get KeyStore instance for hardware device.");
                    }
                    boolean exists = true;
                    InputStream is = null;
                    try {
                        is = WSKeyStore.openKeyStore(SSLKeyFile);
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception e) {
                        Tr.debug(tc, "KeyStore does not exist");
                        if (is != null) {
                            is.close();
                        }
                        Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.WSKeyStore.getKeyStore", "769", this);
                        exists = false;
                    }
                    Tr.debug(tc, "Creating new keyStore");
                    JSSEProvider jsseProvider = JSSEProviderFactory.getInstance();
                    ks1 = jsseProvider.getKeyStoreInstance(SSLKeyStoreType, SSLKeyStoreProvider);
                    if (!exists && (create || name != null && (name.endsWith("DefaultKeyStore") || name.endsWith("DefaultTrustStore") || name.endsWith("DefaultRootStore") || name.endsWith("DefaultDeletedStore") || name.endsWith("DefaultSignersStore") || name.endsWith("LTPAKeys")))) {
                        ks1.load(null, SSLKeyPassword.toCharArray());
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getKeyStore (loaded)");
                        }
                        return ks1;
                    }
                    Tr.debug(tc, "KeyStore exists loading existing keyStore");
                    is = null;
                    is = WSKeyStore.openKeyStore(SSLKeyFile);
                    ks1.load(is, SSLKeyPassword.toCharArray());
                    if (tc.isDebugEnabled()) {
                        Enumeration<String> e = ks1.aliases();
                        while (e.hasMoreElements()) {
                            Tr.debug(tc, "alias: " + e.nextElement());
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getKeyStore (initialized)");
                    }
                    if (is != null) {
                        is.close();
                    }
                    return ks1;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            String ksType = this.getProperty("com.ibm.ssl.keyStoreType");
            Boolean ksReadOnly = Boolean.getBoolean(this.getProperty("com.ibm.ssl.keyStoreReadOnly"));
            if (ksType.equals("JCERACFKS") || ksType.equals("JCECCARACFKS") && ksReadOnly.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot open keystore URL and since this is a RACFKS, we will return null: ", new Object[]{ex});
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot open keystore URL: " + SSLKeyFile, new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.ssl.config.WSKeyStore.getKeyStore", "844", this);
            Tr.error(tc, "ssl.keystore.load.error.CWPKI0033E", new Object[]{SSLKeyFile, ex.getMessage()});
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "do_getKeyStore (from cache)");
        }
        return this.ks;
    }

    public KeyStore getKeyStore(boolean reinitialize, boolean createIfNotPresent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore", new Object[]{reinitialize, createIfNotPresent});
        }
        if (this.ks == null || reinitialize) {
            this.ks = this.do_getKeyStore(reinitialize, createIfNotPresent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore (from cache)");
        }
        return this.ks;
    }

    public void store(String password) throws Exception {
        if (password != null) {
            this.setProperty("com.ibm.ssl.keyStorePassword", password);
        }
        this.store();
    }

    public void store() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "store");
        }
        try {
            PlatformHelper ph;
            String name = this.getProperty("com.ibm.ssl.keyStoreName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Storing KeyStore " + name);
            }
            String SSLKeyFile = this.getProperty("com.ibm.ssl.keyStore");
            String SSLKeyPassword = this.getProperty("com.ibm.ssl.keyStorePassword");
            String SSLKeyStoreType = this.getProperty("com.ibm.ssl.keyStoreType");
            String SSLKeyStoreReadOnly = this.getProperty("com.ibm.ssl.keyStoreReadOnly");
            boolean readOnly = SSLKeyStoreReadOnly != null && SSLKeyStoreReadOnly.equals("true");
            String SSLKeyStoreFileBased = this.getProperty("com.ibm.ssl.keyStoreFileBased");
            boolean fileBased = SSLKeyStoreFileBased != null && SSLKeyStoreFileBased.equals("true");
            String SSLKeyStoreStash = this.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
            boolean stash = SSLKeyStoreStash != null && SSLKeyStoreStash.equals("true");
            String tokenEnabled = this.getProperty("com.ibm.ssl.tokenEnabled");
            KeyStore ks = this.getKeyStore(false, false);
            if (ks != null && !readOnly) {
                String keyStorePassword;
                String keyStoreLocation;
                if (SSLKeyStoreType != null && fileBased && (SSLKeyStoreType.equals("CMSKS") || SSLKeyStoreType.equals("IBMi5OSKeyStore"))) {
                    Tr.debug(tc, "Storing filebased keystore type " + SSLKeyStoreType);
                    Class<?> cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                    Method theMethod1 = cl1.getMethod("storeCMSKeyStore", KeyStore.class, String.class, String.class, String.class, String.class);
                    theMethod1.invoke(cl1.newInstance(), ks, SSLKeyFile, SSLKeyPassword, SSLKeyStoreType, SSLKeyStoreStash);
                } else if (fileBased) {
                    Tr.debug(tc, "Storing filebased keystore type " + SSLKeyStoreType);
                    keyStoreLocation = this.getProperty("com.ibm.ssl.keyStore");
                    keyStorePassword = this.getProperty("com.ibm.ssl.keyStorePassword");
                    FileOutputStream fos = new FileOutputStream(keyStoreLocation);
                    ks.store(fos, keyStorePassword.toCharArray());
                    if (fos != null) {
                        fos.close();
                    }
                } else {
                    Tr.debug(tc, "Storing non-filebased keystore type " + SSLKeyStoreType);
                    keyStoreLocation = this.getProperty("com.ibm.ssl.keyStore");
                    keyStorePassword = this.getProperty("com.ibm.ssl.keyStorePassword");
                    URL ring = new URL(keyStoreLocation);
                    URLConnection ringConnect = ring.openConnection();
                    OutputStream fos = ringConnect.getOutputStream();
                    ks.store(fos, keyStorePassword.toCharArray());
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            if ((ph = PlatformHelperFactory.getPlatformHelper()).isOS400()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OS400 changing file authority for " + SSLKeyFile);
                }
                try {
                    String[] command = new String[]{"system", "CHGAUT", "OBJ('" + SSLKeyFile + "')", "USER(*PUBLIC)", "DTAAUT(*RX)", "OBJAUT(*NONE)"};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command to execute on OS400 " + command);
                    }
                    Runtime.getRuntime().exec(command);
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during file authority setting on OS400", new Object[]{ex});
                    }
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception storing KeyStore.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.WSKeyStore.store", "968", this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "store");
        }
    }

    public void initializeKeyStore(boolean reinitialize) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeyStore");
        }
        try {
            String initAtStartup = this.getProperty("com.ibm.ssl.keyStoreInitializeAtStartup");
            if (initAtStartup != null && initAtStartup.equals("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing keystore at startup.");
                }
                this.getKeyStore(reinitialize, false);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing KeyStore.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.WSKeyStore.initializeKeyStore", "992", this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeyStore");
        }
    }

    public void provideExpirationWarnings(int daysBeforeExpireWarning, String keyStoreName) throws Exception {
        KeyStore keystore;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "provideExpirationWarnings", new Integer(daysBeforeExpireWarning));
        }
        if ((keystore = this.getKeyStore(false, false)) != null) {
            try {
                Enumeration<String> e = keystore.aliases();
                if (e != null) {
                    while (e.hasMoreElements()) {
                        Certificate[] cert_chain;
                        String alias = e.nextElement();
                        if (alias == null || (cert_chain = keystore.getCertificateChain(alias)) == null) continue;
                        for (int i = 0; i < cert_chain.length; ++i) {
                            this.printWarning(daysBeforeExpireWarning, keyStoreName, alias, (X509Certificate)cert_chain[i]);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception validating KeyStore expirations.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.WSKeyStore.provideExpirationWarnings", "1036", this);
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "provideExpirationWarnings");
        }
    }

    public void printWarning(int daysBeforeExpireWarning, String keyStoreName, String alias, X509Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printWarning", new Object[]{new Integer(daysBeforeExpireWarning), keyStoreName, alias});
        }
        try {
            long millisDelta = (long)daysBeforeExpireWarning * 24L * 60L * 60L * 1000L;
            long millisBeforeExpiration = cert.getNotAfter().getTime() - System.currentTimeMillis();
            long daysLeft = millisBeforeExpiration / 1000L / 60L / 60L / 24L;
            if (cert != null && millisBeforeExpiration < 0L) {
                Tr.error(tc, "ssl.expiration.expired.CWPKI0017E", new Object[]{alias, keyStoreName});
            } else if (cert != null && millisBeforeExpiration < millisDelta) {
                Tr.warning(tc, "ssl.expiration.warning.CWPKI0016E", new Object[]{alias, keyStoreName, new Long(daysLeft)});
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate with alias " + alias + " from keyStore " + keyStoreName + " has " + daysLeft + " days left before expiring.");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception reading KeyStore certificates during expiration check.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.WSKeyStore.printWarning", "1073", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "printWarning");
        }
    }

    public static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openKeyStore", fileName);
        }
        InputStream fis = null;
        URL urlFile = null;
        File kfile = new File(fileName);
        if (kfile.exists() && kfile.length() == 0L) {
            throw new IOException("Keystore file exists, but is empty: " + fileName);
        }
        urlFile = !kfile.exists() ? new URL(fileName) : new URL("file:" + kfile.getCanonicalPath());
        fis = urlFile.openStream();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openKeyStore");
        }
        return fis;
    }

    public static ArrayList getKeyStoreTypes() {
        ArrayList<String> keyStoreTypes;
        int e;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreTypes");
        }
        if ((e = (keyStoreTypes = new ArrayList<String>(Security.getAlgorithms("KeyStore"))).indexOf("IBMCMSKS")) >= 0) {
            keyStoreTypes.set(e, "CMSKS");
        }
        if ((e = keyStoreTypes.indexOf("CASEEXACTJKS")) != -1) {
            keyStoreTypes.remove(e);
        }
        if ((e = keyStoreTypes.indexOf("PKCS12S2")) != -1) {
            keyStoreTypes.remove(e);
        }
        if ((e = keyStoreTypes.indexOf("PKCS12JARSIGNER")) != -1) {
            keyStoreTypes.remove(e);
        }
        if ((e = keyStoreTypes.indexOf("JCA4758KS")) != -1) {
            keyStoreTypes.remove(e);
        }
        if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
            e = keyStoreTypes.indexOf("IBMi5OSKeyStore".toUpperCase());
            if (e != -1) {
                keyStoreTypes.set(e, "IBMi5OSKeyStore");
            }
            if ((e = keyStoreTypes.indexOf("IbmISeriesKeyStore".toUpperCase())) != -1) {
                keyStoreTypes.set(e, "IbmISeriesKeyStore");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStoreTypes: " + keyStoreTypes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStoreTypes");
        }
        return keyStoreTypes;
    }

    public String toString() {
        Enumeration<?> e = this.propertyNames();
        StringBuffer buf = new StringBuffer();
        buf.append("WSKeyStore.toString() {");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getProperty(name);
            if (name.toLowerCase().indexOf("password") != -1) {
                buf.append(name);
                buf.append(" = ");
                buf.append(SSLConfigManager.mask(value));
                buf.append("\n");
                continue;
            }
            buf.append(name);
            buf.append(" = ");
            buf.append(value);
            buf.append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public Object[] invokeKeyStoreCommand(String method2, Object[] parms) throws KeyException {
        return this.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invokeKeyStoreCommand(String method2, Object[] parms, Boolean createIfNotPresent) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeKeyStoreCommand", new Object[]{method2, this.printParms(parms)});
        }
        try {
            String keyStoreLocation = this.getProperty("com.ibm.ssl.keyStore");
            Boolean ksReadOnly = Boolean.getBoolean(this.getProperty("com.ibm.ssl.keyStoreReadOnly"));
            String ksType = this.getProperty("com.ibm.ssl.keyStoreType");
            KeyStore jKeyStore = null;
            jKeyStore = (ksType.equals("JCERACFKS") || ksType.equals("JCECCARACFKS")) && ksReadOnly == false ? this.getKeyStore(true, createIfNotPresent) : this.getKeyStore(false, createIfNotPresent);
            if (jKeyStore == null) {
                if ((ksType.equals("JCERACFKS") || ksType.equals("JCECCARACFKS")) && ksReadOnly.booleanValue()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Suppressing Exception since KS type is RACF. Trying another CR/SR." + keyStoreLocation);
                    }
                    if (method2.equals("isKeyEntry") | method2.equals("isCertificateEntry") | method2.equals("containsAlias")) {
                        return new Object[]{new Boolean(Boolean.FALSE)};
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot load the Java keystore at location \"" + keyStoreLocation + "\" on the local node.");
                }
                throw new KeyException("Cannot load the Java keystore at location \"" + keyStoreLocation + "\" on the local node.");
            }
            if (method2.equals("aliases")) {
                ArrayList<String> aliasList = new ArrayList<String>();
                Enumeration<String> aliases = jKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    aliasList.add(aliases.nextElement());
                }
                String[] aliasArray = aliasList.toArray(new String[aliasList.size()]);
                return aliasArray;
            }
            if (method2.equals("containsAlias")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                boolean exists = jKeyStore.containsAlias(alias);
                return new Object[]{new Boolean(exists)};
            }
            if (method2.equals("deleteEntry")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                jKeyStore.deleteEntry(alias);
                this.store();
                return null;
            }
            if (method2.equals("getCertificate")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                Certificate cert = jKeyStore.getCertificate(alias);
                return new Object[]{cert};
            }
            if (method2.equals("getCertificateAlias")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                Certificate cert = (Certificate)parms[0];
                String alias = jKeyStore.getCertificateAlias(cert);
                return new Object[]{alias};
            }
            if (method2.equals("getCertificateChain")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                Certificate[] certChain = jKeyStore.getCertificateChain(alias);
                return new Object[]{certChain};
            }
            if (method2.equals("getCreationDate")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                Date creationDate = jKeyStore.getCreationDate(alias);
                return new Object[]{creationDate};
            }
            if (method2.equals("getDefaultType")) {
                String defaultType = KeyStore.getDefaultType();
                return new Object[]{defaultType};
            }
            if (method2.equals("getKey")) {
                if (parms == null || parms.length != 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                char[] password = (char[])parms[1];
                Key key = jKeyStore.getKey(alias, password);
                return new Object[]{key};
            }
            if (method2.equals("getProvider")) {
                Provider provider = jKeyStore.getProvider();
                return new Object[]{provider};
            }
            if (method2.equals("getType")) {
                String type = jKeyStore.getType();
                return new Object[]{type};
            }
            if (method2.equals("isCertificateEntry")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                boolean isCertEntry = jKeyStore.isCertificateEntry(alias);
                return new Object[]{new Boolean(isCertEntry)};
            }
            if (method2.equals("isKeyEntry")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                boolean isKeyEntry = jKeyStore.isKeyEntry(alias);
                return new Object[]{new Boolean(isKeyEntry)};
            }
            if (method2.equals("setCertificateEntry")) {
                if (parms == null || parms.length != 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                Certificate cert = (Certificate)parms[1];
                String aliasName = alias;
                boolean exists = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)cert, jKeyStore);
                if (exists) {
                    aliasName = jKeyStore.getCertificateAlias(cert);
                }
                if (!exists && !jKeyStore.containsAlias(alias)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + alias + "\" to keystore.");
                    }
                    jKeyStore.setCertificateEntry(alias, cert);
                } else if (!exists) {
                    String newAlias = CertificateManager.getInstance().incrementAlias(jKeyStore, alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + newAlias + "\" to keystore.");
                    }
                    if (!jKeyStore.containsAlias(newAlias)) {
                        jKeyStore.setCertificateEntry(newAlias, cert);
                        aliasName = newAlias;
                    }
                }
                try {
                    this.store();
                }
                catch (IOException e) {
                    if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                        KeyStore ks = this.getKeyStore(true, false);
                        if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)cert, ks)) {
                            Tr.debug(tc, "Certificate already exists in RACF: " + e.getMessage());
                            return new Object[]{ks.getCertificateAlias(cert)};
                        }
                        throw e;
                    }
                    throw e;
                }
                return new Object[]{aliasName};
            }
            if (method2.equals("setCertificateEntryOverwrite")) {
                if (parms == null || parms.length != 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                Certificate cert = (Certificate)parms[1];
                String aliasName = alias;
                boolean exists = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)cert, jKeyStore);
                if (exists) {
                    aliasName = jKeyStore.getCertificateAlias(cert);
                }
                if (!exists) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + alias + "\" to keystore.");
                    }
                    jKeyStore.setCertificateEntry(alias, cert);
                }
                try {
                    this.store();
                }
                catch (IOException e) {
                    if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                        KeyStore ks = this.getKeyStore(true, false);
                        if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)cert, ks)) {
                            Tr.debug(tc, "Certificate already exists in RACF: " + e.getMessage());
                            return new Object[]{ks.getCertificateAlias(cert)};
                        }
                        throw e;
                    }
                    throw e;
                }
                return new Object[]{aliasName};
            }
            if (method2.equals("setKeyEntry") && parms != null && parms.length == 3) {
                if (parms == null || parms.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                byte[] key = (byte[])parms[1];
                Certificate[] certChain = (Certificate[])parms[2];
                String aliasName = null;
                if (!jKeyStore.containsAlias(alias)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + alias + "\" to keystore.");
                    }
                    jKeyStore.setKeyEntry(alias, key, certChain);
                    aliasName = alias;
                } else {
                    String newAlias = CertificateManager.getInstance().incrementAlias(jKeyStore, alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + newAlias + "\" to keystore.");
                    }
                    if (!jKeyStore.containsAlias(newAlias)) {
                        jKeyStore.setKeyEntry(newAlias, key, certChain);
                        aliasName = newAlias;
                    }
                }
                try {
                    this.store();
                }
                catch (IOException e) {
                    if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                        KeyStore ks = this.getKeyStore(true, false);
                        if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certChain[0], ks)) {
                            Tr.debug(tc, "Certificate already exists in RACF: " + e.getMessage());
                            return new Object[]{ks.getCertificateAlias(certChain[0])};
                        }
                        throw e;
                    }
                    throw e;
                }
                return new Object[]{aliasName};
            }
            if (method2.equals("setKeyEntry") && parms != null && parms.length == 4) {
                if (parms == null || parms.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                Key key = (Key)parms[1];
                char[] password = (char[])parms[2];
                Certificate[] certChain = (Certificate[])parms[3];
                String aliasName = null;
                if (!jKeyStore.containsAlias(alias)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + alias + "\" to keystore.");
                    }
                    jKeyStore.setKeyEntry(alias, key, password, certChain);
                    aliasName = alias;
                } else {
                    String newAlias = CertificateManager.getInstance().incrementAlias(jKeyStore, alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + newAlias + "\" to keystore.");
                    }
                    if (!jKeyStore.containsAlias(newAlias)) {
                        jKeyStore.setKeyEntry(newAlias, key, password, certChain);
                        aliasName = newAlias;
                    }
                }
                try {
                    this.store();
                }
                catch (IOException e) {
                    if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                        this.getKeyStore(true, false);
                        if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certChain[0], this.ks)) {
                            Tr.debug(tc, "Certificate already exists in SAF: " + e.getMessage());
                            return new Object[]{this.ks.getCertificateAlias(certChain[0])};
                        }
                        throw e;
                    }
                    throw e;
                }
                return new Object[]{aliasName};
            }
            if (method2.equals("setKeyEntryOverwrite") && parms != null && parms.length == 3) {
                if (parms == null || parms.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                byte[] key = (byte[])parms[1];
                Certificate[] certChain = (Certificate[])parms[2];
                String aliasName = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding alias \"" + alias + "\" to keystore.");
                }
                jKeyStore.setKeyEntry(alias, key, certChain);
                aliasName = alias;
                try {
                    this.store();
                }
                catch (IOException e) {
                    if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                        KeyStore ks = this.getKeyStore(true, false);
                        if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certChain[0], ks)) {
                            Tr.debug(tc, "Certificate already exists in SAF: " + e.getMessage());
                            return new Object[]{ks.getCertificateAlias(certChain[0])};
                        }
                        throw e;
                    }
                    throw e;
                }
                return new Object[]{aliasName};
            }
            if (method2.equals("setKeyEntryOverwrite") && parms != null && parms.length == 4) {
                if (parms == null || parms.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String alias = (String)parms[0];
                Key key = (Key)parms[1];
                char[] password = (char[])parms[2];
                Certificate[] certChain = (Certificate[])parms[3];
                String aliasName = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding alias \"" + alias + "\" to keystore.");
                }
                jKeyStore.setKeyEntry(alias, key, password, certChain);
                aliasName = alias;
                try {
                    this.store();
                }
                catch (IOException e) {
                    if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                        KeyStore ks = this.getKeyStore(true, false);
                        if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certChain[0], ks)) {
                            Tr.debug(tc, "Certificate already exists in SAF: " + e.getMessage());
                            return new Object[]{ks.getCertificateAlias(certChain[0])};
                        }
                        throw e;
                    }
                    throw e;
                }
                return new Object[]{aliasName};
            }
            if (method2.equals("size")) {
                int size = jKeyStore.size();
                return new Object[]{new Integer(size)};
            }
            if (method2.equals("personalCertificateExtract") && parms != null && parms.length == 4) {
                if (parms == null || parms.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                KeyStoreInfo ksInfo = (KeyStoreInfo)parms[0];
                String filePath = (String)parms[1];
                String alias = (String)parms[2];
                Boolean ascii2 = (Boolean)parms[3];
                WSKeyStore wsks = new WSKeyStore(ksInfo);
                KeyStore ks = wsks.getKeyStore(false, false);
                FileOutputStream fos = new FileOutputStream(filePath);
                KeyStoreUtil.exportCertificate((OutputStream)fos, (KeyStore)ks, (String)alias, (boolean)ascii2);
                if (fos != null) {
                    fos.close();
                }
                return null;
            }
            if (method2.equals("receiveCertificate") && parms != null && parms.length == 3) {
                if (parms == null || parms.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                KeyStoreInfo ksInfo = (KeyStoreInfo)parms[0];
                String filePath = (String)parms[1];
                String alias = (String)parms[2];
                WSKeyStore wsks = new WSKeyStore(ksInfo);
                KeyStore ks = wsks.getKeyStore(false, false);
                FileInputStream fis = new FileInputStream(filePath);
                X509Certificate certificate = null;
                if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                    CertificateFactory certificatefactory = CertificateFactory.getInstance("X509");
                    certificate = (X509Certificate)certificatefactory.generateCertificate(fis);
                }
                if (fis != null) {
                    fis.close();
                }
                fis = new FileInputStream(filePath);
                KeyStoreUtil.importCertificate((InputStream)fis, (KeyStore)ks, (String)alias);
                if (fis != null) {
                    fis.close();
                }
                try {
                    wsks.store();
                }
                catch (IOException e) {
                    if (this.getProperty("com.ibm.ssl.keyStoreType").equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType").equals("JCECCARACFKS")) {
                        ks = wsks.getKeyStore(true, false);
                        if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore(certificate, ks)) {
                            Tr.debug(tc, "Certificate already exists in SAF: " + e.getMessage());
                            return new Object[]{ks.getCertificateAlias(certificate)};
                        }
                        throw e;
                    }
                    throw e;
                }
                return new Object[]{alias};
            }
            if (method2.equals("getCertificateChainFromUnManagedKeyStore") && parms != null && parms.length == 4) {
                if (parms == null || parms.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String location = (String)parms[0];
                String type = (String)parms[1];
                char[] password = (char[])parms[2];
                String alias = (String)parms[3];
                KeyStore ks = WSKeyStore.loadKeyStore(location, type, new String(password));
                Certificate[] certChain = ks.getCertificateChain(alias);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (success)");
                }
                return new Object[]{certChain};
            }
            if (method2.equals("getKeyFromUnManagedKeyStore") && parms != null && parms.length == 4) {
                if (parms == null || parms.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String location = (String)parms[0];
                String type = (String)parms[1];
                char[] password = (char[])parms[2];
                String alias = (String)parms[3];
                KeyStore ks = WSKeyStore.loadKeyStore(location, type, new String(password));
                Key key = ks.getKey(alias, password);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (success)");
                }
                return new Object[]{key};
            }
            if (method2.equals("containsAliasFromUnManagedKeyStore") && parms != null && parms.length == 4) {
                if (parms == null || parms.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String location = (String)parms[0];
                String type = (String)parms[1];
                char[] password = (char[])parms[2];
                String alias = (String)parms[3];
                KeyStore ks = WSKeyStore.loadKeyStore(location, type, new String(password));
                boolean exists = ks.containsAlias(alias);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (exists -> " + exists + ")");
                }
                return new Object[]{new Boolean(exists)};
            }
            if (method2.equals("setKeyEntryFromUnManagedKeyStore") && parms != null && parms.length == 6) {
                if (parms == null || parms.length != 6) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String location = (String)parms[0];
                String type = (String)parms[1];
                char[] password = (char[])parms[2];
                String alias = (String)parms[3];
                Certificate[] certChain = (Certificate[])parms[4];
                Key privateKey = (Key)parms[5];
                KeyStore ks = WSKeyStore.loadKeyStore(location, type, new String(password));
                ks.setKeyEntry(alias, privateKey, password, certChain);
                FileOutputStream os2 = new FileOutputStream(location);
                ks.store(os2, password);
                if (os2 != null) {
                    ((OutputStream)os2).close();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (success)");
                }
                return null;
            }
            if (method2.equals("store")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String password = (String)parms[0];
                this.store(password);
                return null;
            }
            if (method2.equals("checkIfSignerAlreadyExists")) {
                if (parms == null || parms.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                Certificate cert = (Certificate)parms[0];
                boolean exists = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)cert, jKeyStore);
                return new Object[]{new Boolean(exists)};
            }
            if (method2.equals("load")) {
                if (parms == null || parms.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String location = (String)parms[0];
                String type = (String)parms[1];
                String password = (String)parms[2];
                KeyStore ks = WSKeyStore.loadKeyStore(location, type, new String(password));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (success)");
                }
                return null;
            }
            if (method2.equals("reinitializeKeyStore")) {
                if (parms != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.  Method expects no arguments.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method. Method expects no arguments, arguments supplied: " + this.printParms(parms));
                }
                this.getKeyStore(true, false);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand[reinitializeKeyStore] (success)");
                }
                return null;
            }
            if (method2.equals("retrieveSignerFromPort")) {
                if (parms == null || parms.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(parms)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(parms));
                }
                String host = (String)parms[0];
                Integer port = (Integer)parms[1];
                String sslCfgAlias = (String)parms[2];
                Object[] certChain = null;
                SSLContext context = JSSEHelper.getInstance().getSSLContext(sslCfgAlias, null, null);
                SSLSocketFactory factory = context.getSocketFactory();
                try {
                    ThreadManager.getInstance().setSetSignerOnThread(true);
                    SSLSocket ssl_sock = (SSLSocket)factory.createSocket(host, (int)port);
                    ssl_sock.startHandshake();
                }
                catch (Exception se) {
                    certChain = ThreadManager.getInstance().getSignerChain();
                    ThreadManager.getInstance().setSignerChain(null);
                }
                finally {
                    ThreadManager.getInstance().setSetSignerOnThread(false);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand[retrieveSigner] (success)");
                }
                return certChain;
            }
            if (method2.equals("listPersonalCertificates")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling listPersonalCertificates");
                }
                HashMap<String, Certificate[]> certList = new HashMap<String, Certificate[]>();
                Enumeration<String> aliases = jKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!jKeyStore.isKeyEntry(alias)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Putting " + alias + " in the personal certs list");
                    }
                    Certificate[] cert = jKeyStore.getCertificateChain(alias);
                    certList.put(alias, cert);
                }
                return new Object[]{certList};
            }
            if (method2.equals("listSignerCertificates")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling listSignerCertificates");
                }
                HashMap<String, Certificate> certList = new HashMap<String, Certificate>();
                Enumeration<String> aliases = jKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!jKeyStore.isCertificateEntry(alias)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Putting " + alias + " in the signers list");
                    }
                    Certificate cert = jKeyStore.getCertificate(alias);
                    certList.put(alias, cert);
                }
                return new Object[]{certList};
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid or unknown method: " + method2);
            }
            throw new KeyException("Invalid or unknown method: " + method2);
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                e = (Exception)e.getCause();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception executing KeyStore method.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.WSKeyStore.invokeKeyStoreCommand", "2086", this);
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(e.getMessage(), e);
        }
    }

    public static KeyStore loadKeyStore(String keyStoreLocation, String keyStoreType, String keyStorePassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadKeyStore");
        }
        KeyStore ks = null;
        InputStream is = null;
        if (keyStoreType != null && (keyStoreType.equals("CMSKS") || keyStoreType.equals("IBMi5OSKeyStore"))) {
            String provider = null;
            provider = keyStoreType.equals("IBMi5OSKeyStore") ? "IBMi5OSJSSEProvider" : "IBMCMSProvider";
            File kFile = new File(keyStoreLocation);
            Class<?> cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
            Method theMethod1 = cl1.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
            ks = (KeyStore)theMethod1.invoke(cl1.newInstance(), kFile, keyStoreLocation, keyStorePassword, keyStoreType, provider, "true");
        } else {
            JSSEProvider jsseProvider = JSSEProviderFactory.getInstance();
            ks = jsseProvider.getKeyStoreInstance(keyStoreType, jsseProvider.getKeyStoreProvider());
            if (keyStoreType.equals("JCERACFKS") || keyStoreType.equals("JCECCARACFKS")) {
                is = WSKeyStore.openKeyStore(keyStoreLocation);
            } else {
                File fileLocation = new File(keyStoreLocation);
                if (fileLocation.exists()) {
                    is = WSKeyStore.openKeyStore(keyStoreLocation);
                }
            }
            ks.load(is, keyStorePassword.toCharArray());
            if (is != null) {
                is.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyStore");
        }
        return ks;
    }

    protected void clearJavaKeyStore() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearJavaKeyStore");
        }
        this.ks = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearJavaKeyStore");
        }
    }

    private String printParms(Object[] parms) {
        StringBuffer sb = new StringBuffer();
        if (parms == null || parms.length == 0) {
            sb.append("null or empty parms");
            return sb.toString();
        }
        for (int i = 0; i < parms.length; ++i) {
            if (parms[i] != null && (parms[i] instanceof byte[] || parms[i] instanceof char[] || parms[i] instanceof Key)) continue;
            sb.append("parm ");
            sb.append(i);
            sb.append(": ");
            sb.append(parms[i]);
            sb.append(", ");
        }
        String parmString = sb.toString();
        if (parmString.endsWith(", ")) {
            parmString = parmString.substring(0, parmString.length() - 2);
        }
        return parmString;
    }
}

