/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.ipc.ssl.SSLSecurityLevel;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.properties.DescriptiveProperty;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.DynamicSSLCacheMissComparator;
import com.ibm.ws.ssl.config.FIPSManager;
import com.ibm.ws.ssl.config.KeyManagerData;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.TrustManagerData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.Constants;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.emf.common.util.EList;

public class SSLConfigManager {
    private static final TraceComponent tc = Tr.register(SSLConfigManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static SSLConfigManager thisClass = null;
    private boolean isServerProcess = false;
    private boolean clientSSLInitializedOnce = false;
    private KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
    private Properties globalConfigProperties = new Properties();
    private HashMap sslConfigMap = new HashMap();
    private ArrayList keyManagerArrayList = new ArrayList();
    private ArrayList trustManagerArrayList = new ArrayList();
    private HashMap sslConfigDynamicSelectionMap = new HashMap();
    private TreeSet sslConfigDynamicSelectionCacheMissTreeSet = new TreeSet(new DynamicSSLCacheMissComparator());
    private HashMap sslConfigDynamicLookupCache = new HashMap();
    private HashSet clientFilesAlreadyProcessed = new HashSet();
    private HashMap sslConfigListenerMap = new HashMap();
    private HashMap sslConfigListenerEventMap = new HashMap();
    private static String[][] SystemSSLCiphers = new String[][]{{"05", "SSL_RSA_WITH_RC4_128_SHA"}, {"04", "SSL_RSA_WITH_RC4_128_MD5"}, {"35", "SSL_RSA_WITH_AES_256_CBC_SHA"}, {"36", "SSL_DH_DSS_WITH_AES_256_CBC_SHA"}, {"37", "SSL_DH_RSA_WITH_AES_256_CBC_SHA"}, {"38", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA"}, {"39", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA"}, {"2F", "SSL_RSA_WITH_AES_128_CBC_SHA"}, {"30", "SSL_DH_DSS_WITH_AES_128_CBC_SHA"}, {"31", "SSL_DH_RSA_WITH_AES_128_CBC_SHA"}, {"32", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA"}, {"33", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA"}, {"0A", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"16", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA"}, {"13", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"}, {"10", "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA"}, {"0D", "SSL_HD_DSS_WITH_3DES_EDE_CBC_SHA"}, {"09", "SSL_RSA_WITH_DES_CBC_SHA"}, {"15", "SSL_DHE_RSA_WITH_DES_CBC_SHA"}, {"12", "SSL_DHE_DSS_WITH_DES_CBC_SHA"}, {"0F", "SSL_DH_RSA_WITH_DES_CBC_SHA"}, {"0C", "SSL_DH_DSS_WITH_DES_CBC_SHA"}, {"03", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"06", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5"}, {"02", "SSL_RSA_NULL_SHA"}, {"01", "SSL_RSA_NULL_MD5"}, {"00", "SSL_NULL_WITH_NULL_NULL"}};

    private SSLConfigManager() {
        JSSEProviderFactory.getInstance();
    }

    public static SSLConfigManager getInstance() {
        if (thisClass == null) {
            thisClass = new SSLConfigManager();
        }
        return thisClass;
    }

    public synchronized void initializeServerSSL(SecurityConfigObject security2, boolean reinitialize) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerSSL");
        }
        if (security2 == null) {
            throw new SSLException("Cannot get security object from WCCM.");
        }
        try {
            int i;
            if (reinitialize) {
                AbstractJSSEProvider.clearSSLContextCache();
            }
            this.isServerProcess = true;
            this.loadGlobalProperties(security2);
            FIPSManager.getInstance().initializeFIPS();
            KeyStoreManager.getInstance().loadKeyStores(security2);
            this.loadKeyManagers(security2);
            this.loadTrustManagers(security2);
            String[] existingAliases = null;
            HashSet<String> newAliases = null;
            if (reinitialize) {
                newAliases = new HashSet<String>();
                existingAliases = this.sslConfigMap.keySet().toArray(new String[0]);
            }
            SecurityConfigObjectList repertoire = security2.getObjectList("repertoire");
            for (i = 0; i < repertoire.size(); ++i) {
                SecurityConfigObject sslConfig = repertoire.get(i);
                if (sslConfig == null) continue;
                String alias = sslConfig.getString("alias");
                SSLConfig config = this.parseSSLConfig(sslConfig, reinitialize);
                if (config == null || !config.requiredPropertiesArePresent()) continue;
                config.setProperty("com.ibm.ssl.alias", alias);
                config.setProperty("com.ibm.ssl.configURLLoadedFrom", "security.xml");
                config.decodePasswords();
                if (reinitialize) {
                    newAliases.add(alias);
                    SSLConfig oldConfig = (SSLConfig)this.sslConfigMap.get(alias);
                    if (oldConfig == null) {
                        this.addSSLConfigToMap(alias, config);
                        continue;
                    }
                    if (!oldConfig.equals(config)) {
                        this.removeSSLConfigFromMap(alias, oldConfig);
                        this.addSSLConfigToMap(alias, config);
                        this.notifySSLConfigChangeListener(alias, "changed");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "New SSL config equals old SSL config for alias: " + alias);
                    continue;
                }
                this.addSSLConfigToMap(alias, config);
            }
            if (reinitialize) {
                for (i = 0; i < existingAliases.length; ++i) {
                    String oldAlias = existingAliases[i];
                    SSLConfig oldConfig = (SSLConfig)this.sslConfigMap.get(oldAlias);
                    String oldConfigURL = oldConfig.getProperty("com.ibm.ssl.configURLLoadedFrom");
                    if (oldConfig == null || newAliases.contains(oldAlias) || oldConfigURL != null && !oldConfigURL.equals("security.xml")) continue;
                    this.removeSSLConfigFromMap(oldAlias, oldConfig);
                    this.notifySSLConfigChangeListener(oldAlias, "deleted");
                }
            }
            this.getDefaultSystemProperties(reinitialize);
            this.loadDynamicSSLSelectionInfo(security2);
            ManagementScopeManager.getInstance().loadSSLConfigGroups(security2, reinitialize);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.SSLConfigManager.initializeServerSSL", "312", this);
            throw new SSLException(e);
        }
        this.checkURLHostNameVerificationProperty(reinitialize);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total Number of SSLConfigs: " + this.sslConfigMap.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeServerSSL");
        }
    }

    public void initializeClientSSL() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClientSSL");
        }
        try {
            if (!this.isServerProcess() && !this.clientSSLInitializedOnce) {
                String soapConfigURL;
                FIPSManager.getInstance().initializeFIPS();
                String sasConfigURL = System.getProperty("com.ibm.CORBA.ConfigURL");
                if (sasConfigURL != null) {
                    this.parseConfigURL("IIOP", sasConfigURL, false);
                }
                if ((soapConfigURL = System.getProperty("com.ibm.SOAP.ConfigURL")) != null) {
                    this.parseConfigURL("ADMIN_SOAP", soapConfigURL, false);
                }
                String sslConfigURL = System.getProperty("com.ibm.SSL.ConfigURL");
                this.parseSSLConfigURL(sslConfigURL, false);
                this.getDefaultSystemProperties(false);
                this.checkURLHostNameVerificationProperty(false);
                this.clientSSLInitializedOnce = true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing SSL properties from ConfigURL.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.SSLConfigManager.reinitializeClientSSL", "%c%", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeClientSSL");
        }
    }

    public void reinitializeClientSSL() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reinitializeClientSSL");
        }
        try {
            if (!this.isServerProcess()) {
                String soapConfigURL;
                FIPSManager.getInstance().initializeFIPS();
                String sasConfigURL = System.getProperty("com.ibm.CORBA.ConfigURL");
                if (sasConfigURL != null) {
                    this.parseConfigURL("IIOP", sasConfigURL, true);
                }
                if ((soapConfigURL = System.getProperty("com.ibm.SOAP.ConfigURL")) != null) {
                    this.parseConfigURL("ADMIN_SOAP", soapConfigURL, true);
                }
                String sslConfigURL = System.getProperty("com.ibm.SSL.ConfigURL");
                this.parseSSLConfigURL(sslConfigURL, true);
                this.getDefaultSystemProperties(true);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception reinitializing SSL properties from ConfigURL.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.SSLConfigManager.reinitializeClientSSL", "410", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reinitializeClientSSL");
        }
    }

    public void loadTrustManagers(SecurityConfigObject security2) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTrustManagers");
        }
        this.trustManagerArrayList.clear();
        SecurityConfigObjectList tmList = security2.getObjectList("trustManagers");
        if (tmList != null) {
            for (int i = 0; i < tmList.size(); ++i) {
                SecurityConfigObject tm = tmList.get(i);
                SecurityConfigObject scope = tm.getObject("managementScope");
                String scopeString = null;
                scopeString = scope != null ? scope.getString("scopeName") : ManagementScopeManager.getInstance().getCellScopeName();
                if (!ManagementScopeManager.getInstance().currentScopeContained(scopeString)) continue;
                String name = tm.getString("name");
                String algorithm = tm.getString("algorithm");
                String provider = tm.getString("provider");
                String customClass = tm.getString("trustManagerClass");
                Properties customClassAttributes = tm.getProperties("additionalTrustManagerAttrs");
                TrustManagerData tmData = new TrustManagerData(name, provider, algorithm, customClass, customClassAttributes, scopeString);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding trustManager name: " + name + " with values: " + tmData);
                }
                this.trustManagerArrayList.add(tmData);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTrustManagers");
        }
    }

    public void loadKeyManagers(SecurityConfigObject security2) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyManagers");
        }
        this.keyManagerArrayList.clear();
        SecurityConfigObjectList kmList = security2.getObjectList("keyManagers");
        if (kmList != null) {
            for (int i = 0; i < kmList.size(); ++i) {
                SecurityConfigObject km = kmList.get(i);
                SecurityConfigObject scope = km.getObject("managementScope");
                String scopeString = null;
                scopeString = scope != null ? scope.getString("scopeName") : ManagementScopeManager.getInstance().getCellScopeName();
                if (!ManagementScopeManager.getInstance().currentScopeContained(scopeString)) continue;
                String name = km.getString("name");
                String algorithm = km.getString("algorithm");
                String provider = km.getString("provider");
                String customClass = km.getString("keyManagerClass");
                Properties customClassAttributes = km.getProperties("additionalKeyManagerAttrs");
                KeyManagerData kmData = new KeyManagerData(name, provider, algorithm, customClass, customClassAttributes, scopeString);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding KeyManager name: " + name + " with values: " + kmData);
                }
                this.keyManagerArrayList.add(kmData);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyManagers");
        }
    }

    public TrustManagerData getTrustManagerData(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustManagerData", new Object[]{name});
        }
        for (int i = 0; i < this.trustManagerArrayList.size(); ++i) {
            TrustManagerData data = (TrustManagerData)this.trustManagerArrayList.get(i);
            if (data == null || !data.getName().equalsIgnoreCase(name) || !ManagementScopeManager.getInstance().currentScopeContained(data.getManagementScope())) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerData (" + name + ")");
            }
            return data;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustManagerData (null)");
        }
        return null;
    }

    public KeyManagerData getKeyManagerData(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyManagerData", new Object[]{name});
        }
        for (int i = 0; i < this.keyManagerArrayList.size(); ++i) {
            KeyManagerData data = (KeyManagerData)this.keyManagerArrayList.get(i);
            if (data == null || !data.getName().equalsIgnoreCase(name) || !ManagementScopeManager.getInstance().currentScopeContained(data.getManagementScope())) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerData (" + name + ")");
            }
            return data;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyManagerData (null)");
        }
        return null;
    }

    public synchronized void loadDynamicSSLSelectionInfo(SecurityConfigObject security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDynamicSSLSelectionInfo");
        }
        this.sslConfigDynamicSelectionMap.clear();
        this.sslConfigDynamicSelectionCacheMissTreeSet.clear();
        this.sslConfigDynamicLookupCache.clear();
        SecurityConfigObjectList dynamicSelections = security2.getObjectList("dynamicSSLConfigSelections");
        if (dynamicSelections != null) {
            for (int i = 0; i < dynamicSelections.size(); ++i) {
                String managementScope;
                SecurityConfigObject selection = dynamicSelections.get(i);
                if (selection == null) continue;
                SecurityConfigObject mgmtScope = selection.getObject("managementScope");
                if (mgmtScope != null && (managementScope = mgmtScope.getString("scopeName")) != null && !managementScope.equals("") && !ManagementScopeManager.getInstance().currentScopeContained(managementScope)) {
                    if (!tc.isEntryEnabled()) continue;
                    Tr.exit(tc, "Scope \"" + managementScope + "\" is out of scope for this process.");
                    continue;
                }
                String selectionInfo = selection.getString("dynamicSelectionInfo");
                String sslAlias = selection.getObject("sslConfig").getString("alias");
                String certAlias = selection.getString("certificateAlias");
                if (selectionInfo == null || sslAlias == null) continue;
                if (certAlias != null) {
                    String selectionAlias = sslAlias + ":" + certAlias;
                    this.sslConfigDynamicSelectionMap.put(selectionInfo, selectionAlias);
                    continue;
                }
                this.sslConfigDynamicSelectionMap.put(selectionInfo, sslAlias);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDynamicSSLSelectionInfo", new Object[]{this.sslConfigDynamicSelectionMap});
        }
    }

    public SSLConfig parseSSLConfig(SecurityConfigObject sslConfig, boolean reinitialize) throws Exception {
        String managementScope;
        SecurityConfigObject mgmtScope;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSSLConfig");
        }
        if (sslConfig == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parseSSLConfig -> null");
            }
            return null;
        }
        String alias = sslConfig.getString("alias");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing SSLConfig with alias: " + alias);
        }
        if ((mgmtScope = sslConfig.getObject("managementScope")) != null && (managementScope = mgmtScope.getString("scopeName")) != null && !managementScope.equals("") && !ManagementScopeManager.getInstance().currentScopeContained(managementScope)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLConfig with alias \"" + alias + "\" and scope (\"" + managementScope + "\") is not in the current process scope");
            }
            return null;
        }
        String sslType = sslConfig.getString("type", "JSSE");
        SSLConfig config = this.parseSecureSocketLayer1(alias, sslType, sslConfig.getObject("setting"), reinitialize);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSSLConfig");
        }
        return config;
    }

    public SSLConfig parseSSLConfig(com.ibm.websphere.models.config.security.SSLConfig sslConfig, boolean reinitialize) throws Exception {
        String managementScope;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSSLConfig");
        }
        if (sslConfig == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parseSSLConfig -> null");
            }
            return null;
        }
        String alias = sslConfig.getAlias();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing SSLConfig with alias: " + alias);
        }
        if (sslConfig.getManagementScope() != null && (managementScope = sslConfig.getManagementScope().getScopeName()) != null && !managementScope.equals("") && !ManagementScopeManager.getInstance().currentScopeContained(managementScope)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLConfig with alias \"" + alias + "\" and scope (\"" + managementScope + "\") is not in the current process scope");
            }
            return null;
        }
        String sslType = null;
        if (null != sslConfig.getType()) {
            sslType = sslConfig.getType().getName();
        }
        SSLConfig config = this.parseSecureSocketLayer(alias, sslType, sslConfig.getSetting(), reinitialize);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSSLConfig");
        }
        return config;
    }

    public SSLConfig parseSecureSocketLayer(String alias, String sslType, SecureSocketLayer ssl2, boolean reinitialize) throws Exception {
        String clientAuthentication;
        String sslProtocol;
        String defaultkeyManager;
        WSKeyStore[] old_wsks_list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSecureSocketLayer");
        }
        SSLConfig sslprops = new SSLConfig();
        if (ssl2 != null) {
            KeyStore wccmKS = ssl2.getKeyStore();
            WSKeyStore wsks_key = null;
            String keyStoreName = null;
            if (wccmKS != null) {
                keyStoreName = wccmKS.getName();
                wsks_key = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
            }
            Certificate signer = null;
            if (wsks_key != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding keystore properties from KeyStore object.");
                }
                sslprops.setProperty("com.ibm.ssl.keyStoreName", keyStoreName);
                this.addSSLPropertiesFromKeyStore(wsks_key, sslprops);
                signer = KeyStoreManager.getInstance().checkIfKeyStoreExistsAndCreateIfNot(wsks_key, sslprops);
                wsks_key.initializeKeyStore(reinitialize);
            }
            KeyStore wccmTS = ssl2.getTrustStore();
            WSKeyStore wsks_trust = null;
            String trustStoreName = null;
            if (wccmTS != null) {
                trustStoreName = wccmTS.getName();
                wsks_trust = KeyStoreManager.getInstance().getKeyStore(trustStoreName);
            }
            if (wsks_trust != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding truststore properties from KeyStore object.");
                }
                sslprops.setProperty("com.ibm.ssl.trustStoreName", trustStoreName);
                this.addSSLPropertiesFromTrustStore(wsks_trust, sslprops);
                KeyStoreManager.getInstance().checkIfTrustStoreExistsAndCreateIfNot(wsks_trust, sslprops, signer);
                wsks_trust.initializeKeyStore(reinitialize);
            }
        }
        if ((old_wsks_list = KeyStoreManager.getInstance().loadOldWCCMKeyStores(alias, sslType, ssl2)) != null) {
            for (int i = 0; i < old_wsks_list.length; ++i) {
                WSKeyStore ks;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key/trust store properties from old attributes.");
                }
                if ((ks = old_wsks_list[i]) != null) {
                    String name = ks.getProperty("com.ibm.ssl.keyStoreName");
                    if (name.endsWith("_trust")) {
                        sslprops.setProperty("com.ibm.ssl.trustStoreName", name);
                        this.addSSLPropertiesFromTrustStore(ks, sslprops);
                    }
                    if (name.endsWith("_key")) {
                        sslprops.setProperty("com.ibm.ssl.keyStoreName", name);
                        this.addSSLPropertiesFromKeyStore(ks, sslprops);
                    }
                }
                old_wsks_list[i].initializeKeyStore(reinitialize);
            }
        }
        KeyManager keyManager = null;
        if (ssl2 != null) {
            keyManager = ssl2.getKeyManager();
        }
        if (keyManager != null) {
            if (keyManager.getAlgorithm() != null && (keyManager.getAlgorithm().equalsIgnoreCase("IbmPKIX") || keyManager.getAlgorithm().equalsIgnoreCase("IbmX509"))) {
                String keyManagerString = null;
                keyManagerString = keyManager.getAlgorithm() != null && keyManager.getProvider() != null ? keyManager.getAlgorithm() + "|" + keyManager.getProvider() : keyManager.getAlgorithm();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting KeyManager: " + keyManagerString);
                }
                sslprops.setProperty("com.ibm.ssl.keyManager", keyManagerString);
            } else if (keyManager.getAlgorithm() != null && keyManager.getProvider() != null || keyManager.getKeyManagerClass() != null) {
                String customKeyManagerName = keyManager.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting custom KeyManager: " + customKeyManagerName);
                }
                sslprops.setProperty("com.ibm.ssl.customKeyManager", customKeyManagerName);
                String defaultkeyManager2 = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
                if (defaultkeyManager2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting default KeyManager: " + defaultkeyManager2);
                    }
                    sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager2);
                }
            } else {
                defaultkeyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
                if (defaultkeyManager != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting default KeyManager: " + defaultkeyManager);
                    }
                    sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager);
                }
            }
        } else {
            defaultkeyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
            if (defaultkeyManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting default KeyManager: " + defaultkeyManager);
                }
                sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager);
            }
        }
        EList tmList = null;
        if (ssl2 != null) {
            tmList = ssl2.getTrustManager();
        }
        if (tmList != null && tmList.size() > 0) {
            String customTrustManagerList = null;
            for (int i = 0; i < tmList.size(); ++i) {
                final TrustManager tm = (TrustManager)tmList.get(i);
                if (i == 0 && tm != null && tm.getAlgorithm() != null && (tm.getAlgorithm().equalsIgnoreCase("IbmX509") || tm.getAlgorithm().equalsIgnoreCase("IbmPKIX"))) {
                    String defaultTrustManager = null;
                    defaultTrustManager = tm.getProvider() != null ? tm.getAlgorithm() + "|" + tm.getProvider() : tm.getAlgorithm();
                    if (tm.getAlgorithm().equalsIgnoreCase("IbmPKIX")) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                EList attrs = tm.getAdditionalTrustManagerAttrs();
                                DescriptiveProperty property = null;
                                String value = null;
                                for (int j = 0; j < attrs.size(); ++j) {
                                    property = (DescriptiveProperty)attrs.get(j);
                                    value = property.getValue();
                                    if (value == null || value.equalsIgnoreCase("")) continue;
                                    if (property.getName().equals("com.ibm.jsse2.checkRevocation")) {
                                        System.setProperty("com.ibm.jsse2.checkRevocation", value);
                                        continue;
                                    }
                                    if (property.getName().equals("com.ibm.security.enableCRLDP")) {
                                        System.setProperty("com.ibm.security.enableCRLDP", value);
                                        if (System.getProperty("com.ibm.security.enableNULLCRLDP") != null) continue;
                                        System.setProperty("com.ibm.security.enableNULLCRLDP", "true");
                                        continue;
                                    }
                                    if (property.getName().equals("com.ibm.security.enableNULLCRLDP")) {
                                        System.setProperty("com.ibm.security.enableNULLCRLDP", value);
                                        continue;
                                    }
                                    if (property.getName().equals("com.ibm.security.ldap.certstore.host")) {
                                        System.setProperty("com.ibm.security.ldap.certstore.host", value);
                                        if (System.getProperty("com.ibm.security.ldap.certstore.port") != null) continue;
                                        System.setProperty("com.ibm.security.ldap.certstore.port", "389");
                                        continue;
                                    }
                                    if (property.getName().equals("com.ibm.security.ldap.certstore.port")) {
                                        System.setProperty("com.ibm.security.ldap.certstore.port", value);
                                        continue;
                                    }
                                    if (property.getName().equals("ocsp.enable")) {
                                        Security.setProperty("ocsp.enable", value);
                                        continue;
                                    }
                                    if (property.getName().equals("ocsp.responderURL")) {
                                        Security.setProperty("ocsp.responderURL", value);
                                        continue;
                                    }
                                    if (property.getName().equals("ocsp.responderCertSubjectName")) {
                                        Security.setProperty("ocsp.responderCertSubjectName", value);
                                        continue;
                                    }
                                    if (property.getName().equals("ocsp.responderCertIssuerName")) {
                                        Security.setProperty("ocsp.responderCertIssuerName", value);
                                        continue;
                                    }
                                    if (!property.getName().equals("ocsp.responderCertSerialNumber")) continue;
                                    Security.setProperty("ocsp.responderCertSerialNumber", value);
                                }
                                return null;
                            }
                        });
                        if (tc.isDebugEnabled()) {
                            this.printTrustManagerProperties();
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting TrustManager: " + defaultTrustManager);
                    }
                    sslprops.setProperty("com.ibm.ssl.trustManager", defaultTrustManager);
                    continue;
                }
                if (i <= 0 || tm == null) continue;
                customTrustManagerList = customTrustManagerList != null ? customTrustManagerList + "," + tm.getName() : tm.getName();
            }
            if (customTrustManagerList != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting custom TrustManager(s): " + customTrustManagerList);
                }
                sslprops.setProperty("com.ibm.ssl.customTrustManagers", customTrustManagerList);
            }
        } else {
            String defaultTrustManager = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
            if (defaultTrustManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting default TrustManager: " + defaultTrustManager);
                }
                sslprops.setProperty("com.ibm.ssl.trustManager", defaultTrustManager);
            }
        }
        if (ssl2 != null) {
            String enabledCiphers;
            String serverKeyAlias;
            String clientKeyAlias;
            String securityLevel;
            String clientAuthenticationSupported;
            String contextProvider;
            sslProtocol = ssl2.getSslProtocol();
            if (sslProtocol != null && !sslProtocol.equals("")) {
                sslprops.setProperty("com.ibm.ssl.protocol", sslProtocol);
            }
            if ((contextProvider = ssl2.getJsseProvider()) != null && !contextProvider.equals("")) {
                if (contextProvider.equalsIgnoreCase("IBMJSSE") || contextProvider.equalsIgnoreCase("IBMJSSEFIPS")) {
                    contextProvider = "IBMJSSE2";
                }
                sslprops.setProperty("com.ibm.ssl.contextProvider", contextProvider);
            }
            if (ssl2.isSetClientAuthentication() && (clientAuthentication = Boolean.toString(ssl2.isClientAuthentication())) != null) {
                sslprops.setProperty("com.ibm.ssl.clientAuthentication", clientAuthentication);
            }
            if ((clientAuthenticationSupported = Boolean.toString(ssl2.isClientAuthenticationSupported())) != null) {
                sslprops.setProperty("com.ibm.ssl.clientAuthenticationSupported", clientAuthenticationSupported);
            }
            if (ssl2.isSetSecurityLevel() && (securityLevel = this.getSecurityLevel(ssl2.getSecurityLevel())) != null && !securityLevel.equals("")) {
                sslprops.setProperty("com.ibm.ssl.securityLevel", securityLevel);
            }
            if ((clientKeyAlias = ssl2.getClientKeyAlias()) != null && !clientKeyAlias.equals("")) {
                sslprops.setProperty("com.ibm.ssl.keyStoreClientAlias", clientKeyAlias);
            }
            if ((serverKeyAlias = ssl2.getServerKeyAlias()) != null && !serverKeyAlias.equals("")) {
                sslprops.setProperty("com.ibm.ssl.keyStoreServerAlias", serverKeyAlias);
            }
            if ((enabledCiphers = ssl2.getEnabledCiphers()) != null && !enabledCiphers.equals("")) {
                sslprops.setProperty("com.ibm.ssl.enabledCipherSuites", enabledCiphers);
            }
            for (int j = 0; j < ssl2.getProperties().size(); ++j) {
                Property sslproperty = (Property)ssl2.getProperties().get(j);
                if (sslproperty == null || sslproperty.getValue() == null || sslproperty.getValue().equals("")) continue;
                String value = sslproperty.getValue();
                if (sslproperty.getName().equals("com.ibm.ssl.contextProvider") && (value.equalsIgnoreCase("IBMJSSE") || value.equalsIgnoreCase("IBMJSSEFIPS"))) {
                    value = "IBMJSSE2";
                }
                sslprops.setProperty(sslproperty.getName(), value);
            }
        } else {
            String enabledCiphers;
            String serverKeyAlias;
            String clientKeyAlias;
            String securityLevel;
            String clientAuthenticationSupported;
            String contextProvider;
            sslProtocol = System.getProperty("com.ibm.ssl.protocol");
            if (sslProtocol != null && !sslProtocol.equals("")) {
                sslprops.setProperty("com.ibm.ssl.protocol", sslProtocol);
            }
            if ((contextProvider = System.getProperty("com.ibm.ssl.contextProvider")) != null && !contextProvider.equals("")) {
                if (contextProvider.equalsIgnoreCase("IBMJSSE") || contextProvider.equalsIgnoreCase("IBMJSSEFIPS")) {
                    contextProvider = "IBMJSSE2";
                }
                sslprops.setProperty("com.ibm.ssl.contextProvider", contextProvider);
            }
            if ((clientAuthentication = System.getProperty("com.ibm.CSI.performTLClientAuthenticationRequired")) != null && !clientAuthentication.equals("")) {
                sslprops.setProperty("com.ibm.ssl.clientAuthentication", clientAuthentication);
            }
            if ((clientAuthenticationSupported = System.getProperty("com.ibm.CSI.performTLClientAuthenticationSupported")) != null && !clientAuthenticationSupported.equals("")) {
                sslprops.setProperty("com.ibm.ssl.clientAuthenticationSupported", clientAuthenticationSupported);
            }
            if ((securityLevel = System.getProperty("com.ibm.ssl.securityLevel")) != null && !securityLevel.equals("")) {
                sslprops.setProperty("com.ibm.ssl.securityLevel", securityLevel);
            }
            if ((clientKeyAlias = System.getProperty("com.ibm.ssl.keyStoreClientAlias")) != null && !clientKeyAlias.equals("")) {
                sslprops.setProperty("com.ibm.ssl.keyStoreClientAlias", clientKeyAlias);
            }
            if ((serverKeyAlias = System.getProperty("com.ibm.ssl.keyStoreServerAlias")) != null && !serverKeyAlias.equals("")) {
                sslprops.setProperty("com.ibm.ssl.keyStoreServerAlias", serverKeyAlias);
            }
            if ((enabledCiphers = System.getProperty("com.ibm.ssl.enabledCipherSuites")) != null && !enabledCiphers.equals("")) {
                sslprops.setProperty("com.ibm.ssl.enabledCipherSuites", enabledCiphers);
            }
        }
        if (FIPSManager.getInstance().isFIPSEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "FIPS enabled, setting SSL protocol to TLS.");
            }
            sslprops.put("com.ibm.ssl.protocol", "TLS");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Saving SSLConfig.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sslprops.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSecureSocketLayer");
        }
        return sslprops;
    }

    private void printTrustManagerProperties() {
        Tr.debug(tc, "Trust Manager Properties:");
        Tr.debug(tc, " com.ibm.jsse2.checkRevocation - " + System.getProperty("com.ibm.jsse2.checkRevocation"));
        Tr.debug(tc, " com.ibm.security.enableCRLDP - " + System.getProperty("com.ibm.security.enableCRLDP"));
        Tr.debug(tc, " com.ibm.security.enableNULLCRLDP - " + System.getProperty("com.ibm.security.enableNULLCRLDP"));
        Tr.debug(tc, " ocsp.enable - " + Security.getProperty("ocsp.enable"));
        Tr.debug(tc, " ocsp.responderURL - " + Security.getProperty("ocsp.responderURL"));
        Tr.debug(tc, " ocsp.responderCertSubjectName - " + Security.getProperty("ocsp.responderCertSubjectName"));
        Tr.debug(tc, " ocsp.responderCertIssuerName - " + Security.getProperty("ocsp.responderCertIssuerName"));
        Tr.debug(tc, " ocsp.responderCertSerialNumber - " + Security.getProperty("ocsp.responderCertSerialNumber"));
    }

    public SSLConfig parseSecureSocketLayer1(String alias, String sslType, SecurityConfigObject ssl2, boolean reinitialize) throws Exception {
        WSKeyStore[] old_wsks_list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSecureSocketLayer");
        }
        SSLConfig sslprops = new SSLConfig();
        if (ssl2 != null) {
            SecurityConfigObject wccmKS = ssl2.getObject("keyStore");
            WSKeyStore wsks_key = null;
            String keyStoreName = null;
            if (wccmKS != null) {
                keyStoreName = wccmKS.getString("name");
                wsks_key = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
            }
            Certificate signer = null;
            if (wsks_key != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding keystore properties from KeyStore object.");
                }
                sslprops.setProperty("com.ibm.ssl.keyStoreName", keyStoreName);
                this.addSSLPropertiesFromKeyStore(wsks_key, sslprops);
                signer = KeyStoreManager.getInstance().checkIfKeyStoreExistsAndCreateIfNot(wsks_key, sslprops);
                wsks_key.initializeKeyStore(reinitialize);
            }
            SecurityConfigObject wccmTS = ssl2.getObject("trustStore");
            WSKeyStore wsks_trust = null;
            String trustStoreName = null;
            if (wccmTS != null) {
                trustStoreName = wccmTS.getString("name");
                wsks_trust = KeyStoreManager.getInstance().getKeyStore(trustStoreName);
            }
            if (wsks_trust != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding truststore properties from KeyStore object.");
                }
                sslprops.setProperty("com.ibm.ssl.trustStoreName", trustStoreName);
                this.addSSLPropertiesFromTrustStore(wsks_trust, sslprops);
                KeyStoreManager.getInstance().checkIfTrustStoreExistsAndCreateIfNot(wsks_trust, sslprops, signer);
                wsks_trust.initializeKeyStore(reinitialize);
            }
        }
        if ((old_wsks_list = KeyStoreManager.getInstance().loadOldWCCMKeyStores(alias, sslType, ssl2)) != null) {
            for (int i = 0; i < old_wsks_list.length; ++i) {
                WSKeyStore ks;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key/trust store properties from old attributes.");
                }
                if ((ks = old_wsks_list[i]) != null) {
                    String name = ks.getProperty("com.ibm.ssl.keyStoreName");
                    if (name.endsWith("_trust")) {
                        sslprops.setProperty("com.ibm.ssl.trustStoreName", name);
                        this.addSSLPropertiesFromTrustStore(ks, sslprops);
                    }
                    if (name.endsWith("_key")) {
                        sslprops.setProperty("com.ibm.ssl.keyStoreName", name);
                        this.addSSLPropertiesFromKeyStore(ks, sslprops);
                    }
                }
                old_wsks_list[i].initializeKeyStore(reinitialize);
            }
        }
        SecurityConfigObject keyManager = null;
        if (ssl2 != null) {
            keyManager = ssl2.getObject("keyManager");
        }
        if (keyManager != null) {
            String algorithm = keyManager.getString("algorithm");
            String provider = keyManager.getString("provider");
            if (algorithm != null && (algorithm.equalsIgnoreCase("IbmPKIX") || algorithm.equalsIgnoreCase("IbmX509"))) {
                String keyManagerString = null;
                keyManagerString = algorithm != null && provider != null ? algorithm + "|" + provider : algorithm;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting KeyManager: " + keyManagerString);
                }
                sslprops.setProperty("com.ibm.ssl.keyManager", keyManagerString);
            } else if (algorithm != null && provider != null || keyManager.getString("keyManagerClass") != null) {
                String customKeyManagerName = keyManager.getString("name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting custom KeyManager: " + customKeyManagerName);
                }
                sslprops.setProperty("com.ibm.ssl.customKeyManager", customKeyManagerName);
                String defaultkeyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
                if (defaultkeyManager != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting default KeyManager: " + defaultkeyManager);
                    }
                    sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager);
                }
            } else {
                String defaultkeyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
                if (defaultkeyManager != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting default KeyManager: " + defaultkeyManager);
                    }
                    sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager);
                }
            }
        } else {
            String defaultkeyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
            if (defaultkeyManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting default KeyManager: " + defaultkeyManager);
                }
                sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager);
            }
        }
        SecurityConfigObjectList tmList = null;
        if (ssl2 != null) {
            tmList = ssl2.getObjectList("trustManager");
        }
        if (tmList != null && tmList.size() > 0) {
            String customTrustManagerList = null;
            for (int i = 0; i < tmList.size(); ++i) {
                final SecurityConfigObject tm = tmList.get(i);
                String algorithm = tm.getString("algorithm");
                if (i == 0 && tm != null && algorithm != null && (algorithm.equalsIgnoreCase("IbmX509") || algorithm.equalsIgnoreCase("IbmPKIX"))) {
                    String defaultTrustManager = null;
                    defaultTrustManager = tm.getString("provider") != null ? algorithm + "|" + tm.getString("provider") : algorithm;
                    if (algorithm.equalsIgnoreCase("IbmPKIX")) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                SecurityConfigObjectList attrs = tm.getObjectList("additionalTrustManagerAttrs");
                                SecurityConfigObject property = null;
                                String value = null;
                                for (int j = 0; j < attrs.size(); ++j) {
                                    property = attrs.get(j);
                                    value = property.getString("value");
                                    if (value == null || value.equalsIgnoreCase("")) continue;
                                    if (property.getString("name").equals("com.ibm.jsse2.checkRevocation")) {
                                        System.setProperty("com.ibm.jsse2.checkRevocation", value);
                                        continue;
                                    }
                                    if (property.getString("name").equals("com.ibm.security.enableCRLDP")) {
                                        System.setProperty("com.ibm.security.enableCRLDP", value);
                                        if (System.getProperty("com.ibm.security.enableNULLCRLDP") != null) continue;
                                        System.setProperty("com.ibm.security.enableNULLCRLDP", "true");
                                        continue;
                                    }
                                    if (property.getString("name").equals("com.ibm.security.enableNULLCRLDP")) {
                                        System.setProperty("com.ibm.security.enableNULLCRLDP", value);
                                        continue;
                                    }
                                    if (property.getString("name").equals("ocsp.enable")) {
                                        Security.setProperty("ocsp.enable", value);
                                        continue;
                                    }
                                    if (property.getString("name").equals("ocsp.responderURL")) {
                                        Security.setProperty("ocsp.responderURL", value);
                                        continue;
                                    }
                                    if (property.getString("name").equals("ocsp.responderCertSubjectName")) {
                                        Security.setProperty("ocsp.responderCertSubjectName", value);
                                        continue;
                                    }
                                    if (property.getString("name").equals("ocsp.responderCertIssuerName")) {
                                        Security.setProperty("ocsp.responderCertIssuerName", value);
                                        continue;
                                    }
                                    if (!property.getString("name").equals("ocsp.responderCertSerialNumber")) continue;
                                    Security.setProperty("ocsp.responderCertSerialNumber", value);
                                }
                                return null;
                            }
                        });
                        if (tc.isDebugEnabled()) {
                            this.printTrustManagerProperties();
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting TrustManager: " + defaultTrustManager);
                    }
                    sslprops.setProperty("com.ibm.ssl.trustManager", defaultTrustManager);
                    continue;
                }
                if (i <= 0 || tm == null) continue;
                customTrustManagerList = customTrustManagerList != null ? customTrustManagerList + "," + tm.getString("name") : tm.getString("name");
            }
            if (customTrustManagerList != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting custom TrustManager(s): " + customTrustManagerList);
                }
                sslprops.setProperty("com.ibm.ssl.customTrustManagers", customTrustManagerList);
            }
        } else {
            String defaultTrustManager = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
            if (defaultTrustManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting default TrustManager: " + defaultTrustManager);
                }
                sslprops.setProperty("com.ibm.ssl.trustManager", defaultTrustManager);
            }
        }
        if (ssl2 != null) {
            String enabledCiphers;
            String serverKeyAlias;
            String clientKeyAlias;
            String securityLevel;
            String clientAuthenticationSupported;
            String clientAuthentication;
            String contextProvider;
            String sslProtocol = ssl2.getString("sslProtocol");
            if (sslProtocol != null && !sslProtocol.equals("")) {
                sslprops.setProperty("com.ibm.ssl.protocol", sslProtocol);
            }
            if ((contextProvider = ssl2.getString("jsseProvider")) != null && !contextProvider.equals("")) {
                if (contextProvider.equalsIgnoreCase("IBMJSSE") || contextProvider.equalsIgnoreCase("IBMJSSEFIPS")) {
                    contextProvider = "IBMJSSE2";
                }
                sslprops.setProperty("com.ibm.ssl.contextProvider", contextProvider);
            }
            if (ssl2.isSet("clientAuthentication") && (clientAuthentication = ssl2.getBoolean("clientAuthentication").toString()) != null) {
                sslprops.setProperty("com.ibm.ssl.clientAuthentication", clientAuthentication);
            }
            if ((clientAuthenticationSupported = ssl2.getBoolean("clientAuthenticationSupported").toString()) != null) {
                sslprops.setProperty("com.ibm.ssl.clientAuthenticationSupported", clientAuthenticationSupported);
            }
            if (ssl2.isSet("securityLevel") && (securityLevel = ssl2.getString("securityLevel", "HIGH")) != null && !securityLevel.equals("")) {
                sslprops.setProperty("com.ibm.ssl.securityLevel", securityLevel);
            }
            if ((clientKeyAlias = ssl2.getString("clientKeyAlias")) != null && !clientKeyAlias.equals("")) {
                sslprops.setProperty("com.ibm.ssl.keyStoreClientAlias", clientKeyAlias);
            }
            if ((serverKeyAlias = ssl2.getString("serverKeyAlias")) != null && !serverKeyAlias.equals("")) {
                sslprops.setProperty("com.ibm.ssl.keyStoreServerAlias", serverKeyAlias);
            }
            if ((enabledCiphers = ssl2.getString("enabledCiphers")) != null && !enabledCiphers.equals("")) {
                sslprops.setProperty("com.ibm.ssl.enabledCipherSuites", enabledCiphers);
            }
            SecurityConfigObjectList props = ssl2.getObjectList("properties");
            for (int j = 0; j < props.size(); ++j) {
                String value;
                SecurityConfigObject sslproperty = props.get(j);
                if (sslproperty == null || (value = sslproperty.getString("value")) == null || value.equals("")) continue;
                String name = sslproperty.getString("name");
                if (name.equals("com.ibm.ssl.contextProvider") && (value.equalsIgnoreCase("IBMJSSE") || value.equalsIgnoreCase("IBMJSSEFIPS"))) {
                    value = "IBMJSSE2";
                }
                sslprops.setProperty(name, value);
            }
        }
        if (FIPSManager.getInstance().isFIPSEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "FIPS enabled, setting SSL protocol to TLS.");
            }
            sslprops.put("com.ibm.ssl.protocol", "TLS");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Saving SSLConfig.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sslprops.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSecureSocketLayer");
        }
        return sslprops;
    }

    public void addSSLPropertiesFromKeyStore(WSKeyStore wsks, SSLConfig sslprops) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSSLPropertiesFromKeyStore");
        }
        Enumeration<?> e = wsks.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            String value = wsks.getProperty(property);
            sslprops.setProperty(property, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSSLPropertiesFromKeyStore");
        }
    }

    public void addSSLPropertiesFromTrustStore(WSKeyStore wsts, SSLConfig sslprops) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSSLPropertiesFromTrustStore");
        }
        Enumeration<?> e = wsts.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            String value = wsts.getProperty(property);
            String trustManagerProperty = null;
            if (property.startsWith("com.ibm.ssl.keyStore")) {
                int index = property.indexOf("com.ibm.ssl.keyStore");
                String lastPart = null;
                if (index + "com.ibm.ssl.keyStore".length() < property.length()) {
                    lastPart = property.substring(index + "com.ibm.ssl.keyStore".length());
                }
                trustManagerProperty = lastPart != null ? "com.ibm.ssl.trustStore" + lastPart : "com.ibm.ssl.trustStore";
            }
            if (trustManagerProperty == null || value == null) continue;
            sslprops.setProperty(trustManagerProperty, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSSLPropertiesFromKeyStore");
        }
    }

    public String[] getSSLConfigAliases() {
        return this.sslConfigMap.keySet().toArray(new String[0]);
    }

    public SSLConfig getSSLConfig(String alias) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLConfig", alias);
        }
        if (alias == null || alias.equals("")) {
            return this.getDefaultSSLConfig();
        }
        SSLConfig ssl2 = (SSLConfig)this.sslConfigMap.get(alias);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLConfig", ssl2);
        }
        return ssl2;
    }

    public void loadGlobalProperties(SecurityConfigObject security2) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadGlobalProperties");
        }
        this.globalConfigProperties.clear();
        SecurityConfigObjectList globalConfigList = security2.getObjectList("properties");
        if (this.globalConfigProperties != null && globalConfigList != null) {
            for (int i = 0; i < globalConfigList.size(); ++i) {
                SecurityConfigObject p = globalConfigList.get(i);
                String name = p.getString("name");
                if (!name.startsWith("com.ibm.ssl") && !name.startsWith("com.ibm.security") && !name.startsWith("was.com.ibm.websphere.security.zos.csiv2")) continue;
                String value = null;
                value = name.equals("com.ibm.ssl.defaultCertReqSubjectDN") ? p.getUnexpandedString("value") : p.getString("value");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting global property: " + name + "=" + value);
                }
                this.globalConfigProperties.setProperty(name, value);
            }
        }
        this.loadCSIv2SSLProperties(security2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadGlobalProperties");
        }
    }

    public void loadCSIv2SSLProperties(SecurityConfigObject security2) {
        SecurityConfigObject csiv2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCSIv2SSLProperties");
        }
        if ((csiv2 = security2.getObject("CSI")) != null) {
            SecurityConfigObject claimCSI = csiv2.getObject("claims");
            SecurityConfigObjectList layers = claimCSI.getObjectList("layers");
            SecurityConfigObject csiv2ClaimIIOPTransportLayer = null;
            for (int i = 0; i < layers.size(); ++i) {
                SecurityConfigObject layer = layers.get(i);
                if (!layer.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi", "TransportLayer")) continue;
                csiv2ClaimIIOPTransportLayer = layer;
                break;
            }
            if (csiv2ClaimIIOPTransportLayer != null) {
                SecurityConfigObject csiv2ClaimTransportQOPSupported = csiv2ClaimIIOPTransportLayer.getObject("supportedQOP");
                if (csiv2ClaimTransportQOPSupported.getBoolean("enableProtection").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "false");
                }
                if (csiv2ClaimTransportQOPSupported.getBoolean("establishTrustInClient").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationSupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationSupported", "false");
                }
                if (csiv2ClaimTransportQOPSupported.getBoolean("integrity").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegritySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegritySupported", "false");
                }
                if (csiv2ClaimTransportQOPSupported.getBoolean("confidentiality").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialitySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialitySupported", "false");
                }
                SecurityConfigObject csiv2ClaimTransportQOPRequired = csiv2ClaimIIOPTransportLayer.getObject("requiredQOP");
                if (csiv2ClaimTransportQOPRequired.getBoolean("enableProtection").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "false");
                }
                if (csiv2ClaimTransportQOPRequired.getBoolean("establishTrustInClient").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationRequired", "false");
                }
                if (csiv2ClaimTransportQOPRequired.getBoolean("integrity").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegrityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegrityRequired", "false");
                }
                if (csiv2ClaimTransportQOPRequired.getBoolean("confidentiality").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialityRequired", "false");
                }
                SecurityConfigObject csiv2ClaimIIOPTransportSSLServerAuth = csiv2ClaimIIOPTransportLayer.getObject("serverAuthentication");
                String sslAlias = null;
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    sslAlias = this.globalConfigProperties.getProperty("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig");
                }
                if (sslAlias == null) {
                    sslAlias = csiv2ClaimIIOPTransportSSLServerAuth.getString("sslConfig");
                }
                if (sslAlias != null) {
                    this.globalConfigProperties.setProperty("com.ibm.ssl.csi.inbound.alias", sslAlias);
                }
            }
            SecurityConfigObject performCSI = csiv2.getObject("performs");
            layers = performCSI.getObjectList("layers");
            SecurityConfigObject csiv2PerformIIOPTransportLayer = null;
            for (int i = 0; i < layers.size(); ++i) {
                SecurityConfigObject layer = layers.get(i);
                if (!layer.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi", "TransportLayer")) continue;
                csiv2PerformIIOPTransportLayer = layer;
                break;
            }
            if (csiv2PerformIIOPTransportLayer != null) {
                SecurityConfigObject csiv2PerformTransportQOPSupported = csiv2PerformIIOPTransportLayer.getObject("supportedQOP");
                if (csiv2PerformTransportQOPSupported.getBoolean("enableProtection").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported", "false");
                }
                if (csiv2PerformTransportQOPSupported.getBoolean("integrity").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegritySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegritySupported", "false");
                }
                if (csiv2PerformTransportQOPSupported.getBoolean("confidentiality").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialitySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialitySupported", "false");
                }
                if (csiv2PerformTransportQOPSupported.getBoolean("establishTrustInClient").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTLClientAuthenticationSupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTLClientAuthenticationSupported", "false");
                }
                SecurityConfigObject csiv2PerformTransportQOPRequired = csiv2PerformIIOPTransportLayer.getObject("requiredQOP");
                if (csiv2PerformTransportQOPRequired.getBoolean("enableProtection").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired", "false");
                }
                if (csiv2PerformTransportQOPRequired.getBoolean("integrity").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegrityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegrityRequired", "false");
                }
                if (csiv2PerformTransportQOPRequired.getBoolean("confidentiality").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialityRequired", "false");
                }
                if (csiv2PerformTransportQOPRequired.getBoolean("establishTrustInClient").booleanValue()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTLClientAuthenticationRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTLClientAuthenticationRequired", "false");
                }
                SecurityConfigObject csiv2PerformIIOPTransportSSLServerAuth = csiv2PerformIIOPTransportLayer.getObject("serverAuthentication");
                String sslAlias = null;
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    sslAlias = this.globalConfigProperties.getProperty("was.com.ibm.websphere.security.zos.csiv2.outbound.transport.sslconfig");
                }
                if (sslAlias == null) {
                    sslAlias = csiv2PerformIIOPTransportSSLServerAuth.getString("sslConfig");
                }
                if (sslAlias != null) {
                    this.globalConfigProperties.setProperty("com.ibm.ssl.csi.outbound.alias", sslAlias);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCSIv2SSLProperties");
        }
    }

    public Properties determineIfCSIv2SettingsApply(Properties config, Map connectionInfo) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineIfCSIv2SettingsApply", new Object[]{connectionInfo});
        }
        Properties newConfig = null;
        if (connectionInfo != null) {
            String endPointName = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            String direction = (String)connectionInfo.get("com.ibm.ssl.direction");
            if (endPointName != null && (endPointName.equals("ORB_SSL_LISTENER_ADDRESS") || endPointName.equals("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS") || endPointName.equals("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS")) && direction != null && direction.equals("inbound")) {
                String sslAlias = this.globalConfigProperties.getProperty("com.ibm.ssl.csi.inbound.alias");
                if (sslAlias != null && sslAlias.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting inbound SSL config with alias: " + sslAlias);
                    }
                    newConfig = this.getProperties(sslAlias);
                }
                if (newConfig != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning CSIv2 alias reference configuration.");
                    }
                    newConfig = (Properties)newConfig.clone();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning JSSEHelper configuration.");
                    }
                    newConfig = (Properties)config.clone();
                }
                if (newConfig != null) {
                    String claimSSLClientAuthSupported = this.globalConfigProperties.getProperty("com.ibm.CSI.claimTLClientAuthenticationSupported");
                    String claimSSLClientAuthRequired = this.globalConfigProperties.getProperty("com.ibm.CSI.claimTLClientAuthenticationRequired");
                    if (claimSSLClientAuthSupported != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting client auth supported: " + claimSSLClientAuthSupported);
                        }
                        newConfig.setProperty("com.ibm.ssl.clientAuthenticationSupported", claimSSLClientAuthSupported);
                    }
                    if (claimSSLClientAuthRequired != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting client auth required: " + claimSSLClientAuthRequired);
                        }
                        newConfig.setProperty("com.ibm.ssl.clientAuthentication", claimSSLClientAuthRequired);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "determineIfCSIv2SettingsApply (settings applied)");
                    }
                    return newConfig;
                }
            } else if ("IIOP".equals(endPointName) && "outbound".equals(direction)) {
                String sslAlias = this.globalConfigProperties.getProperty("com.ibm.ssl.csi.outbound.alias");
                if (sslAlias != null && sslAlias.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting outbound SSL config with alias: " + sslAlias);
                    }
                    newConfig = this.getProperties(sslAlias);
                }
                if (newConfig != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning CSIv2 alias reference configuration.");
                    }
                    newConfig = (Properties)newConfig.clone();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning JSSEHelper configuration.");
                    }
                    newConfig = (Properties)config.clone();
                }
                if (newConfig != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "determineIfCSIv2SettingsApply (settings applied)");
                    }
                    return newConfig;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineIfCSIv2SettingsApply (original settings)");
        }
        return config;
    }

    public Properties getDefaultSystemProperties(boolean reinitialize) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSystemProperties");
        }
        if (!reinitialize && this.sslConfigMap.get("DefaultSystemProperties") != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultSystemProperties -> already present.");
            }
            return (Properties)this.sslConfigMap.get("DefaultSystemProperties");
        }
        SSLConfig config = this.parseSecureSocketLayer("DefaultSystemProperties", "JSSE", null, reinitialize);
        if (config != null && config.requiredPropertiesArePresent()) {
            config.setProperty("com.ibm.ssl.alias", "DefaultSystemProperties");
            config.setProperty("com.ibm.ssl.configURLLoadedFrom", "System Properties");
            config.decodePasswords();
            SSLConfig oldConfig = (SSLConfig)this.sslConfigMap.get("DefaultSystemProperties");
            if (oldConfig == null) {
                this.addSSLConfigToMap("DefaultSystemProperties", config);
            } else if (!oldConfig.equals(config)) {
                this.removeSSLConfigFromMap("DefaultSystemProperties", oldConfig);
                this.addSSLConfigToMap("DefaultSystemProperties", config);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New SSL config equals old SSL config for alias: DefaultSystemProperties");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultSystemProperties -> found valid system properties");
            }
            return config;
        }
        this.setDefaultSystemPropertiesIfNecessary();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSystemProperties -> null");
        }
        return null;
    }

    public void setDefaultSystemPropertiesIfNecessary() {
        SSLConfig systemPropertyConfig;
        String defaultSSLSocketFactory = JSSEProviderFactory.getDefaultSSLSocketFactory();
        String defaultSSLServerSocketFactory = JSSEProviderFactory.getDefaultSSLServerSocketFactory();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultSystemPropertiesIfNecessary", new Object[]{defaultSSLSocketFactory, defaultSSLServerSocketFactory});
        }
        if ((defaultSSLSocketFactory != null && defaultSSLSocketFactory.equals("com.ibm.jsse2.SSLSocketFactoryImpl") || defaultSSLServerSocketFactory != null && defaultSSLServerSocketFactory.equals("com.ibm.jsse2.SSLServerSocketFactoryImpl")) && (systemPropertyConfig = (SSLConfig)this.sslConfigMap.get("DefaultSystemProperties")) == null && (systemPropertyConfig = this.getDefaultSSLConfig()) != null) {
            final SSLConfig systemPropertyConfigFinal = systemPropertyConfig;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String keyStoreName = systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStoreName");
                    WSKeyStore wsks = null;
                    if (keyStoreName != null) {
                        wsks = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
                    }
                    if (wsks != null && wsks.getProperty("com.ibm.ssl.keyStore") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStore") != null) {
                        System.setProperty("javax.net.ssl.keyStore", wsks != null ? wsks.getProperty("com.ibm.ssl.keyStore") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStore"));
                    }
                    if (wsks != null && wsks.getProperty("com.ibm.ssl.keyStorePassword") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStorePassword") != null) {
                        System.setProperty("javax.net.ssl.keyStorePassword", wsks != null ? wsks.getProperty("com.ibm.ssl.keyStorePassword") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStorePassword"));
                    }
                    if (wsks != null && wsks.getProperty("com.ibm.ssl.keyStoreType") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStoreType") != null) {
                        System.setProperty("javax.net.ssl.keyStoreType", wsks != null ? wsks.getProperty("com.ibm.ssl.keyStoreType") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStoreType"));
                    }
                    if (wsks != null && wsks.getProperty("com.ibm.ssl.keyStoreProvider") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStoreProvider") != null) {
                        System.setProperty("javax.net.ssl.keyStoreProvider", wsks != null ? wsks.getProperty("com.ibm.ssl.keyStoreProvider") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.keyStoreProvider"));
                    }
                    String trustStoreName = systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStoreName");
                    WSKeyStore wsts = null;
                    if (trustStoreName != null) {
                        wsts = KeyStoreManager.getInstance().getKeyStore(trustStoreName);
                    }
                    if (wsts != null && wsts.getProperty("com.ibm.ssl.keyStore") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStore") != null) {
                        System.setProperty("javax.net.ssl.trustStore", wsts != null ? wsts.getProperty("com.ibm.ssl.keyStore") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStore"));
                    }
                    if (wsts != null && wsts.getProperty("com.ibm.ssl.keyStorePassword") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStorePassword") != null) {
                        System.setProperty("javax.net.ssl.trustStorePassword", wsts != null ? wsts.getProperty("com.ibm.ssl.keyStorePassword") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStorePassword"));
                    }
                    if (wsts != null && wsts.getProperty("com.ibm.ssl.keyStoreType") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStoreType") != null) {
                        System.setProperty("javax.net.ssl.trustStoreType", wsts != null ? wsts.getProperty("com.ibm.ssl.keyStoreType") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStoreType"));
                    }
                    if (wsts != null && wsts.getProperty("com.ibm.ssl.keyStoreProvider") != null || systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStoreProvider") != null) {
                        System.setProperty("javax.net.ssl.trustStoreProvider", wsts != null ? wsts.getProperty("com.ibm.ssl.keyStoreProvider") : systemPropertyConfigFinal.getProperty("com.ibm.ssl.trustStoreProvider"));
                    }
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set System JSSE properties using the following SSL config: " + systemPropertyConfig.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultSystemPropertiesIfNecessary");
        }
    }

    public SSLConfig getDefaultSSLConfig() throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSSLConfig");
        }
        SSLConfig defaultSSLConfig = null;
        String defaultAlias = this.getGlobalProperty("com.ibm.ssl.defaultAlias");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "defaultAlias: " + defaultAlias);
        }
        if (defaultAlias != null && (defaultSSLConfig = (SSLConfig)this.sslConfigMap.get(defaultAlias)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "defaultAlias not null, getDefaultSSLConfig for: " + defaultAlias);
            }
            return defaultSSLConfig;
        }
        if (defaultSSLConfig == null) {
            String mapKey;
            SSLConfig mapValue;
            String processType = ManagementScopeManager.getInstance().getProcessType();
            if (processType.equals("DeploymentManager")) {
                for (Map.Entry current : this.sslConfigMap.entrySet()) {
                    mapValue = (SSLConfig)current.getValue();
                    mapKey = (String)current.getKey();
                    if (mapValue == null) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDefaultSSLConfig: " + mapKey);
                    }
                    if (!mapKey.equals("CellDefaultSSLSettings")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "defaultSSLConfig: " + mapValue.toString());
                    }
                    return mapValue;
                }
            } else {
                for (Map.Entry current : this.sslConfigMap.entrySet()) {
                    mapValue = (SSLConfig)current.getValue();
                    mapKey = (String)current.getKey();
                    if (mapValue == null) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDefaultSSLConfig: " + mapKey);
                    }
                    if (!mapKey.equals("NodeDefaultSSLSettings")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "defaultSSLConfig: " + mapValue.toString());
                    }
                    return mapValue;
                }
            }
        }
        if (defaultSSLConfig == null) {
            String trustStoreProvider;
            String trustStoreType;
            String trustStorePassword;
            String trustStoreLocation;
            String keyStoreProvider;
            String keyStoreType;
            String keyStorePassword;
            String sslConfigAlias = "DefaultSystemProperties";
            SSLConfig defaultSystemConfig = new SSLConfig();
            defaultSystemConfig.setProperty("com.ibm.ssl.alias", sslConfigAlias);
            String keyStoreLocation = System.getProperty("javax.net.ssl.keyStore");
            if (keyStoreLocation != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.keyStore", keyStoreLocation);
            }
            if ((keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
            }
            if ((keyStoreType = System.getProperty("javax.net.ssl.keyStoreType")) != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.keyStoreType", keyStoreType);
            }
            if ((keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider")) != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.keyStoreProvider", keyStoreProvider);
            }
            if ((trustStoreLocation = System.getProperty("javax.net.ssl.trustStore")) != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.trustStore", trustStoreLocation);
            }
            if ((trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.trustStorePassword", trustStorePassword);
            }
            if ((trustStoreType = System.getProperty("javax.net.ssl.trustStoreType")) != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.trustStoreType", trustStoreType);
            }
            if ((trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider")) != null) {
                defaultSystemConfig.setProperty("com.ibm.ssl.trustStoreProvider", trustStoreProvider);
            }
            try {
                if (defaultSystemConfig.requiredPropertiesArePresent()) {
                    this.addSSLConfigToMap(sslConfigAlias, defaultSystemConfig);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception adding default System properties to configuration.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.SSLConfigManager.getDefaultSSLConfig", "2058", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSSLConfig -> null");
        }
        return null;
    }

    public Properties getPropertiesFromDynamicSelectionInfo(Map connectionInfo) {
        SSLConfig oldSOAPConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesFromDynamicSelectionInfo", new Object[]{connectionInfo});
        }
        if (connectionInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (no connection info)");
            }
            return null;
        }
        if (this.sslConfigDynamicSelectionMap.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (no dynamic selections configured)");
            }
            return null;
        }
        if (this.sslConfigDynamicSelectionCacheMissTreeSet.contains(connectionInfo)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> previous cache miss.");
            }
            return null;
        }
        SSLConfig cachedConfig = (SSLConfig)this.sslConfigDynamicLookupCache.get(connectionInfo);
        if (cachedConfig != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> cached.");
            }
            return cachedConfig;
        }
        String direction = (String)connectionInfo.get("com.ibm.ssl.direction");
        if (direction != null && direction.equals("inbound")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (direction inbound).");
            }
            return null;
        }
        String connInfoProtocolName = (String)connectionInfo.get("com.ibm.ssl.endPointName");
        String connInfoRemoteHost = (String)connectionInfo.get("com.ibm.ssl.remoteHost");
        String connInfoRemotePort = (String)connectionInfo.get("com.ibm.ssl.remotePort");
        if (connInfoProtocolName != null && connInfoProtocolName.equals("ADMIN_SOAP") && (oldSOAPConfig = this.getSSLConfig("ADMIN_SOAP")) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> returning old soap config.");
            }
            this.sslConfigDynamicLookupCache.put(connectionInfo, oldSOAPConfig);
            return oldSOAPConfig;
        }
        Set sslConfigDynamicSelectionSet = this.sslConfigDynamicSelectionMap.keySet();
        Iterator sslConfigDynamicSelectionIterator = null;
        if (sslConfigDynamicSelectionSet != null && sslConfigDynamicSelectionSet.size() > 0) {
            sslConfigDynamicSelectionIterator = sslConfigDynamicSelectionSet.iterator();
        }
        if (sslConfigDynamicSelectionIterator != null) {
            while (sslConfigDynamicSelectionIterator.hasNext()) {
                String[] dynamicSelectionEntries;
                String dynamicSelectionInfo = (String)sslConfigDynamicSelectionIterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfig dynamic selection info: " + dynamicSelectionInfo);
                }
                if (dynamicSelectionInfo == null || (dynamicSelectionEntries = dynamicSelectionInfo.split("\\|")) == null || dynamicSelectionEntries.length <= 0) continue;
                for (int j = 0; j < dynamicSelectionEntries.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Parsing entry " + j + " of " + dynamicSelectionEntries.length + ": " + dynamicSelectionEntries[j]);
                    }
                    String[] dynamicSelectionAttributes = dynamicSelectionEntries[j].split(",");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This entry has " + dynamicSelectionAttributes.length + " attributes.");
                    }
                    if (dynamicSelectionAttributes == null || dynamicSelectionAttributes.length != 3) continue;
                    String protocol = dynamicSelectionAttributes[0];
                    String host = dynamicSelectionAttributes[1];
                    String port = dynamicSelectionAttributes[2];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Protocol: " + protocol + ", Host: " + host + ", Port: " + port);
                    }
                    if (protocol == null || host == null || port == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Ending evaluation, one of the values is null.");
                        continue;
                    }
                    if (!(protocol.equals("*") || connInfoProtocolName != null && protocol.equalsIgnoreCase(connInfoProtocolName))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Protocol does not match.");
                        continue;
                    }
                    if (!(host.equals("*") || connInfoRemoteHost != null && connInfoRemoteHost.equalsIgnoreCase(host) && connInfoRemoteHost.toLowerCase().endsWith(host.toLowerCase()))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Host does not match.");
                        continue;
                    }
                    if (!(port.equals("*") || connInfoRemotePort != null && port.equalsIgnoreCase(connInfoRemotePort))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Port does not match.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found a dynamic selection match!");
                    }
                    String sslAliasAndCert = (String)this.sslConfigDynamicSelectionMap.get(dynamicSelectionInfo);
                    String sslAlias = null;
                    String sslCert = null;
                    if (sslAliasAndCert != null && sslAliasAndCert.indexOf(":") != -1) {
                        String[] split = sslAliasAndCert.split(":");
                        if (split != null && split.length == 2) {
                            sslAlias = split[0];
                            sslCert = split[1];
                        }
                    } else if (sslAliasAndCert != null) {
                        sslAlias = sslAliasAndCert;
                    }
                    SSLConfig config = (SSLConfig)this.sslConfigMap.get(sslAlias);
                    if (config != null) {
                        String clientAlias;
                        if (!(sslCert == null || (clientAlias = config.getProperty("com.ibm.ssl.keyStoreClientAlias")) != null && clientAlias.equals(sslAlias))) {
                            config = new SSLConfig(config);
                            config.setProperty("com.ibm.ssl.keyStoreClientAlias", sslCert);
                        }
                        this.sslConfigDynamicLookupCache.put(connectionInfo, config);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> found.");
                        }
                        return config;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Could not find the associated SSL configuration.");
                }
            }
        }
        if (this.sslConfigDynamicSelectionCacheMissTreeSet.size() > 50) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache miss tree set size is > 50, clearing the TreeSet.");
            }
            this.sslConfigDynamicSelectionCacheMissTreeSet.clear();
        }
        this.sslConfigDynamicSelectionCacheMissTreeSet.add(connectionInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache miss tree set size is " + this.sslConfigDynamicSelectionCacheMissTreeSet.size() + " entries.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (not found).");
        }
        return null;
    }

    public Properties getProperties(String alias) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", alias);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties");
        }
        return this.getSSLConfig(alias);
    }

    public String getGlobalProperty(String name) {
        String value = null;
        if (this.globalConfigProperties != null) {
            value = System.getProperty(name);
            if (value == null) {
                value = this.globalConfigProperties.getProperty(name);
            }
            if (tc.isDebugEnabled() && value != null) {
                Tr.debug(tc, "getGlobalProperties -> " + value);
            }
            return value;
        }
        value = System.getProperty(name);
        if (tc.isDebugEnabled() && value != null) {
            Tr.debug(tc, "getGlobalProperties -> " + value);
        }
        return value;
    }

    public String getGlobalProperty(String name, String defaultValue) {
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalProperty", new Object[]{name, defaultValue});
        }
        if ((value = this.getGlobalProperty(name)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGlobalProperty -> " + defaultValue);
            }
            return defaultValue;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalProperty -> " + value);
        }
        return value;
    }

    public String[] parseEnabledCiphers(String enabledCiphers) {
        if (enabledCiphers != null) {
            return enabledCiphers.split("\\s");
        }
        return null;
    }

    public String[] adjustSupportedCiphersToSecurityLevel(String[] supportedCiphers, String securityLevel) {
        return Constants.adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
    }

    public String convertCipherListToString(String[] cipherList) {
        if (cipherList == null || cipherList.length == 0) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cipherList.length; ++i) {
            sb.append(cipherList[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getSecurityLevel(SSLSecurityLevel level) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityLevel");
        }
        int value = level.getValue();
        String securityLevel = null;
        switch (value) {
            case 2: {
                securityLevel = "LOW";
                break;
            }
            case 1: {
                securityLevel = "MEDIUM";
                break;
            }
            case 3: {
                securityLevel = "CUSTOM";
                break;
            }
            default: {
                securityLevel = "HIGH";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityLevel -> " + securityLevel);
        }
        return securityLevel;
    }

    public static String mask(String inString) {
        String outString = null;
        if (inString != null) {
            char[] outStringBuffer = new char[inString.length()];
            for (int i = 0; i < inString.length(); ++i) {
                outStringBuffer[i] = 42;
            }
            outString = new String(outStringBuffer);
        }
        return outString;
    }

    public void parseConfigURL(String defaultAlias, String configURL, boolean reinitialize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseConfigURL", new Object[]{configURL});
        }
        if (configURL != null && (!this.clientFilesAlreadyProcessed.contains(configURL) || reinitialize)) {
            try {
                SSLConfig oldConfig;
                SSLConfig sslConfig = new SSLConfig(configURL);
                String alias = sslConfig.getProperty("com.ibm.ssl.alias");
                if (alias == null) {
                    alias = defaultAlias;
                    sslConfig.setProperty("com.ibm.ssl.alias", alias);
                }
                if (configURL.indexOf("soap.client.props") != -1) {
                    if (sslConfig.getProperty("com.ibm.ssl.keyStoreType") == null) {
                        sslConfig.setProperty("com.ibm.ssl.keyStoreType", "JKS");
                    }
                    if (sslConfig.getProperty("com.ibm.ssl.trustStoreType") == null) {
                        sslConfig.setProperty("com.ibm.ssl.trustStoreType", "JKS");
                    }
                }
                if (configURL.indexOf("sas.client.props") != -1) {
                    this.globalConfigProperties.put("com.ibm.CSI.performTLClientAuthenticationRequired", sslConfig.getProperty("com.ibm.CSI.performTLClientAuthenticationRequired"));
                    this.globalConfigProperties.put("com.ibm.CSI.performTLClientAuthenticationSupported", sslConfig.getProperty("com.ibm.CSI.performTLClientAuthenticationSupported"));
                }
                if (sslConfig.requiredPropertiesArePresent()) {
                    sslConfig.setProperty("com.ibm.ssl.configURLLoadedFrom", configURL);
                    sslConfig.decodePasswords();
                    if (reinitialize) {
                        SSLConfig oldConfig2 = (SSLConfig)this.sslConfigMap.get(alias);
                        if (oldConfig2 == null) {
                            this.addSSLConfigToMap(alias, sslConfig);
                        } else if (!oldConfig2.equals(sslConfig)) {
                            this.removeSSLConfigFromMap(alias, sslConfig);
                            this.addSSLConfigToMap(alias, sslConfig);
                            this.notifySSLConfigChangeListener(alias, "changed");
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New SSL config equals old SSL config for alias: " + alias);
                        }
                    } else {
                        this.addSSLConfigToMap(alias, sslConfig);
                    }
                } else if (reinitialize && (oldConfig = (SSLConfig)this.sslConfigMap.get(alias)) != null) {
                    this.removeSSLConfigFromMap(alias, oldConfig);
                    this.notifySSLConfigChangeListener(alias, "deleted");
                }
                this.clientFilesAlreadyProcessed.add(configURL);
            }
            catch (Exception e) {
                Tr.error(tc, "ssl.client.config.parse.CWPKI0019E", new Object[]{configURL, e.getMessage() != null ? e.getClass().getName() + ":" + e.getMessage() : e.getClass().getName()});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception parsing SSL properties from ConfigURL.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.SSLConfigManager.parseConfigURL", "2567", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseConfigURL");
        }
    }

    public void parseSSLConfigURL(String configURL, boolean reinitialize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSSLConfigURL", new Object[]{configURL, new Boolean(reinitialize)});
        }
        if (configURL != null && (!this.clientFilesAlreadyProcessed.contains(configURL) || reinitialize)) {
            try {
                int i;
                SSLConfig tempSSLConfig;
                SSLConfig[] sslConfigArray;
                String[] existingAliases = null;
                HashSet<String> newAliases = null;
                if (reinitialize) {
                    newAliases = new HashSet<String>();
                    existingAliases = this.sslConfigMap.keySet().toArray(new String[0]);
                }
                if ((sslConfigArray = (tempSSLConfig = new SSLConfig()).loadPropertiesFile(configURL, true)) != null) {
                    for (i = 0; i < sslConfigArray.length; ++i) {
                        if (i == 0 && sslConfigArray[0] != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting global SSL properties.");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, sslConfigArray[i].toString());
                            }
                            this.globalConfigProperties.putAll(sslConfigArray[0]);
                            String value = (String)this.globalConfigProperties.get("com.ibm.jsse2.checkRevocation");
                            if (value != null && value != "") {
                                System.setProperty("com.ibm.jsse2.checkRevocation", value);
                            }
                            if ((value = (String)this.globalConfigProperties.get("com.ibm.security.enableCRLDP")) != null && value != "") {
                                System.setProperty("com.ibm.security.enableCRLDP", value);
                                if (System.getProperty("com.ibm.security.enableNULLCRLDP") == null) {
                                    System.setProperty("com.ibm.security.enableNULLCRLDP", "true");
                                }
                            }
                            if ((value = (String)this.globalConfigProperties.get("com.ibm.security.enableNULLCRLDP")) != null && value != "") {
                                System.setProperty("com.ibm.security.enableNULLCRLDP", value);
                            }
                            if ((value = (String)this.globalConfigProperties.get("ocsp.enable")) != null && value != "") {
                                Security.setProperty("ocsp.enable", value);
                            }
                            if ((value = (String)this.globalConfigProperties.get("ocsp.responderURL")) != null && value != "") {
                                Security.setProperty("ocsp.responderURL", value);
                            }
                            if ((value = (String)this.globalConfigProperties.get("ocsp.responderCertSubjectName")) != null && value != "") {
                                Security.setProperty("ocsp.responderCertSubjectName", value);
                            }
                            if ((value = (String)this.globalConfigProperties.get("ocsp.responderCertIssuerName")) != null && value != "") {
                                Security.setProperty("ocsp.responderCertIssuerName", value);
                            }
                            if ((value = (String)this.globalConfigProperties.get("ocsp.responderCertSerialNumber")) != null && value != "") {
                                Security.setProperty("ocsp.responderCertSerialNumber", value);
                            }
                            if (!tc.isDebugEnabled()) continue;
                            this.printTrustManagerProperties();
                            continue;
                        }
                        if (sslConfigArray[i] == null || !sslConfigArray[i].requiredPropertiesArePresent()) continue;
                        SSLConfig sslConfig = sslConfigArray[i];
                        String alias = sslConfig.getProperty("com.ibm.ssl.alias");
                        sslConfig.setProperty("com.ibm.ssl.configURLLoadedFrom", configURL);
                        sslConfig.decodePasswords();
                        if (reinitialize) {
                            newAliases.add(alias);
                            SSLConfig oldConfig = (SSLConfig)this.sslConfigMap.get(alias);
                            if (oldConfig == null) {
                                this.addSSLConfigToMap(alias, sslConfig);
                                continue;
                            }
                            if (!oldConfig.equals(sslConfig)) {
                                this.removeSSLConfigFromMap(alias, sslConfig);
                                this.addSSLConfigToMap(alias, sslConfig);
                                this.notifySSLConfigChangeListener(alias, "changed");
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "New SSL config equals old SSL config for alias: " + alias);
                            continue;
                        }
                        this.addSSLConfigToMap(alias, sslConfig);
                    }
                } else {
                    File sslConfig = new File(configURL);
                    if (!new File(configURL).exists()) {
                        throw new FileNotFoundException(configURL);
                    }
                }
                this.clientFilesAlreadyProcessed.add(configURL);
                if (reinitialize) {
                    for (i = 0; i < existingAliases.length; ++i) {
                        String oldAlias = existingAliases[i];
                        SSLConfig oldConfig = (SSLConfig)this.sslConfigMap.get(oldAlias);
                        String oldConfigURL = oldConfig.getProperty("com.ibm.ssl.configURLLoadedFrom");
                        if (oldConfig == null || newAliases.contains(oldAlias) || !oldConfigURL.equals(configURL)) continue;
                        this.removeSSLConfigFromMap(oldAlias, oldConfig);
                        this.notifySSLConfigChangeListener(oldAlias, "deleted");
                    }
                }
            }
            catch (Exception e) {
                Tr.error(tc, "ssl.client.config.parse.CWPKI0019E", new Object[]{configURL, e.getMessage() != null ? e.getClass().getName() + ":" + e.getMessage() : e.getClass().getName()});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception parsing SSL properties from ssl.client.props.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.SSLConfigManager.parseSSLConfigURL", "2765", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSSLConfigURL");
        }
    }

    public void removeSSLConfigFromMap(String alias, SSLConfig sslConfig) throws Exception {
        String dynamicSelectionInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSSLConfigFromMap", new Object[]{alias});
        }
        if ((dynamicSelectionInfo = sslConfig.getDynamicSelectionProperty()) != null && !dynamicSelectionInfo.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing old SSL properties from dynamic selection info list.");
            }
            this.sslConfigDynamicSelectionMap.remove(dynamicSelectionInfo);
        }
        this.sslConfigMap.remove(alias);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSSLConfigFromMap");
        }
    }

    public void addSSLConfigToMap(String alias, SSLConfig sslConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSSLConfigToMap");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding SSL properties for alias: " + alias);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sslConfig.toString());
        }
        sslConfig.expandPaths();
        if (this.validationEnabled()) {
            sslConfig.validateSSLConfig();
        }
        if (!this.isServerProcess) {
            KeyStoreManager.getInstance().checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot(sslConfig);
        }
        this.sslConfigMap.put(alias, sslConfig);
        String dynamicSelectionInfo = sslConfig.getDynamicSelectionProperty();
        if (dynamicSelectionInfo != null && !dynamicSelectionInfo.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding SSL properties to dynamic selection list with value: " + dynamicSelectionInfo);
            }
            this.sslConfigDynamicSelectionMap.put(dynamicSelectionInfo, alias);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSSLConfigToMap");
        }
    }

    public String toString() {
        if (this.sslConfigMap.size() > 0) {
            Iterator sslConfigIterator = this.sslConfigMap.entrySet().iterator();
            StringBuffer sb = new StringBuffer();
            sb.append("SSLConfigManager configuration: \n");
            while (sslConfigIterator.hasNext()) {
                Map.Entry current = sslConfigIterator.next();
                SSLConfig mapValue = (SSLConfig)current.getValue();
                String mapKey = (String)current.getKey();
                sb.append(mapKey);
                sb.append("===");
                sb.append(mapValue.toString());
            }
            return sb.toString();
        }
        return "SSLConfigManager does not contain any SSL configurations.";
    }

    public boolean validationEnabled() {
        String validate = this.getGlobalProperty("com.ibm.ssl.validationEnabled");
        return validate != null && (validate.equalsIgnoreCase("true") || validate.equalsIgnoreCase("yes"));
    }

    public void checkURLHostNameVerificationProperty(boolean reinitialize) {
        String urlHostNameVerification = this.getGlobalProperty("com.ibm.ssl.performURLHostNameVerification");
        if (urlHostNameVerification == null || urlHostNameVerification.equalsIgnoreCase("false") || urlHostNameVerification.equalsIgnoreCase("no")) {
            HostnameVerifier verifier = new HostnameVerifier(){

                public boolean verify(String urlHostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(verifier);
            if (!reinitialize) {
                Tr.info(tc, "ssl.disable.url.hostname.verification.CWPKI0027I");
            }
        }
    }

    public synchronized void notifySSLConfigChangeListener(String alias, String state) {
        List listenerList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifySSLConfigChangeListener", new Object[]{alias, state});
        }
        if (alias != null && (listenerList = (List)this.sslConfigListenerMap.get(alias)) != null && listenerList.size() > 0) {
            SSLConfigChangeListener[] listenerArray = listenerList.toArray(new SSLConfigChangeListener[listenerList.size()]);
            for (int i = 0; i < listenerArray.length; ++i) {
                SSLConfigChangeEvent event2 = null;
                event2 = (SSLConfigChangeEvent)this.sslConfigListenerEventMap.get(listenerArray[i]);
                if (event2 == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notifying listener[" + i + "]: " + listenerArray[i].getClass().getName());
                }
                event2.setState(state);
                SSLConfig changedConfig = (SSLConfig)this.sslConfigMap.get(alias);
                event2.setChangedSSLConfig(changedConfig);
                listenerArray[i].stateChanged(event2);
                if (!state.equals("deleted")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deregistering event for listener.");
                }
                this.sslConfigListenerEventMap.remove(listenerArray[i]);
            }
            if (state.equals("deleted")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deregistering all listeners for this alias due to alias deletion.");
                }
                this.sslConfigListenerMap.remove(alias);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifySSLConfigChangeListener");
        }
    }

    public synchronized void registerSSLConfigChangeListener(SSLConfigChangeListener listener, SSLConfigChangeEvent event2) {
        ArrayList<SSLConfigChangeListener> listenerList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSSLConfigChangeListener", new Object[]{listener, event2});
        }
        if ((listenerList = (ArrayList<SSLConfigChangeListener>)this.sslConfigListenerMap.get(event2.getAlias())) != null) {
            listenerList.add(listener);
            this.sslConfigListenerMap.put(event2.getAlias(), listenerList);
        } else {
            listenerList = new ArrayList<SSLConfigChangeListener>();
            listenerList.add(listener);
            this.sslConfigListenerMap.put(event2.getAlias(), listenerList);
        }
        this.sslConfigListenerEventMap.put(listener, event2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSSLConfigChangeListener");
        }
    }

    public synchronized void deregisterSSLConfigChangeListener(SSLConfigChangeListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterSSLConfigChangeListener", new Object[]{listener});
        }
        SSLConfigChangeEvent event2 = null;
        if (listener != null && this.sslConfigListenerEventMap.containsKey(listener)) {
            event2 = (SSLConfigChangeEvent)this.sslConfigListenerEventMap.get(listener);
        }
        if (event2 != null) {
            int index;
            List listenerList;
            String alias;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing listener: " + listener.getClass().getName());
            }
            if (this.sslConfigListenerMap.containsKey(alias = event2.getAlias()) && (listenerList = (List)this.sslConfigListenerMap.get(alias)) != null && (index = listenerList.indexOf(listener)) != -1) {
                listenerList.remove(index);
            }
            this.sslConfigListenerEventMap.remove(listener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterSSLConfigChangeListener");
        }
    }

    public boolean isServerProcess() {
        return this.isServerProcess;
    }

    public String[] getSystemSSLCiphers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemSSLCiphers");
        }
        ArrayList<String> cipherList = new ArrayList<String>();
        boolean extendedPolicy = false;
        if (this.isExtendedPolicy()) {
            extendedPolicy = true;
        }
        for (int i = 0; i < SystemSSLCiphers.length; ++i) {
            if (SystemSSLCiphers[i][1].indexOf("AES_256") != -1) {
                if (!extendedPolicy) continue;
                cipherList.add(SystemSSLCiphers[i][1]);
                continue;
            }
            cipherList.add(SystemSSLCiphers[i][1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemSSLCiphers");
        }
        return cipherList.toArray(new String[0]);
    }

    public String convertCiphersList(String cipherString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCiphersList", new Object[]{cipherString});
        }
        String[] orderedCipherList = new String[SystemSSLCiphers.length];
        String[] ciphers = cipherString.split(" ");
        block0: for (int i = 0; i < ciphers.length; ++i) {
            for (int j = 0; j < SystemSSLCiphers.length; ++j) {
                if (!SystemSSLCiphers[j][1].equals(ciphers[i])) continue;
                orderedCipherList[j] = SystemSSLCiphers[j][0];
                continue block0;
            }
        }
        String orderedCiphers = "";
        for (int i = 0; i < orderedCipherList.length; ++i) {
            if (orderedCipherList[i] == null) continue;
            orderedCiphers = orderedCiphers + orderedCipherList[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCiphersList");
        }
        return orderedCiphers;
    }

    public String getSystemSSLList(String ciphers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemSSLList", new Object[]{ciphers});
        }
        StringBuffer cipherBuffer = new StringBuffer();
        for (int i = 0; i < ciphers.length(); i += 2) {
            String key = ciphers.substring(i, i + 2);
            for (int j = 0; j < SystemSSLCiphers.length; ++j) {
                if (!SystemSSLCiphers[j][0].equals(key)) continue;
                cipherBuffer.append(SystemSSLCiphers[i][1]);
                cipherBuffer.append(" ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemSSLList");
        }
        return cipherBuffer.toString();
    }

    private boolean isExtendedPolicy() {
        boolean extendedPolicy;
        block2: {
            extendedPolicy = false;
            try {
                KeyPairGenerator kp = KeyPairGenerator.getInstance("AES");
                kp.initialize(256);
                extendedPolicy = true;
            }
            catch (NoSuchAlgorithmException e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Extened policy is not availible");
            }
        }
        return extendedPolicy;
    }

    public SSLSocket setCipherListOnSocket(Properties props, SSLSocket socket) {
        block10: {
            String cipherString;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCipherListOnSocket");
            }
            String[] ciphers = null;
            String string = cipherString = props != null ? props.getProperty("com.ibm.ssl.enabledCipherSuites") : null;
            if (socket != null) {
                try {
                    if (cipherString != null) {
                        ciphers = cipherString.split("\\s");
                    } else {
                        String securityLevel = props.getProperty("com.ibm.ssl.securityLevel");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "securityLevel from properties is " + securityLevel);
                        }
                        if (securityLevel == null) {
                            securityLevel = "HIGH";
                        }
                        String[] supportedCiphers = socket.getSupportedCipherSuites();
                        ciphers = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
                    }
                    if (ciphers != null) {
                        socket.setEnabledCipherSuites(ciphers);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception setting ciphers in SSL Socket Factory.", new Object[]{e});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCipherListOnSocket");
        }
        return socket;
    }

    public SSLServerSocket setCipherListOnServerSocket(Properties props, SSLServerSocket socket) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCipherListOnServerSocket");
            }
            String[] ciphers = null;
            String cipherString = props.getProperty("com.ibm.ssl.enabledCipherSuites");
            if (socket != null) {
                try {
                    String clientAuth;
                    String clientAuthSupported;
                    if (cipherString != null) {
                        ciphers = cipherString.split("\\s");
                    } else {
                        String securityLevel = props.getProperty("com.ibm.ssl.securityLevel");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "securityLevel from properties is " + securityLevel);
                        }
                        if (securityLevel == null) {
                            securityLevel = "HIGH";
                        }
                        String[] supportedCiphers = socket.getSupportedCipherSuites();
                        ciphers = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
                    }
                    if (ciphers != null) {
                        socket.setEnabledCipherSuites(ciphers);
                    }
                    if ((clientAuthSupported = props.getProperty("com.ibm.ssl.clientAuthenticationSupported")) != null && clientAuthSupported.equals("true")) {
                        socket.setWantClientAuth(true);
                    }
                    if ((clientAuth = props.getProperty("com.ibm.ssl.clientAuthentication")) != null && clientAuth.equals("true")) {
                        socket.setNeedClientAuth(true);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Exception setting ciphers in SSL Socket Factory.", new Object[]{e});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCipherListOnServerSocket");
        }
        return socket;
    }

    public boolean isClientAuthenticationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isClientAuthenticationEnabled");
        }
        boolean auth = false;
        String claimSSLClientAuthSupported = this.getGlobalProperty("com.ibm.CSI.performTLClientAuthenticationSupported");
        String claimSSLClientAuthRequired = this.getGlobalProperty("com.ibm.CSI.performTLClientAuthenticationRequired");
        if (claimSSLClientAuthRequired != null && claimSSLClientAuthSupported != null && (claimSSLClientAuthRequired.equalsIgnoreCase("true") || claimSSLClientAuthSupported.equalsIgnoreCase("true"))) {
            auth = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClientAuthenticationEnabled", new Boolean(auth));
        }
        return auth;
    }
}

