/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.EncodedCertificateInfo;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotableFactory;
import com.ibm.ws.ssl.config.WSKeyStoreRemotableInterface;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;

public class CertificateManager {
    private static final TraceComponent tc = Tr.register(CertificateManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static CertificateManager thisClass = null;

    private CertificateManager() {
    }

    public static CertificateManager getInstance() {
        if (thisClass == null) {
            thisClass = new CertificateManager();
        }
        return thisClass;
    }

    public Certificate selfSignedCertificateCreate(CertReqInfo ssCertInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfSignedCertificateCreate", new Object[]{ssCertInfo});
        }
        InputStream is = null;
        FileOutputStream fos = null;
        String alias = null;
        String subjectDN = null;
        int size = 0;
        int validDays = 0;
        KeyStoreInfo keyStoreInfo = null;
        String keyStoreFile = null;
        String keyStoreType = null;
        String keyStoreProvider = null;
        String password = null;
        subjectDN = ssCertInfo.getSubjectDN();
        alias = ssCertInfo.getLabel();
        size = ssCertInfo.getSize();
        validDays = ssCertInfo.getValidDays();
        keyStoreInfo = ssCertInfo.getKsInfo();
        keyStoreFile = KeyStoreManager.getInstance().expand(keyStoreInfo.getLocation());
        keyStoreType = keyStoreInfo.getType();
        keyStoreProvider = keyStoreInfo.getProvider();
        password = keyStoreInfo.getPassword();
        Boolean stash = keyStoreInfo.getStashFile();
        PkSsCertificate SsCertificate = null;
        Certificate certificate = null;
        KeyStore ks = null;
        try {
            Method theMethod1;
            Class<?> cl1;
            boolean isCA = false;
            if (ssCertInfo.getKsInfo().getName().endsWith("DefaultRootStore") || ssCertInfo.getKsInfo().getName().endsWith("RSATokenRootStore")) {
                isCA = true;
            }
            Date deltaDate = new Date();
            deltaDate.setTime(deltaDate.getTime() - 86400000L);
            ArrayList<String> subjectAltNames = new ArrayList<String>();
            try {
                String profilePath = SecurityObjectLocator.getAdminData().getUserInstallRootPath();
                Class<?> cl12 = Class.forName("com.ibm.ws.ssl.commands.ProfileCreation");
                Method theMethod12 = cl12.getMethod("getProfileUUID", String.class, Object.class);
                String profileUUID = (String)theMethod12.invoke(null, profilePath, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retrieved the following profileUUID for the alternate Subject name: " + profileUUID);
                }
                subjectAltNames.add("ProfileUUID:" + profileUUID);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating profileUUID, using subjectDN instead: " + subjectDN, new Object[]{e});
                }
                subjectAltNames.add("ProfileUUID:" + subjectDN);
            }
            Object ssCertificate = null;
            try {
                SsCertificate = !JSSEProviderFactory.isFipsEnabled() ? PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)"IBMJCE", null, (boolean)isCA) : PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)"IBMJCEFIPS", null, (boolean)isCA);
            }
            catch (NoSuchMethodError e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Certificate Signing API's are not available: " + e.getMessage());
                }
                SsCertificate = !JSSEProviderFactory.isFipsEnabled() ? PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)"IBMJCE", null) : PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)"IBMJCEFIPS", null);
            }
            try {
                Tr.audit(tc, "Self Signed Certificate: notBefore time: " + SsCertificate.getCertificate().getNotBefore().toString() + " notAfter time: " + SsCertificate.getCertificate().getNotAfter().toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
            ks = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            if (keyStoreFile == null || keyStoreFile.equals("")) {
                throw new FileNotFoundException("KeyStore file path cannot not be missing or null.");
            }
            File f = new File(keyStoreFile);
            if (!f.exists()) {
                ks.load(null, password.toCharArray());
            } else if (keyStoreType != null && (keyStoreType.equals("CMSKS") || keyStoreType.equals("IBMi5OSKeyStore"))) {
                cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                theMethod1 = cl1.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                ks = (KeyStore)theMethod1.invoke(cl1.newInstance(), f, keyStoreFile, password, keyStoreType, keyStoreProvider, stash.toString());
            } else {
                is = KeyStoreManager.getInstance().getInputStream(keyStoreFile, true);
                ks.load(is, password.toCharArray());
            }
            SsCertificate.setToKeyStore(alias, password, ks);
            certificate = ks.getCertificate(alias);
            if (keyStoreType != null && (keyStoreType.equals("CMSKS") || keyStoreType.equals("IBMi5OSKeyStore"))) {
                cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                theMethod1 = cl1.getMethod("storeCMSKeyStore", KeyStore.class, String.class, String.class, String.class, String.class);
                theMethod1.invoke(cl1.newInstance(), ks, keyStoreFile, password, keyStoreType, stash.toString());
            } else if (keyStoreInfo.getFileBased().booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyStore is file based");
                }
                fos = new FileOutputStream(keyStoreFile);
                ks.store(fos, password.toCharArray());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyStore is not file based");
                }
                URL ring = new URL(keyStoreFile);
                URLConnection ringConnect = ring.openConnection();
                OutputStream os2 = ringConnect.getOutputStream();
                ks.store(os2, password.toCharArray());
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error creating keystore or certificate.", new Object[]{e});
            }
            Tr.error(tc, "ssl.self.signed.create.error.CWPKI0032E", new Object[]{e.getMessage()});
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.self.signed.create.error.CWPKI0032E", new Object[]{e.getMessage()}, "Error creating a self-signed certificate.  The exception is " + e.getMessage());
            throw new SSLException(message, e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfSignedCertificateCreate");
        }
        return certificate;
    }

    public Certificate chainedCertificateCreate(CertReqInfo chainedCertInfo, String rootCertificateAlias, KeyStoreInfo rootKeyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainedCertificateCreate", new Object[]{chainedCertInfo, rootCertificateAlias});
        }
        String subjectDN = chainedCertInfo.getSubjectDN();
        String alias = chainedCertInfo.getLabel();
        int keySize = chainedCertInfo.getSize();
        int validDays = chainedCertInfo.getValidDays();
        KeyStoreInfo keyStoreInfo = chainedCertInfo.getKsInfo();
        String keyStoreFile = keyStoreInfo.getLocation();
        String keyStoreType = keyStoreInfo.getType();
        String keyStoreUsage = keyStoreInfo.getUsage();
        String keyStoreProvider = keyStoreInfo.getProvider();
        String password = keyStoreInfo.getPassword();
        Boolean stash = keyStoreInfo.getStashFile();
        SecurityConfigObject rootKeyStoreObject = null;
        String rootKeyStoreName = null;
        String rootPassword = null;
        if (rootKeyStore == null) {
            rootKeyStoreObject = keyStoreUsage != null && keyStoreUsage.equals("RSATokenKeys") ? KeyStoreManager.getDefaultKeyStore("RSATokenRootStore", null) : KeyStoreManager.getDefaultKeyStore("DefaultRootStore", null);
            if (rootKeyStoreObject == null) {
                return this.selfSignedCertificateCreate(chainedCertInfo);
            }
            rootKeyStoreName = rootKeyStoreObject.getString("name");
            rootPassword = rootKeyStoreObject.getDecodedString("password");
        } else {
            rootKeyStoreName = rootKeyStore.getName();
            rootPassword = rootKeyStore.getPassword();
        }
        WSKeyStore rootStore = null;
        rootStore = rootKeyStore == null ? new WSKeyStore(rootKeyStoreObject) : new WSKeyStore(rootKeyStore);
        String method2 = "containsAlias";
        Object[] parms = new Object[]{rootCertificateAlias};
        Object[] containsAlias = rootStore.invokeKeyStoreCommand(method2, parms, true);
        if (!((Boolean)containsAlias[0]).booleanValue() && rootKeyStoreObject != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The root certificate does not exist so create it.");
            }
            String rootSubjectDN = null;
            int rootValidDays = 7300;
            String cellName = ManagementScopeManager.getInstance().getCellName();
            String nodeName = ManagementScopeManager.getInstance().getNodeName();
            if (rootSubjectDN == null) {
                rootSubjectDN = "cn=${hostname},ou=Root Certificate,ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
            }
            String host = null;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException uhe) {
                if (System.getProperty("os.name").equals("OS/400")) {
                    host = "LOOPBACK";
                }
                throw uhe;
            }
            rootSubjectDN = KeyStoreManager.expandHostNameVariable(rootSubjectDN, host);
            KeyStoreInfo rootKeyStoreInfo = new KeyStoreInfo(rootKeyStoreName, rootKeyStoreObject.getUnexpandedString("location"), rootPassword, rootKeyStoreObject.getString("provider"), rootKeyStoreObject.getString("type"), rootKeyStoreObject.getBoolean("fileBased"), null, null, null, rootKeyStoreObject.getBoolean("readOnly"), null, null, null, null, null, null, null);
            CertReqInfo rootCertInfo = new CertReqInfo(rootCertificateAlias, 1024, rootSubjectDN, rootValidDays, rootKeyStoreInfo, rootKeyStoreObject.getUnexpandedString("location"));
            this.selfSignedCertificateCreate(rootCertInfo);
            rootStore.clearJavaKeyStore();
            rootStore = new WSKeyStore(rootKeyStoreObject);
        }
        PkNewCertificate chainedCert = null;
        try {
            chainedCert = this.chainedCertificateCreate(chainedCertInfo, rootCertificateAlias, rootStore, rootKeyStoreName, rootPassword.toCharArray());
        }
        catch (ClassNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate Signing API's are not available: " + e.getMessage());
            }
            return this.selfSignedCertificateCreate(chainedCertInfo);
        }
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            KeyStore targetKeyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            File f = new File(keyStoreFile);
            if (!f.exists()) {
                targetKeyStore.load(null, password.toCharArray());
            } else if (keyStoreType != null && (keyStoreType.equals("CMSKS") || keyStoreType.equals("IBMi5OSKeyStore"))) {
                Class<?> cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                Method theMethod1 = cl1.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                targetKeyStore = (KeyStore)theMethod1.invoke(cl1.newInstance(), f, keyStoreFile, password, keyStoreType, keyStoreProvider, stash.toString());
            } else {
                is = KeyStoreManager.getInstance().getInputStream(keyStoreFile, true);
                targetKeyStore.load(is, password.toCharArray());
            }
            chainedCert.setToKeyStore(alias, password, targetKeyStore);
            Certificate[] certificateChain = targetKeyStore.getCertificateChain(alias);
            if (keyStoreType != null && (keyStoreType.equals("CMSKS") || keyStoreType.equals("IBMi5OSKeyStore"))) {
                Class<?> cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                Method theMethod1 = cl1.getMethod("storeCMSKeyStore", KeyStore.class, String.class, String.class, String.class, String.class);
                theMethod1.invoke(cl1.newInstance(), targetKeyStore, keyStoreFile, password, keyStoreType, stash.toString());
            } else if (keyStoreInfo.getFileBased().booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyStore is a file based");
                }
                fos = new FileOutputStream(keyStoreFile);
                targetKeyStore.store(fos, password.toCharArray());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyStore is not file based");
                }
                URL ring = new URL(keyStoreFile);
                URLConnection ringConnect = ring.openConnection();
                OutputStream os2 = ringConnect.getOutputStream();
                targetKeyStore.store(os2, password.toCharArray());
            }
            X509Certificate[] chainedCertificate = chainedCert.getCertificateChain();
            try {
                Tr.audit(tc, "Chained Certificate\n\t Owner: " + chainedCertificate[0].getSubjectDN() + "\n\t" + " Issuer: " + chainedCertificate[0].getIssuerDN() + "\n\t" + " Not Before: " + chainedCertificate[0].getNotBefore().toString() + "\n\t" + " Not After: " + chainedCertificate[0].getNotAfter().toString() + "\n\t" + " Serial: " + chainedCertificate[0].getSerialNumber());
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (certificateChain != null && certificateChain.length > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "chainedCertificateCreate (success)");
                }
                Certificate certificate = certificateChain[certificateChain.length - 1];
                return certificate;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error creating keystore or certificate.", new Object[]{e});
            }
            Tr.error(tc, "ssl.chained.create.error.CWPKI0043E", new Object[]{e.getMessage()});
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.chained.create.error.CWPKI0043E", new Object[]{e.getMessage()}, "Error creating a chained certificate.  The exception is " + e.getMessage());
            throw new SSLException(message, e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainedCertificateCreate (null)");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PkNewCertificate chainedCertificateCreate(CertReqInfo chainedCertInfo, String rootCertificateAlias, WSKeyStore rootStore, String rootKeyStoreName, char[] rootPassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainedCertificateCreate", new Object[]{chainedCertInfo});
        }
        InputStream is = null;
        FileOutputStream fos = null;
        String subjectDN = chainedCertInfo.getSubjectDN();
        String alias = chainedCertInfo.getLabel();
        int keySize = chainedCertInfo.getSize();
        int validDays = chainedCertInfo.getValidDays();
        try {
            Thread.currentThread().getContextClassLoader().loadClass("com.ibm.security.certclient.util.PkNewCertFactory");
        }
        catch (ClassNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate Signing API's are not available: " + e.getMessage());
            }
            throw e;
        }
        PkNewCertificate chainedCert = null;
        Certificate[] rootCertChain = null;
        X509Certificate[] rootCertChainX509 = null;
        PrivateKey rootPrivateKey = null;
        ArrayList<String> subjectAltNames = new ArrayList<String>();
        try {
            String profilePath = SecurityObjectLocator.getAdminData().getUserInstallRootPath();
            Class<?> cl1 = Class.forName("com.ibm.ws.ssl.commands.ProfileCreation");
            Method theMethod1 = cl1.getMethod("getProfileUUID", String.class, Object.class);
            String profileUUID = (String)theMethod1.invoke(null, profilePath, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved the following profileUUID for the alternate Subject name: " + profileUUID);
            }
            subjectAltNames.add("ProfileUUID:" + profileUUID);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating profileUUID, using subjectDN instead: " + subjectDN, new Object[]{e});
            }
            subjectAltNames.add("ProfileUUID:" + subjectDN);
        }
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{rootCertificateAlias};
            Object[] containsAlias = rootStore.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{rootCertificateAlias};
            Object[] isKeyEntry = rootStore.invokeKeyStoreCommand(method2, parms);
            if (!((Boolean)containsAlias[0]).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.does.not.exist.CWPKI0655E", new Object[]{alias, rootKeyStoreName}, "Certificate alias \"" + rootCertificateAlias + "\" does not exist in key store \"" + rootKeyStoreName + "\".");
                throw new Exception(msg);
            }
            if (!((Boolean)isKeyEntry[0]).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{alias}, "Certificate \"" + rootCertificateAlias + "\" is not a personal certificate.");
                throw new Exception(msg);
            }
            method2 = "getCertificateChain";
            parms = new Object[]{rootCertificateAlias};
            Object[] certArray = rootStore.invokeKeyStoreCommand(method2, parms);
            rootCertChain = (Certificate[])certArray[0];
            if (rootCertChain != null) {
                rootCertChainX509 = new X509Certificate[rootCertChain.length];
                for (int i = 0; i < rootCertChain.length; ++i) {
                    rootCertChainX509[i] = (X509Certificate)rootCertChain[i];
                }
            }
            if (rootCertChainX509[0].getBasicConstraints() == -1) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.ca.CWPKI0701E", new Object[]{alias}, "Certificate specified as alias \"" + rootCertificateAlias + "\" is not a certificate authority (CA) certificate");
                throw new Exception(msg);
            }
            method2 = "getKey";
            parms = new Object[]{rootCertificateAlias, rootPassword};
            Object[] key = rootStore.invokeKeyStoreCommand(method2, parms);
            rootPrivateKey = (PrivateKey)key[0];
            boolean isCA = false;
            if (chainedCertInfo.getKsInfo().getName().endsWith("DefaultRootStore")) {
                isCA = true;
            }
            Date deltaDate = new Date();
            deltaDate.setTime(deltaDate.getTime() - 86400000L);
            chainedCert = !JSSEProviderFactory.isFipsEnabled() ? PkNewCertFactory.newCert((int)keySize, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, subjectAltNames, null, null, (String)"IBMJCE", null, (X509Certificate[])rootCertChainX509, (PrivateKey)rootPrivateKey, (boolean)isCA) : PkNewCertFactory.newCert((int)keySize, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, subjectAltNames, null, null, (String)"IBMJCEFIPS", null, (X509Certificate[])rootCertChainX509, (PrivateKey)rootPrivateKey, (boolean)isCA);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error creating keystore or certificate.", new Object[]{e});
            }
            Tr.error(tc, "ssl.chained.create.error.CWPKI0043E", new Object[]{e.getMessage()});
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.chained.create.error.CWPKI0043E", new Object[]{e.getMessage()}, "Error creating a chained certificate.  The exception is " + e.getMessage());
            throw new SSLException(message, e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainedCertificateCreate");
        }
        return chainedCert;
    }

    public boolean isKeyCertJarAvailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyCertJarAvailable");
        }
        boolean result = true;
        String clz = "com.ibm.security.certclient.util.PkSsCertFactory";
        try {
            Thread.currentThread().getContextClassLoader().loadClass(clz);
        }
        catch (ClassNotFoundException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "isKeyCertJarAvailable", "Unable to load class \"" + clz + "\".");
            }
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyCertJarAvailable", result);
        }
        return result;
    }

    public byte[] getEncodedRootSigner(String type) {
        Certificate cert;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncodedRootSigner", new Object[]{type});
        }
        if ((cert = this.getRootSigner(type)) != null) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEncodedRootSigner (success)");
                }
                return cert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error encoding root signer.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.CertificateManager.getEncodedRootSigner", "600", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncodedRootSigner (null)");
        }
        return null;
    }

    public Certificate getRootSigner(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootSigner", new Object[]{type});
        }
        Certificate[] cert = null;
        String keyStoreName = null;
        String alias = null;
        WSKeyStore wsks = null;
        if (type.equalsIgnoreCase("SSL")) {
            keyStoreName = KeyStoreManager.getDefaultKeyStoreName("DefaultKeyStore");
            wsks = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
            alias = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.ssl.rootCertAlias");
            if (alias == null || alias.length() == 0) {
                alias = "default";
            }
        } else if (type.equalsIgnoreCase("RSA")) {
            keyStoreName = KeyStoreManager.getDefaultKeyStoreName("RSATokenKeyStore");
            wsks = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
            alias = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.rsa.rootCertAlias");
            if (alias == null || alias.length() == 0) {
                alias = "default";
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRootSigner: Invalid input \"type\".");
            }
            return null;
        }
        WSKeyStoreRemotableInterface wsksr = null;
        if (wsks != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting remotable instance of WSKeyStore name: " + keyStoreName);
            }
            wsksr = WSKeyStoreRemotableFactory.getInstance(wsks);
        }
        if (wsksr != null) {
            String method2 = "getCertificateChain";
            Object[] parms = new Object[]{alias};
            Object[] returnedData = null;
            try {
                returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                if (returnedData != null && returnedData[0] != null) {
                    cert = (Certificate[])returnedData[0];
                    if (cert != null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getRootSigner (success): " + ((X509Certificate)cert[cert.length - 1]).getSubjectDN());
                        }
                        return cert[cert.length - 1];
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not get a certificate in returnedData from specific alias: " + alias);
                    }
                } else {
                    method2 = "aliases";
                    parms = new Object[]{};
                    returnedData = null;
                    returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                    if (returnedData != null && returnedData[0] != null) {
                        String[] aliases = (String[])returnedData;
                        for (int i = 0; i < aliases.length; ++i) {
                            String newAlias = aliases[i];
                            method2 = "isKeyEntry";
                            parms = new Object[]{newAlias};
                            returnedData = null;
                            returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                            if (returnedData == null || returnedData[0] == null) continue;
                            Boolean isKeyEntry = (Boolean)returnedData[0];
                            if (isKeyEntry.booleanValue()) {
                                method2 = "getCertificateChain";
                                parms = new Object[]{newAlias};
                                returnedData = null;
                                returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                                if (returnedData == null || returnedData.length <= 0 || (cert = (Certificate[])returnedData[0]) == null) continue;
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "getRootSigner (success): " + ((X509Certificate)cert[cert.length - 1]).getSubjectDN());
                                }
                                return cert[cert.length - 1];
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Alias \"" + newAlias + "\" is not a key entry.");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not find a certificate from the list of aliases in the keystore that matched isKeyEntry().");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find any certificates in the returnedData.");
                    }
                }
            }
            catch (KeyException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error obtaining the root signer.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.CertificateManager.getRootSigner", "729", this);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Error getting the root signer from keystore " + keyStoreName + ".");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootSigner (null)");
        }
        return null;
    }

    public void addRootSigner(Certificate cert, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRootSigner", new Object[]{cert, type});
        }
        String keyStoreName = null;
        String alias = ((Object)((X509Certificate)cert).getSubjectDN()).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding signer of type \"" + type + "\" with alias: " + alias);
        }
        if (type == null) {
            type = "SSL";
        }
        if (type.equalsIgnoreCase("SSL")) {
            keyStoreName = KeyStoreManager.getDefaultKeyStoreName("DefaultTrustStore");
        } else if (type.equalsIgnoreCase("RSA")) {
            keyStoreName = KeyStoreManager.getDefaultKeyStoreName("RSATokenTrustStore");
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addRootSigner: Invalid input \"type\".");
            }
            return;
        }
        WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
        WSKeyStoreRemotableInterface wsksr = null;
        if (wsks != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting remotable instance of WSKeyStore.");
            }
            wsksr = WSKeyStoreRemotableFactory.getInstance(wsks);
        }
        if (wsksr != null) {
            Boolean ksReadOnly = Boolean.getBoolean(wsks.getProperty("com.ibm.ssl.keyStoreReadOnly"));
            if (ksReadOnly.booleanValue()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addRootSigner (read-only, noop)");
                }
                return;
            }
            try {
                String method2 = "reinitializeKeyStore";
                Object[] parms = null;
                Object[] returnedData = null;
                returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyStore reinitialized");
                }
                method2 = "getCertificateAlias";
                parms = new Object[]{cert};
                returnedData = null;
                returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                if (returnedData != null && returnedData[0] != null && !returnedData[0].equals("<null>")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "addRootSigner (already exists)", new Object[]{returnedData[0]});
                    }
                    return;
                }
                method2 = "setCertificateEntry";
                parms = new Object[]{alias, cert};
                wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                wsksr.store();
                KeyStoreManager.getInstance().clearJavaKeyStoresFromKeyStoreMap();
                AbstractJSSEProvider.clearSSLContextCache();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Successfully added signer to keystore: " + keyStoreName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addRootSigner (success)");
                }
                return;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error adding the root signer.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.CertificateManager.addRootSigner", "812", this);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding the root signer to keystore " + keyStoreName + ".");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRootSigner");
        }
    }

    public void deleteRootSigner(Certificate cert, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteRootSigner", new Object[]{cert, type});
        }
        String keyStoreName = null;
        String alias = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Deleting signer of type \"" + type + "\".");
        }
        if (type == null) {
            type = "SSL";
        }
        if (type.equalsIgnoreCase("SSL")) {
            keyStoreName = KeyStoreManager.getDefaultKeyStoreName("DefaultTrustStore");
        } else if (type.equalsIgnoreCase("RSA")) {
            keyStoreName = KeyStoreManager.getDefaultKeyStoreName("RSATokenTrustStore");
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteRootSigner: Invalid input \"type\".");
            }
            return;
        }
        WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
        WSKeyStoreRemotableInterface wsksr = null;
        if (wsks != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting remotable instance of WSKeyStore.");
            }
            wsksr = WSKeyStoreRemotableFactory.getInstance(wsks);
        }
        if (wsksr != null) {
            Boolean ksReadOnly = Boolean.getBoolean(wsks.getProperty("com.ibm.ssl.keyStoreReadOnly"));
            if (ksReadOnly.booleanValue()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteRootSigner (read-only, noop)");
                }
                return;
            }
            String method2 = "reinitializeKeyStore";
            Object[] parms = null;
            Object[] returnedData = null;
            try {
                returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyStore reinitialized");
                }
                method2 = "getCertificateAlias";
                parms = new Object[]{cert};
                returnedData = null;
                returnedData = wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                if (returnedData != null && returnedData[0] != null && !returnedData[0].equals("<null>")) {
                    alias = (String)returnedData[0];
                    if (alias != null) {
                        method2 = "deleteEntry";
                        parms = new Object[]{alias};
                        wsksr.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
                        wsksr.store();
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "deleteRootSigner (success)");
                        }
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not get a certificate from the returned data.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not get any returned data.");
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error deleting the root signer.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.CertificateManager.deleteRootSigner", "896", this);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not delete root signer from keystore " + keyStoreName + ".");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteRootSigner");
        }
    }

    public EncodedCertificateInfo createPersonalCertificate(CertReqInfo certRequestInfo, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPersonalCertificate", new Object[]{certRequestInfo, type});
        }
        SecurityConfigObject rootKeyStoreObject = null;
        String rootKeyStoreName = null;
        String rootPassword = null;
        String alias = "root";
        try {
            if (type.equalsIgnoreCase("SSL")) {
                rootKeyStoreObject = KeyStoreManager.getDefaultKeyStore("DefaultRootStore", null);
                if (rootKeyStoreObject == null) {
                    // empty if block
                }
                if ((alias = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.ws.ssl.rootCertAlias")) == null || alias.length() == 0) {
                    alias = "root";
                }
                rootKeyStoreName = rootKeyStoreObject.getString("name");
                rootPassword = rootKeyStoreObject.getDecodedString("password");
            } else if (type.equalsIgnoreCase("RSA")) {
                rootKeyStoreObject = KeyStoreManager.getDefaultKeyStore("RSATokenRootStore", null);
                if (rootKeyStoreObject == null) {
                    // empty if block
                }
                if ((alias = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.ws.rsa.rootCertAlias")) == null || alias.length() == 0) {
                    alias = "root";
                }
                rootKeyStoreName = rootKeyStoreObject.getString("name");
                rootPassword = rootKeyStoreObject.getDecodedString("password");
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRootSigner: Invalid input \"type\".");
                }
                return null;
            }
            WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(rootKeyStoreName);
            PkNewCertificate chainedCert = this.chainedCertificateCreate(certRequestInfo, alias, wsks, rootKeyStoreName, rootPassword.toCharArray());
            return new EncodedCertificateInfo(chainedCert);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating a personal certificate.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.CertificateManager.createPersonalCertificate", "980", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPersonalCertificate");
            }
            return null;
        }
    }

    public Certificate[] createPersonalCertificate(byte[] cert_request, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPersonalCertificate");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPersonalCertificate");
        }
        return null;
    }

    public String incrementAlias(KeyStore jKeyStore, String alias) throws KeyStoreException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incrementAlias", new Object[]{alias});
        }
        int num = 1;
        String newAlias = null;
        int aliasLi = -1;
        String last = null;
        String first = null;
        do {
            try {
                if (newAlias != null) {
                    alias = newAlias;
                }
                if ((aliasLi = alias.lastIndexOf(95)) == -1) {
                    throw new NumberFormatException();
                }
                last = alias.substring(aliasLi + 1);
                first = alias.substring(0, aliasLi + 1);
                int n = Integer.parseInt(last);
                newAlias = first + last.replaceAll(last, Integer.toString(++n));
            }
            catch (NumberFormatException e) {
                newAlias = alias + "_" + num++;
            }
        } while (jKeyStore.containsAlias(newAlias));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incrementAlias", new Object[]{newAlias});
        }
        return newAlias;
    }

    private void runTest() {
        KeyStoreInfo ksi = new KeyStoreInfo("PeteKeyStore", "c:/temp/pete_key.p12", "WebAS", "IBMJCE", "PKCS12", Boolean.TRUE, "", null, null, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, Boolean.FALSE, null, "Pete's key store");
        CertReqInfo cri = new CertReqInfo("mycert", 1024, "cn=pete,o=ibm,c=us", 365, ksi, ksi.getLocation());
        EncodedCertificateInfo eci_rsa = this.createPersonalCertificate(cri, "RSA");
        System.out.println(eci_rsa);
        byte[] eci_rsa_bytes = eci_rsa.getBytes();
        EncodedCertificateInfo eci_rsa_after_decode = EncodedCertificateInfo.createFromBytes(eci_rsa_bytes);
        System.out.println(eci_rsa_after_decode);
        EncodedCertificateInfo eci_ssl = this.createPersonalCertificate(cri, "SSL");
        System.out.println(eci_ssl);
        byte[] eci_ssl_bytes = eci_ssl.getBytes();
        EncodedCertificateInfo eci_ssl_after_decode = EncodedCertificateInfo.createFromBytes(eci_ssl_bytes);
        System.out.println(eci_ssl_after_decode);
    }
}

