/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RetrieveSignerFromPort
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RetrieveSignerFromPort.class, "SSL", "com.ibm.ws.ssl.commands.signerCertificates");
    private String host = null;
    private Integer port = null;
    private String certificateAlias = null;
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String sslConfigName = null;
    private String sslConfigScopeName = null;
    private ObjectName sslCfgObjName = null;
    private KeyStoreInfo ksInfo = null;

    public RetrieveSignerFromPort(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public RetrieveSignerFromPort(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName security2 = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            Object keyFileName = null;
            this.host = (String)this.getParameter(CommandConstants.HOST);
            this.port = (Integer)this.getParameter(CommandConstants.PORT);
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
            this.sslConfigName = (String)this.getParameter(CommandConstants.CONFIG_NAME);
            this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "host=" + this.host + " port=" + this.port + " certificateAlias=" + this.certificateAlias + " sslConfigName=" + this.sslConfigName + " sslConfigScopeName=" + this.sslConfigScopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            if (this.sslConfigName != null) {
                AttributeList queryAttrs = new AttributeList();
                if (this.sslConfigScopeName == null) {
                    this.sslConfigScopeName = commandHelper.defaultCellScope(cell);
                    Tr.debug(tc, "Default cell scopeName: " + this.sslConfigScopeName);
                }
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslConfigName);
                this.sslCfgObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.sslConfigScopeName);
                if (this.sslCfgObjName == null) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.sslConfigName, this.sslConfigScopeName}, this.sslConfigName + " does not exist within the management scope " + this.sslConfigScopeName);
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.getSignerAndAddToKeyStore(this.host, this.port, this.sslConfigName, this.ksInfo);
            result.setResult("Signer Certificate Successfully added to keyStore.");
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void getSignerAndAddToKeyStore(String Host, Integer port, String sslCfgAlias, KeyStoreInfo info) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignerAndAddToKeyStore", new Object[]{this.host, port, sslCfgAlias});
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminService = " + adminService);
            }
            String node = adminService.getNodeName();
            String process = adminService.getProcessName();
            ObjectName queryName = new ObjectName(adminService.getDomainName() + ":" + "type=SSLAdmin,node=" + node + ",process=" + process + ",*");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLAdmin QueryName = " + queryName);
            }
            Set names = adminService.queryNames(queryName, null);
            ObjectName mBeanName = (ObjectName)names.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLAdmin MBeanName = " + mBeanName);
            }
            Object[] params = new Object[]{this.host, port, sslCfgAlias};
            String[] signature = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.String"};
            Certificate[] certChain = (Certificate[])adminService.invoke(mBeanName, "retrieveSignerFromPort", params, signature);
            if (certChain == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.no.signer.CWPKI0661E", new Object[]{this.host, port}, "Unable to get signer information from hostname \"" + this.host + "\" and port \"" + port + "\".  Verify hostname and port are correct.");
                throw new CommandValidationException(msg);
            }
            this.addCertToKeyStore((X509Certificate)certChain[0], this.certificateAlias, info);
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(info, session);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignerAndAddToKeyStore");
        }
    }

    public void addCertToKeyStore(X509Certificate cert, String alias, KeyStoreInfo info) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCertToKeyStore");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{alias, info.getName()}, "Alias \"" + alias + " already exists in key store \"" + info.getName() + "\".");
                throw new KeyStoreException(msg);
            }
            method2 = "checkIfSignerAlreadyExists";
            parms = new Object[]{cert};
            exists = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue()) {
                String msg = "Certificate already exists in key store.  May be under a different alias name.";
                throw new KeyStoreException(msg);
            }
            method2 = "setCertificateEntry";
            parms = new Object[]{alias, cert};
            wsksr.invokeKeyStoreCommand(method2, parms);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCertToKeyStore");
        }
    }
}

