/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import javax.management.ObjectName;

public class DeleteSignerCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteSignerCertificate.class, "SSL", "com.ibm.ws.ssl.commands.trustedCertificates");
    private String keyStoreName = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private KeyStoreInfo ksInfo = null;
    private KeyStoreInfo deletedKsInfo = null;

    public DeleteSignerCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteSignerCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            this.deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, this.keyStoreName);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.trustedCertificateDelete(this.ksInfo, this.deletedKsInfo, this.certAlias);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void trustedCertificateDelete(KeyStoreInfo info, KeyStoreInfo deletedInfo, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "certificateDelete");
        }
        WSKeyStoreRemotable wsksrDeleted = null;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        if (deletedInfo != null && !deletedInfo.getReadOnly().booleanValue()) {
            wsksrDeleted = new WSKeyStoreRemotable(deletedInfo);
        }
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            method2 = "isCertificateEntry";
            parms = new Object[]{alias};
            Object[] isCertEntry = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isCertEntry[0]).booleanValue()) {
                if (wsksrDeleted != null && !deletedInfo.getType().equals("JCERACFKS") && !deletedInfo.getType().equals("JCECCARACFKS")) {
                    String deletedAlias = info.getName() + "_" + alias;
                    method2 = "getCertificate";
                    parms = new Object[]{alias};
                    Object[] cert = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (cert[0] != null) {
                        method2 = "setCertificateEntry";
                        parms = new Object[]{deletedAlias, cert[0]};
                        wsksrDeleted.invokeKeyStoreCommand(method2, parms);
                    }
                }
            } else {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.not.exists.CWPKI0650E", new Object[]{alias, info.getName()}, "Signer certificate alias \"" + alias + "\" does not exist in key store \"" + info.getName() + "\".");
                throw new CommandValidationException(msg);
            }
            method2 = "deleteEntry";
            parms = new Object[]{alias};
            wsksr.invokeKeyStoreCommand(method2, parms);
            Session session = this.getConfigSession();
            if (info.getFileBased().booleanValue()) {
                PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
            }
            PersonalCertificateHelper.markSSLConfigChanged(info, session);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certificateDelete");
        }
    }
}

