/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.wsspi.ssl.WSPKIClient;
import com.ibm.wsspi.ssl.WSPKIException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RequestCACertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RequestCACertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private static final String USER_INSTALL_ROOT = System.getProperty("user.install.root");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certificateRequestAlias = null;
    private String certCommonName = null;
    private String certOrganization = null;
    private String certOrganizationalUnit = null;
    private int certSize = 0;
    private String certVersion = null;
    private String certZip = null;
    private String certCountry = null;
    private String certLocality = null;
    private String certState = null;
    private String caClientName = null;
    private String caClientScope = null;
    private String revocationPassword = null;
    private KeyStoreInfo ksInfo = null;
    private CertReqInfo certInfo = null;
    private ObjectName caClientObjName = null;
    private ObjectName keyStoreObjName = null;
    private boolean createCertRequest = true;

    public RequestCACertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public RequestCACertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName security2 = null;
        Object keyFileName = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateRequestAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
            this.certCommonName = (String)this.getParameter(CommandConstants.CERT_COMMON_NAME);
            this.certSize = (Integer)this.getParameter(CommandConstants.CERT_SIZE);
            this.certOrganization = (String)this.getParameter(CommandConstants.CERT_ORGANIZATION);
            this.certOrganizationalUnit = (String)this.getParameter(CommandConstants.CERT_ORGANIZATIONAL_UNIT);
            this.certLocality = (String)this.getParameter(CommandConstants.CERT_LOCALITY);
            this.certState = (String)this.getParameter(CommandConstants.CERT_STATE);
            this.certZip = (String)this.getParameter(CommandConstants.CERT_ZIP);
            this.certCountry = (String)this.getParameter(CommandConstants.CERT_COUNTRY);
            this.revocationPassword = (String)this.getParameter(CommandConstants.REVOCATION_PASSWORD);
            this.caClientName = (String)this.getParameter(CommandConstants.CACLIENT_NAME);
            this.caClientScope = (String)this.getParameter(CommandConstants.CACLIENT_SCOPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certificateRequestAlias=" + this.certificateRequestAlias + " certCommonName=" + this.certCommonName + " certSize=" + this.certSize + " certOrganization=" + this.certOrganization + " certOrganizationalUnit=" + this.certOrganizationalUnit + " certLocality=" + this.certLocality + " certState=" + this.certState + " certZip=" + this.certZip + " certCountry=" + this.certCountry + " certVersion=" + this.certVersion);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.keyStoreName}, this.keyStoreName + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            if (!this.ksInfo.getType().equals("JCERACFKS") && !this.ksInfo.getType().equals("JCECCARACFKS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Lowercase alias: " + this.certificateRequestAlias);
                }
                this.certificateRequestAlias = this.certificateRequestAlias.toLowerCase();
            }
            this.createCertRequest = this.createCertificateRequest(this.ksInfo);
            if (this.caClientScope == null) {
                this.caClientScope = commandHelper.defaultScope();
            }
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
            }
            AttributeList queryAttrs = new AttributeList();
            if (this.keyStoreName != null) {
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
                this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.keyStoreScope);
            }
            if (this.caClientName != null) {
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.caClientName);
                this.caClientObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.CACLIENTS, queryAttrs, this.caClientScope);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.RevokeCACertificate.validate", "%c%", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error processing parameters: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        boolean created = false;
        String subjectDN = null;
        String certReqFileName = null;
        String msg = null;
        int certValidDays = 365;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            if (!this.createCertRequest) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using a predefined certificate request");
                }
                AttributeList certReqAttrs = CertificateRequestHelper.getCertificateInfo(this.ksInfo, this.certificateRequestAlias);
                subjectDN = (String)ConfigServiceHelper.getAttributeValue(certReqAttrs, "requestedBy");
                String size = (String)ConfigServiceHelper.getAttributeValue(certReqAttrs, "size");
                this.certSize = Integer.parseInt(size);
                certReqFileName = (String)ConfigServiceHelper.getAttributeValue(certReqAttrs, "filename");
                this.certInfo = new CertReqInfo(this.certificateRequestAlias, this.certSize, subjectDN, certValidDays, this.ksInfo, certReqFileName);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating a certificate request");
                }
                String ksFilePath = this.ksInfo.getLocation();
                File path = new File(ksFilePath);
                String fileName = path.getName();
                File certReqFile = this.createTemporaryFile(fileName, ".req");
                certReqFileName = certReqFile.getAbsolutePath();
                certReqFile.delete();
                subjectDN = PersonalCertificateHelper.makeSubjectDN(this.certCommonName, this.certOrganization, this.certOrganizationalUnit, this.certLocality, this.certState, this.certZip, this.certCountry);
                this.certInfo = new CertReqInfo(this.certificateRequestAlias, this.certSize, subjectDN, certValidDays, this.ksInfo, certReqFileName);
                CertificateRequestHelper.personalCertificateCreate(session, this.certInfo);
            }
            created = this.caCertificateRequest(session, cs, this.certInfo, this.caClientObjName);
            msg = created ? TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.certComplete.CWPKI0708I", new Object[]{this.certificateRequestAlias}, "Certificate " + this.certificateRequestAlias + " is COMPLETE.") : TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.certComplete.CWPKI0709I", new Object[]{this.certificateRequestAlias}, "Certificate " + this.certificateRequestAlias + " is PENDING.");
            result.setResult(msg);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.RevokeCACertificate.afterStepsExecuted", "283", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error requesting CA certificate: ", e.getMessage());
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean caCertificateRequest(Session session, ConfigService cs, CertReqInfo ssCertInfo, ObjectName caClientObj) throws Exception {
        boolean certCreated;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "caCertificateRequest");
            }
            certCreated = false;
            String alias = null;
            KeyStoreInfo keyStoreInfo = null;
            String password = null;
            alias = ssCertInfo.getLabel();
            keyStoreInfo = ssCertInfo.getKsInfo();
            password = keyStoreInfo.getPassword();
            X509Certificate[] certs = null;
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            if (!((Boolean)exists[0]).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.request.CWPKI0690E", new Object[]{alias}, "Certificate request \"" + alias + "\" does not exist.  Unable to request a certificate from a Certificate Authority (CA).");
                throw new CommandValidationException(msg);
            }
            method2 = "getCertificate";
            parms = new Object[]{alias};
            Object[] certReq = wsksr.invokeKeyStoreCommand(method2, parms);
            X509Certificate certFromConfig = (X509Certificate)certReq[0];
            ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
            String implClassName = (String)cs.getAttribute(session, caClientObj, CommandConstants.CACLIENT_IMPL_CLASS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implentation class is " + implClassName);
            }
            HashMap customAttrs = this.getCustomAttrs(cs, session, caClientObj);
            byte[] certReqBytes = this.getCertReqBytes(ssCertInfo.getFilename());
            WSPKIClient pkiClient = null;
            try {
                pkiClient = (WSPKIClient)Class.forName(implClassName).newInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.requestCertificate", "374", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting WSPKIClient implementation.", new Object[]{e});
                }
                throw e;
            }
            try {
                if (pkiClient == null) {
                    Class<?> c = Class.forName(implClassName, true, ExtClassLoader.getInstance());
                    pkiClient = (WSPKIClient)c.newInstance();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.requestCertificate", "360", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting WSPKIClient implementation from ExtClassLoader.", new Object[]{e});
                }
                throw e;
            }
            try {
                pkiClient.init(customAttrs);
                certs = pkiClient.requestCertificate(certReqBytes, certFromConfig.getIssuerX500Principal(), this.revocationPassword.getBytes(), customAttrs);
                if (certs[0] != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cert returned now set it in the key store.");
                    }
                    method2 = "getKey";
                    parms = new Object[]{alias, password.toCharArray()};
                    Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (key != null) {
                        method2 = "setKeyEntryOverwrite";
                        parms = new Object[]{alias, (Key)key[0], password.toCharArray(), certs};
                        wsksr.invokeKeyStoreCommand(method2, parms);
                    }
                    certCreated = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No cert returned from the implementation. Create the certificate object in Pending state.");
                    }
                    this.createCACertObject(cs, session, security2, CommandConstants.PENDING);
                }
                if (!certCreated) break block22;
                this.createCACertObject(cs, session, security2, CommandConstants.COMPLETE);
                if (ssCertInfo.getKsInfo().getFileBased().booleanValue()) {
                    PersonalCertificateHelper.setWorkspaceUpdated(session, ssCertInfo.getKsInfo().getLocation());
                }
            }
            catch (WSPKIException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.requestCertificate", "", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from WSPKIClient implementation.", new Object[]{e});
                }
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.requestCertificate", "", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception create certificate object.", new Object[]{e});
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "caCertificateRequest");
        }
        return certCreated;
    }

    private boolean createCertificateRequest(KeyStoreInfo ksInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertificateRequest");
        }
        boolean isCertReq = false;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
        String method2 = "getCertificate";
        Object[] parms = new Object[]{this.certificateRequestAlias};
        Object[] cert = wsksr.invokeKeyStoreCommand(method2, parms);
        X509Certificate certRequest = (X509Certificate)cert[0];
        if (certRequest != null) {
            if (CertificateRequestHelper.isKeyCertReq(certRequest, this.certificateRequestAlias) == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{this.certificateRequestAlias}, "Certificate alias \"" + this.certificateRequestAlias + "\" is not a certificate request.");
                throw new CommandValidationException(msg);
            }
            if (this.certCommonName != null && this.certCommonName.length() != 0) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.info.CWPKI0691E", new Object[]{this.certificateRequestAlias}, "Certificate request \"" + this.certificateRequestAlias + "\" already exist.  Distinguished Name (DN) information was provided to create a new certificate request.  If using an existing certificate do not provide minimum DN information needed for a new certificate.");
                throw new CommandValidationException(msg);
            }
        } else if (this.certCommonName != null && this.certCommonName.length() != 0) {
            isCertReq = true;
        } else {
            String msg = TraceNLSHelper.getInstance().getString("ssl.command.need.cert.info.CWPKI0686E", "To request a certificate and not use an existing certificate request a certificateCommonName must be specified.");
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertificateRequest");
        }
        return isCertReq;
    }

    private HashMap getCustomAttrs(ConfigService cs, Session session, ObjectName caClientObj) throws Exception {
        AttributeList attributeList;
        String password;
        String userName;
        Integer port;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomAttrs");
        }
        HashMap<String, Object> customAttrs = new HashMap<String, Object>();
        String host = (String)cs.getAttribute(session, caClientObj, CommandConstants.HOST);
        if (host != null) {
            customAttrs.put("CAHostname", host);
        }
        if ((port = (Integer)cs.getAttribute(session, caClientObj, CommandConstants.PORT)) != null) {
            customAttrs.put("CAPort", port);
        }
        if ((userName = (String)cs.getAttribute(session, caClientObj, CommandConstants.CACLIENT_USERID)) != null) {
            customAttrs.put("AuthenticationID", userName);
        }
        if ((password = (String)cs.getAttribute(session, caClientObj, CommandConstants.PASSWORD)) != null) {
            customAttrs.put("AuthenticationPWD", password.getBytes());
        }
        if ((attributeList = cs.getAttributes(session, caClientObj, new String[]{"properties"}, false)) != null) {
            List props = (List)((Attribute)attributeList.get(0)).getValue();
            for (ObjectName property : props) {
                String propName = (String)cs.getAttribute(session, property, "name");
                String value = (String)cs.getAttribute(session, property, "value");
                if (propName == null || value == null) continue;
                customAttrs.put(propName, value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomAttrs");
        }
        return customAttrs;
    }

    private byte[] getCertReqBytes(String certReqFile) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertReqBytes");
        }
        FileInputStream fis = null;
        byte[] certReqBytes = null;
        fis = new FileInputStream(certReqFile);
        certReqBytes = new byte[fis.available()];
        fis.read(certReqBytes);
        CertificationRequest certReq = new CertificationRequest(certReqFile, true);
        certReqBytes = certReq.encode();
        if (fis != null) {
            fis.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertReqBytes");
        }
        return certReqBytes;
    }

    private void createCACertObject(ConfigService cs, Session session, ObjectName security2, String status) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating the caCertificate object");
        }
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "alias", this.certificateRequestAlias);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_STORE, this.keyStoreObjName);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CACLIENT, this.caClientObjName);
        ObjectName certificateObj = cs.createConfigData(session, security2, "certificates", "CACertificate", attrList);
        AttributeList attrs = cs.getAttributes(session, certificateObj, null, true);
        if (status.equals(CommandConstants.COMPLETE)) {
            ConfigServiceHelper.setAttributeValue(attrs, CommandConstants.CACERTIFICATE_STATUS, "COMPLETE");
        } else if (status.equals(CommandConstants.PENDING)) {
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CACERTIFICATE_STATUS, "PENDING");
        }
        cs.setAttributes(session, certificateObj, attrs);
    }

    private File createTemporaryFile(String prefix, String suffix) throws IOException {
        File dir;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemporaryFile");
        }
        File tempFile = File.createTempFile(prefix, suffix, (dir = new File(USER_INSTALL_ROOT + File.separator + "temp")).exists() ? dir : null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTemporaryFile");
        }
        return tempFile;
    }
}

