/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.management.ObjectName;

public class ReplaceCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ReplaceCertificate.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certificateAlias = null;
    private String replacementCertificateAlias = null;
    private Boolean deleteOldCert = null;
    private Boolean deleteOldSigners = null;
    private KeyStoreInfo ksInfo = null;
    private ConfigService cs = null;
    private Session session = null;

    public ReplaceCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ReplaceCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName security2 = null;
        try {
            this.cs = ConfigServiceFactory.getConfigService();
            this.session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName cell = this.cs.resolve(this.session, "Cell=")[0];
            if (cell != null) {
                security2 = this.cs.queryConfigObjects(this.session, cell, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.replacementCertificateAlias = (String)this.getParameter(CommandConstants.REPLACE_CERT_ALIAS);
            this.deleteOldCert = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_CERT);
            this.deleteOldSigners = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_SIGNERS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope= " + this.keyStoreScope + " certAlias=" + this.certificateAlias + " replacementCertificateAlias=" + this.replacementCertificateAlias + " deleteOldCert= " + this.deleteOldCert + " deleteOldSigners= " + this.deleteOldSigners);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            if (this.certificateAlias.equalsIgnoreCase(this.replacementCertificateAlias)) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.dup.alias.values.CWPKI0674E", new Object[]{"certificateAlias", "replacementCertificateAlias"}, "certificateAlias and replacementCertificate alias values must be different.");
                throw new CommandValidationException(msg);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(this.session, this.cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String resultString = this.personalCertificateReplace(this.ksInfo, this.certificateAlias, this.replacementCertificateAlias, this.deleteOldCert, this.deleteOldSigners, this.keyStoreScope);
            result.setResult(resultString);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public String personalCertificateReplace(KeyStoreInfo info, String certAlias, String replaceWithAlias, boolean delCert, boolean delSigners, String scope) throws Exception {
        StringBuffer resultString;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "personalCertificateReplace");
            }
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
            boolean readOnly = info.getReadOnly();
            Certificate[] origCertChain = null;
            Certificate[] replaceCertChain = null;
            Key key = null;
            Key origKey = null;
            resultString = new StringBuffer();
            X509Certificate cert = null;
            X509Certificate replaceCert = null;
            Session session = this.getConfigSession();
            Locale currentLocale = this.getLocale();
            if (currentLocale == null) {
                currentLocale = Locale.getDefault();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
                }
            }
            try {
                if (!readOnly) {
                    String method2 = "isKeyEntry";
                    Object[] parms = new Object[]{certAlias};
                    Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (((Boolean)isKeyEntry[0]).booleanValue()) {
                        method2 = "getCertificate";
                        parms = new Object[]{certAlias};
                        Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                        method2 = "getCertificateChain";
                        parms = new Object[]{certAlias};
                        Object[] origCertChainArray = wsksr.invokeKeyStoreCommand(method2, parms);
                        origCertChain = (Certificate[])origCertChainArray[0];
                        method2 = "getKey";
                        parms = new Object[]{certAlias, info.getPassword() != null ? info.getPassword().toCharArray() : null};
                        Object[] origKeyFromKS = wsksr.invokeKeyStoreCommand(method2, parms);
                        origKey = (Key)origKeyFromKS[0];
                        cert = (X509Certificate)certArray[0];
                        if (CertificateRequestHelper.isKeyCertReq(cert, certAlias) != null) {
                            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{certAlias}, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                            throw new CommandValidationException(msg);
                        }
                    } else {
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{certAlias}, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                        throw new CommandValidationException(msg);
                    }
                    method2 = "isKeyEntry";
                    parms = new Object[]{replaceWithAlias};
                    isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (((Boolean)isKeyEntry[0]).booleanValue()) {
                        method2 = "getCertificate";
                        parms = new Object[]{replaceWithAlias};
                        Object[] replaceCertArray = wsksr.invokeKeyStoreCommand(method2, parms);
                        replaceCert = (X509Certificate)replaceCertArray[0];
                        if (CertificateRequestHelper.isKeyCertReq(replaceCert, replaceWithAlias) != null) {
                            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{replaceWithAlias}, "Certificate \"" + replaceWithAlias + "\" is not a personal certificate.");
                            throw new CommandValidationException(msg);
                        }
                        method2 = "getCertificateChain";
                        parms = new Object[]{replaceWithAlias};
                        Object[] chain = wsksr.invokeKeyStoreCommand(method2, parms);
                        replaceCertChain = (Certificate[])chain[0];
                        method2 = "getKey";
                        parms = new Object[]{replaceWithAlias, info.getPassword() != null ? info.getPassword().toCharArray() : null};
                        Object[] keyFromKS = wsksr.invokeKeyStoreCommand(method2, parms);
                        key = (Key)keyFromKS[0];
                    } else {
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{replaceWithAlias}, "Certificate \"" + replaceWithAlias + "\" is not a personal certificate.");
                        throw new CommandValidationException(msg);
                    }
                }
                if (cert != null && replaceCert != null) {
                    PersonalCertificateHelper.changeAliasReferences(session, info, certAlias, replaceWithAlias);
                    resultString.append(PersonalCertificateHelper.replaceCerts(session, info, certAlias, cert, replaceWithAlias, replaceCert, replaceCertChain, key, delSigners, currentLocale));
                    CommandHelper commandHelper = new CommandHelper();
                    X509Certificate origRootCert = (X509Certificate)origCertChain[origCertChain.length - 1];
                    String origRootMD5Digest = KeyStoreManager.getInstance().generateDigest("MD5", origRootCert);
                    X509Certificate replaceRootCert = (X509Certificate)replaceCertChain[replaceCertChain.length - 1];
                    String replaceRootMD5Digest = KeyStoreManager.getInstance().generateDigest("MD5", replaceRootCert);
                    if (!replaceRootMD5Digest.equals(origRootMD5Digest)) {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "Certificate is signed by a new root certificate, add root signer to keystores where old root signer exists");
                        }
                        String rootKeyStoreName = null;
                        String usage = this.ksInfo.getUsage();
                        rootKeyStoreName = usage != null && usage.equals(CommandConstants.KS_USAGE_RSA) ? commandHelper.getDefaultKeyStoreName("RSATokenRootStore", session, this.cs) : commandHelper.getDefaultKeyStoreName("DefaultRootStore", session, this.cs);
                        String rootKeyStoreScope = commandHelper.getScopeForNodeKeyStore(session, this.cs, rootKeyStoreName);
                        KeyStoreInfo rootKsInfo = PersonalCertificateHelper.getKsInfo(session, this.cs, rootKeyStoreName, rootKeyStoreScope);
                        String replaceAlias = null;
                        WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(rootKsInfo);
                        String[] aliasArray = wsksHelper.getCertAliases();
                        for (int i = 0; i < aliasArray.length; ++i) {
                            String md5Digest;
                            BigInteger serialNumber;
                            String alias = aliasArray[i];
                            X509Certificate signer = wsksHelper.getSigner(alias);
                            if (signer == null || (serialNumber = signer.getSerialNumber()).compareTo(origRootCert.getSerialNumber()) != 0 || !(md5Digest = KeyStoreManager.getInstance().generateDigest("MD5", signer)).equals(origRootMD5Digest)) continue;
                            replaceAlias = alias;
                            break;
                        }
                        resultString.append(PersonalCertificateHelper.replaceCerts(session, rootKsInfo, null, origRootCert, replaceAlias, replaceRootCert, null, null, false, currentLocale));
                    }
                    if (delCert) {
                        WSKeyStoreRemotable wsksrDeleted = null;
                        KeyStoreInfo deletedInfo = commandHelper.getDeletedKeyStore(session, ConfigServiceFactory.getConfigService(), this.keyStoreName);
                        if (deletedInfo != null && !deletedInfo.getReadOnly().booleanValue()) {
                            wsksrDeleted = new WSKeyStoreRemotable(deletedInfo);
                        }
                        String method3 = null;
                        Object[] parms = null;
                        if (wsksrDeleted != null && !deletedInfo.getType().equals("JCERACFKS") && !deletedInfo.getType().equals("JCECCARACFKS")) {
                            String deletedAlias = info.getName() + "_" + certAlias;
                            method3 = "setKeyEntry";
                            parms = new Object[]{deletedAlias, origKey, deletedInfo.getPassword() != null ? deletedInfo.getPassword().toCharArray() : null, origCertChain};
                            wsksrDeleted.invokeKeyStoreCommand(method3, parms);
                            PersonalCertificateHelper.setWorkspaceUpdated(session, deletedInfo.getLocation());
                        }
                        method3 = "deleteEntry";
                        parms = new Object[]{certAlias};
                        wsksr.invokeKeyStoreCommand(method3, parms);
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.delete.CWPKI0647I", new Object[]{certAlias, info.getName()}, "Personal certificate alias \"" + certAlias + "\" was DELETED from KeyStore \"" + info.getName() + "\"", currentLocale);
                        resultString.append(System.getProperty("line.separator"));
                        resultString.append(msg);
                    }
                    if (info.getFileBased().booleanValue()) {
                        PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                    }
                    PersonalCertificateHelper.markSSLConfigChanged(info, session);
                    if (info.getName().endsWith("RSATokenKeyStore")) {
                        SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").reinitializeRSAProperties();
                    }
                    break block22;
                }
                String msg = "Certificate not found in keyStore.";
                throw new KeyStoreException(msg);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.personalCertificates.ReplaceCertificate", "%c%");
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateExport");
        }
        return resultString.toString();
    }
}

