/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListPersonalCertificates
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListPersonalCertificates.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String scopeName = null;

    public ListPersonalCertificates(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListPersonalCertificates(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            result.setResult(this.personalCertificateList(session, cs, this.keyStoreName, this.scopeName));
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public List personalCertificateList(Session session, ConfigService cs, String keyStore, String scope) throws Exception {
        KeyStoreInfo keyStoreInfo = null;
        List certList = null;
        try {
            keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, cs, keyStore, scope);
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        try {
            certList = this.getPersonalCerts(keyStoreInfo);
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        return certList;
    }

    public List getPersonalCerts(KeyStoreInfo keyStoreInfo) throws Exception {
        ArrayList<AttributeList> personalCerts = new ArrayList<AttributeList>();
        AttributeList certAttr = null;
        Locale currentLocale = this.getLocale();
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
            }
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            String method2 = "listPersonalCertificates";
            Object[] parms = null;
            Object[] certList = wsksr.invokeKeyStoreCommand(method2, parms);
            HashMap personalCertList = (HashMap)certList[0];
            for (String certAlias : personalCertList.keySet()) {
                Certificate[] cert = (Certificate[])personalCertList.get(certAlias);
                if (cert[0] == null || CertificateRequestHelper.isKeyCertReq((X509Certificate)cert[0], certAlias) != null) continue;
                certAttr = PersonalCertificateHelper.getCertAttrlist(certAlias, (X509Certificate)cert[0], currentLocale);
                personalCerts.add(certAttr);
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        return personalCerts;
    }
}

