/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String keyStoreLocation = null;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String keyStoreProvider = null;
    private Boolean keyStoreIsFileBased = null;
    private Boolean keyStoreReadOnly = null;
    private Boolean keyStoreInitAtStartup = null;
    private String scopeName = null;
    private String keyStoreDescription = null;
    private String keyStoreUsage = null;
    private Boolean keyStoreStashFile = null;
    private Boolean keyStoreForAcceleration = null;
    private String keyStoreHostList = null;
    private String keyStoreCustomProvider = null;
    private ObjectName keyStoreObjName = null;

    public ModifyKeyStore(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        Object pattern = null;
        ObjectName security2 = null;
        try {
            String tempKeyStoreType;
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreLocation = (String)this.getParameter(CommandConstants.KEY_STORE_LOCATION);
            this.keyStoreType = (String)this.getParameter(CommandConstants.KEY_STORE_TYPE);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.keyStoreIsFileBased = (Boolean)this.getParameter(CommandConstants.KEY_STORE_IS_FILE_BASED);
            this.keyStoreReadOnly = (Boolean)this.getParameter(CommandConstants.KEY_STORE_READ_ONLY);
            this.keyStoreInitAtStartup = (Boolean)this.getParameter(CommandConstants.KEY_STORE_INIT_AT_STARTUP);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.keyStoreDescription = (String)this.getParameter(CommandConstants.KEY_STORE_DESCRIPTION);
            this.keyStoreProvider = (String)this.getParameter(CommandConstants.KEY_STORE_PROVIDER);
            this.keyStoreUsage = (String)this.getParameter(CommandConstants.KEY_STORE_USAGE);
            String keyringPrefix = "safkeyring://";
            String keyringPrefixHW = "safkeyringhw://";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreLocation=" + this.keyStoreLocation + " keyStoreType=" + this.keyStoreType + " keyStorePassword=" + this.keyStorePassword + " keyStoreIsFileBased=" + this.keyStoreIsFileBased + " keyStoreReadOnly=" + this.keyStoreReadOnly + " keyStoreInitAtStartup=" + this.keyStoreInitAtStartup + " scopeName=" + this.scopeName + " keyStoreDescription=" + this.keyStoreDescription);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultScope();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (this.keyStoreObjName != null) {
                if (this.keyStoreIsFileBased == null) {
                    this.keyStoreIsFileBased = (Boolean)cs.getAttribute(session, this.keyStoreObjName, "fileBased");
                }
                if (this.keyStoreReadOnly == null) {
                    this.keyStoreReadOnly = (Boolean)cs.getAttribute(session, this.keyStoreObjName, "readOnly");
                }
                if (this.keyStoreInitAtStartup == null) {
                    this.keyStoreInitAtStartup = (Boolean)cs.getAttribute(session, this.keyStoreObjName, "initializeAtStartup");
                }
            }
            if (this.keyStoreUsage != null && !KeyStoreHelper.ValidUsage(this.keyStoreUsage)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.usage.not.valid.CWPKI0710E", "Usage is not valid.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Usage is not valid.");
                }
                throw new CommandValidationException(msg);
            }
            if (this.keyStoreType != null && !this.keyStoreType.equals("")) {
                if (this.keyStoreType.indexOf("(PKCS11)") >= 0) {
                    this.keyStoreType = "PKCS11";
                }
                if (this.keyStoreType.equals("PKCS11") || this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    this.keyStoreIsFileBased = Boolean.FALSE;
                }
            }
            if (this.keyStoreLocation != null && !this.keyStoreLocation.equals("")) {
                File keyFile;
                String msg;
                if (this.keyStoreType == null || this.keyStorePassword == null) {
                    String msg2 = TraceNLSHelper.getInstance().getString("ssl.command.missing.parameters.CWPKI0698E", "Must specify the keyStoreLocation, keyStoreType, and keyStorePassword to change the key store.");
                    throw new CommandValidationException(msg2);
                }
                if (this.keyStoreIsFileBased.booleanValue()) {
                    int status = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    if (status == 1) {
                        File libFile = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation));
                        status = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    }
                    if (status != 0) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyStoreLocation}, this.keyStoreName + " in the management scope " + this.scopeName + " already exists.");
                        throw new CommandValidationException(msg);
                    }
                } else if (this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    if (this.keyStoreLocation.startsWith(keyringPrefixHW)) {
                        keyringPrefix = keyringPrefixHW;
                    }
                    if (!this.keyStoreLocation.startsWith(keyringPrefix) || this.keyStoreLocation.startsWith(keyringPrefix) && this.keyStoreLocation.endsWith(keyringPrefix) || this.keyStoreLocation.endsWith("/")) {
                        String msg3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyring.uri.invalid.CWPKI0713E", new Object[]{this.keyStoreLocation}, "The SAF keyring location specified as \"" + this.keyStoreLocation + "\", is not valid.");
                        throw new CommandValidationException(msg3);
                    }
                    String[] slashes = this.keyStoreLocation.split("/");
                    if (slashes.length > 4) {
                        String msg4 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyring.uri.invalid.CWPKI0713E", new Object[]{this.keyStoreLocation}, "The SAF keyring location specified as \"" + this.keyStoreLocation + "\", is not valid.");
                        throw new CommandValidationException(msg4);
                    }
                    KeyStoreInfo ksInfo = new KeyStoreInfo(this.keyStoreName, this.keyStoreLocation, this.keyStorePassword, this.keyStoreProvider, this.keyStoreType, this.keyStoreIsFileBased, this.keyStoreHostList, this.scopeName, null, this.keyStoreReadOnly, this.keyStoreInitAtStartup, this.keyStoreStashFile, this.keyStoreCustomProvider, null, this.keyStoreForAcceleration, null, this.keyStoreDescription);
                    WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
                    String method2 = "load";
                    Object[] parms = new Object[]{this.keyStoreLocation, this.keyStoreType, this.keyStorePassword};
                    wsksr.invokeKeyStoreCommand(method2, parms);
                }
                if (!(this.keyStoreType == null || !this.keyStoreType.equalsIgnoreCase("PKCS11") || (keyFile = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation))) != null && keyFile.isFile() && keyFile.canRead())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key store file \"" + this.keyStoreLocation + "\" does not exist.");
                    }
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.check.file.CWPKI0673E", new Object[]{this.keyStoreLocation}, "Creating a read only key store object.  File \"" + this.keyStoreLocation + "\" should already exist.");
                    throw new CommandValidationException(msg);
                }
            }
            String tempKeyStoreLocation = this.keyStoreLocation == null ? (String)cs.getAttribute(session, this.keyStoreObjName, "location") : this.keyStoreLocation;
            String string = tempKeyStoreType = this.keyStoreType == null ? (String)cs.getAttribute(session, this.keyStoreObjName, "type") : this.keyStoreType;
            if ((tempKeyStoreType.equals("JCERACFKS") || tempKeyStoreType.equals("JCECCARACFKS")) && tempKeyStoreLocation.startsWith(keyringPrefix + "/") && !this.keyStoreReadOnly.booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.readonly.required.CWPKI0726E", "CWPKI0726E: Keystore location is not qualified with a user and must be marked as a read only key store.  Unable to perform write operations to this key store file.");
                throw new CommandValidationException(msg);
            }
            if (this.keyStoreProvider == null && this.keyStoreType != null) {
                if (this.keyStoreType.equals("CMSKS")) {
                    this.keyStoreProvider = "IBMCMSProvider";
                } else if (this.keyStoreType.equals("IBMi5OSKeyStore")) {
                    this.keyStoreProvider = "IBMi5OSJSSEProvider";
                } else if (this.keyStoreType.equals("PKCS11")) {
                    this.keyStoreProvider = "PKCS11";
                } else if (this.keyStoreType.equals("PKCS12") || this.keyStoreType.equals("JKS") || this.keyStoreType.equals("JCEKS")) {
                    this.keyStoreProvider = "IBMJCE";
                } else if (this.keyStoreType.equals("JCECCAKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    this.keyStoreProvider = "IBMJCECCA";
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
            AttributeList attrList = new AttributeList();
            if (this.keyStoreLocation != null && !this.keyStoreLocation.equals("")) {
                attrList.add(new Attribute("location", this.keyStoreLocation));
                if (this.keyStoreType != null && !this.keyStoreType.equals("")) {
                    attrList.add(new Attribute("type", this.keyStoreType));
                }
                if (this.keyStorePassword != null && !this.keyStorePassword.equals("")) {
                    attrList.add(new Attribute("password", this.keyStorePassword));
                }
                if (this.keyStoreProvider != null && !this.keyStoreProvider.equals("")) {
                    attrList.add(new Attribute("provider", this.keyStoreProvider));
                }
            }
            if (this.keyStoreIsFileBased != null) {
                attrList.add(new Attribute("fileBased", this.keyStoreIsFileBased));
            }
            if (this.keyStoreReadOnly != null) {
                attrList.add(new Attribute("readOnly", this.keyStoreReadOnly));
            }
            if (this.keyStoreInitAtStartup != null) {
                attrList.add(new Attribute("initializeAtStartup", this.keyStoreInitAtStartup));
            }
            if (this.keyStoreDescription != null) {
                attrList.add(new Attribute("description", this.keyStoreDescription));
            }
            if (this.keyStoreUsage != null) {
                attrList.add(new Attribute("usage", this.keyStoreUsage));
            }
            cs.setAttributes(session, this.keyStoreObjName, attrList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

