/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.cmskeystore.CMSLoadStoreParameterFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class CreateCMSKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateCMSKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String cmsKeyStoreURI = null;
    private String pluginHostName = null;
    private String keyStoreName = null;
    private String keyStoreLocation = null;
    private String workspaceKeyStoreLocation = null;
    private String nodeName = null;
    private String cellName = null;
    private String serverName = null;
    private String scopeName = null;
    private String rootAlias = null;
    private ObjectName mgmScopeObjName = null;
    private boolean createMgmScope = false;
    private KeyStoreInfo rootKsInfo = null;
    private String rootKeyStoreName = null;
    private KeyStoreInfo signersKsInfo = null;
    private String defaultSignersKeyStoreName = null;
    private String vmName = System.getProperty("java.vm.name");

    public CreateCMSKeyStore(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateCMSKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName security2 = null;
        boolean keyStoreFound = false;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.cmsKeyStoreURI = (String)this.getParameter(CommandConstants.CMS_KEY_STORE_URI);
            this.pluginHostName = (String)this.getParameter(CommandConstants.PLUGIN_HOSTNAME);
            WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
            String expandedWorkspaceRoot = ws.getPath();
            this.keyStoreLocation = CreateCMSKeyStore.fixupLocationWithRepositoryRoot("${CONFIG_ROOT}", this.cmsKeyStoreURI);
            this.workspaceKeyStoreLocation = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(expandedWorkspaceRoot, this.cmsKeyStoreURI);
            this.scopeName = this.getScopeFromURI(this.keyStoreLocation, "server");
            this.keyStoreName = "CMSKeyStore";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cmsKeyStoreURI=" + this.cmsKeyStoreURI + " pluginHostName=" + this.pluginHostName + " keyStoreName=" + this.keyStoreName + " keyStoreLocation=" + this.keyStoreLocation + " scope=" + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            keyStoreFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (keyStoreFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keyStoreName, this.scopeName}, this.keyStoreName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean mgmScopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (!mgmScopeNameFound) {
                this.createMgmScope = true;
            } else {
                this.mgmScopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mgmScopeObjName: " + this.mgmScopeObjName);
                }
            }
            boolean isDmgrNode = commandHelper.isDmgrNode(session, cs);
            if (isDmgrNode) {
                this.rootKeyStoreName = "DmgrDefaultRootStore";
                this.defaultSignersKeyStoreName = "DmgrDefaultSignersStore";
            } else {
                this.rootKeyStoreName = "NodeDefaultRootStore";
                this.defaultSignersKeyStoreName = "NodeDefaultSignersStore";
            }
            String rootKeyStoreScope = commandHelper.getScopeForNodeKeyStore(session, cs, this.rootKeyStoreName);
            this.rootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.rootKeyStoreName, rootKeyStoreScope);
            this.rootAlias = (String)PersonalCertificateHelper.getCustomProperty(cs, session, security2, "com.ibm.ssl.rootCertAlias");
            this.signersKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.defaultSignersKeyStoreName, rootKeyStoreScope);
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e, e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    private String getNodeURIFromPath(String workspaceLocation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellURIFromPath", new Object[]{workspaceLocation});
        }
        String workspaceURI = null;
        int index = workspaceLocation.indexOf("nodes/");
        workspaceURI = index != -1 ? workspaceLocation.substring(index) : workspaceLocation;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellURIFromPath");
        }
        return workspaceURI;
    }

    private String changeToStashURIPath(String path) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeToStashURIPath", new Object[]{path});
        }
        int index = path.lastIndexOf(".");
        String stashFile = null;
        if (index != -1) {
            String firstPart = path.substring(0, index);
            stashFile = firstPart + ".sth";
        } else {
            stashFile = path;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeToStashURIPath -> " + stashFile);
        }
        return stashFile;
    }

    private String getScopeFromURI(String cmsKeyStoreURI, String type) throws CommandValidationException {
        cmsKeyStoreURI = cmsKeyStoreURI.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeFromURI", new Object[]{cmsKeyStoreURI});
        }
        StringBuffer scope = new StringBuffer();
        try {
            int index = cmsKeyStoreURI.indexOf("/cells/");
            int cellBeginIndex = index + "/cells/".length();
            int cellEndIndex = cmsKeyStoreURI.indexOf("/nodes/");
            int nodeEndIndex = cmsKeyStoreURI.indexOf("/servers/");
            this.cellName = cmsKeyStoreURI.substring(cellBeginIndex, cellEndIndex);
            this.nodeName = cmsKeyStoreURI.substring(cellEndIndex + "/nodes/".length(), nodeEndIndex);
            this.serverName = cmsKeyStoreURI.substring(nodeEndIndex + "/servers/".length(), cmsKeyStoreURI.lastIndexOf("/"));
            if (type.equals("cell") || type.equals("node") || type.equals("server")) {
                scope.append("(cell):");
                scope.append(this.cellName);
            }
            if (type.equals("node") || type.equals("server")) {
                scope.append(":(node):");
                scope.append(this.nodeName);
            }
            if (type.equals("server")) {
                scope.append(":(server):");
                scope.append(this.serverName);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getScopeFromURI exception is" + e.getMessage());
            }
            InvalidParameterValueException ipve = new InvalidParameterValueException(this.getName(), "cmsKeyStoreURI", cmsKeyStoreURI);
            throw new CommandValidationException(ipve, ipve.getMessage() + ".  Please put the KeyStore under <USER.INSTALL.ROOT>/config/cells/<cell_name>/nodes/<node_name>/servers/<server_name>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeFromURI -> " + scope.toString());
        }
        return scope.toString();
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectCreated = null;
        ObjectName securityObject = null;
        AttributeList attrList = new AttributeList();
        ConfigService cs = null;
        Session session = null;
        String description = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String sthFileURI;
            ManagementScopeData thisMSD;
            cs = ConfigServiceFactory.getConfigService();
            session = this.getConfigSession();
            securityObject = cs.resolve(session, "Cell=:Security=")[0];
            ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
            if (this.createMgmScope) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                this.mgmScopeObjName = cs.createConfigData(session, securityObject, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
                attrList.clear();
            }
            String keyStoreType = null;
            String keyStoreProvider = null;
            String keyStorePassword = "WebAS";
            if (PlatformHelperFactory.getPlatformHelper().isOS400() && this.vmName.equals("Classic VM")) {
                keyStoreType = "IBMi5OSKeyStore";
                keyStoreProvider = "IBMi5OSJSSEProvider";
            } else {
                keyStoreType = "CMSKS";
                keyStoreProvider = "IBMCMSProvider";
            }
            String serverName = scopeData.getProcessName();
            description = TraceNLSHelper.getInstance().getFormattedMessage("cmsKeyStoreDesc", new Object[]{serverName}, "CMSKeyStore for web server " + serverName);
            KeyStoreInfo ksInfo = new KeyStoreInfo(this.keyStoreName, this.keyStoreLocation, keyStorePassword, keyStoreProvider, keyStoreType, Boolean.TRUE, null, this.scopeName, this.mgmScopeObjName, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, null, new Integer(0), Boolean.FALSE, null, description);
            objectCreated = KeyStoreHelper.createKeyStoreObjectName(session, ksInfo);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.mgmScopeObjName);
            cs.setAttributes(session, objectCreated, attrList);
            attrList.clear();
            com.ibm.websphere.models.config.ipc.ssl.KeyStore cmsKeyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)objectCreated);
            com.ibm.websphere.models.config.ipc.ssl.KeyStore defaultTrustStore = null;
            com.ibm.websphere.models.config.ipc.ssl.KeyStore nodeKeyStore = null;
            ManagementScopeData nodeKeyStoreMSD = new ManagementScopeData(this.scopeName);
            Security security2 = (Security)MOFUtil.convertToEObject((Session)session, (ObjectName)securityObject);
            EList keyStoreList = security2.getKeyStores();
            for (int i = 0; i < keyStoreList.size(); ++i) {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)keyStoreList.get(i);
                if (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager")) {
                    if (keyStore.getName().endsWith("DefaultTrustStore") && keyStore.getManagementScope().getScopeType().equals("cell")) {
                        defaultTrustStore = keyStore;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using trust store name: " + defaultTrustStore.getName() + " with scope " + defaultTrustStore.getManagementScope().getScopeName());
                        }
                    }
                } else if (keyStore.getName().endsWith("DefaultTrustStore") && keyStore.getManagementScope().getScopeType().equals("node")) {
                    defaultTrustStore = keyStore;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using trust store name: " + defaultTrustStore.getName() + " with scope " + defaultTrustStore.getManagementScope().getScopeName());
                    }
                }
                if (!keyStore.getName().endsWith("NodeDefaultKeyStore") || !keyStore.getManagementScope().getScopeType().equals("node")) continue;
                thisMSD = new ManagementScopeData(keyStore.getManagementScope().getScopeName());
                if (!nodeKeyStoreMSD.formNodeScope().equals(thisMSD.formNodeScope())) continue;
                nodeKeyStore = keyStore;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Using key store name: " + nodeKeyStore.getName() + " with scope " + nodeKeyStore.getManagementScope().getScopeName());
            }
            KeyStoreInfo defaultTrustStoreInfo = PersonalCertificateHelper.getKsInfo(session, cs, defaultTrustStore.getName(), defaultTrustStore.getManagementScope().getScopeName());
            this.checkIfCMSKeyStoreExistsAndCreateIfNot(nodeKeyStore, defaultTrustStore, defaultTrustStoreInfo, this.workspaceKeyStoreLocation, cmsKeyStore, this.pluginHostName);
            PersonalCertificateHelper.setWorkspaceUpdated(session, defaultTrustStoreInfo.getLocation());
            WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "cellName = " + this.cellName);
            }
            thisMSD = new ManagementScopeData(defaultTrustStore.getManagementScope().getScopeName());
            RepositoryContext cellC = ws.findContext("cells/" + thisMSD.getCellName());
            String kdbFileURI = this.getNodeURIFromPath(this.workspaceKeyStoreLocation);
            if (kdbFileURI != null) {
                cellC.notifyChanged(0, kdbFileURI);
            }
            if ((sthFileURI = this.changeToStashURIPath(kdbFileURI)) != null) {
                cellC.notifyChanged(0, sthFileURI);
            }
            result.setResult(objectCreated);
        }
        catch (Exception e) {
            try {
                if (objectCreated != null && cs != null && session != null) {
                    cs.deleteConfigData(session, objectCreated);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private static String fixupLocationWithRepositoryRoot(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/cells/");
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + newPath);
        }
        return newPath;
    }

    public void checkIfCMSKeyStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore defaultKeyStore, com.ibm.websphere.models.config.ipc.ssl.KeyStore defaultTrustStore, KeyStoreInfo defaultTrustStoreInfo, String workspaceKeyStoreLocation, com.ibm.websphere.models.config.ipc.ssl.KeyStore cmsKeyStore, String nodeHostName) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfCMSKeyStoreExistsAndCreateIfNot", new Object[]{cmsKeyStore.getLocation(), nodeHostName});
        }
        try {
            File nodeStore;
            String scope;
            String password;
            String provider;
            String type;
            String location;
            boolean fileBased;
            Session session = this.getConfigSession();
            boolean readOnly = false;
            JSSEProviderFactory.initializeIBMCMSProvider();
            String profileRoot = KeyStoreManager.getConfigRoot();
            String expandedConfigRoot = null;
            if (this.rootAlias == null) {
                this.rootAlias = "root";
            }
            expandedConfigRoot = profileRoot != null ? profileRoot : KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
            String cmsLocation = cmsKeyStore.getLocation();
            boolean cmsstoremodified = false;
            cmsLocation = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(expandedConfigRoot, cmsLocation);
            KeyStore cmsStore = null;
            KeyStore.LoadStoreParameter loadParm = null;
            File cmsLocationFile = new File(cmsLocation);
            File workspaceKeyStoreLocationFile = new File(workspaceKeyStoreLocation);
            if (cmsLocationFile.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfCMSKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                return;
            }
            if (cmsKeyStore == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfCMSKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                throw new SSLException("WCCM KeyStore object for CMS keystore is null.");
            }
            if (defaultKeyStore != null) {
                readOnly = defaultKeyStore.isReadOnly();
            }
            if (defaultKeyStore != null && !readOnly) {
                fileBased = defaultKeyStore.isFileBased();
                location = defaultKeyStore.getLocation();
                type = defaultKeyStore.getType();
                provider = defaultKeyStore.getProvider();
                password = defaultKeyStore.getPassword();
                scope = defaultKeyStore.getManagementScope().getScopeName();
                String keyStoreName = defaultKeyStore.getName();
                if (keyStoreName != null && keyStoreName.endsWith("DefaultKeyStore") && fileBased) {
                    location = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(expandedConfigRoot, location);
                    location = KeyStoreManager.getInstance().expand(location);
                    nodeStore = new File(location);
                    if (!nodeStore.exists()) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot -> (does not exist)");
                        }
                        throw new SSLException("Cannot find Node's DefaultKeyStore named " + keyStoreName + " at location " + location);
                    }
                }
                KeyStore defaultJavaKeyStore = KeyStoreManager.getInstance().getKeyStore(null, type, provider, workspaceKeyStoreLocation, password, scope, false, null);
                String cmsType = null;
                cmsType = PlatformHelperFactory.getPlatformHelper().isOS400() && this.vmName.equals("Classic VM") ? "IBMi5OSKeyStore" : "CMSKS";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extracting certificate from default KeyStore to use in CMS store.");
                }
                String alias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                Key privateKey = defaultJavaKeyStore.getKey(alias, password.toCharArray());
                Certificate[] certChain = defaultJavaKeyStore.getCertificateChain(alias);
                if (privateKey != null && certChain != null) {
                    HashMap<String, X509Certificate> signerCerts;
                    cmsStore = KeyStore.getInstance(cmsType, cmsKeyStore.getProvider());
                    cmsStore.load(null, cmsKeyStore.getPassword().toCharArray());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing CMS default signers from keystore");
                    }
                    Enumeration<String> aliases = cmsStore.aliases();
                    String a = null;
                    while (aliases.hasMoreElements()) {
                        a = aliases.nextElement();
                        if (!cmsStore.isCertificateEntry(a)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing signer with alias " + a + " from key store " + cmsLocation + ".");
                        }
                        cmsStore.deleteEntry(a);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WAS default signers to CMS keystore");
                    }
                    if ((signerCerts = KeyStoreHelper.getDefaultSigners(session, this.signersKsInfo)).size() > 0 && !readOnly) {
                        for (String key : signerCerts.keySet()) {
                            X509Certificate certificate = signerCerts.get(key);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding signer with alias " + key + " to key store " + cmsLocation + ".");
                            }
                            cmsStore.setCertificateEntry(key, certificate);
                        }
                    }
                    if (cmsStore != null) {
                        cmsStore.setKeyEntry(alias, privateKey, cmsKeyStore.getPassword().toCharArray(), certChain);
                        cmsstoremodified = true;
                    }
                    if (!defaultTrustStore.isReadOnly() && certChain.length > 1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Add new signer certificate to trust store: " + defaultTrustStore.getName());
                        }
                        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(defaultTrustStoreInfo);
                        String method2 = "setCertificateEntry";
                        Object[] parms = new Object[]{alias, certChain[certChain.length - 1]};
                        wsksr.invokeKeyStoreCommand(method2, parms);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trust store is read only, unable to add new signer certificate to trust store: " + defaultTrustStore.getName());
                    }
                }
            }
            if (!cmsstoremodified) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default keystore is not found in repository, creating a new certificate for CMS store.");
                }
                String name = cmsKeyStore.getName();
                String password2 = cmsKeyStore.getPassword();
                type = cmsKeyStore.getType();
                provider = cmsKeyStore.getProvider();
                String scope2 = cmsKeyStore.getManagementScope().getScopeName();
                boolean stash = cmsKeyStore.isCreateStashFileForCMS();
                Boolean stashBoolean = new Boolean(stash);
                Boolean fileBasedBoolean = Boolean.TRUE;
                Boolean readOnlyBoolean = Boolean.FALSE;
                Boolean initializeAtStartupBoolean = Boolean.TRUE;
                String description = cmsKeyStore.getDescription();
                KeyStoreInfo ksInfo = new KeyStoreInfo(name, workspaceKeyStoreLocation, password2, provider, type, fileBasedBoolean, null, scope2, null, readOnlyBoolean, initializeAtStartupBoolean, stashBoolean, null, new Integer(0), Boolean.FALSE, null, description);
                String sizeString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                String subjectDN = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US");
                KeyStoreManager.getInstance();
                subjectDN = KeyStoreManager.expandHostNameVariable(subjectDN, nodeHostName);
                String daysString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "5475");
                int size = new Integer(sizeString);
                int days = new Integer(daysString);
                String alias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                CertReqInfo certReq = new CertReqInfo(alias, size, subjectDN, days, ksInfo, null);
                WSKeyStoreHelper wsksh = null;
                if (this.rootKsInfo != null) {
                    wsksh = new WSKeyStoreHelper(this.rootKsInfo);
                }
                X509Certificate signer = null;
                signer = wsksh != null && wsksh.containsAlias(this.rootAlias) && wsksh.isCertKeyEntry(this.rootAlias) ? PersonalCertificateHelper.chainedCertificateCreate(certReq, this.rootAlias, this.rootKsInfo, session) : PersonalCertificateHelper.personalCertificateCreate(certReq, session);
                KeyStoreHelper.removeSigners(ksInfo);
                if (this.signersKsInfo != null) {
                    KeyStoreHelper.addDefaultSigners(session, ksInfo, this.signersKsInfo);
                }
                if (defaultTrustStoreInfo != null) {
                    WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(defaultTrustStoreInfo);
                    String method3 = "listSignerCertificates";
                    Object[] parms = null;
                    Object[] certList = wsksr.invokeKeyStoreCommand(method3, parms);
                    WSKeyStoreRemotable cmsStoreWsksr = new WSKeyStoreRemotable(ksInfo);
                    HashMap signerCertList = (HashMap)certList[0];
                    for (String certAlias : signerCertList.keySet()) {
                        X509Certificate cert = (X509Certificate)signerCertList.get(certAlias);
                        if (cert == null) continue;
                        method3 = "setCertificateEntry";
                        parms = new Object[]{certAlias, cert};
                        cmsStoreWsksr.invokeKeyStoreCommand(method3, parms);
                    }
                    if (!defaultTrustStore.isReadOnly() && signer != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Add new signer certificate to trust store: " + defaultTrustStore.getName());
                        }
                        method3 = "setCertificateEntry";
                        parms = new Object[]{alias, signer};
                        wsksr.invokeKeyStoreCommand(method3, parms);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trust store is read only, unable to add new signer certificate to trust store: " + defaultTrustStore.getName());
                    }
                }
            }
            if (cmsStore != null) {
                if (defaultTrustStore != null) {
                    fileBased = defaultTrustStore.isFileBased();
                    location = defaultTrustStore.getLocation();
                    type = defaultTrustStore.getType();
                    provider = defaultTrustStore.getProvider();
                    password = defaultTrustStore.getPassword();
                    scope = defaultTrustStore.getManagementScope().getScopeName();
                    String trustStoreName = defaultTrustStore.getName();
                    readOnly = defaultTrustStore.isReadOnly();
                    nodeStore = null;
                    if (trustStoreName != null && trustStoreName.endsWith("DefaultTrustStore") && fileBased) {
                        location = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(expandedConfigRoot, location);
                        nodeStore = new File(location);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trust store passed in is not default or file-based, not adding signers to CMS store.");
                    }
                    if (nodeStore != null && nodeStore.exists() || readOnly) {
                        KeyStore defaultJavaTrustStore = KeyStoreManager.getInstance().getKeyStore(null, type, provider, location, password, scope, false, null);
                        if (defaultJavaTrustStore != null) {
                            Enumeration<String> aliases = defaultJavaTrustStore.aliases();
                            while (aliases.hasMoreElements()) {
                                String alias = aliases.nextElement();
                                if (!defaultJavaTrustStore.isCertificateEntry(alias)) continue;
                                X509Certificate signer = (X509Certificate)defaultJavaTrustStore.getCertificate(alias);
                                boolean exists = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore(signer, cmsStore);
                                if (!exists && !cmsStore.containsAlias(alias)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding alias \"" + alias + "\" to CMS keystore.");
                                    }
                                    cmsStore.setCertificateEntry(alias, signer);
                                    cmsstoremodified = true;
                                    continue;
                                }
                                if (exists) continue;
                                int num = 1;
                                String newAlias = null;
                                while (cmsStore.containsAlias(newAlias = alias + "_" + num++)) {
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding alias \"" + newAlias + "\" to CMS keystore.");
                                }
                                if (cmsStore.containsAlias(newAlias)) continue;
                                cmsStore.setCertificateEntry(newAlias, signer);
                                cmsstoremodified = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load Java KeyStore from repository.  Not adding signers to CMS store.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot find the default trust store on the file system.  Not adding signers to CMS store.");
                    }
                }
                if (cmsstoremodified) {
                    if (PlatformHelperFactory.getPlatformHelper().isOS400() && this.vmName.equals("Classic VM")) {
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            Class<?> permClass = null;
                            permClass = cl != null ? cl.loadClass("com.ibm.i5os.keystore.i5OSLoadStoreParameter") : Class.forName("com.ibm.i5os.keystore.i5OSLoadStoreParameter");
                            KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(cmsKeyStore.getPassword().toCharArray());
                            Constructor<?> constructor = permClass.getConstructor(File.class, KeyStore.PasswordProtection.class);
                            loadParm = (KeyStore.LoadStoreParameter)constructor.newInstance(workspaceKeyStoreLocationFile, protection);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException(e, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfKeyStoreExistsAndCreateIfNot", "934", this, new Object[]{e});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Could not load iSeries LoadStoreParameter to store the CMS keystore.", new Object[]{e});
                            }
                            throw new SSLException(e.getMessage(), e);
                        }
                    } else if (cmsKeyStore.getType().equals("CMSKS") && cmsKeyStore.isCreateStashFileForCMS()) {
                        loadParm = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)workspaceKeyStoreLocationFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(cmsKeyStore.getPassword().toCharArray()), (boolean)true);
                    } else if (cmsKeyStore.getType().equals("CMSKS")) {
                        loadParm = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)workspaceKeyStoreLocationFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(cmsKeyStore.getPassword().toCharArray()), (boolean)false);
                    }
                    if (loadParm != null) {
                        cmsStore.store(loadParm);
                    } else {
                        FileOutputStream fos = new FileOutputStream(workspaceKeyStoreLocation);
                        cmsStore.store(fos, cmsKeyStore.getPassword().toCharArray());
                        if (fos != null) {
                            fos.close();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfKeyStoreExistsAndCreateIfNot", "962", this, new Object[]{e});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating CMS keystore.", new Object[]{e});
            }
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot (success)");
        }
    }

    private String getNameFromURI(String cmsKeyStoreURI, String type) throws CommandValidationException {
        cmsKeyStoreURI = cmsKeyStoreURI.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameFromURI", new Object[]{cmsKeyStoreURI});
        }
        StringBuffer scope = new StringBuffer();
        try {
            int index = cmsKeyStoreURI.indexOf("/cells/");
            int cellBeginIndex = index + "/cells/".length();
            int cellEndIndex = cmsKeyStoreURI.indexOf("/nodes/");
            int nodeEndIndex = cmsKeyStoreURI.indexOf("/servers/");
            this.cellName = cmsKeyStoreURI.substring(cellBeginIndex, cellEndIndex);
            this.nodeName = cmsKeyStoreURI.substring(cellEndIndex + "/nodes/".length(), nodeEndIndex);
            this.serverName = cmsKeyStoreURI.substring(nodeEndIndex + "/servers/".length(), cmsKeyStoreURI.lastIndexOf("/"));
            if (type.equals("cell")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNameFromURI -> " + this.cellName);
                }
                return this.cellName;
            }
            if (type.equals("node")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNameFromURI -> " + this.nodeName);
                }
                return this.nodeName;
            }
            if (type.equals("server")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNameFromURI -> " + this.serverName);
                }
                return this.serverName;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getNameFromURI exception is" + e.getMessage());
            }
            InvalidParameterValueException ipve = new InvalidParameterValueException(this.getName(), "getNameFromURI", cmsKeyStoreURI);
            throw new CommandValidationException(ipve, ipve.getMessage() + ".  Please put the KeyStore under <USER.INSTALL.ROOT>/config/cells/<cell_name>/nodes/<node_name>/servers/<server_name>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeFromURI -> " + scope.toString());
        }
        return scope.toString();
    }
}

