/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.adminagent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class AgentProfileServerIDExchanger {
    private static TraceComponent tc = Tr.register(AgentProfileServerIDExchanger.class, "SSL", "com.ibm.ws.ssl.resources.sslCommandTask");
    String profileKey = null;
    String profileConfigPath = null;
    String profileCellName = null;
    String profileNodeName = null;
    Security profileSecurityXML = null;
    ConfigService profileConfigService = null;
    WorkSpace profileWorkSpace = null;
    String agentConfigPath = null;
    String agentCellName = null;
    String agentNodeName = null;
    Security agentSecurityXML = null;
    ConfigService agentConfigService = null;
    WorkSpace agentWorkSpace = null;

    public void exchangeServerIDs(String profilePath, String agentPath, Session session, boolean register) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exchangeServerIDs", new Object[]{profilePath, agentPath, session, new Boolean(register)});
        }
        try {
            this.profileConfigPath = this.getConfigRootFromProfileHome(profilePath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The profile config path is: " + this.profileConfigPath);
            }
            this.agentConfigPath = this.getConfigRootFromProfileHome(agentPath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The agent config path is: " + this.agentConfigPath);
            }
            this.profileWorkSpace = this.getWorkSpace(this.profileConfigPath);
            this.profileSecurityXML = this.getCellSecurityObject(this.profileConfigPath, this.profileWorkSpace);
            WorkSpaceManagerImpl wmgr = (WorkSpaceManagerImpl)WorkSpaceManagerFactory.getManager();
            wmgr.releaseWorkSpace(this.profileWorkSpace.getUserName());
            this.agentWorkSpace = this.getWorkSpace(this.agentConfigPath);
            this.agentSecurityXML = this.getCellSecurityObject(this.agentConfigPath, this.agentWorkSpace);
            if (this.agentSecurityXML != null && this.agentSecurityXML.isEnabled() && this.profileSecurityXML != null && this.profileSecurityXML.isEnabled()) {
                UserRegistry profileRegistry;
                boolean isProfileUseRegistryServerID;
                String[] profileCellAndNode = this.getCellAndNodeName(this.profileConfigPath);
                this.profileCellName = profileCellAndNode[0];
                this.profileNodeName = profileCellAndNode[1];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The profile cell and node names are: " + this.profileCellName + ":" + this.profileNodeName);
                }
                String[] agentCellAndNode = this.getCellAndNodeName(this.agentConfigPath);
                this.agentCellName = agentCellAndNode[0];
                this.agentNodeName = agentCellAndNode[1];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The agent cell and node names are: " + this.agentCellName + ":" + this.agentNodeName);
                }
                this.profileKey = this.getProfileKey(profilePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The profile key is: " + this.profileKey);
                }
                this.profileConfigService = this.getConfigService(this.profileKey);
                this.agentConfigService = this.getConfigService(null);
                UserRegistry agentRegistry = this.agentSecurityXML.getActiveUserRegistry();
                boolean isAgentUseRegistryServerID = agentRegistry.isUseRegistryServerId();
                if (isAgentUseRegistryServerID) {
                    String agentServerID = agentRegistry.getServerId();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The agent server ID is: " + agentServerID);
                    }
                    if (agentServerID != null && agentServerID.length() > 0) {
                        if (register) {
                            String agentAccessID = this.getAccessIDFromServerID(null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The agent access ID is: " + agentAccessID);
                            }
                            if (agentAccessID != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding the agent userID to profile administrator and naming role.");
                                }
                                this.addUserToAdminAndNamingRole(this.profileKey, agentServerID, agentAccessID);
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Removing the agent userID from profile administrator role and naming role.");
                            }
                            this.removeUserFromAdminAndNamingRole(this.profileKey, agentServerID);
                        }
                    }
                }
                if (isProfileUseRegistryServerID = (profileRegistry = this.profileSecurityXML.getActiveUserRegistry()).isUseRegistryServerId()) {
                    String profileServerID = profileRegistry.getServerId();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The profile server ID is: " + profileServerID);
                    }
                    if (profileServerID != null && profileServerID.length() > 0) {
                        if (register) {
                            String profileAccessID = this.getAccessIDFromServerID(this.profileKey);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The profile access ID is: " + profileAccessID);
                            }
                            System.out.println("The profile access ID is: " + profileAccessID);
                            if (profileAccessID != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding the profile userID to agent administrator role and naming role.");
                                }
                                this.addUserToAdminAndNamingRole(null, profileServerID, profileAccessID);
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Removing the profile userID from agent administrator role and naming role.");
                            }
                            this.removeUserFromAdminAndNamingRole(null, profileServerID);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is not enabled in the profile and/or agent.");
            }
            wmgr.releaseWorkSpace(this.agentWorkSpace.getUserName());
        }
        catch (Exception e) {
            WorkSpaceManagerImpl wmgr = (WorkSpaceManagerImpl)WorkSpaceManagerFactory.getManager();
            wmgr.releaseWorkSpace(this.agentWorkSpace.getUserName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in exchangeServerIDs: ", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.adminagent.AgentProfileServerIDExchanger.exchangeServerIDs", "192", this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exchangeServerIDs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProfileKey(String profilePath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProfileKey");
        }
        String pKey = null;
        AdminCommand cmd = null;
        Session session = new Session();
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            cmd = cmdMgr.createCommand("getProfileKey");
            cmd.setParameter("profilePath", profilePath);
            cmd.setConfigSession(session);
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (!result.isSuccessful()) {
            } else {
                pKey = (String)result.getResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ConfigServiceFactory.getConfigService().discard(session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProfileKey", pKey);
        }
        return pKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccessIDFromServerID(String key) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessIDFromServerID");
        }
        String accessID = null;
        final Session session = new Session();
        boolean pushed = false;
        try {
            pushed = AdminContext.push(key);
            accessID = (String)SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AdminCommand cmd = null;
                    CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                    cmd = cmdMgr.createCommand("getAccessIdFromServerId");
                    cmd.setConfigSession(session);
                    cmd.execute();
                    CommandResult result = cmd.getCommandResult();
                    if (!result.isSuccessful()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getAccessIDFromServerID was unsuccessful.");
                        }
                        return null;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getAccessIDFromServerID: ", result.getResult());
                    }
                    return (String)result.getResult();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting access ID: ", new Object[]{e.getException()});
            }
        }
        finally {
            ConfigServiceFactory.getConfigService().discard(session);
            if (pushed) {
                AdminContext.pop();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessIDFromServerID", accessID);
        }
        return accessID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigService getConfigService(String profileKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigService", profileKey);
        }
        ConfigService profCS = null;
        boolean pushed = false;
        try {
            pushed = AdminContext.push(profileKey);
            if (ConfigServiceFactory.getConfigService() != null) {
                profCS = ConfigServiceFactory.getConfigService();
            }
            if (profCS == null) {
                Properties prop = new Properties();
                prop.setProperty("location", "local");
                prop.setProperty("profileKey", profileKey);
                prop.setProperty("was.repository.root", this.profileConfigPath);
                try {
                    profCS = ConfigServiceFactory.createConfigService(true, prop);
                }
                catch (AdminException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception creating config service in local mode: " + ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception when trying to set thread local: " + ex);
            }
        }
        finally {
            if (pushed) {
                AdminContext.pop();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService", profCS);
        }
        return profCS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addUserToAdminAndNamingRole(String profileKey, final String userid, final String accessID) throws Exception {
        block20: {
            boolean pushed;
            Session session;
            boolean save;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "addUserToAdminAndNamingRole", new Object[]{profileKey, userid, accessID});
                }
                save = true;
                Object profCS = null;
                session = new Session();
                pushed = false;
                pushed = AdminContext.push(profileKey);
                Boolean added = (Boolean)SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        AdminCommand cmd = null;
                        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding user to admin authorization.");
                        }
                        cmd = cmdMgr.createCommand("mapUsersToAdminRole");
                        cmd.setParameter("roleName", "administrator");
                        cmd.setParameter("userids", new String[]{userid});
                        cmd.setParameter("accessids", new String[]{accessID});
                        cmd.setConfigSession(session);
                        cmd.execute();
                        CommandResult result = cmd.getCommandResult();
                        if (!result.isSuccessful()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "adding user to Admin Role was unsuccessful.");
                            }
                            return null;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added user to Admin Role: ", result.getResult());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding user to naming authorization.");
                        }
                        cmd = cmdMgr.createCommand("mapUsersToNamingRole");
                        cmd.setParameter("roleName", "CosNamingWrite");
                        cmd.setParameter("userids", new String[]{userid});
                        cmd.setParameter("accessids", new String[]{accessID});
                        cmd.setConfigSession(session);
                        cmd.execute();
                        result = cmd.getCommandResult();
                        if (!result.isSuccessful()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "added user to Naming Role was unsuccessful.");
                            }
                            return null;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added user to Naming Role: ", result.getResult());
                        }
                        return (Boolean)result.getResult();
                    }
                });
                boolean bl = save = added != null && added != false;
                if (!save) break block17;
                ConfigServiceFactory.getConfigService().save(session, true);
                try {
                    SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            String processName = AdminServiceFactory.getAdminService().getProcessName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "addUserToAdminAndNamingRole processName=" + processName);
                            }
                            ObjectName on = new ObjectName("WebSphere:type=AuthorizationGroupManager,*");
                            Set s = AdminServiceFactory.getAdminService().queryNames(on, null);
                            Iterator it = s.iterator();
                            if (!it.hasNext() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "addUserToAdminAndNamingRole queryNames returned no matches for ObjectName('WebSphere:type=AuthorizationGroupManager,*')");
                            }
                            while (it.hasNext()) {
                                on = (ObjectName)it.next();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "addUserToAdminAndNamingRole " + on.getKeyProperty("process") + " " + processName);
                                }
                                if (!on.getKeyProperty("process").equals(processName)) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "addUserToAdminAndNamingRole refreshing " + on.getKeyProperty("process"));
                                }
                                AdminServiceFactory.getAdminService().invoke(on, "refreshAll", new Object[0], new String[0]);
                                break;
                            }
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "addUserToAdminAndNamingRole Exception occurred on refreshAll ", ex);
                }
            }
            ConfigServiceFactory.getConfigService().discard(session);
            if (pushed) {
                AdminContext.pop();
            }
            break block20;
            catch (PrivilegedActionException e) {
                block18: {
                    try {
                        save = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred adding user to admin and naming role: ", new Object[]{e.getException()});
                        }
                        if (!save) break block18;
                    }
                    catch (Throwable throwable) {
                        block19: {
                            if (save) {
                                ConfigServiceFactory.getConfigService().save(session, true);
                                try {
                                    SecurityContext.runAsSystem(new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (Exception ex) {
                                    if (!tc.isDebugEnabled()) break block19;
                                    Tr.debug(tc, "addUserToAdminAndNamingRole Exception occurred on refreshAll ", ex);
                                }
                            }
                        }
                        ConfigServiceFactory.getConfigService().discard(session);
                        if (pushed) {
                            AdminContext.pop();
                        }
                        throw throwable;
                    }
                    ConfigServiceFactory.getConfigService().save(session, true);
                    try {
                        SecurityContext.runAsSystem(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block18;
                        Tr.debug(tc, "addUserToAdminAndNamingRole Exception occurred on refreshAll ", ex);
                    }
                }
                ConfigServiceFactory.getConfigService().discard(session);
                if (pushed) {
                    AdminContext.pop();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addUserToAdminAndNamingRole");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUserFromAdminAndNamingRole(String profileKey, final String userid) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUserFromAdminAndNamingRole", new Object[]{profileKey, userid});
        }
        boolean save = true;
        Object profCS = null;
        final Session session = new Session();
        boolean pushed = false;
        try {
            pushed = AdminContext.push(profileKey);
            Boolean removed = (Boolean)SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AdminCommand cmd = null;
                    CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing user from admin authorization.");
                    }
                    cmd = cmdMgr.createCommand("removeUsersFromAdminRole");
                    cmd.setParameter("roleName", "administrator");
                    cmd.setParameter("userids", new String[]{userid});
                    cmd.setConfigSession(session);
                    cmd.execute();
                    CommandResult result = cmd.getCommandResult();
                    if (!result.isSuccessful()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing user from admin role was unsuccessful.");
                        }
                        return null;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removed user from admin role: ", result.getResult());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing user from naming authorization.");
                    }
                    cmd = cmdMgr.createCommand("removeUsersFromNamingRole");
                    cmd.setParameter("roleName", "CosNamingWrite");
                    cmd.setParameter("userids", new String[]{userid});
                    cmd.setConfigSession(session);
                    cmd.execute();
                    result = cmd.getCommandResult();
                    if (!result.isSuccessful()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing user from naming role was unsuccessful.");
                        }
                        return null;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removed user from naming role: ", result.getResult());
                    }
                    return (Boolean)result.getResult();
                }
            });
            save = removed != null && removed != false;
        }
        catch (PrivilegedActionException e) {
            save = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred removing user from admin and naming role: ", new Object[]{e.getException()});
            }
        }
        finally {
            if (save) {
                ConfigServiceFactory.getConfigService().save(session, true);
            }
            ConfigServiceFactory.getConfigService().discard(session);
            if (pushed) {
                AdminContext.pop();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUserFromAdminAndNamingRole");
        }
    }

    private Security getCellSecurityObject(String path, WorkSpace ws) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellSecurityObject", new Object[]{path, ws});
        }
        Resource resource = null;
        RepositoryContextType cellType = ws.getMetaData().getContextType("cells");
        Collection cellContexts = ws.findContext(cellType);
        Iterator cellContextsItr = cellContexts.iterator();
        RepositoryContext cellContext = (RepositoryContext)cellContextsItr.next();
        cellContext = ws.findContext(cellContext.getURI());
        URI uri = URI.createURI("security.xml");
        resource = cellContext.getResourceSet().getResource(uri, true);
        resource.load(new HashMap());
        Security security2 = (Security)resource.getContents().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellSecurityObject", security2);
        }
        return security2;
    }

    private WorkSpace getWorkSpace(String location) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpace", location);
        }
        WorkSpace workSpace = null;
        int MAX_ATTEMPTS = 10;
        int attempts = 0;
        while (workSpace == null) {
            Properties props = new Properties();
            String wsId = "baseToAgent" + System.currentTimeMillis();
            props.setProperty("workspace.user.id", wsId);
            props.setProperty("workspace.repository.adapter", "com.ibm.ws.sm.workspace.impl.WorkSpaceSelfRepositoryAdapter");
            String metadata_dir = location + "/.repository";
            props.setProperty("workspace.root", location);
            props.setProperty("workspace.metadata.root", metadata_dir);
            try {
                WorkSpaceManagerImpl wmgr = (WorkSpaceManagerImpl)WorkSpaceManagerFactory.getManager();
                workSpace = wmgr.createUniqueWorkSpace(props);
            }
            catch (Exception e) {
                Tr.debug(tc, "Caught exception creating the workspace: ", new Object[]{e});
            }
            if (workSpace == null) {
                ++attempts;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (attempts <= 10) continue;
            throw new Exception("Failed to create workspace ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpace", workSpace);
        }
        return workSpace;
    }

    private String[] getCellAndNodeName(String configPath) throws Exception {
        String nodeName;
        String cellName;
        block5: {
            String[] nodeList;
            block4: {
                String nodePath;
                File nodePathFile;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getCellAndNodeName", new Object[]{configPath});
                }
                cellName = null;
                nodeName = null;
                String cellPath = configPath + File.separator + "cells";
                File cellPathFile = new File(cellPath);
                int cellPathFileNum = cellPathFile.list().length;
                for (int k = 0; k <= cellPathFileNum; ++k) {
                    String file = cellPathFile.list()[k];
                    if (file.endsWith(".xml")) continue;
                    cellName = cellPathFile.list()[k];
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Profile cell name is " + cellName);
                    break;
                }
                if ((nodeList = (nodePathFile = new File(nodePath = cellPath + File.separator + cellName + File.separator + "nodes")).list()).length != 1) break block4;
                nodeName = nodeList[0];
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Profile node name is " + nodeName);
                break block5;
            }
            for (int i = 0; i < nodeList.length; ++i) {
                String nName = nodeList[i];
                if (nName.indexOf("Manager") == -1) continue;
                nodeName = nName;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Profile node name is " + nodeName);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellAndNodeName", new Object[]{cellName, nodeName});
        }
        return new String[]{cellName, nodeName};
    }

    private String getConfigRootFromProfileHome(String sProfileHome) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRootFromProfileHome ", sProfileHome);
        }
        String S_CONFIG = "config";
        String configRoot = null;
        File configFile = new File(sProfileHome + File.separator + S_CONFIG);
        if (configFile.exists() && configFile.isDirectory()) {
            try {
                configRoot = configFile.getCanonicalPath();
            }
            catch (IOException e) {
                configRoot = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRootFromProfileHome ", configRoot);
        }
        return configRoot;
    }
}

