/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSSchedule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteWSSchedule
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteWSSchedule.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsScheduleName = null;
    private ObjectName wsScheduleObjName = null;

    public DeleteWSSchedule(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteWSSchedule(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            AttributeList ref;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.wsScheduleName = (String)this.getParameter(CommandConstants.NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.wsScheduleName);
            this.wsScheduleObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.WS_SCHEDULES, queryAttrs, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsScheduleObjName: " + this.wsScheduleObjName);
            }
            AttributeList referenceList = new AttributeList();
            AttributeList wsCertExpMonitor = (AttributeList)cs.getAttribute(session, security2, CommandConstants.WS_CERT_EXP_MONITOR);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsCertExpMonitor: " + wsCertExpMonitor);
            }
            if (wsCertExpMonitor != null) {
                ObjectName schedule = (ObjectName)ConfigServiceHelper.getAttributeValue(wsCertExpMonitor, CommandConstants.WS_SCHEDULE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "schedule: " + schedule);
                }
                if (schedule != null && this.wsScheduleObjName.equals(schedule)) {
                    String name = (String)ConfigServiceHelper.getAttributeValue(wsCertExpMonitor, CommandConstants.NAME);
                    referenceList.add(new Attribute(CommandConstants.WS_CERT_EXP_MONITOR, name));
                }
            }
            if ((ref = commandHelper.getReference(cs, session, security2, CommandConstants.KEY_SET_GROUPS, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName)).size() > 0) {
                referenceList.addAll(ref);
            }
            if (referenceList.size() > 0) {
                String msg = "This object is referenced by " + referenceList;
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.deleteWSSchedule.validate", "163", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            cs.deleteConfigData(session, this.wsScheduleObjName);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

