/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSNotification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyWSNotification
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyWSNotification.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsNotificationName = null;
    private Boolean logToSystemOut = null;
    private Boolean sendEmail = null;
    private String emailList = null;
    private String emailListConfig = null;
    private Boolean sendEmailConfig = null;
    private ObjectName wsNotificationObjName = null;

    public ModifyWSNotification(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyWSNotification(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean wsNotificationNameFound = false;
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.wsNotificationName = (String)this.getParameter(CommandConstants.NAME);
            this.logToSystemOut = (Boolean)this.getParameter(CommandConstants.LOG_TO_SYSTEM_OUT);
            this.sendEmail = (Boolean)this.getParameter(CommandConstants.SEND_EMAIL);
            this.emailList = (String)this.getParameter(CommandConstants.EMAIL_LIST);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsNotificationName: " + this.wsNotificationName);
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.wsNotificationName);
            this.wsNotificationObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.WS_NOTIFICATIONS, queryAttrs, null);
            this.emailListConfig = (String)cs.getAttribute(session, this.wsNotificationObjName, CommandConstants.EMAIL_LIST);
            this.sendEmailConfig = (Boolean)cs.getAttribute(session, this.wsNotificationObjName, CommandConstants.SEND_EMAIL);
            if (this.sendEmail != null && this.sendEmail.booleanValue()) {
                if (this.emailList == null && this.emailListConfig == null) {
                    String msg = TraceNLSHelper.getInstance().getString("ssl.command.email.list.CWPKI0684E", "Must enter an email list when send email is true.");
                    throw new CommandValidationException(msg);
                }
            } else if (this.sendEmailConfig != null && this.sendEmailConfig.booleanValue() && this.emailList == null && this.emailListConfig == null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.email.list.CWPKI0684E", "Must enter an email list when send email is true.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.modifyWSNotification.validate", "140", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.wsNotificationName);
            if (this.logToSystemOut != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.LOG_TO_SYSTEM_OUT, this.logToSystemOut);
            }
            if (this.sendEmail != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SEND_EMAIL, this.sendEmail);
            }
            if (this.emailList != null && this.emailList.length() > 0) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.EMAIL_LIST, this.emailList);
            }
            cs.setAttributes(session, this.wsNotificationObjName, attrList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

