/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.ipc.ssl.WSCertificateExpirationMonitor;
import com.ibm.ws.crypto.config.WSNotifier;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.commands.ProfileCreation.PrepareKeysUtility;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.net.InetAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class StartCertificateExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(StartCertificateExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    List expiredCerts = new ArrayList();
    List personalCerts = new ArrayList();
    List signerCerts = new ArrayList();
    List rootSignerDigestCache = new ArrayList();
    StringBuffer notificationCerts = new StringBuffer();
    StringBuffer notificationSignerCerts = new StringBuffer();
    StringBuffer replaceCerts = new StringBuffer();
    StringBuffer expInfoBuffer = new StringBuffer();
    StringBuffer deletedKeystoreBuffer = new StringBuffer();
    StringBuffer rootKeystoreBuffer = new StringBuffer();
    StringBuffer noUpdateBuffer = new StringBuffer();
    StringBuffer scanBuffer = new StringBuffer();
    private Boolean saveConfig = Boolean.FALSE;
    WSCertificateExpirationMonitor monitor = null;
    String linesep = System.getProperty("line.separator");
    String report = null;
    String preNotificationMsg1 = "The expiration monitor has recently run and discovered that the certificates listed below will be replaced within the next ";
    String preNotificationMsg2 = " days based upon the configured policy to automatically replace expiring self-signed certificates ";
    String preNotificationMsg3 = " days prior to expiration.  This notification is warning you that problems may arise when this automatic replace occurs.";
    String preNotificationWarning = "In some cases, automatic updates to the self-signed certificates can cause outages for WebServer plug-ins operating on unmanaged nodes.  In such a situation, the plugin will be unable to contact the application servers over HTTPS because it will be using signers for certificates that have been replaced by the automatic replacement process.";
    String preNotificationWarning2 = "To prevent what may be and serious outage you should act before the scheduled replacement date and replace the expiring certificates and update the plugin kdb to use the new signers.";
    String notifyNotice1 = "*** CERTIFICATES WITHIN THE ";
    String notifyNotice2 = " DAY PRE-NOTIFICATION THRESHOLD (MAY BE REPLACED WITHIN ";
    String notifyNotice3 = " DAYS)  ***";
    String replaceNotice = "*** CERTIFICATES THAT ARE BEYOND THE EXPIRATION THRESHOLD AND HAVE BEEN REPLACED ***";
    String thresholdNotice = "*** CERTIFICATES THAT ARE BEYOND THE EXPIRATION THRESHOLD ***";
    String PreNotificationMsg = null;
    String NotifyNotice = null;
    long notificationDays = 0L;
    boolean replaceWritableSaf = false;

    public StartCertificateExpMonitor(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public StartCertificateExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.saveConfig = (Boolean)this.getParameter("ExpMonitorSaveConfig");
            String expirationStatus = this.startExpMonitor();
            result.setResult(expirationStatus);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        this.setCommandResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public String startExpMonitor() throws Exception {
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startExpMonitor");
            }
            Boolean deleteOld = null;
            Boolean autoReplace = null;
            Integer daysBeforeNotify = null;
            KeyStoreInfo ksInfo = null;
            try {
                int i;
                PersonalCertificateHelper.clearCertReplaced();
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
                AttributeList expMonitor = (AttributeList)cs.getAttribute(session, security2, CommandConstants.WS_CERT_EXP_MONITOR);
                ObjectName expMonitorObj = ConfigServiceHelper.createObjectName(expMonitor);
                if (expMonitor != null) {
                    deleteOld = (Boolean)ConfigServiceHelper.getAttributeValue(expMonitor, CommandConstants.DELETE_OLD);
                    daysBeforeNotify = (Integer)ConfigServiceHelper.getAttributeValue(expMonitor, CommandConstants.DAYS_BEFORE_NOTIFICATION);
                    autoReplace = (Boolean)ConfigServiceHelper.getAttributeValue(expMonitor, CommandConstants.AUTO_REPLACE);
                    this.notificationDays = this.getNotifyProperty(cs, session, security2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleteOld=" + deleteOld + " daysBeforeNotify=" + daysBeforeNotify + " autoReplace=" + autoReplace);
                    }
                } else {
                    throw new Exception("certifcate expiration monitor object does not exist.");
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("scanExpiration", new Object[]{daysBeforeNotify}, "Checking for expired certificate and certificates in the " + daysBeforeNotify + " days threshold period.");
                this.scanBuffer.append(this.linesep);
                this.scanBuffer.append(msg);
                this.scanBuffer.append(this.linesep);
                String preNotificationMsg = this.preNotificationMsg1 + this.notificationDays + this.preNotificationMsg2 + daysBeforeNotify + this.preNotificationMsg3;
                String notifyNotice = this.notifyNotice1 + this.notificationDays + this.notifyNotice2 + this.notificationDays + this.notifyNotice3;
                this.NotifyNotice = TraceNLSHelper.getInstance().getFormattedMessage("notifyNotice", new Object[]{this.notificationDays, this.notificationDays}, notifyNotice);
                this.PreNotificationMsg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.preNotificationMsg.CWPKI0714I", new Object[]{this.notificationDays, daysBeforeNotify}, preNotificationMsg);
                this.replaceWritableSaf = this.replaceWritableSAFCerts(cs, session, security2);
                this.clearDeletedKeystore(session, cs);
                String rootKeystoreString = this.handleRootKeystore(session, cs, daysBeforeNotify, autoReplace, deleteOld);
                if (rootKeystoreString.length() > 0) {
                    this.rootKeystoreBuffer.append(rootKeystoreString);
                }
                List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
                for (i = 0; i < keyStores.size(); ++i) {
                    AttributeList keyStore = (AttributeList)keyStores.get(i);
                    String name = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
                    if (name.endsWith("DefaultDeletedStore") || name.endsWith("DefaultRootStore") || name.endsWith("LTPAKeys")) continue;
                    try {
                        ObjectName scopeObj = (ObjectName)ConfigServiceHelper.getAttributeValue(keyStore, "managementScope");
                        String scope = (String)cs.getAttribute(session, scopeObj, CommandConstants.SCOPE_NAME);
                        ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, name, scope);
                        String expOutPut = this.checkCertsInKeyStore(session, cs, ksInfo, daysBeforeNotify);
                        if (expOutPut == null) continue;
                        this.expInfoBuffer.append(expOutPut);
                        continue;
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "There is a problem extracting a keystore", e.getMessage());
                    }
                }
                if (autoReplace.booleanValue()) {
                    if (this.personalCerts.size() > 0 || this.expiredCerts.size() > 0) {
                        CertReqInfo certInfo;
                        String buf;
                        for (i = 0; i < this.expiredCerts.size(); ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Replacing expired certificate....");
                            }
                            if ((buf = this.genNewCertsAndReplace(session, cs, certInfo = (CertReqInfo)this.expiredCerts.get(i), deleteOld)) == null) continue;
                            this.replaceCerts.append(buf);
                        }
                        for (i = 0; i < this.personalCerts.size(); ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Replacing personal certificate....");
                            }
                            if ((buf = this.genNewCertsAndReplace(session, cs, certInfo = (CertReqInfo)this.personalCerts.get(i), deleteOld)) == null) continue;
                            this.replaceCerts.append(buf);
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "autoReplace is off");
                }
                this.genExpiredSignerList();
                this.report = this.createCertExpMonitorReport();
                if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                    cs.save(session, true);
                }
                PersonalCertificateHelper.clearCertReplaced();
                this.expiredCerts.clear();
                this.personalCerts.clear();
                this.signerCerts.clear();
                this.rootSignerDigestCache.clear();
                this.monitor = (WSCertificateExpirationMonitor)MOFUtil.convertToEObject((Session)session, (ObjectName)expMonitorObj);
                WSNotifier notifier = new WSNotifier(this.monitor.getWsNotification());
                notifier.notify(this.report);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.startCertificateExpMonitor", "321");
                if (!tc.isDebugEnabled()) break block20;
                Tr.debug(tc, "Exception while running certificate exp", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startExpMonitor");
        }
        return this.report;
    }

    private String checkCertsInKeyStore(Session session, ConfigService cs, KeyStoreInfo info, int daysBeforeNotify) throws Exception {
        StringBuffer expBuffer;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkCertsInKeyStore");
            }
            WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(info);
            String ksName = info.getName();
            Boolean readOnly = info.getReadOnly();
            Boolean fileBased = info.getFileBased();
            long day = 86400000L;
            long currentDate = System.currentTimeMillis();
            long replacePeriod = day * (long)daysBeforeNotify;
            long notificationPeriod = day * this.notificationDays;
            expBuffer = new StringBuffer();
            String certificateType = "self-signed";
            String linesep = System.getProperty("line.separator");
            Object msg = null;
            boolean issuedByWebSphere = true;
            String rootKeyStoreScope = ManagementScopeManager.getInstance().getNodeScopeName();
            String rootKeyStoreName = KeyStoreManager.getDefaultKeyStoreName("DefaultRootStore");
            KeyStoreInfo rootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, rootKeyStoreName, rootKeyStoreScope);
            try {
                HashMap personalCertList = wsksHelper.listPersonalCertificates();
                for (String alias : personalCertList.keySet()) {
                    Certificate[] cert = (Certificate[])personalCertList.get(alias);
                    if (CertificateRequestHelper.isKeyCertReq((X509Certificate)cert[0], alias) != null) continue;
                    try {
                        cert[0].verify(cert[0].getPublicKey());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Certificate to be renewed is self-signed");
                        }
                    }
                    catch (SignatureException e) {
                        certificateType = "chained";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Certificate to be renewed is chained");
                        }
                        issuedByWebSphere = this.signedByWebSphere((X509Certificate)cert[cert.length - 1]);
                    }
                    expBuffer = this.checkSignerValidity(alias, (X509Certificate)cert[0], expBuffer, true, info, certificateType, issuedByWebSphere, replacePeriod, notificationPeriod);
                }
                HashMap signerCertsList = wsksHelper.listSignerCertificates();
                for (String alias : signerCertsList.keySet()) {
                    X509Certificate cert = (X509Certificate)signerCertsList.get(alias);
                    expBuffer = this.checkSignerValidity(alias, cert, expBuffer, false, info, certificateType, issuedByWebSphere, replacePeriod, notificationPeriod);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.startCertificateExpMonitor", "593");
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Exception while running certificate exp", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCertsInKeyStore");
        }
        return expBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String genNewCertsAndReplace(Session session, ConfigService cs, CertReqInfo certInfo, boolean delOld) throws Exception {
        StringBuffer buf;
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "genNewCertsAndReplace");
            }
            String certAlias = certInfo.getLabel();
            KeyStoreInfo keyStoreInfo = certInfo.getKsInfo();
            String password = keyStoreInfo.getPassword();
            String ksName = keyStoreInfo.getName();
            String usage = keyStoreInfo.getUsage();
            String ksScope = keyStoreInfo.getScopeNameString();
            WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(keyStoreInfo);
            Certificate[] certChain = null;
            X509Certificate cert = null;
            PrivateKey certKey = null;
            String certificateType = "self-signed";
            boolean isCA = false;
            String newAlias = null;
            boolean overwrite = false;
            String rootType = "DefaultRootStore";
            String linesep = System.getProperty("line.separator");
            buf = new StringBuffer();
            String msg = null;
            String entry = null;
            String report = null;
            Locale currentLocale = this.getLocale();
            if (currentLocale == null) {
                currentLocale = Locale.getDefault();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
                }
            }
            if (usage != null && usage.equals(CommandConstants.KS_USAGE_RSA)) {
                rootType = "RSATokenRootStore";
            }
            String rootKeyStoreScope = ManagementScopeManager.getInstance().getNodeScopeName();
            String rootKeyStoreName = KeyStoreManager.getDefaultKeyStoreName(rootType);
            KeyStoreInfo rootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, rootKeyStoreName, rootKeyStoreScope);
            WSKeyStoreHelper root_wsksHelper = new WSKeyStoreHelper(rootKsInfo);
            entry = keyStoreInfo.getName() + "|" + keyStoreInfo.getScopeNameString() + "|" + certAlias;
            if (!PersonalCertificateHelper.isCertAlreadyReplaced(entry)) {
                try {
                    X509Certificate oldRootSigner;
                    X509Certificate newRootSigner;
                    boolean signWithDefaultRoot;
                    X509Certificate signer;
                    block33: {
                        block32: {
                            certKey = (PrivateKey)wsksHelper.getKey(certAlias, password);
                            if (certKey != null) {
                                certChain = wsksHelper.getCertChainFromKey(certAlias);
                                cert = (X509Certificate)certChain[0];
                                if (cert.getBasicConstraints() != -1) {
                                    isCA = true;
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                            }
                            if (cert == null || certKey == null) break block31;
                            try {
                                cert.verify(cert.getPublicKey());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Certificate to be renewed is self-signed");
                                }
                            }
                            catch (SignatureException e) {
                                certificateType = "chained";
                                if (!tc.isDebugEnabled()) break block32;
                                Tr.debug(tc, "Certificate to be renewed is chained");
                            }
                        }
                        boolean issuedByWebSphere = true;
                        if (certificateType.equalsIgnoreCase("chained")) {
                            issuedByWebSphere = this.signedByWebSphere((X509Certificate)certChain[certChain.length - 1]);
                        }
                        if (!certificateType.equals("self-signed") && (!certificateType.equals("chained") || !issuedByWebSphere)) break block31;
                        signer = null;
                        signWithDefaultRoot = false;
                        newRootSigner = null;
                        oldRootSigner = null;
                        if (delOld && !keyStoreInfo.getType().equals("JCERACFKS") && !keyStoreInfo.getType().equals("JCECCARACFKS")) {
                            CommandHelper commandHelper = new CommandHelper();
                            KeyStoreInfo deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, ksName);
                            commandHelper.deleteCertificate(session, keyStoreInfo, deletedKsInfo, certAlias);
                            overwrite = true;
                        }
                        if (certificateType.equals("chained")) {
                            Key rootCertKey;
                            String rootCertAlias;
                            String rootCertificateAlias = PersonalCertificateHelper.findRootCertificateAlias((X509Certificate)certChain[certChain.length - 1], rootKsInfo);
                            if (rootCertificateAlias == null && issuedByWebSphere && (rootCertAlias = PersonalCertificateHelper.getDefaultRootAlias(rootKsInfo)) != null) {
                                signWithDefaultRoot = true;
                                rootCertificateAlias = rootCertAlias;
                            }
                            if ((rootCertKey = root_wsksHelper.getKey(rootCertificateAlias, rootKsInfo.getPassword())) == null) {
                                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{certAlias}, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                                throw new Exception(msg);
                            }
                            Certificate[] rootCertChain = root_wsksHelper.getCertChainFromKey(rootCertificateAlias);
                            newAlias = wsksHelper.createChainedCertificate(certInfo, rootCertChain, (PrivateKey)rootCertKey, isCA, overwrite);
                            if (signWithDefaultRoot) {
                                newRootSigner = (X509Certificate)rootCertChain[rootCertChain.length - 1];
                                oldRootSigner = (X509Certificate)certChain[certChain.length - 1];
                            }
                        } else if (certificateType.equals("self-signed")) {
                            newAlias = wsksHelper.createSelfSignedCertificate(certInfo, isCA, overwrite);
                        }
                        String nameString = ksName + "(" + ksScope + ")";
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.replace.CWPKI0645I", new Object[]{certAlias, nameString}, "Personal certificate alias \"" + certAlias + "\" in KeyStore \"" + nameString + "\" was REPLACED", currentLocale);
                        PersonalCertificateHelper.markCertReplaced(entry);
                        buf.append(linesep);
                        buf.append(msg);
                        if (!certAlias.equals(newAlias)) {
                            PersonalCertificateHelper.changeAliasReferences(session, certInfo.getKsInfo(), certAlias, newAlias);
                            msg = TraceNLSHelper.getInstance().getFormattedMessage("rootCert", new Object[]{certAlias, newAlias}, "\tNew alias for \"" + certAlias + "\" is \"" + newAlias + ".", currentLocale);
                            entry = keyStoreInfo.getName() + "|" + keyStoreInfo.getScopeNameString() + "|" + newAlias;
                            PersonalCertificateHelper.markCertReplaced(entry);
                            buf.append(linesep);
                            buf.append(msg);
                        }
                        if (ksName.endsWith("RSATokenKeyStore")) {
                            try {
                                SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").reinitializeRSAProperties();
                            }
                            catch (Exception e) {
                                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.startCertificateExpMonitor", "841");
                                if (!tc.isDebugEnabled()) break block33;
                                Tr.debug(tc, "Exception while reinitializing the RSA propagation properties: ", e.getMessage());
                            }
                        }
                    }
                    if ((signer = (X509Certificate)wsksHelper.getSignerFromKey(newAlias)) == null) break block31;
                    PrivateKey newCreatedKey = (PrivateKey)wsksHelper.getKey(newAlias, keyStoreInfo.getPassword());
                    Certificate[] newCreatedChain = wsksHelper.getCertChainFromKey(newAlias);
                    if (certAlias.equals(newAlias)) {
                        newAlias = null;
                    }
                    report = PersonalCertificateHelper.replaceCerts(session, keyStoreInfo, certAlias, cert, newAlias, signer, newCreatedChain, newCreatedKey, delOld, currentLocale);
                    if (signWithDefaultRoot) {
                        PersonalCertificateHelper.addNewRootSigner(session, oldRootSigner, newRootSigner);
                    }
                    if (delOld && (keyStoreInfo.getType().equals("JCERACFKS") || keyStoreInfo.getType().equals("JCECCARACFKS"))) {
                        CommandHelper commandHelper = new CommandHelper();
                        KeyStoreInfo deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, ksName);
                        commandHelper.deleteCertificate(session, keyStoreInfo, deletedKsInfo, certAlias);
                        wsksHelper.deleteCertificate(certAlias);
                    }
                    PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
                    PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
                    if (report != null) {
                        buf.append(report);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.startCertificateExpMonitor", "808");
                    if (!tc.isDebugEnabled()) break block31;
                    Tr.debug(tc, "Exception while running certificate exp", e.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genNewCertsAndReplace");
        }
        return buf.toString();
    }

    private String createCertExpMonitorReport() {
        String NoUpdateNotice;
        String ReplaceNotice;
        String RootReplaceNotice;
        String ThresholdNotice;
        String PreNotificationWarning;
        boolean status;
        String linesep;
        StringBuffer bufferedReport;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCertExpMonitorReport");
            }
            bufferedReport = new StringBuffer();
            linesep = System.getProperty("line.separator");
            status = false;
            String CertMonitorTitle = TraceNLSHelper.getInstance().getString("certMonitorTitle", "**** Subject:  Expiration Monitor ****");
            PreNotificationWarning = TraceNLSHelper.getInstance().getString("ssl.command.preNotificationWarning.CWPKI0715I", this.preNotificationWarning + " " + this.preNotificationWarning2);
            ThresholdNotice = TraceNLSHelper.getInstance().getString("thresholdNotice", "*** CERTIFICATES THAT ARE EXIPIRED OR IN THE EXPIRATION THRESHOLD ***");
            RootReplaceNotice = TraceNLSHelper.getInstance().getString("rootReplaceNotice", "*** ROOT CERTIFICATES THAT ARE REPLACED AND CERTIFICATES REPLACED DUE TO THE ROOT CERTIFICATE BEING REPLACED ***");
            ReplaceNotice = TraceNLSHelper.getInstance().getString("replaceNotice", "*** CERTIFICATES THAT ARE EXPIRED OR BEYOND THE EXPIRATION THRESHOLD AND HAVE BEEN REPLACED ***");
            NoUpdateNotice = TraceNLSHelper.getInstance().getString("noUpdateNotice", "*** CERTIFICATES THAT ARE EXPIRED OR BEYOND THE EXPIRATION THRESHOLD THAT CAN NOT BE REPLACED BY THE SERVER ***");
            bufferedReport.append(linesep);
            bufferedReport.append(CertMonitorTitle);
            bufferedReport.append(linesep);
            bufferedReport.append(linesep);
            try {
                String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                String profileRoot = SecurityObjectLocator.getAdminData().getUserInstallRootPath();
                String profileUUID = PrepareKeysUtility.getProfileUUID(profileRoot, null);
                String processType = ManagementScopeManager.getInstance().getProcessType();
                bufferedReport.append("Hostname: " + hostName);
                bufferedReport.append(linesep);
                bufferedReport.append("Profile UUID: " + profileUUID);
                bufferedReport.append(linesep);
                bufferedReport.append("Process type: " + processType);
                bufferedReport.append(linesep);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Exception while getting host information: ", e.getMessage());
            }
        }
        if (this.notificationCerts.length() > 0) {
            bufferedReport.append(this.NotifyNotice);
            bufferedReport.append(linesep);
            bufferedReport.append(this.PreNotificationMsg);
            bufferedReport.append(linesep);
            bufferedReport.append(linesep);
            bufferedReport.append(PreNotificationWarning);
            bufferedReport.append(linesep);
            bufferedReport.append(linesep);
            bufferedReport.append(this.notificationCerts);
            bufferedReport.append(linesep);
            status = true;
        }
        if (this.notificationCerts.length() > 0 && this.notificationSignerCerts.length() > 0) {
            bufferedReport.append(this.notificationSignerCerts);
            bufferedReport.append(linesep);
        }
        bufferedReport.append(this.scanBuffer);
        if (this.expInfoBuffer.length() > 0) {
            bufferedReport.append(linesep);
            bufferedReport.append(ThresholdNotice);
            bufferedReport.append(linesep);
            bufferedReport.append(this.expInfoBuffer);
            bufferedReport.append(linesep);
            status = true;
        }
        if (this.rootKeystoreBuffer.length() > 0) {
            bufferedReport.append(linesep);
            bufferedReport.append(RootReplaceNotice);
            bufferedReport.append(linesep);
            bufferedReport.append(this.rootKeystoreBuffer);
            bufferedReport.append(linesep);
            status = true;
        }
        if (this.replaceCerts.length() > 0) {
            bufferedReport.append(linesep);
            bufferedReport.append(ReplaceNotice);
            bufferedReport.append(linesep);
            bufferedReport.append(this.replaceCerts);
            bufferedReport.append(linesep);
            status = true;
        }
        if (this.noUpdateBuffer.length() > 0) {
            bufferedReport.append(linesep);
            bufferedReport.append(NoUpdateNotice);
            bufferedReport.append(linesep);
            bufferedReport.append(this.noUpdateBuffer);
            bufferedReport.append(linesep);
            status = true;
        }
        if (!status) {
            String noCertInfo = TraceNLSHelper.getInstance().getString("ssl.command.monitor.no.cert.status.CWPKI0735I", "There is no certificate expiration information to report on at this time.");
            bufferedReport.append(linesep);
            bufferedReport.append(noCertInfo);
            bufferedReport.append(linesep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertExpMonitorReport");
        }
        return bufferedReport.toString();
    }

    private long getNotifyProperty(ConfigService cs, Session session, ObjectName sec2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotifyProperty");
        }
        try {
            String propValue = (String)PersonalCertificateHelper.getCustomProperty(cs, session, sec2, "com.ibm.ws.security.expirationMonitorNotificationPeriod");
            if (propValue != null) {
                Long value = new Long(propValue);
                return value;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotifyProperty");
        }
        Long defaultValue = new Long("90");
        return defaultValue;
    }

    private boolean replaceWritableSAFCerts(ConfigService cs, Session session, ObjectName sec2) {
        String propValue;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceWritableSAFCerts");
        }
        boolean replaceSAFCerts = false;
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && (propValue = (String)PersonalCertificateHelper.getCustomProperty(cs, session, sec2, "com.ibm.ssl.replaceWritableSAFCerts")) != null && propValue.equalsIgnoreCase("true")) {
            replaceSAFCerts = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceWritableSAFCerts", replaceSAFCerts);
        }
        return replaceSAFCerts;
    }

    private void clearDeletedKeystore(Session session, ConfigService cs) throws Exception {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "clearDeletedKeystore");
            }
            try {
                CommandHelper commandHelper = new CommandHelper();
                KeyStoreInfo deletedKSInfo = commandHelper.getDefaultKeyStore(session, cs, "DefaultDeletedStore");
                if (!deletedKSInfo.getReadOnly().booleanValue() && deletedKSInfo.getFileBased().booleanValue()) {
                    String[] aliases;
                    WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(deletedKSInfo);
                    if (!wsksHelper.contains("dummyclientsigner")) {
                        X509Certificate clientCert = KeyStoreHelper.getCertFromArmFile("client");
                        wsksHelper.setSignerCert("dummyclientsigner", clientCert);
                    }
                    if (!wsksHelper.contains("dummyserversigner")) {
                        X509Certificate serverCert = KeyStoreHelper.getCertFromArmFile("server");
                        wsksHelper.setSignerCert("dummyserversigner", serverCert);
                    }
                    if ((aliases = wsksHelper.getCertAliases()).length > 0) {
                        for (int i = 0; i < aliases.length; ++i) {
                            String alias = aliases[i];
                            if (alias.equalsIgnoreCase("dummyServerSigner") || alias.equalsIgnoreCase("dummyClientSigner")) continue;
                            wsksHelper.deleteCertificate(alias);
                        }
                    }
                    PersonalCertificateHelper.setWorkspaceUpdated(session, deletedKSInfo.getLocation());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.startCertificateExpMonitor", "997");
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Problem cleaning out the deleted keystore ", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearDeletedKeystore");
        }
    }

    private String handleRootKeystore(Session session, ConfigService cs, int daysBeforeNotify, boolean autoReplace, boolean deleteOld) throws Exception {
        String buf;
        CertReqInfo certInfo;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRootKeystore");
        }
        KeyStoreInfo rootKsInfo = null;
        String rootKeyStoreName = null;
        KeyStoreInfo rsaRootKSInfo = null;
        String rsaRootKeyStoreName = null;
        String rootKeyStoreScope = ManagementScopeManager.getInstance().getNodeScopeName();
        rootKeyStoreName = KeyStoreManager.getDefaultKeyStoreName("DefaultRootStore");
        rootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, rootKeyStoreName, rootKeyStoreScope);
        rsaRootKeyStoreName = KeyStoreManager.getDefaultKeyStoreName("RSATokenRootStore");
        rsaRootKSInfo = PersonalCertificateHelper.getKsInfo(session, cs, rsaRootKeyStoreName, rootKeyStoreScope);
        StringBuffer buffer = new StringBuffer();
        this.storeRootCertificateDigest(rootKsInfo, rsaRootKSInfo);
        String expOutPut = this.checkCertsInKeyStore(session, cs, rootKsInfo, daysBeforeNotify);
        if (expOutPut.length() > 0) {
            this.expInfoBuffer.append(expOutPut);
        }
        if ((expOutPut = this.checkCertsInKeyStore(session, cs, rsaRootKSInfo, daysBeforeNotify)).length() > 0) {
            this.expInfoBuffer.append(expOutPut);
        }
        if (autoReplace && this.expiredCerts.size() > 0) {
            for (i = 0; i < this.expiredCerts.size(); ++i) {
                certInfo = (CertReqInfo)this.expiredCerts.get(i);
                buf = this.genNewRootAndReplace(session, cs, certInfo, deleteOld);
                if (buf == null) continue;
                buffer.append(buf);
            }
            this.expiredCerts.clear();
        }
        if (autoReplace && this.personalCerts.size() > 0) {
            for (i = 0; i < this.personalCerts.size(); ++i) {
                certInfo = (CertReqInfo)this.personalCerts.get(i);
                buf = this.genNewRootAndReplace(session, cs, certInfo, deleteOld);
                if (buf == null) continue;
                buffer.append(buf);
            }
            this.personalCerts.clear();
        }
        PersonalCertificateHelper.setWorkspaceUpdated(session, rootKsInfo.getLocation());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRootKeystore");
        }
        return buffer.toString();
    }

    private String genNewRootAndReplace(Session session, ConfigService cs, CertReqInfo certInfo, boolean deleteOld) throws Exception {
        StringBuffer certBuffer;
        block33: {
            Locale currentLocale;
            boolean overwrite;
            String entry;
            String msg;
            String newAlias;
            boolean isCA;
            String certificateType;
            PrivateKey certKey;
            X509Certificate cert;
            Certificate[] certChain;
            String keyStoreName;
            String password;
            WSKeyStoreHelper wsksHelper;
            String certAlias;
            KeyStoreInfo ksInfo;
            block34: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "genNewRootAndReplace");
                }
                ksInfo = certInfo.getKsInfo();
                certAlias = certInfo.getLabel();
                wsksHelper = new WSKeyStoreHelper(ksInfo);
                password = ksInfo.getPassword();
                keyStoreName = ksInfo.getName();
                certChain = null;
                cert = null;
                certKey = null;
                certificateType = "self-signed";
                isCA = false;
                newAlias = null;
                msg = null;
                entry = null;
                certBuffer = new StringBuffer();
                overwrite = false;
                currentLocale = this.getLocale();
                if (currentLocale == null) {
                    currentLocale = Locale.getDefault();
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
                    }
                }
                if ((certKey = (PrivateKey)wsksHelper.getKey(certAlias, password)) != null) {
                    certChain = wsksHelper.getCertChainFromKey(certAlias);
                    cert = (X509Certificate)certChain[0];
                    if (cert.getBasicConstraints() != -1) {
                        isCA = true;
                    }
                } else {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, certAlias + " does not appear to be a personal certificate");
                    }
                    return null;
                }
                if (cert == null || certKey == null) break block33;
                try {
                    cert.verify(cert.getPublicKey());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate to be renewed is self-signed");
                    }
                }
                catch (SignatureException e) {
                    certificateType = "chained";
                    if (!tc.isDebugEnabled()) break block34;
                    Tr.debug(tc, "Certificate to be renewed is chained");
                }
            }
            boolean issuedByWebSphere = true;
            if (certificateType.equalsIgnoreCase("chained")) {
                issuedByWebSphere = this.signedByWebSphere((X509Certificate)certChain[certChain.length - 1]);
            }
            if (certificateType.equals("self-signed") || certificateType.equals("chained") && issuedByWebSphere) {
                KeyStoreInfo deletedKsInfo;
                CommandHelper commandHelper;
                X509Certificate signer = null;
                boolean signWithDefaultRoot = false;
                X509Certificate oldRootSigner = null;
                X509Certificate newRootSigner = null;
                if (deleteOld && !ksInfo.getType().equals("JCERACFKS") && !ksInfo.getType().equals("JCECCARACFKS")) {
                    commandHelper = new CommandHelper();
                    deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, keyStoreName);
                    commandHelper.deleteCertificate(session, ksInfo, deletedKsInfo, certAlias);
                    overwrite = true;
                }
                if (certificateType.equals("chained")) {
                    PrivateKey rootCertKey;
                    String rootCertAlias;
                    String rootCertificateAlias = PersonalCertificateHelper.findRootCertificateAlias((X509Certificate)certChain[1], ksInfo);
                    if (rootCertificateAlias == null && issuedByWebSphere && (rootCertAlias = PersonalCertificateHelper.getDefaultRootAlias(ksInfo)) != null) {
                        signWithDefaultRoot = true;
                        rootCertificateAlias = rootCertAlias;
                    }
                    if ((rootCertKey = (PrivateKey)wsksHelper.getKey(rootCertificateAlias, password)) != null) {
                        Certificate[] rootCertChain = wsksHelper.getCertChainFromKey(rootCertificateAlias);
                        newAlias = wsksHelper.createChainedCertificate(certInfo, rootCertChain, rootCertKey, isCA, overwrite);
                        if (signWithDefaultRoot) {
                            newRootSigner = (X509Certificate)rootCertChain[rootCertChain.length - 1];
                            oldRootSigner = (X509Certificate)certChain[certChain.length - 1];
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                    }
                } else if (certificateType.equals("self-signed")) {
                    newAlias = wsksHelper.createSelfSignedCertificate(certInfo, isCA, overwrite);
                }
                if (deleteOld && (ksInfo.getType().equals("JCERACFKS") || ksInfo.getType().equals("JCECCARACFKS"))) {
                    commandHelper = new CommandHelper();
                    deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, keyStoreName);
                    commandHelper.deleteCertificate(session, ksInfo, deletedKsInfo, certAlias);
                    wsksHelper.deleteCertificate(certAlias);
                }
                String ksNameString = ksInfo.getName() + "(" + ksInfo.getScopeNameString() + ")";
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.rootCertReplaced.CWPKI0717I", new Object[]{certAlias, ksNameString}, "Root certificate alias \"" + newAlias + "\" in KeyStore \"" + ksNameString + "\" was REPLACED");
                entry = ksInfo.getName() + "|" + ksInfo.getScopeNameString() + "|" + certAlias;
                PersonalCertificateHelper.markCertReplaced(entry);
                certBuffer.append(this.linesep);
                certBuffer.append(msg);
                if (!certAlias.equals(newAlias)) {
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("aliasChange", new Object[]{certAlias, newAlias}, "\tNew alias for \"" + certAlias + "\" is \"" + newAlias + ".");
                    entry = ksInfo.getName() + "|" + ksInfo.getScopeNameString() + "|" + newAlias;
                    PersonalCertificateHelper.markCertReplaced(entry);
                    certBuffer.append(this.linesep);
                    certBuffer.append(msg);
                }
                if ((signer = (X509Certificate)wsksHelper.getSignerFromKey(newAlias)) != null) {
                    String replaceInfo;
                    String buf2;
                    PrivateKey newCreatedKey = (PrivateKey)wsksHelper.getKey(newAlias, password);
                    Certificate[] newCreatedChain = wsksHelper.getCertChainFromKey(newAlias);
                    String buf = this.recreateChainedWithNewRoot(session, cs, certChain, certKey, newCreatedChain, newCreatedKey, deleteOld);
                    if (buf.length() > 0) {
                        certBuffer.append(buf);
                    }
                    if ((buf2 = this.recreateRootsWithNewRoot(session, cs, certChain, certKey, newCreatedChain, newCreatedKey, deleteOld)).length() > 0) {
                        certBuffer.append(buf2);
                    }
                    if ((replaceInfo = PersonalCertificateHelper.replaceCerts(session, ksInfo, certAlias, cert, newAlias, signer, newCreatedChain, newCreatedKey, deleteOld, currentLocale)).length() > 0) {
                        certBuffer.append(replaceInfo);
                    }
                    if (signWithDefaultRoot) {
                        PersonalCertificateHelper.addNewRootSigner(session, oldRootSigner, newRootSigner);
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Unable to get the signer for the newly created certificate:" + newAlias + " in " + ksInfo.getName());
                }
                PersonalCertificateHelper.setWorkspaceUpdated(session, ksInfo.getLocation());
                PersonalCertificateHelper.markSSLConfigChanged(ksInfo, session);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genNewRootAndReplace");
        }
        return certBuffer.toString();
    }

    private String recreateChainedWithNewRoot(Session session, ConfigService cs, Certificate[] certChain, PrivateKey certKey, Certificate[] newCreatedChain, Key newCreatedKey, boolean deleteOld) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreateChainedWithNewRoot");
        }
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        String[] aliases = null;
        X509Certificate rootCert = null;
        String msg = null;
        String entry = null;
        StringBuffer certBuffer = new StringBuffer();
        rootCert = (X509Certificate)certChain[0];
        Locale currentLocale = this.getLocale();
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
            }
        }
        List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
        Iterator iter = keyStores.iterator();
        while (iter.hasNext()) {
            KeyStoreInfo ksInfo;
            block15: {
                boolean overwrite = false;
                AttributeList keyStore = (AttributeList)iter.next();
                String name = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
                if (name.endsWith("DefaultDeletedStore") || name.endsWith("DefaultRootStore") || name.endsWith("RSATokenRootStore") || name.endsWith("LTPAKeys")) continue;
                ObjectName scopeObj = (ObjectName)ConfigServiceHelper.getAttributeValue(keyStore, "managementScope");
                String scope = (String)cs.getAttribute(session, scopeObj, CommandConstants.SCOPE_NAME);
                ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, name, scope);
                WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(ksInfo);
                aliases = wsksHelper.getCertAliases();
                if (aliases != null) {
                    for (int i = 0; i < aliases.length; ++i) {
                        String replaceInfo;
                        boolean isSigned;
                        String alias = aliases[i];
                        entry = ksInfo.getName() + "|" + ksInfo.getScopeNameString() + "|" + alias;
                        if (PersonalCertificateHelper.isCertAlreadyReplaced(entry) || !(isSigned = wsksHelper.isCertSignedWithThisRoot(rootCert, alias))) continue;
                        boolean isCA = false;
                        X509Certificate cert = (X509Certificate)wsksHelper.getSignerFromKey(alias);
                        CertReqInfo certInfo = this.createCertInfoFromCert(alias, cert, ksInfo);
                        if (cert.getBasicConstraints() != -1) {
                            isCA = true;
                        }
                        if (deleteOld && !ksInfo.getType().equals("JCERACFKS") && !ksInfo.getType().equals("JCECCARACFKS")) {
                            CommandHelper commandHelper = new CommandHelper();
                            KeyStoreInfo deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, ksInfo.getName());
                            commandHelper.deleteCertificate(session, ksInfo, deletedKsInfo, alias);
                            overwrite = true;
                        }
                        String aliasFromCreate = wsksHelper.createChainedCertificate(certInfo, newCreatedChain, (PrivateKey)newCreatedKey, isCA, overwrite);
                        String ksNameString = ksInfo.getName() + "(" + ksInfo.getScopeNameString() + ")";
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.renewCertWithNewRoot.CWPKI0718I", new Object[]{alias, ksNameString}, "Personal certificate alias \"" + alias + "\" in keystore \"" + ksNameString + "\"was RENEWED with a new root certificate");
                        PersonalCertificateHelper.markCertReplaced(entry);
                        certBuffer.append(this.linesep);
                        certBuffer.append(msg);
                        if (!alias.equals(aliasFromCreate)) {
                            PersonalCertificateHelper.changeAliasReferences(session, certInfo.getKsInfo(), alias, aliasFromCreate);
                            msg = TraceNLSHelper.getInstance().getFormattedMessage("aliasChange", new Object[]{alias, aliasFromCreate}, "\tNew alias for \"" + alias + "\" is \"" + aliasFromCreate + ".");
                            entry = ksInfo.getName() + "|" + ksInfo.getScopeNameString() + "|" + aliasFromCreate;
                            PersonalCertificateHelper.markCertReplaced(entry);
                            certBuffer.append(this.linesep);
                            certBuffer.append(msg);
                        }
                        X509Certificate signer = (X509Certificate)wsksHelper.getSignerFromKey(aliasFromCreate);
                        Certificate[] chain = wsksHelper.getCertChainFromKey(aliasFromCreate);
                        Key key = wsksHelper.getKey(aliasFromCreate, ksInfo.getPassword());
                        if (alias.equals(aliasFromCreate)) {
                            aliasFromCreate = null;
                        }
                        if ((replaceInfo = PersonalCertificateHelper.replaceCerts(session, ksInfo, alias, cert, aliasFromCreate, signer, chain, key, deleteOld, currentLocale)).length() > 0) {
                            certBuffer.append(replaceInfo);
                        }
                        if (!deleteOld || !ksInfo.getType().equals("JCERACFKS") && !ksInfo.getType().equals("JCECCARACFKS")) continue;
                        CommandHelper commandHelper = new CommandHelper();
                        KeyStoreInfo deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, ksInfo.getName());
                        commandHelper.deleteCertificate(session, ksInfo, deletedKsInfo, alias);
                        wsksHelper.deleteCertificate(alias);
                    }
                }
                if (ksInfo.getName().endsWith("RSATokenKeyStore")) {
                    try {
                        SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").reinitializeRSAProperties();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.startCertificateExpMonitor", "1523");
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "Exception while reinitializing the RSA propagation properties: ", e.getMessage());
                    }
                }
            }
            PersonalCertificateHelper.setWorkspaceUpdated(session, ksInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(ksInfo, session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recreateChainedWithNewRoot");
        }
        return certBuffer.toString();
    }

    private String recreateRootsWithNewRoot(Session session, ConfigService cs, Certificate[] certChain, PrivateKey certKey, Certificate[] newCreatedChain, Key newCreatedKey, boolean deleteOld) throws Exception {
        String rsaRootKeyStoreName;
        KeyStoreInfo rsaRootKsInfo;
        Locale currentLocale;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreateRootsWithNewRoot");
        }
        String[] aliases = null;
        X509Certificate rootCert = null;
        String msg = null;
        String entry = null;
        StringBuffer certBuffer = new StringBuffer();
        ArrayList<KeyStoreInfo> rootStores = new ArrayList<KeyStoreInfo>();
        if (certChain.length > 0) {
            rootCert = (X509Certificate)certChain[0];
        }
        if ((currentLocale = this.getLocale()) == null) {
            currentLocale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
            }
        }
        String rootKeyStoreScope = ManagementScopeManager.getInstance().getNodeScopeName();
        String rootKeyStoreName = KeyStoreManager.getDefaultKeyStoreName("DefaultRootStore");
        KeyStoreInfo rootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, rootKeyStoreName, rootKeyStoreScope);
        if (rootKsInfo != null) {
            rootStores.add(rootKsInfo);
        }
        if ((rsaRootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, rsaRootKeyStoreName = KeyStoreManager.getDefaultKeyStoreName("RSATokenRootStore"), rootKeyStoreScope)) != null) {
            rootStores.add(rsaRootKsInfo);
        }
        for (int j = 0; j < rootStores.size(); ++j) {
            WSKeyStoreHelper root_wsksHelper;
            KeyStoreInfo ksInfo = (KeyStoreInfo)rootStores.get(j);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "working root store " + ksInfo.getName());
            }
            if ((aliases = (root_wsksHelper = new WSKeyStoreHelper(ksInfo)).getCertAliases()) == null) continue;
            for (int i = 0; i < aliases.length; ++i) {
                String newChainInfo;
                String replaceInfo;
                boolean isSigned;
                boolean overwrite = false;
                String alias = aliases[i];
                entry = ksInfo.getName() + "|" + ksInfo.getScopeNameString() + "|" + alias;
                if (PersonalCertificateHelper.isCertAlreadyReplaced(entry) || !(isSigned = root_wsksHelper.isCertSignedWithThisRoot(rootCert, alias))) continue;
                boolean isCA = false;
                Certificate[] savedChain = root_wsksHelper.getCertChainFromKey(alias);
                Key savedKey = root_wsksHelper.getKey(alias, ksInfo.getPassword());
                X509Certificate cert = (X509Certificate)root_wsksHelper.getSignerFromKey(alias);
                CertReqInfo certInfo = this.createCertInfoFromCert(alias, cert, ksInfo);
                if (cert.getBasicConstraints() != -1) {
                    isCA = true;
                }
                if (deleteOld && !ksInfo.getType().equals("JCERACFKS") && !ksInfo.getType().equals("JCECCARACFKS")) {
                    CommandHelper commandHelper = new CommandHelper();
                    KeyStoreInfo deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, ksInfo.getName());
                    commandHelper.deleteCertificate(session, ksInfo, deletedKsInfo, alias);
                    overwrite = true;
                }
                String aliasFromCreate = root_wsksHelper.createChainedCertificate(certInfo, newCreatedChain, (PrivateKey)newCreatedKey, isCA, overwrite);
                String ksNameString = ksInfo.getName() + "(" + ksInfo.getScopeNameString() + ")";
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.renewCertWithNewRoot.CWPKI0718I", new Object[]{alias, ksNameString}, "Personal certificate alias \"" + alias + "\" in keystore \"" + ksNameString + "\" was RENEWED with a new root certificate.");
                PersonalCertificateHelper.markCertReplaced(entry);
                certBuffer.append(this.linesep);
                certBuffer.append(msg);
                if (deleteOld && (ksInfo.getType().equals("JCERACFKS") || ksInfo.getType().equals("JCECCARACFKS"))) {
                    CommandHelper commandHelper = new CommandHelper();
                    KeyStoreInfo deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, ksInfo.getName());
                    commandHelper.deleteCertificate(session, ksInfo, deletedKsInfo, alias);
                    root_wsksHelper.deleteCertificate(alias);
                }
                if (!alias.equals(aliasFromCreate)) {
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("aliasChange", new Object[]{alias, aliasFromCreate}, "\tNew alias for \"" + alias + "\" is \"" + aliasFromCreate + ".");
                    entry = ksInfo.getName() + "|" + ksInfo.getScopeNameString() + "|" + aliasFromCreate;
                    PersonalCertificateHelper.markCertReplaced(entry);
                    certBuffer.append(this.linesep);
                    certBuffer.append(msg);
                }
                X509Certificate signer = (X509Certificate)root_wsksHelper.getSignerFromKey(aliasFromCreate);
                Certificate[] chain = root_wsksHelper.getCertChainFromKey(aliasFromCreate);
                Key key = root_wsksHelper.getKey(aliasFromCreate, ksInfo.getPassword());
                if (alias.equals(aliasFromCreate)) {
                    aliasFromCreate = null;
                }
                if ((replaceInfo = PersonalCertificateHelper.replaceCerts(session, ksInfo, alias, cert, aliasFromCreate, signer, chain, key, deleteOld, currentLocale)).length() > 0) {
                    certBuffer.append(replaceInfo);
                }
                if ((newChainInfo = this.recreateChainedWithNewRoot(session, cs, savedChain, (PrivateKey)savedKey, chain, key, deleteOld)).length() > 0) {
                    certBuffer.append(newChainInfo);
                }
                String newRootInfo = this.recreateRootsWithNewRoot(session, cs, savedChain, (PrivateKey)savedKey, chain, key, deleteOld);
                certBuffer.append(newRootInfo);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recreateRootsWithNewRoot");
        }
        return certBuffer.toString();
    }

    private CertReqInfo createCertInfoFromCert(String certAlias, X509Certificate cert, KeyStoreInfo ksInfo) {
        CertReqInfo newCertInfo;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCertInfoFromCert");
            }
            newCertInfo = null;
            try {
                PublicKey publicKey = cert.getPublicKey();
                int keySize = -1;
                keySize = publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : ((DSAPublicKey)publicKey).getParams().getP().bitLength();
                if (keySize % 2 != 0) {
                    ++keySize;
                }
                Date begin = cert.getNotBefore();
                Date end = cert.getNotAfter();
                long difference = end.getTime() - begin.getTime();
                long differenceDays = difference / 86400000L;
                int validDays = new Long(differenceDays).intValue();
                String subjectDN = ((Object)cert.getSubjectDN()).toString();
                String profileUUID = PersonalCertificateHelper.getUUIDFromCert(cert);
                newCertInfo = new CertReqInfo(certAlias, keySize, subjectDN, validDays, ksInfo, null);
                if (profileUUID != null) {
                    newCertInfo.setProfileUUID(profileUUID);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.createCertInfoFromCert", "1551");
                if (!tc.isEntryEnabled()) break block6;
                Tr.debug(tc, "Exception encountered while trying to build certificate information for " + certAlias + " certificate exception is " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertInfoFromCert");
        }
        return newCertInfo;
    }

    private void genExpiredSignerList() {
        block8: {
            Locale currentLocale;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "genExpiredSignerList");
            }
            if ((currentLocale = this.getLocale()) == null) {
                currentLocale = Locale.getDefault();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
                }
            }
            try {
                if (this.signerCerts.size() > 0) {
                    for (int i = 0; i < this.signerCerts.size(); ++i) {
                        WSKeyStoreHelper wsksHelper;
                        X509Certificate cert;
                        CertReqInfo certInfo = (CertReqInfo)this.signerCerts.get(i);
                        String certAlias = certInfo.getLabel();
                        KeyStoreInfo ksInfo = certInfo.getKsInfo();
                        String entry = ksInfo.getName() + "|" + ksInfo.getScopeNameString() + "|" + certAlias;
                        if (PersonalCertificateHelper.isCertAlreadyReplaced(entry) || (cert = (wsksHelper = new WSKeyStoreHelper(ksInfo)).getSigner(certAlias)) == null) continue;
                        Date timeOfNotAfter = cert.getNotAfter();
                        String dateExpires = DateFormat.getDateInstance(2, currentLocale).format(timeOfNotAfter);
                        String ksNameString = ksInfo.getName() + "(" + ksInfo.getScopeNameString() + ")";
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.expires.CWPKI0642I", new Object[]{certAlias, ksNameString, dateExpires}, "Signer certificate alias \"" + certAlias + "\" in KeyStore \"" + ksNameString + "\" expires on " + dateExpires, currentLocale);
                        this.noUpdateBuffer.append(this.linesep);
                        this.noUpdateBuffer.append(msg);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.startCertificateExpMonitor", "1624");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception while building signer that can not be replaced: ", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genExpiredSignerList");
        }
    }

    private StringBuffer checkSignerValidity(String alias, X509Certificate cert, StringBuffer expBuffer, boolean isKey, KeyStoreInfo info, String certificateType, boolean issuedByWebSphere, long replacePeriod, long notificationPeriod) {
        Locale currentLocale;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSignerValidity");
        }
        if ((currentLocale = this.getLocale()) == null) {
            currentLocale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
            }
        }
        String linesep = System.getProperty("line.separator");
        String msg = null;
        CertReqInfo certInfo = null;
        Date timeOfNotAfter = cert.getNotAfter();
        Date timeOfNotBefore = cert.getNotBefore();
        long notAfter = timeOfNotAfter.getTime();
        long thresholdStartDate = notAfter - replacePeriod;
        long notificationStartDate = thresholdStartDate - notificationPeriod;
        String ksName = info.getName();
        Boolean readOnly = info.getReadOnly();
        Boolean fileBased = info.getFileBased();
        Date date = new Date(thresholdStartDate);
        String thresholdDate = DateFormat.getDateInstance(2, currentLocale).format(date);
        date = new Date(notificationStartDate);
        String notificationDate = DateFormat.getDateInstance(2, currentLocale).format(date);
        String expiredDate = DateFormat.getDateInstance(2, currentLocale).format(timeOfNotAfter);
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            Tr.debug(tc, "Certificate is expired");
            if (isKey) {
                String ksNameString = ksName + "(" + info.getScopeNameString() + ")";
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.expired.CWPKI0680I", new Object[]{alias, ksNameString, expiredDate}, "Personal certificate alias \"" + alias + "\" in KeyStore \"" + ksNameString + "\" expired on " + expiredDate, currentLocale);
                if ((certificateType.equals("self-signed") || certificateType.equals("chained") && issuedByWebSphere) && !readOnly.booleanValue() && (fileBased.booleanValue() || !fileBased.booleanValue() && this.replaceWritableSaf)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alias " + alias + " in key store " + ksName + " was added to the expired certs list.");
                    }
                    certInfo = this.createCertInfoFromCert(alias, cert, info);
                    this.expiredCerts.add(certInfo);
                } else {
                    this.noUpdateBuffer.append(linesep);
                    this.noUpdateBuffer.append(msg);
                }
                expBuffer.append(linesep);
                expBuffer.append(msg);
            } else {
                if (!readOnly.booleanValue() && fileBased.booleanValue()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alias " + alias + " in key store " + ksName + " was added to the signer certs list.");
                    }
                    certInfo = this.createCertInfoFromCert(alias, cert, info);
                    this.signerCerts.add(certInfo);
                }
                String ksNameString = ksName + "(" + info.getScopeNameString() + ")";
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.expired.CWPKI0679I", new Object[]{alias, ksNameString, expiredDate}, "Signer certificate alias \"" + alias + "\" in KeyStore \"" + ksNameString + "\" expired on " + expiredDate, currentLocale);
                expBuffer.append(linesep);
                expBuffer.append(msg);
            }
        }
        catch (CertificateNotYetValidException e) {
            // empty catch block
        }
        long currentDate = System.currentTimeMillis();
        String dateExpires = DateFormat.getDateInstance(2, currentLocale).format(timeOfNotAfter);
        if (notAfter - currentDate <= replacePeriod) {
            Tr.debug(tc, "Certificate is within the threshold");
            if (isKey) {
                String ksNameString = ksName + "(" + info.getScopeNameString() + ")";
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.expires.CWPKI0643I", new Object[]{alias, ksNameString, dateExpires}, "Personal certificate alias \"" + alias + "\" in KeyStore \"" + ksNameString + "\" expires on " + dateExpires, currentLocale);
                if ((certificateType.equals("self-signed") || certificateType.equals("chained") && issuedByWebSphere) && !readOnly.booleanValue() && (fileBased.booleanValue() || !fileBased.booleanValue() && this.replaceWritableSaf)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alias " + alias + " in key store " + ksName + " was added to the personel certs list.");
                    }
                    certInfo = this.createCertInfoFromCert(alias, cert, info);
                    this.personalCerts.add(certInfo);
                } else {
                    this.noUpdateBuffer.append(linesep);
                    this.noUpdateBuffer.append(msg);
                }
                expBuffer.append(linesep);
                expBuffer.append(msg);
            } else {
                if (!readOnly.booleanValue() && fileBased.booleanValue()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alias " + alias + " in key store " + ksName + " was added to the signerCerts list.");
                    }
                    certInfo = this.createCertInfoFromCert(alias, cert, info);
                    this.signerCerts.add(certInfo);
                }
                String ksNameString = ksName + "(" + info.getScopeNameString() + ")";
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.expires.CWPKI0642I", new Object[]{alias, ksNameString, dateExpires}, "Signer certificate alias \"" + alias + "\" in KeyStore \"" + ksNameString + "\" expires on " + dateExpires, currentLocale);
                expBuffer.append(linesep);
                expBuffer.append(msg);
            }
        } else if (notificationStartDate <= currentDate && currentDate < thresholdStartDate) {
            if (isKey) {
                if (!readOnly.booleanValue() && fileBased.booleanValue() && (certificateType.equals("self-signed") || certificateType.equals("chained") && issuedByWebSphere)) {
                    String ksStringName = ksName + "(" + info.getScopeNameString() + ")";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alias " + alias + " in key store " + ksStringName + " was added to the notification list.");
                    }
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.preNotifyPersonalCert.CWPKI0719I", new Object[]{alias, ksStringName, dateExpires, thresholdDate}, "Personal certificate \"" + alias + "\" in the \"" + ksStringName + "\" key store is due to expire on " + expiredDate + " and can be replaced after the threshold date " + thresholdDate + ".", currentLocale);
                    this.notificationCerts.append(msg);
                    this.notificationCerts.append(linesep);
                }
            } else if (!readOnly.booleanValue() && fileBased.booleanValue()) {
                String ksStringName = ksName + "(" + info.getScopeNameString() + ")";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Alias " + alias + " in key store " + ksStringName + " was added to the notificationSignerCerts list.");
                }
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.preNotifySignerCert.CWPKI0720I", new Object[]{alias, ksStringName, dateExpires, thresholdDate}, "Signer certificate \"" + alias + "\" in the \"" + ksStringName + "\" key store is due to expire on " + expiredDate + " and can be replaced after the threshold date " + thresholdDate + ".", currentLocale);
                this.notificationCerts.append(msg);
                this.notificationCerts.append(linesep);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSignerValidity");
        }
        return expBuffer;
    }

    private void storeRootCertificateDigest(KeyStoreInfo rootKsInfo, KeyStoreInfo rsaRootKeyStoreInfo) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "storeRootCertificateDigest");
            }
            try {
                String rootDigest;
                Certificate[] cert;
                WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(rootKsInfo);
                HashMap personalCertList = wsksHelper.listPersonalCertificates();
                for (String alias : personalCertList.keySet()) {
                    cert = (Certificate[])personalCertList.get(alias);
                    if (cert[0] == null || this.rootSignerDigestCache.contains(rootDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", (X509Certificate)cert[0]))) continue;
                    this.rootSignerDigestCache.add(rootDigest);
                }
                wsksHelper = new WSKeyStoreHelper(rsaRootKeyStoreInfo);
                personalCertList = wsksHelper.listPersonalCertificates();
                for (String alias : personalCertList.keySet()) {
                    cert = (Certificate[])personalCertList.get(alias);
                    if (cert[0] == null || this.rootSignerDigestCache.contains(rootDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", (X509Certificate)cert[0]))) continue;
                    this.rootSignerDigestCache.add(rootDigest);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.WSCertExpMonitor.storeRootCertificateDigest", "1624");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Unable to build the list root certificate digests: ", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeRootCertificateDigest");
        }
    }

    private boolean signedByWebSphere(X509Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signedByWebSphere");
        }
        boolean signedByWebSphere = false;
        String rootDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", cert);
        if (this.rootSignerDigestCache.contains(rootDigest)) {
            signedByWebSphere = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signedByWebSphere");
        }
        return signedByWebSphere;
    }
}

