/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetInheritedSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetInheritedSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String direction = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;

    public GetInheritedSSLConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetInheritedSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "direction: " + this.direction);
            }
            if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.direction.CWPKI0614E", "Direction is not valid.  Should be inbound or outbound.");
                throw new CommandValidationException(msg);
            }
            if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
            String inheritedSSLConfig = this.getInheritedSSLConfig(cs, session, security2, this.scopeName, this.direction);
            result.setResult(inheritedSSLConfig);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private String getInheritedSSLConfig(ConfigService cs, Session session, ObjectName sec2, String scope, String dir) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInheritedSSLConfig");
        }
        Object managementScopeType = null;
        ObjectName sslConfigGrp = null;
        String inheritedString = null;
        ManagementScopeData mgmScopeData = new ManagementScopeData(scope);
        if (mgmScopeData != null) {
            String cellScope;
            String nodeGroupScope;
            String mgmScopeType = mgmScopeData.getScopeType();
            if (mgmScopeType.equalsIgnoreCase("endpoint")) {
                String serverScope = mgmScopeData.formProcessScope();
                sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, serverScope);
                if (sslConfigGrp == null) {
                    String nodeScope;
                    String clusterServerIsIn = null;
                    clusterServerIsIn = this.getServersClusterName(cs, session, mgmScopeData.getProcessName());
                    if (clusterServerIsIn != null) {
                        String clusterScope = mgmScopeData.formCellScope() + ":(cluster):" + clusterServerIsIn;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cluster scope is " + clusterScope);
                        }
                        sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, clusterScope);
                    }
                    if (sslConfigGrp == null && (sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, nodeScope = mgmScopeData.formNodeScope())) == null) {
                        String cellScope2 = mgmScopeData.formCellScope();
                        sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, cellScope2);
                    }
                }
            } else if (mgmScopeType.equalsIgnoreCase("server")) {
                String nodeScope;
                String clusterServerIsIn = null;
                clusterServerIsIn = this.getServersClusterName(cs, session, mgmScopeData.getProcessName());
                if (clusterServerIsIn != null) {
                    String clusterScope = mgmScopeData.formCellScope() + ":(cluster):" + clusterServerIsIn;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cluster scope is " + clusterScope);
                    }
                    sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, clusterScope);
                }
                if (sslConfigGrp == null && (sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, nodeScope = mgmScopeData.formNodeScope())) == null) {
                    String nodeInNodeGroup = null;
                    nodeInNodeGroup = this.getNodeNodeGroup(cs, session, mgmScopeData.getNodeName());
                    if (nodeInNodeGroup != null) {
                        String nodeGroupScope2 = mgmScopeData.formCellScope() + ":(nodeGroup):" + nodeInNodeGroup;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Built node group scope is " + nodeGroupScope2);
                        }
                        sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, nodeGroupScope2);
                    }
                    if (sslConfigGrp == null) {
                        String cellScope3 = mgmScopeData.formCellScope();
                        sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, cellScope3);
                    }
                }
            } else if (mgmScopeType.equalsIgnoreCase("cluster")) {
                String clusterInNodeGroup = null;
                clusterInNodeGroup = this.getClusterNodeGroup(cs, session, mgmScopeData.getClusterName());
                if (clusterInNodeGroup != null) {
                    nodeGroupScope = mgmScopeData.formCellScope() + ":(nodeGroup):" + clusterInNodeGroup;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Built node scope is " + nodeGroupScope);
                    }
                    sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, nodeGroupScope);
                }
                if (sslConfigGrp == null) {
                    cellScope = mgmScopeData.formCellScope();
                    sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, cellScope);
                }
            } else if (mgmScopeType.equalsIgnoreCase("node")) {
                String nodeInNodeGroup = null;
                nodeInNodeGroup = this.getNodeNodeGroup(cs, session, mgmScopeData.getNodeName());
                if (nodeInNodeGroup != null) {
                    nodeGroupScope = mgmScopeData.formCellScope() + ":(nodeGroup):" + nodeInNodeGroup;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Built node scope is " + nodeGroupScope);
                    }
                    sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, nodeGroupScope);
                }
                if (sslConfigGrp == null) {
                    cellScope = mgmScopeData.formCellScope();
                    sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, cellScope);
                }
            } else if (mgmScopeType.equalsIgnoreCase("cell") || mgmScopeType.equalsIgnoreCase("nodeGroup")) {
                String cellScope4 = mgmScopeData.formCellScope();
                sslConfigGrp = this.getSSLConfigGrp(cs, session, sec2, dir, cellScope4);
            }
            if (sslConfigGrp != null) {
                String sslConfigName = null;
                ObjectName sslConfigObj = (ObjectName)cs.getAttribute(session, sslConfigGrp, "sslConfig");
                if (sslConfigObj != null) {
                    sslConfigName = (String)cs.getAttribute(session, sslConfigObj, "alias");
                }
                String alias = (String)cs.getAttribute(session, sslConfigGrp, "certificateAlias");
                inheritedString = new String(sslConfigName + "," + alias);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inherited SSL Config is " + inheritedString);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There seems to be no SSL config group so let's get the default SSL Config");
                }
                SSLConfig defaultSSLConfig = SSLConfigManager.getInstance().getDefaultSSLConfig();
                String sslConfigAlias = defaultSSLConfig.getProperty("com.ibm.ssl.alias");
                inheritedString = new String(sslConfigAlias);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inherited SSL Config is " + inheritedString);
                }
            }
        } else {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
            throw new Exception(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInheritedSSLConfig");
        }
        return inheritedString;
    }

    private ObjectName getSSLConfigGrp(ConfigService cs, Session session, ObjectName secObj, String direction, String scopeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLConfigGrp");
        }
        ObjectName sslConfigGroupName = null;
        CommandHelper commandHelper = new CommandHelper();
        AttributeList queryAttrs = new AttributeList();
        try {
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.DIRECTION, direction);
            sslConfigGroupName = commandHelper.getObjectName(cs, session, secObj, CommandConstants.SSL_CONFIG_GROUPS, queryAttrs, scopeName);
        }
        catch (CommandValidationException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no ssl config group for direction " + direction + " and management scope " + scopeName);
            }
        }
        catch (Exception e) {
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLConfigGrp");
        }
        return sslConfigGroupName;
    }

    private String getServersClusterName(ConfigService cs, Session session, String processName) {
        String clusterName;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServersClusterName");
            }
            clusterName = null;
            try {
                ObjectName[] clusters = cs.resolve(session, "ServerCluster=");
                if (clusters.length > 0) {
                    block2: for (int i = 0; i < clusters.length; ++i) {
                        List members = (List)cs.getAttribute(session, clusters[i], "members");
                        for (AttributeList member : members) {
                            String serverName = (String)ConfigServiceHelper.getAttributeValue(member, "memberName");
                            if (processName.equalsIgnoreCase(serverName)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Server found in cluster");
                                }
                                clusterName = (String)cs.getAttribute(session, clusters[i], "name");
                                continue block2;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "member is null");
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception while trying to find out if the server is in a cluster " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersClusterName");
        }
        return clusterName;
    }

    private String getClusterNodeGroup(ConfigService cs, Session session, String clusterName) {
        String nodeGroupName;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getClusterNodeGroup");
            }
            nodeGroupName = null;
            try {
                ObjectName cluster = cs.resolve(session, "ServerCluster=" + clusterName)[0];
                if (cluster != null) {
                    nodeGroupName = (String)cs.getAttribute(session, cluster, "nodeGroupName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster's node group name is" + nodeGroupName);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster not found");
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception while trying to find out the node group of the cluster " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterNodeGroup");
        }
        return nodeGroupName;
    }

    private String getNodeNodeGroup(ConfigService cs, Session session, String nodeName) {
        String nodeGroupName;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeNodeGroup");
            }
            nodeGroupName = null;
            try {
                ObjectName[] nodeGroups = cs.resolve(session, "NodeGroup=");
                if (nodeGroups.length > 0) {
                    block2: for (int i = 0; i < nodeGroups.length; ++i) {
                        List members = (List)cs.getAttribute(session, nodeGroups[i], "members");
                        for (AttributeList member : members) {
                            String nodeNameInGroup = (String)ConfigServiceHelper.getAttributeValue(member, "nodeName");
                            if (!nodeName.equalsIgnoreCase(nodeNameInGroup)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Node found in nodeGroup");
                            }
                            nodeGroupName = (String)cs.getAttribute(session, nodeGroups[i], "name");
                            continue block2;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception while trying to find out nodeGroup of the node " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeNodeGroup");
        }
        return nodeGroupName;
    }
}

