/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String scopeName = null;
    private String clientKeyAlias = null;
    private String serverKeyAlias = null;
    private String type = null;
    private Boolean clientAuthentication = null;
    private String securityLevel = null;
    private String enabledCiphers = null;
    private String jsseProvider = null;
    private Boolean clientAuthenticationSupported = null;
    private String sslProtocol = null;
    private String trustManagerObjNames = null;
    private String keyManagerName = null;
    private String keyManagerScopeName = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private String trustStoreName = null;
    private String trustStoreScopeName = null;
    private ObjectName scopeObjName = null;
    private ObjectName trustStoreObjName = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName keyManagerObjName = null;
    private boolean createMgmScope = false;
    private List trustManagerObjNameList = null;
    private String keyFileName = null;
    private Integer timeout = null;

    public CreateSSLConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            boolean sslConfigNameFound;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
            this.type = (String)this.getParameter(CommandConstants.TYPE);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.clientKeyAlias = (String)this.getParameter(CommandConstants.CLIENT_KEY_ALIAS);
            this.serverKeyAlias = (String)this.getParameter(CommandConstants.SERVER_KEY_ALIAS);
            this.clientAuthentication = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION);
            this.securityLevel = (String)this.getParameter(CommandConstants.SECURITY_LEVEL);
            this.enabledCiphers = (String)this.getParameter(CommandConstants.ENABLED_CIPHERS);
            this.jsseProvider = (String)this.getParameter(CommandConstants.JSSE_PROVIDER);
            this.clientAuthenticationSupported = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED);
            this.sslProtocol = (String)this.getParameter(CommandConstants.SSL_PROTOCOL);
            this.trustManagerObjNames = (String)this.getParameter(CommandConstants.TRUST_MANAGER_OBJECT_NAMES);
            this.trustStoreName = (String)this.getParameter(CommandConstants.TRUST_STORE_NAME);
            this.trustStoreScopeName = (String)this.getParameter(CommandConstants.TRUST_STORE_SCOPE_NAME);
            this.keyManagerName = (String)this.getParameter(CommandConstants.KEY_MANAGER_NAME);
            this.keyManagerScopeName = (String)this.getParameter(CommandConstants.KEY_MANAGER_SCOPE_NAME);
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE_NAME);
            this.keyFileName = (String)this.getParameter(CommandConstants.SSSL_KEY_RING_NAME);
            this.timeout = (Integer)this.getParameter(CommandConstants.SSSL_V3_TIME_OUT);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig aliasName:  " + this.aliasName);
                Tr.debug(tc, "type:                 " + this.type);
                Tr.debug(tc, "scopeName:            " + this.scopeName);
                Tr.debug(tc, "clientKeyAlias:       " + this.clientKeyAlias);
                Tr.debug(tc, "serverKeyAlias:       " + this.serverKeyAlias);
                Tr.debug(tc, "clientAuthentication: " + this.clientAuthentication);
                Tr.debug(tc, "securityLevel:        " + this.securityLevel);
                Tr.debug(tc, "enabledCiphers:       " + this.enabledCiphers);
                Tr.debug(tc, "jsseProvider:         " + this.jsseProvider);
                Tr.debug(tc, "clientAuthSupported:  " + this.clientAuthenticationSupported);
                Tr.debug(tc, "sslProtocol:          " + this.sslProtocol);
                Tr.debug(tc, "trustManagerObjNames: " + this.trustManagerObjNames);
                Tr.debug(tc, "trustStoreName:       " + this.trustStoreName);
                Tr.debug(tc, "trustStoreScopeName:  " + this.trustStoreScopeName);
                Tr.debug(tc, "keyManagerName:       " + this.keyManagerName);
                Tr.debug(tc, "keyManagerScopeName:  " + this.keyManagerScopeName);
                Tr.debug(tc, "keyStoreName:         " + this.keyStoreName);
                Tr.debug(tc, "keyStoreScopeName:    " + this.keyStoreScopeName);
                Tr.debug(tc, "keyFileName:          " + this.keyFileName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.type != null && !commandHelper.contains(CommandConstants.SSLType, this.type)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.type.CWPKI610E", "SSL type is not valid.  Should be SSSL or JSSE.");
                throw new CommandValidationException(msg);
            }
            if (this.securityLevel != null && !commandHelper.contains(CommandConstants.SSLSecurityLevel, this.securityLevel)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.securityLevel.CWPKI611E", "SSL security level is not valid.  Should be HIGH, MEDIUM, LOW, or CUSTOM.");
                throw new CommandValidationException(msg);
            }
            if (this.sslProtocol != null && !commandHelper.contains(CommandConstants.SSLProtocol, this.sslProtocol)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.protocol.CWPKI612E", "SSL protocol is not valid.  Should be SSL_TLS, SSL, SSLv2, SSLv3, TLS, or TLSv1.");
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            if (this.type.equalsIgnoreCase("SSSL")) {
                if (this.keyFileName == null) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.missing.parameter.CWPKI0676", new Object[]{"ssslKeyRingName"}, "The \"ssslKeyRingName\" parameter is required for System SSL (SSSL) SSL configuration types.");
                    throw new CommandValidationException(msg);
                }
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.aliasName);
                sslConfigNameFound = commandHelper.exists(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, null);
                if (sslConfigNameFound) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.exists.CWPKI0621E", new Object[]{this.aliasName}, this.aliasName + " already exists.");
                    throw new CommandValidationException(msg);
                }
                if (this.timeout != null && (this.timeout < 1 || this.timeout > 86400)) {
                    String msg = TraceNLSHelper.getInstance().getString("ssl.command.timeout.range.CWPKI0683E", "V3 time out range is between 1 and 86400.");
                    throw new CommandValidationException(msg);
                }
            }
            if (this.type.equalsIgnoreCase("JSSE")) {
                String msg;
                boolean inScope;
                AttributeList attrList;
                if (this.keyStoreName == null || this.trustStoreName == null) {
                    String msg2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.missing.parameters.CWPKI0677", new Object[]{"keyStoreName", "trustStoreName"}, "The \"keyStoreName\" and \"trustStoreName\" parameters are required for JSSE SSL configuration types.");
                    throw new CommandValidationException(msg2);
                }
                if (this.scopeName == null) {
                    this.scopeName = commandHelper.defaultCellScope(matches);
                } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                    }
                    String msg3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                    throw new CommandValidationException(msg3);
                }
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.aliasName);
                sslConfigNameFound = commandHelper.exists(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
                if (sslConfigNameFound) {
                    String msg4 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.aliasName, this.scopeName}, this.aliasName + " in the management scope " + this.scopeName + " already exists.");
                    throw new CommandValidationException(msg4);
                }
                if (this.keyManagerScopeName == null) {
                    this.keyManagerScopeName = commandHelper.defaultCellScope(matches);
                }
                if (this.keyStoreScopeName == null) {
                    this.keyStoreScopeName = commandHelper.defaultCellScope(matches);
                }
                if (this.trustStoreScopeName == null) {
                    this.trustStoreScopeName = commandHelper.defaultCellScope(matches);
                }
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
                boolean mgmScopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (!mgmScopeNameFound) {
                    this.createMgmScope = true;
                } else {
                    queryAttrs.clear();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
                    this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scopeObjName: " + this.scopeObjName);
                    }
                }
                if (this.trustManagerObjNames != null) {
                    String[] trustManagers = this.trustManagerObjNames.split(":");
                    this.trustManagerObjNameList = new ArrayList();
                    for (int i = 0; i < trustManagers.length; ++i) {
                        ObjectName trustManagerObjName;
                        if (trustManagers[i] == null) continue;
                        String id = trustManagers[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "trustManagers[i]: " + trustManagers[i]);
                        }
                        if (trustManagers[i].indexOf("(") != -1 && trustManagers[i].indexOf(")") != -1) {
                            id = trustManagers[i].substring(trustManagers[i].indexOf("(") + 1, trustManagers[i].indexOf(")"));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "id: " + id);
                            }
                        }
                        if ((trustManagerObjName = commandHelper.getObjectWithinScope(cs, session, "TrustManager", id, this.scopeName)) == null) continue;
                        this.trustManagerObjNameList.add(trustManagerObjName);
                    }
                }
                if (this.keyManagerName != null) {
                    queryAttrs.clear();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyManagerName);
                    this.keyManagerObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_MANAGERS, queryAttrs, this.keyManagerScopeName);
                    attrList = cs.getAttributes(session, this.keyManagerObjName, null, true);
                    if (attrList != null && !(inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName))) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keyManagerName, this.scopeName}, "Object " + this.keyManagerName + " does not exist within management scope " + this.scopeName);
                        throw new CommandValidationException(msg);
                    }
                }
                if (this.trustStoreName != null) {
                    queryAttrs.clear();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.trustStoreName);
                    this.trustStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.trustStoreScopeName);
                    attrList = cs.getAttributes(session, this.trustStoreObjName, null, true);
                    if (attrList != null && !(inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName))) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.trustStoreName, this.scopeName}, "Object " + this.trustStoreName + " does not exist within management scope " + this.scopeName);
                        throw new CommandValidationException(msg);
                    }
                }
                if (this.keyStoreName != null) {
                    queryAttrs.clear();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
                    this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.keyStoreScopeName);
                    attrList = cs.getAttributes(session, this.keyStoreObjName, null, true);
                    if (attrList != null && !(inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName))) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keyStoreName, this.scopeName}, "Object " + this.keyStoreName + " does not exist within management scope " + this.scopeName);
                        throw new CommandValidationException(msg);
                    }
                    if (this.clientKeyAlias != null || this.serverKeyAlias != null) {
                        String msg5;
                        KeyStore ks = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)this.keyStoreObjName);
                        KeyStoreInfo ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, ks.getName(), ks.getManagementScope().getScopeName());
                        if (this.clientKeyAlias != null && !PersonalCertificateHelper.isAliasInKeyStore(this.clientKeyAlias, ksInfo)) {
                            msg5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.clientKeyAlias, this.keyStoreName}, "Alias " + this.clientKeyAlias + " is not a personal certificate in key store " + this.keyStoreName + ".");
                            throw new CommandValidationException(msg5);
                        }
                        if (this.serverKeyAlias != null && !PersonalCertificateHelper.isAliasInKeyStore(this.serverKeyAlias, ksInfo)) {
                            msg5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.serverKeyAlias, this.keyStoreName}, "Alias " + this.serverKeyAlias + " is not a personal certificate in key store " + this.keyStoreName + ".");
                            throw new CommandValidationException(msg5);
                        }
                    }
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createSSLConfig.validate", "326", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        ObjectName repertoire = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            if (this.type.equalsIgnoreCase("JSSE")) {
                AttributeList attrList = new AttributeList();
                if (this.createMgmScope) {
                    ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                    this.scopeObjName = cs.createConfigData(session, security2, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
                    attrList.clear();
                }
                repertoire = this.createJSSEConfig(cs, session, security2);
            } else if (this.type.equalsIgnoreCase("SSSL")) {
                repertoire = this.createSSSLConfig(cs, session, security2);
            } else {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.type.CWPKI610E", "SSL type is not valid.  Should be SSSL or JSSE.");
                throw new CommandValidationException(msg);
            }
            if (repertoire != null) {
                result.setResult(repertoire);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private ObjectName createJSSEConfig(ConfigService cs, Session session, ObjectName sec2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJSSEConfig");
        }
        ObjectName repertoire = null;
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ALIAS, this.aliasName);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.TYPE, this.type);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
        repertoire = cs.createConfigData(session, sec2, CommandConstants.REPERTOIRE, null, attrList);
        attrList.clear();
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_KEY_ALIAS, this.clientKeyAlias);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SERVER_KEY_ALIAS, this.serverKeyAlias);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_AUTHENTICATION, this.clientAuthentication);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SECURITY_LEVEL, this.securityLevel);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ENABLED_CIPHERS, this.enabledCiphers);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.JSSE_PROVIDER, this.jsseProvider);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED, this.clientAuthenticationSupported);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SSL_PROTOCOL, this.sslProtocol);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.TRUST_MANAGER, this.trustManagerObjNameList);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.TRUST_STORE, this.trustStoreObjName);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_MANAGER, this.keyManagerObjName);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_STORE, this.keyStoreObjName);
        ObjectName setting = cs.createConfigData(session, repertoire, CommandConstants.SETTING, null, attrList);
        this.updateSSLConfigMap(session, repertoire, this.keyStoreObjName, this.trustStoreObjName, this.aliasName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJSSEConfig");
        }
        return repertoire;
    }

    private ObjectName createSSSLConfig(ConfigService cs, Session session, ObjectName sec2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSSSLConfig");
        }
        ObjectName repertoire = null;
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ALIAS, this.aliasName);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.TYPE, this.type);
        repertoire = cs.createConfigData(session, sec2, CommandConstants.REPERTOIRE, null, attrList);
        attrList.clear();
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SSSL_KEY_FILE_NAME, this.keyFileName);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_AUTHENTICATION, this.clientAuthentication);
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SECURITY_LEVEL, this.securityLevel);
        if (this.enabledCiphers != null) {
            String cipherString = SSLConfigManager.getInstance().convertCiphersList(this.enabledCiphers);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ENABLED_CIPHERS, cipherString);
        }
        ObjectName setting = cs.createConfigData(session, repertoire, CommandConstants.SETTING, null, attrList);
        attrList.clear();
        attrList.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.contextProvider"));
        attrList.add(new Attribute(CommandConstants.VALUE, this.jsseProvider));
        cs.createConfigData(session, setting, CommandConstants.PROPERTIES, null, attrList);
        attrList.clear();
        attrList.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.protocol"));
        attrList.add(new Attribute(CommandConstants.VALUE, this.sslProtocol));
        cs.createConfigData(session, setting, CommandConstants.PROPERTIES, null, attrList);
        attrList.clear();
        attrList.add(new Attribute(CommandConstants.NAME, "was.com.ibm.ssl.sys.v3.timeout"));
        attrList.add(new Attribute(CommandConstants.VALUE, this.timeout.toString()));
        cs.createConfigData(session, setting, CommandConstants.PROPERTIES, null, attrList);
        this.updateSSLConfigMap(session, repertoire, null, null, this.aliasName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSSSLConfig");
        }
        return repertoire;
    }

    void updateSSLConfigMap(Session session, ObjectName repertoire, ObjectName keyStoreObj, ObjectName trustStoreObj, String aliasName) throws CommandValidationException {
        boolean reinitialize = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSSLConfigMap: repertoire=" + repertoire + " aliasName=" + aliasName);
        }
        try {
            if (keyStoreObj != null) {
                KeyStore keystore = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)keyStoreObj);
                KeyStoreManager.getInstance().loadWCCMKeyStore(keystore);
            }
            if (trustStoreObj != null) {
                KeyStore truststore = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)trustStoreObj);
                KeyStoreManager.getInstance().loadWCCMKeyStore(truststore);
            }
            com.ibm.websphere.models.config.security.SSLConfig SecurityConfigObject2 = (com.ibm.websphere.models.config.security.SSLConfig)MOFUtil.convertToEObject((Session)session, (ObjectName)repertoire);
            SSLConfig sslConfig = SSLConfigManager.getInstance().parseSSLConfig(SecurityConfigObject2, reinitialize);
            if (sslConfig != null) {
                SSLConfigManager.getInstance().addSSLConfigToMap(aliasName, sslConfig);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createSSLConfig.validate", "659", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSSLConfigMap");
        }
    }
}

