/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySetGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class GenerateKeyForKeySetGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GenerateKeyForKeySetGroup.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keySetGroupName = null;
    private String scopeName = null;
    private Boolean updateRuntime = Boolean.FALSE;
    private Boolean saveConfig = Boolean.FALSE;
    private Boolean isLTPAKeySetGroup = Boolean.FALSE;
    ObjectName keySetGroupObjName = null;
    private KeySetGroup keySetGroup = null;
    protected ObjectName objName = null;

    public GenerateKeyForKeySetGroup(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GenerateKeyForKeySetGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keySetGroupName = (String)this.getParameter(CommandConstants.KEY_SET_GROUP_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_SET_GROUP_SCOPE);
            this.updateRuntime = (Boolean)this.getParameter(CommandConstants.KEY_SET_GROUP_UPDATE_RUNTIME);
            this.saveConfig = (Boolean)this.getParameter(CommandConstants.KEY_SET_GROUP_SAVE_CONFIG);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetGroupName: " + this.keySetGroupName);
                Tr.debug(tc, "keySetGroupScope: " + this.scopeName);
                Tr.debug(tc, "keySetGroupUpdateRuntime: " + this.updateRuntime);
                Tr.debug(tc, "keySetGroupSaveConfig: " + this.saveConfig);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keySetGroupName);
            this.keySetGroupObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_SET_GROUPS, queryAttrs, this.scopeName);
            if (this.keySetGroupObjName == null) {
                String msg = this.keySetGroupObjName + " does not exists.";
                throw new CommandValidationException(msg);
            }
            this.keySetGroup = (KeySetGroup)MOFUtil.convertToEObject((Session)session, (ObjectName)this.keySetGroupObjName);
            queryAttrs.clear();
            AttributeList attrs = cs.getAttributes(session, security2, new String[]{"authMechanisms"}, true);
            ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
            for (AttributeList authMechanism : mechanisms) {
                ObjectName activeKeySetGroupObject;
                KeySetGroup activeKeySetGroup;
                String am = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found auth mechanism of type " + am);
                }
                if (!am.equals("LTPA") || !this.keySetGroupName.equals((activeKeySetGroup = (KeySetGroup)MOFUtil.convertToEObject((Session)session, (ObjectName)(activeKeySetGroupObject = (ObjectName)ConfigServiceHelper.getAttributeValue(authMechanism, "keySetGroup")))).getName())) continue;
                Tr.debug(tc, "KeySetGroup is active LTPA KeySetGroup");
                this.isLTPAKeySetGroup = true;
                break;
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.getKeySet.validate", "132");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            EList keySetList = this.keySetGroup.getKeySet();
            HashMap allKeys = new HashMap();
            for (int i = 0; i < keySetList.size(); ++i) {
                KeySet ref = (KeySet)keySetList.get(i);
                String keySetName = ref.getName();
                String keySetScope = ref.getManagementScope().getScopeName();
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand getUserCmd = commandMgr.createCommand("generateKeyForKeySet");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter(CommandConstants.KEY_SET_NAME, keySetName);
                getUserCmd.setParameter(CommandConstants.KEY_SET_SCOPE, keySetScope);
                getUserCmd.execute();
                CommandResult cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    Map keyMap = (Map)cmdResult.getResult();
                    if (keyMap == null) continue;
                    for (Map.Entry entry : keyMap.entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Updating key map with alias: " + key);
                        }
                        allKeys.put(key, value);
                    }
                    continue;
                }
                throw cmdResult.getException();
            }
            if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                cs.save(session, true);
            }
            if (this.updateRuntime != null && this.updateRuntime.booleanValue() && this.isLTPAKeySetGroup.booleanValue()) {
                this.objName = this.getMBean();
                ObjectName on = new ObjectName("WebSphere:type=SecurityAdmin,*");
                Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                while (it.hasNext()) {
                    try {
                        on = (ObjectName)it.next();
                        if (this.objName.equals(on)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " SecurityAdmin object name = " + on);
                        }
                        AdminServiceFactory.getAdminService().invoke(on, "updateRuntimeKeys", new Object[]{allKeys}, new String[]{"java.util.Map"});
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.beforeStepsExecuted", "271", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception on MBean call.", new Object[]{ex});
                        }
                        throw ex;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SecurityAdmin object name (self) = " + this.objName);
                }
                AdminServiceFactory.getAdminService().invoke(this.objName, "updateRuntimeKeys", new Object[]{allKeys}, new String[]{"java.util.Map"});
            }
            result.setResult(allKeys);
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.beforeStepsExecuted", "285", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{th});
            }
            result.setException(new CommandException(th, "generateKeyForKeySetGroup command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private ObjectName getMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean");
        }
        if (this.objName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting MBean");
            }
            try {
                String processName = AdminServiceFactory.getAdminService().getProcessName();
                this.objName = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                Iterator it = AdminServiceFactory.getAdminService().queryNames(this.objName, null).iterator();
                if (!it.hasNext()) {
                    Tr.error(tc, "security.ctr.nombean.error");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean");
                    }
                    throw new Exception("No SecurityAdmin MBean found: returning null");
                }
                this.objName = (ObjectName)it.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SecurityAdmin object name = " + this.objName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean");
                }
                return this.objName;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.getMBean", "317", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{ex});
                }
                throw ex;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return this.objName;
    }
}

