/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySetGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeySetGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeySetGroup.class, "SSL", "com.ibm.ws.ssl.commands.KeySetGroup");
    private String keySetGroupName = null;
    private Boolean autoGenerate = null;
    private String keySetObjNames = null;
    private String wsScheduleName = null;
    private String scopeName = null;
    private List keySetObjNameList = null;
    private ObjectName wsScheduleObjName = null;
    private ObjectName scopeObjName = null;
    private boolean createMgmScope = false;

    public CreateKeySetGroup(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateKeySetGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keySetGroupName = (String)this.getParameter(CommandConstants.NAME);
            this.autoGenerate = (Boolean)this.getParameter(CommandConstants.AUTO_GENERATE);
            this.keySetObjNames = (String)this.getParameter(CommandConstants.KEY_SET_OBJECT_NAMES);
            this.wsScheduleName = (String)this.getParameter(CommandConstants.WS_SCHEDULE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetGroupName: " + this.keySetGroupName);
                Tr.debug(tc, "autoGenerate: " + (this.autoGenerate == null ? "null" : this.autoGenerate.toString()));
                Tr.debug(tc, "keySetObjNames: " + this.keySetObjNames);
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keySetGroupName);
            boolean keySetGroupNameFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_SET_GROUPS, queryAttrs, this.scopeName);
            if (keySetGroupNameFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keySetGroupName, this.scopeName}, this.keySetGroupName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean mgmScopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (!mgmScopeNameFound) {
                this.createMgmScope = true;
            } else {
                this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            }
            if (this.wsScheduleName != null) {
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.wsScheduleName);
                this.wsScheduleObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.WS_SCHEDULES, queryAttrs, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wsScheduleObjName: " + this.wsScheduleObjName);
                }
            }
            if (this.keySetObjNames != null) {
                String[] keySets = this.keySetObjNames.split(":");
                this.keySetObjNameList = new ArrayList();
                for (int i = 0; i < keySets.length; ++i) {
                    ObjectName keySetObjName;
                    if (keySets[i] == null) continue;
                    String id = keySets[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keySets[i]: " + keySets[i]);
                    }
                    if (keySets[i].indexOf("(") != -1 && keySets[i].indexOf(")") != -1) {
                        id = keySets[i].substring(keySets[i].indexOf("(") + 1, keySets[i].indexOf(")"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "id: " + id);
                        }
                    }
                    if ((keySetObjName = commandHelper.getObjectWithinScope(cs, session, "KeySet", id, this.scopeName)) == null) continue;
                    this.keySetObjNameList.add(keySetObjName);
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.createKeySetGroup.validate", "215");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            if (this.createMgmScope) {
                ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                this.scopeObjName = cs.createConfigData(session, security2, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
                attrList.clear();
            }
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.keySetGroupName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.AUTO_GENERATE, this.autoGenerate);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_SET, this.keySetObjNameList);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            ObjectName keySetGroup = cs.createConfigData(session, security2, CommandConstants.KEY_SET_GROUPS, null, attrList);
            if (keySetGroup != null) {
                result.setResult(keySetGroup);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

