/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.CAClients;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyCAClient
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyCAClient.class, "SSL", "com.ibm.ws.ssl.commands");
    private String caClientName = null;
    private String caClientImplClass = null;
    private String host = null;
    private Integer port = null;
    private String userName = null;
    private String password = null;
    private String baseDN = null;
    private Integer frequencyCheck = null;
    private Integer retryCheck = null;
    private String scopeName = null;
    private String portValue = null;
    private String frequencyCheckValue = null;
    private String retryCheckValue = null;
    private String customProperties = null;
    private ObjectName caClientObjName = null;

    public ModifyCAClient(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyCAClient(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.caClientName = (String)this.getParameter(CommandConstants.CACLIENT_NAME);
            this.caClientImplClass = (String)this.getParameter(CommandConstants.CACLIENT_IMPL_CLASS);
            this.host = (String)this.getParameter(CommandConstants.HOST);
            this.portValue = (String)this.getParameter(CommandConstants.PORT);
            this.userName = (String)this.getParameter(CommandConstants.CA_USER_NAME);
            this.password = (String)this.getParameter(CommandConstants.PASSWORD);
            this.frequencyCheckValue = (String)this.getParameter(CommandConstants.FREQUENCY_CHECK);
            this.retryCheckValue = (String)this.getParameter(CommandConstants.RETRY_CHECK);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.customProperties = (String)this.getParameter("customProperties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caClientName: " + this.caClientName);
                Tr.debug(tc, "caClientImplClass: " + this.caClientImplClass);
                Tr.debug(tc, "host: " + this.host);
                Tr.debug(tc, "port: " + this.port);
                Tr.debug(tc, "userName: " + this.userName);
                Tr.debug(tc, "frequencyCheck: " + this.frequencyCheck);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            if (this.frequencyCheckValue != null && !this.frequencyCheckValue.equals("")) {
                try {
                    this.frequencyCheck = new Integer(this.frequencyCheckValue);
                    if (this.frequencyCheck < 1) {
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.positive.int.CWPKI0697E", new Object[]{"frequencyCheck"}, "frequencyCheck must be a positive integer.");
                        throw new CommandValidationException(msg);
                    }
                }
                catch (NumberFormatException e) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.positive.int.CWPKI0697E", new Object[]{"frequencyCheck"}, "frequencyCheck must be a positive integer.");
                    throw new CommandValidationException(msg);
                }
            }
            if (this.retryCheckValue != null && !this.retryCheckValue.equals("")) {
                try {
                    this.retryCheck = new Integer(this.retryCheckValue);
                    if (this.retryCheck < 1) {
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.positive.int.CWPKI0697E", new Object[]{"retrycheck"}, "retryCheck must be a positive integer.");
                        throw new CommandValidationException(msg);
                    }
                }
                catch (NumberFormatException e) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.positive.int.CWPKI0697E", new Object[]{"retrycheck"}, "retryCheck must be a positive integer.");
                    throw new CommandValidationException(msg);
                }
            }
            if (this.portValue != null && !this.portValue.equals("")) {
                try {
                    this.port = new Integer(this.portValue);
                    if (this.port < 1) {
                        String msg = TraceNLSHelper.getInstance().getString("ssl.command.port.value.CWPKI0700E", "port value is not valid.");
                        throw new CommandValidationException(msg);
                    }
                }
                catch (NumberFormatException e) {
                    String msg = TraceNLSHelper.getInstance().getString("ssl.command.port.value.CWPKI0700E", "port value is not valid.");
                    throw new CommandValidationException(msg);
                }
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultScope();
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.caClientName);
            this.caClientObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.CACLIENTS, queryAttrs, this.scopeName);
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.modifyCAClient.validate", "%c%", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            AttributeList attrList = new AttributeList();
            if (this.host != null && this.host.length() != 0) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.HOST, this.host);
            }
            if (this.portValue != null) {
                if (this.portValue.equals("")) {
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.PORT, null);
                } else {
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.PORT, this.port);
                }
            }
            if (this.userName != null && this.userName.length() != 0) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CACLIENT_USERID, this.userName);
            }
            if (this.password != null && this.password.length() != 0) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.PASSWORD, this.password);
            }
            if (this.caClientImplClass != null && this.caClientImplClass.length() != 0) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CACLIENT_IMPL_CLASS, this.caClientImplClass);
            }
            if (this.frequencyCheckValue != null) {
                if (this.frequencyCheckValue.equals("")) {
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.FREQUENCY_CHECK, null);
                } else {
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.FREQUENCY_CHECK, this.frequencyCheck);
                }
            }
            if (this.retryCheckValue != null) {
                if (this.retryCheckValue.equals("")) {
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.RETRY_CHECK, null);
                } else {
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.RETRY_CHECK, this.retryCheck);
                }
            }
            cs.setAttributes(session, this.caClientObjName, attrList);
            if (this.customProperties != null && !this.customProperties.equals("")) {
                ModifyCAClient.updateCustomProperties(session, cs, this.caClientObjName, this.customProperties);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private static void updateCustomProperties(Session session, ConfigService cs, ObjectName clientObj, String customProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCustomProperties");
        }
        AttributeList attrs = new AttributeList();
        String[] properties = customProps.split(",");
        for (int i = 0; i < properties.length; ++i) {
            AttributeList attributeList = cs.getAttributes(session, clientObj, new String[]{"properties"}, false);
            List caClientProps = (List)((Attribute)attributeList.get(0)).getValue();
            AttributeList attrList = new AttributeList();
            String entry = properties[i];
            ObjectName caClientProperty = null;
            int index = entry.indexOf("=");
            if (index <= 0) continue;
            String name = entry.substring(0, index);
            String value = entry.substring(index + 1);
            attrList.clear();
            attrList.add(new Attribute("name", name));
            attrList.add(new Attribute("value", value));
            if (caClientProps != null) {
                boolean propertySet = false;
                for (int j = 0; j < caClientProps.size(); ++j) {
                    caClientProperty = (ObjectName)caClientProps.get(j);
                    String propName = (String)cs.getAttribute(session, caClientProperty, "name");
                    if (!propName.equals(name)) continue;
                    cs.deleteConfigData(session, caClientProperty);
                    if (value != null && value.length() > 0) {
                        cs.createConfigData(session, clientObj, CommandConstants.PROPERTIES, null, attrList);
                    }
                    propertySet = true;
                    break;
                }
                if (propertySet || value == null || value.length() <= 0) continue;
                cs.createConfigData(session, clientObj, CommandConstants.PROPERTIES, null, attrList);
                continue;
            }
            if (value == null || value.length() <= 0) continue;
            cs.createConfigData(session, clientObj, CommandConstants.PROPERTIES, null, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCustomProperties");
        }
    }
}

