/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.CAClients;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListCAClients
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListCAClients.class, "SSL", "com.ibm.ws.ssl.commands.CAClients");
    private String scopeName = null;
    private Boolean allScopes = null;

    public ListCAClients(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListCAClients(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
        this.allScopes = (Boolean)this.getParameter(CommandConstants.ALL);
        if (this.allScopes == null) {
            this.allScopes = Boolean.FALSE;
        }
        if (this.allScopes.booleanValue()) {
            this.scopeName = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeName: " + this.scopeName);
            Tr.debug(tc, "all: " + this.allScopes);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        ArrayList<AttributeList> listCAClient = new ArrayList<AttributeList>();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null && !this.allScopes.booleanValue()) {
                this.scopeName = commandHelper.defaultScope();
            }
            List caClients = (List)cs.getAttribute(session, security2, CommandConstants.CACLIENTS);
            for (AttributeList caClient : caClients) {
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(caClient), null);
                caClient = commandHelper.fixAttrs(session, cs, caClient);
                if (matches.length == 1) {
                    if (this.scopeName != null) {
                        boolean inScope = commandHelper.withInScope(cs, session, caClient, this.scopeName);
                        if (!inScope) continue;
                        listCAClient.add(caClient);
                        continue;
                    }
                    listCAClient.add(caClient);
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.CACLIENTS, caClient);
            }
            result.setResult(listCAClient);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        this.setCommandResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

