/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.Properties;
import javax.net.ssl.SSLEngine;

public class SSLLinkConfig {
    private static final TraceComponent tc = Tr.register(SSLLinkConfig.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private Properties myConfig = null;

    public SSLLinkConfig(Properties config) {
        this.myConfig = config;
    }

    public boolean getBooleanProperty(String key) {
        return "true".equalsIgnoreCase(this.myConfig.getProperty(key));
    }

    public String getProperty(String key) {
        return this.myConfig.getProperty(key);
    }

    public Properties getProperties() {
        return this.myConfig;
    }

    public String[] getEnabledCipherSuites(SSLEngine sslEngine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnabledCipherSuites");
        }
        String[] ciphers = null;
        Object ciphersObject = this.myConfig.get("com.ibm.ssl.enabledCipherSuites");
        if (null == ciphersObject) {
            String securityLevel = this.myConfig.getProperty("com.ibm.ssl.securityLevel");
            if (null == securityLevel) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Defaulting to HIGH security level");
                }
                securityLevel = "HIGH";
            }
            ciphers = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(sslEngine.getSupportedCipherSuites(), securityLevel);
        } else if (ciphersObject instanceof String) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String: " + ciphersObject);
            }
            ciphers = ((String)ciphersObject).split("\\s");
        } else if (ciphersObject instanceof String[]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String array");
            }
            ciphers = (String[])ciphersObject;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Invalid object for enabledCipherSuites: " + ciphersObject);
        }
        if ((null == ciphers || 0 == ciphers.length) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Unable to find any enabled ciphers");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnabledCipherSuites");
        }
        return ciphers;
    }
}

