/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.ws.ssl.channel.impl.SSLChannelFactory;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLDiscriminatorState;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeErrorTracker;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.OutboundChannel;
import com.ibm.wsspi.channel.OutboundProtocol;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLChannel
implements InboundChannel,
OutboundChannel,
Discriminator {
    private static final TraceComponent tc = Tr.register(SSLChannel.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLChannel";
    public static final String SSL_DISCRIMINATOR_STATE = "SSLDiscState";
    protected DiscriminationProcess discProcess = null;
    protected SSLChannelData sslConfig = null;
    private boolean isInitialized = false;
    protected boolean XD = false;
    protected SSLHandshakeErrorTracker handshakeErrorTracker = null;
    protected String alias = null;
    protected String endPointName = null;
    protected String inboundHost = null;
    protected String inboundPort = null;
    protected JSSEProvider jsseProvider;
    protected ChannelFramework channelFramework = null;
    protected boolean isZOS = false;
    protected boolean isZOSCR = false;
    private SSLSessionContext sessionContext = null;
    private SSLChannelFactory myFactory = null;

    public SSLChannel(ChannelData inputData, SSLChannelFactory factory) throws ChannelException {
        this.sslConfig = new SSLChannelData(inputData);
        this.myFactory = factory;
        this.handshakeErrorTracker = new SSLHandshakeErrorTracker();
        this.channelFramework = inputData.getChannelFramework();
        PlatformHelper osHelper = PlatformHelperFactory.getPlatformHelper();
        if (osHelper != null) {
            this.isZOS = osHelper.isZOS();
            this.isZOSCR = osHelper.isControlJvm();
        }
    }

    public SSLHandshakeErrorTracker getHandshakeErrorTracker() {
        return this.handshakeErrorTracker;
    }

    public void setXD(boolean value) {
        this.XD = value;
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.discProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess dp) {
        this.discProcess = dp;
    }

    public Class<?> getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    public Class<?> getDeviceAddress() {
        return TCPConnectRequestContext.class;
    }

    public Class<?>[] getApplicationAddress() {
        return new Class[]{TCPConnectRequestContext.class};
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        if (!this.isInitialized) {
            try {
                this.init();
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught while getting SSL connection link: " + e);
                }
                FFDCFilter.processException(e, CLASS_NAME, "217", this, new Object[]{vc});
                throw new RuntimeException(e);
            }
        }
        SSLConnectionLink link = new SSLConnectionLink(this);
        link.init(vc);
        return link;
    }

    public SSLContext getSSLContextForInboundLink(SSLConnectionLink link, VirtualConnection vc) throws ChannelException {
        Boolean isZWebContainerChain;
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getSSLContextForInboundLink");
            }
            isZWebContainerChain = Boolean.FALSE;
            if (this.isZOS) {
                try {
                    Class<?> wccFactory = Class.forName("com.ibm.ws.webcontainer.channel.WCChannelFactory");
                    ChainData[] chains = this.channelFramework.getInternalRunningChains(this.getName());
                    if (chains == null) break block9;
                    com.ibm.websphere.channel.framework.ChannelData[] channels = null;
                    for (int i = 0; i < chains.length; ++i) {
                        channels = chains[i].getChannelList();
                        if (!channels[channels.length - 1].getFactoryType().isInstance(wccFactory)) continue;
                        isZWebContainerChain = Boolean.TRUE;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found web container channel in chain " + chains[i].getName());
                        }
                        break;
                    }
                }
                catch (ChannelException ce) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting runtime chain.", (Object)ce);
                    }
                    FFDCFilter.processException(ce, CLASS_NAME, "273", this, new Object[]{vc, this.getName()});
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "The WCChannelFactory class was not found; " + t);
                }
            }
        }
        SSLContext context = this.getSSLContextForLink(vc, this.inboundHost, this.inboundPort, this.endPointName, isZWebContainerChain, link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextForInboundLink");
        }
        return context;
    }

    public SSLContext getSSLContextForOutboundLink(SSLConnectionLink link, VirtualConnection vc, Object address) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContextForOutboundLink");
        }
        TCPConnectRequestContext tcpRequest = (TCPConnectRequestContext)address;
        InetSocketAddress socket = tcpRequest.getRemoteAddress();
        String protocol = "HTTP";
        String mapProtocol = (String)vc.getStateMap().get("protocol");
        if (mapProtocol != null) {
            protocol = mapProtocol;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutboundProtocol=" + protocol + " specified by in VC");
            }
        } else {
            Object channelAccessor = ((OutboundVirtualConnection)vc).getChannelAccessor();
            if (channelAccessor instanceof OutboundProtocol) {
                protocol = ((OutboundProtocol)channelAccessor).getProtocol();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OutboundProtocol=" + protocol + " specified by " + channelAccessor.getClass().getName());
                }
            }
        }
        SSLContext context = this.getSSLContextForLink(vc, socket.getHostName(), Integer.toString(socket.getPort()), protocol, Boolean.FALSE, link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextForOutboundLink");
        }
        return context;
    }

    protected SSLContext getSSLContextForLink(VirtualConnection vc, String host, String port, String endPoint, Boolean isZWebContainerChain, SSLConnectionLink link) throws ChannelException {
        String sslType;
        boolean useJSSEHelper;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "host=" + host + " port=" + port + " endPoint=" + endPoint);
        }
        String direction = this.getConfig().isInbound() ? "inbound" : "outbound";
        final HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("com.ibm.ssl.direction", direction);
        connectionInfo.put("com.ibm.ssl.remoteHost", host);
        connectionInfo.put("com.ibm.ssl.remotePort", port);
        connectionInfo.put("com.ibm.ssl.endPointName", endPoint);
        if (this.isZOS && this.getConfig().isInbound()) {
            Properties threadInfo = new Properties();
            Object remoteAddress = vc.getStateMap().get("REMOTE_ADDRESS");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "REMOTE_ADDRESS = " + remoteAddress + " isZWebContainerChain = " + isZWebContainerChain);
            }
            if (remoteAddress != null) {
                threadInfo.put("com.ibm.ssl.certMappingHost", remoteAddress);
            } else {
                Exception e = new Exception("REMOTE_ADDRESS was not found in the VC state map.  Z channel should put it there.");
                FFDCFilter.processException(e, CLASS_NAME, "380", this, new Object[]{vc});
            }
            threadInfo.put("com.ibm.ssl.isWebContainerInbound", isZWebContainerChain);
            if (endPoint != null) {
                threadInfo.put("com.ibm.ssl.endPointName", endPoint);
            }
            JSSEHelper.getInstance().setInboundConnectionInfo(threadInfo);
            connectionInfo.put("com.ibm.ssl.isWebContainerInbound", isZWebContainerChain);
        }
        Properties props = null;
        boolean bl = useJSSEHelper = null != this.alias;
        if (!useJSSEHelper) {
            block32: {
                try {
                    props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                        @Override
                        public Properties run() throws Exception {
                            return JSSEHelper.getInstance().getSSLPropertiesOnThread();
                        }
                    });
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block32;
                    Tr.debug(tc, "Caught exception looking for on-thread props; e=" + e);
                }
            }
            if (null == props || 0 == props.size()) {
                props = null;
                useJSSEHelper = !this.getConfig().getProperties().containsKey("com.ibm.ssl.keyStore") || !this.getConfig().getProperties().containsKey("com.ibm.ssl.trustStore");
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found on-thread ssl properties");
            }
        }
        if (useJSSEHelper) {
            try {
                final String aliasFinal = this.alias;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Querying security service for alias=[" + aliasFinal + "]");
                }
                props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                    @Override
                    public Properties run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(aliasFinal, connectionInfo, null);
                    }
                });
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting SSL properties from alias: " + this.alias);
                }
                throw new ChannelException((Throwable)e);
            }
        }
        if (null != props) {
            Enumeration<?> names = this.getConfig().getProperties().propertyNames();
            String key = null;
            String value = null;
            while (names.hasMoreElements()) {
                key = (String)names.nextElement();
                value = this.getConfig().getStringProperty(key);
                if (null == value || props.containsKey(key)) continue;
                props.put(key, value);
            }
        } else {
            props = this.getConfig().getProperties();
        }
        if (null != (sslType = (String)props.get("com.ibm.ssl.sslType"))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig type: " + sslType);
            }
            if (sslType.equals("SSSL")) {
                throw new ChannelException("Invalid SSLConfig type: " + sslType);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL configuration <null value means non-string>:");
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                if (-1 == key.toLowerCase().indexOf("password")) {
                    Tr.debug(tc, "\t" + key + " = " + value);
                    continue;
                }
                StringBuilder output = new StringBuilder(4 + key.length() + value.length());
                output.append("\t").append(key).append(" = ");
                for (int i = 0; i < value.length(); ++i) {
                    output.append("*");
                }
                Tr.debug(tc, output.toString());
            }
        }
        SSLContext context = null;
        try {
            SSLConfig config = new SSLConfig(props);
            context = this.jsseProvider.getSSLContext(connectionInfo, config);
            SSLLinkConfig linkConfig = new SSLLinkConfig(props);
            if (null == link) {
                vc.getStateMap().put("SSLLINKCONFIG", linkConfig);
            } else {
                link.setLinkConfig(linkConfig);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLContext from properties.", new Object[]{e});
            }
            throw new ChannelException((Throwable)e);
        }
        return context;
    }

    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            if (this.getConfig().isInbound()) {
                ChainData chainData = this.channelFramework.getInternalRunningChains(this.getConfig().getName())[0];
                ChannelData channelData = (ChannelData)chainData.getChannelList()[0];
                Map channelProperties = channelData.getPropertyBag();
                this.inboundHost = (String)channelProperties.get("hostname");
                this.inboundPort = (String)channelProperties.get("port");
                this.endPointName = (String)channelProperties.get("endPointName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "inboundHost = " + this.inboundHost + " inboundPort = " + this.inboundPort + " endPointName = " + this.endPointName);
                }
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during start, throwing up stack.  " + e);
            }
            throw new ChannelException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop(long millisec) throws ChannelException {
    }

    public void init() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (this.isInitialized) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "init");
            }
            return;
        }
        try {
            Properties channelProps = this.getConfig().getProperties();
            if (channelProps != null) {
                this.alias = channelProps.getProperty("alias");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (this.alias != null) {
                        Tr.debug(tc, "Found alias in SSL properties, " + this.alias);
                    } else {
                        Tr.debug(tc, "No alias found in SSL properties");
                    }
                }
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "init received exception handling properties; " + e);
            }
            throw new ChannelException((Throwable)e);
        }
        this.jsseProvider = JSSEProviderFactory.getInstance("IBMJSSE");
        if (this.jsseProvider == null) {
            this.jsseProvider = JSSEProviderFactory.getInstance("SunJSSE");
            if (null == this.jsseProvider) {
                String message = "Unable to get an instance of the JSSEProvider";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, message);
                }
                throw new ChannelException(message);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Have a valid jsseProvider; " + this.jsseProvider);
        }
        this.isInitialized = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void destroy() throws ChannelException {
        if (null != this.myFactory && null != this.getConfig()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing channel from factory; " + this.getConfig().getName());
            }
            this.myFactory.destroyChannel(this.getConfig().getName());
            this.myFactory = null;
        }
        this.discProcess = null;
        this.sslConfig = null;
        this.sessionContext = null;
    }

    public String getName() {
        return this.sslConfig.getName();
    }

    public Class<?> getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public Class<?> getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public void update(ChannelData inputData) {
        this.sslConfig.updateChannelData(inputData);
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        SSLDiscriminatorState discState;
        int result;
        SSLEngineResult sslResult;
        SSLContext vcSSLContext;
        SSLEngine sslEngine;
        Map stateMap;
        WsByteBuffer decryptedNetBuffer;
        int initialNetBufLimit;
        int initialNetBufPosition;
        WsByteBuffer netBuffer;
        block36: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "discriminate");
            }
            if (discrimData == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received null discrim data.  Returning NO from discriminator.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "discriminate");
                }
                return 0;
            }
            netBuffer = ((WsByteBuffer[])discrimData)[0];
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "netBuffer: " + SSLUtils.getBufferTraceInfo(netBuffer));
            }
            if (0 == netBuffer.position()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received empty discrim data.  Returning MAYBE from discriminator.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "discriminate");
                }
                return -1;
            }
            if (!this.isInitialized) {
                try {
                    this.init();
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught while getting SSL connection link: " + e);
                    }
                    FFDCFilter.processException(e, CLASS_NAME, "724", this, new Object[]{vc});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "discriminate");
                    }
                    return 0;
                }
            }
            initialNetBufPosition = netBuffer.position();
            initialNetBufLimit = netBuffer.limit();
            decryptedNetBuffer = null;
            stateMap = vc.getStateMap();
            sslEngine = null;
            vcSSLContext = null;
            sslResult = null;
            result = 1;
            discState = null;
            try {
                netBuffer.flip();
                discState = (SSLDiscriminatorState)stateMap.get(SSL_DISCRIMINATOR_STATE);
                if (discState == null) {
                    vcSSLContext = this.getSSLContextForInboundLink(null, vc);
                    sslEngine = SSLUtils.getSSLEngine(vcSSLContext, FlowType.INBOUND, (SSLLinkConfig)vc.getStateMap().get("SSLLINKCONFIG"));
                    decryptedNetBuffer = SSLUtils.allocateByteBuffer(sslEngine.getSession().getApplicationBufferSize(), this.getConfig().getDecryptBuffersDirect());
                } else {
                    sslEngine = discState.getEngine();
                    vcSSLContext = discState.getSSLContext();
                    decryptedNetBuffer = discState.getDecryptedNetBuffer();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecNetBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer));
                }
                int savedLimit = SSLUtils.adjustBufferForJSSE(netBuffer, sslEngine.getSession().getPacketBufferSize());
                sslResult = sslEngine.unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                if (0 < sslResult.bytesProduced()) {
                    decryptedNetBuffer.flip();
                }
                if (-1 != savedLimit) {
                    netBuffer.limit(savedLimit);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecNetBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)sslResult.getStatus()) + " HSstatus=" + (Object)((Object)sslResult.getHandshakeStatus()) + " consumed=" + sslResult.bytesConsumed() + " produced=" + sslResult.bytesProduced());
                }
                if (sslResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    result = -1;
                } else {
                    result = 1;
                    if (netBuffer.remaining() == 0) {
                        netBuffer.clear();
                    }
                }
            }
            catch (Exception e) {
                result = 0;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block36;
                Tr.debug(tc, "Caught Exception during discriminate: " + e);
            }
        }
        switch (result) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminator returning YES");
                }
                if (discState == null) {
                    discState = new SSLDiscriminatorState();
                }
                discState.updateState(vcSSLContext, sslEngine, sslResult, decryptedNetBuffer, netBuffer.position(), netBuffer.limit());
                stateMap.put(SSL_DISCRIMINATOR_STATE, discState);
                break;
            }
            case 0: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminator returning NO");
                }
                if (discState != null) {
                    stateMap.remove(SSL_DISCRIMINATOR_STATE);
                }
                if (null != sslEngine) {
                    this.closeEngine(sslEngine);
                }
                if (null == decryptedNetBuffer) break;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Releasing decryptedNetworkBuffer");
                }
                decryptedNetBuffer.release();
                decryptedNetBuffer = null;
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminator returning MAYBE");
                }
                if (discState != null) break;
                discState = new SSLDiscriminatorState();
                discState.updateState(vcSSLContext, sslEngine, sslResult, decryptedNetBuffer, netBuffer.position(), netBuffer.limit());
                stateMap.put(SSL_DISCRIMINATOR_STATE, discState);
            }
        }
        netBuffer.limit(initialNetBufLimit);
        netBuffer.position(initialNetBufPosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "discriminate");
        }
        return result;
    }

    public void cleanUpState(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUpState");
        }
        SSLDiscriminatorState discState = (SSLDiscriminatorState)vc.getStateMap().remove(SSL_DISCRIMINATOR_STATE);
        this.closeEngine(discState.getEngine());
        WsByteBuffer decryptedNetBuffer = discState.getDecryptedNetBuffer();
        if (decryptedNetBuffer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing decryptedNetworkBuffer");
            }
            decryptedNetBuffer.release();
            decryptedNetBuffer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUpState");
        }
    }

    protected void onHandshakeFinish(SSLEngine engine2) {
        SSLSessionContext context = null;
        try {
            final SSLEngine localEngine = engine2;
            context = AccessController.doPrivileged(new PrivilegedExceptionAction<SSLSessionContext>(){

                @Override
                public SSLSessionContext run() throws Exception {
                    return localEngine.getSession().getSessionContext();
                }
            });
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.channel.impl.SSLChannel.onHandshakeFinish", "953");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception querying sessioncontext; " + e);
            }
            return;
        }
        if (null == context || context.equals(this.sessionContext)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Channel [" + this + "] saving context: " + context);
        }
        this.sessionContext = context;
        context.setSessionCacheSize(this.getConfig().getSSLSessionCacheSize());
        context.setSessionTimeout(this.getConfig().getSSLSessionTimeout());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Session cache size set to " + context.getSessionCacheSize());
            Tr.debug(tc, "Session timeout set to " + context.getSessionTimeout());
        }
    }

    private void closeEngine(SSLEngine engine2) {
        block5: {
            if (null != engine2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closing discrimination engine");
                }
                engine2.closeOutbound();
                if (!engine2.isInboundDone()) {
                    try {
                        engine2.closeInbound();
                    }
                    catch (SSLException se) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                        Tr.event(tc, "Error closing inbound engine side; " + se);
                    }
                }
            }
        }
    }

    public Class<?> getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.sslConfig.getWeight();
    }

    public SSLChannelData getConfig() {
        return this.sslConfig;
    }
}

