/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.template.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.impl.TemplateImpl;
import com.ibm.ws.sm.workspace.template.impl.TemplateMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class TemplateManagerImpl
implements TemplateManager,
TemplateMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(TemplateManagerImpl.class);
    private String templateRootURI = "templates";
    private RepositoryContext templateRoot = null;
    private RefObjectHelper refObjectHelper = null;
    private WorkSpace workSpace = null;
    private HashMap templateMap = null;

    public static TemplateManagerImpl getManager(WorkSpace workSpace) {
        return new TemplateManagerImpl(workSpace);
    }

    public TemplateManagerImpl(WorkSpace workSpace) {
        this.workSpace = workSpace;
        this.refObjectHelper = RefObjectHelperFactory.getRefObjectHelper();
        this.templateMap = new HashMap();
    }

    public RefObjectHelper getRefObjectHelper() {
        return this.refObjectHelper;
    }

    public RepositoryContext getRootTemplateContext() throws WorkSpaceException {
        if (this.templateRoot == null) {
            this.templateRoot = this.workSpace.findContext(this.templateRootURI);
        }
        return this.templateRoot;
    }

    public Collection getTemplates(RepositoryContextType type) throws WorkSpaceException {
        Tr.entry(tc, "getTemplates", new Object[]{type.getName()});
        Collection contexts = this.getTemplateContext(type);
        ArrayList<Template> templates = new ArrayList<Template>();
        for (RepositoryContext context : contexts) {
            templates.add(this.getTemplate(context));
        }
        Tr.exit(tc, "getTemplates");
        return templates;
    }

    public Template getTemplate(RepositoryContext context) throws WorkSpaceException {
        Tr.entry(tc, "getTemplate", new Object[]{context.getURI()});
        String uri = context.getURI();
        Template template = (Template)this.templateMap.get(uri);
        if (template == null) {
            template = new TemplateImpl(context);
            this.templateMap.put(uri, template);
        }
        Tr.exit(tc, "getTemplate");
        return template;
    }

    public RepositoryContext createContext(RepositoryContext parentContext, String name, Template template, HashMap data) throws WorkSpaceException {
        Tr.entry(tc, "createContext", new Object[]{parentContext.getURI(), name, template.getName(), data});
        RepositoryContext newContext = parentContext.create(template.getType(), name);
        List files = template.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            this.createFile(newContext, (String)files.get(i), template, data);
        }
        Tr.exit(tc, "createContext");
        return newContext;
    }

    public void copyContext(RepositoryContext context, Template template, HashMap data) throws WorkSpaceException {
        Tr.entry(tc, "copyContext", new Object[]{context.getURI(), template.getName(), data});
        List files = template.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            this.createFile(context, (String)files.get(i), template, data);
        }
        Tr.exit(tc, "copyContext");
    }

    public void createFile(RepositoryContext context, String uri, Template template, HashMap data) throws WorkSpaceException {
        this.copyFile(context, uri, template, data);
    }

    public Collection getTemplateObjects(RepositoryContext templateContext, String uri, String mofType) throws WorkSpaceException {
        Tr.entry(tc, "getTemplateObjects", new Object[]{templateContext.getURI(), uri, mofType});
        try {
            EList extent = templateContext.getResourceSet().getResource(URI.createURI(uri), true).getContents();
            ArrayList<EObject> result = new ArrayList<EObject>();
            for (EObject refO : extent) {
                if (!refO.eClass().getName().endsWith(mofType)) continue;
                result.add(refO);
            }
            Tr.exit(tc, "getTemplateObjects");
            return result;
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, "WKSP1000 Error load extent of {0}--{1}.", new Object[]{uri, e}, e);
        }
    }

    private void copyFile(RepositoryContext context, String uri, Template template, HashMap data) throws WorkSpaceException {
        Tr.entry(tc, "copyFile", new Object[]{context.getURI(), template.getName(), data});
        try {
            OutputStream os2 = context.getOutputStream(uri);
            RepositoryContext templateContext = template.getContext();
            WorkSpaceFile src = templateContext.getFile(uri);
            if (src == null) {
                throw WorkSpaceLogger.createException(tc, "WKSP1006 Error copying source file {0} from template {1} to context {2}.  Call stack: {3}.", new Object[]{uri, template, context, this.getCallStack()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type of the file", src.getType());
            }
            if (src.getType() == null) {
                int nbytes;
                os2 = new BufferedOutputStream(os2);
                BufferedInputStream is = new BufferedInputStream(templateContext.getInputStream(uri));
                int MAXBYTES = 2048;
                byte[] buf = new byte[MAXBYTES];
                while ((nbytes = ((InputStream)is).read(buf, 0, MAXBYTES)) != -1) {
                    os2.write(buf, 0, nbytes);
                }
                ((InputStream)is).close();
            } else {
                os2.write(this.getConvertedContentBytes(template, uri, data));
            }
            os2.flush();
            os2.close();
            Tr.exit(tc, "copyFile");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] getConvertedContentBytes(Template template, String uri, HashMap data) throws WorkSpaceException {
        byte[] result;
        Tr.entry(tc, "getConvertedContent", new Object[]{template.getName(), uri, data});
        if (data == null || data.size() == 0) {
            result = ((TemplateImpl)template).getContentBytes(uri);
        } else {
            String content = ((TemplateImpl)template).getContent(uri);
            for (String token : data.keySet()) {
                String value = (String)data.get(token);
                int index = content.indexOf(token);
                while (index != -1) {
                    content = content.substring(0, index) + value + content.substring(index + token.length());
                    index = content.indexOf(token, index + token.length());
                }
            }
            result = content.getBytes();
        }
        Tr.exit(tc, "getConvertedContent", result);
        return result;
    }

    private Collection getTemplateContext(RepositoryContextType type) throws WorkSpaceException {
        return this.getRootTemplateContext().findContext(type);
    }

    private String getCallStack() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        String callStack = "";
        for (int i = 0; i < ste.length; ++i) {
            callStack = callStack + "    " + ste[i] + "\n";
        }
        return callStack;
    }
}

