/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.migration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public final class WSURIConverter
extends URIConverterImpl {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WSURIConverter.class);
    private RepositoryContext context;
    private URI baseURI;
    FileAccessor fa = null;

    public WSURIConverter(RepositoryContext context) {
        this.context = context;
        this.baseURI = URI.createURI(context.getURI());
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        this.fa = ws.getFileAccessor();
    }

    public URI normalize(URI uri) {
        return URI.createURI(this.baseURI.toString() + "/" + uri.toString());
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        URI converted = this.normalize(uri);
        this.checkExtracted(uri);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createOutputStream", converted.toString());
        }
        return FileAccessorUtil.getOutputStream(this.fa, converted.toString());
    }

    public InputStream createInputStream(URI uri) throws IOException {
        URI converted = this.normalize(uri);
        this.checkExtracted(uri);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createInputStream", converted.toString());
        }
        return FileAccessorUtil.getInputStream(this.fa, converted.toString());
    }

    private void checkExtracted(URI uri) throws IOException {
        String fileName = uri.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "file " + fileName);
        }
        if (this.context.isAvailable(fileName) && !this.context.isExtracted(fileName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file is not exists,but not extracted " + fileName);
            }
            try {
                this.context.extract(fileName, false);
            }
            catch (WorkSpaceException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

