/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.metadata.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryDocumentTypeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RepositoryContextTypeImpl
implements RepositoryContextType {
    protected static TraceComponent tc = WorkSpaceLogger.registerTC(RepositoryContextTypeImpl.class);
    protected String name = "";
    protected String dirName = null;
    protected String handlerClassName = null;
    protected List childContextTypes = null;
    protected List childContextTypeNames = new ArrayList();
    protected List documentTypes = null;
    protected List documentTypeNames = new ArrayList();
    protected RepositoryDocumentType rootDocumentType = null;
    protected String rootDocumentTypeName = null;
    protected RepositoryMetaData metaData = null;
    private transient HashMap reachableChildTypes = new HashMap();

    RepositoryContextTypeImpl(RepositoryMetaData metaData) {
        this.metaData = metaData;
    }

    public RepositoryDocumentType getRootDocumentType() {
        if (this.rootDocumentType == null && this.rootDocumentTypeName != null) {
            this.rootDocumentType = this.metaData.getDocumentType(this.rootDocumentTypeName);
            if (this.rootDocumentType == null) {
                this.rootDocumentTypeName = null;
            }
        }
        return this.rootDocumentType;
    }

    void setRootDocumentTypeName(String rootDocumentTypeName) {
        this.rootDocumentTypeName = rootDocumentTypeName;
    }

    public RepositoryContextType getChildContextType(String name) {
        RepositoryContextType type = this.metaData.getContextType(name);
        if (type != null && !this.getChildContextTypes().contains(type)) {
            type = null;
        }
        return type;
    }

    void addChildContextTypeName(String childContextTypeName) {
        this.childContextTypeNames.add(childContextTypeName);
    }

    public List getChildContextTypes() {
        if (this.childContextTypes == null) {
            this.childContextTypes = new ArrayList();
            for (int i = 0; i < this.childContextTypeNames.size(); ++i) {
                RepositoryContextType type = this.metaData.getContextType((String)this.childContextTypeNames.get(i));
                if (type != null) {
                    this.childContextTypes.add(type);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Child context is null: " + (String)this.childContextTypeNames.get(i));
            }
        }
        return this.childContextTypes;
    }

    public RepositoryDocumentType getChildDocumentType(String filePattern) {
        for (RepositoryDocumentTypeImpl rdt : this.getChildDocumentTypes()) {
            if (!rdt.matches(filePattern)) continue;
            return rdt;
        }
        return null;
    }

    public List getChildDocumentTypes() {
        if (this.documentTypes == null) {
            this.documentTypes = new ArrayList();
            for (int i = 0; i < this.documentTypeNames.size(); ++i) {
                RepositoryDocumentType type = this.metaData.getDocumentType((String)this.documentTypeNames.get(i));
                if (type != null) {
                    this.documentTypes.add(type);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Child doc is null: " + (String)this.documentTypeNames.get(i));
            }
        }
        return this.documentTypes;
    }

    void addDocumentTypeName(String documentTypeName) {
        this.documentTypeNames.add(documentTypeName);
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getDirectoryName() {
        if (this.dirName == null && this.name != null) {
            this.dirName = this.name;
        }
        return this.dirName;
    }

    void setDirectoryName(String dirName) {
        this.dirName = dirName;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    void setHandlerClassName(String handlerClassName) {
        this.handlerClassName = handlerClassName;
    }

    public Set findReachableChildrenTo(String type) {
        HashSet<RepositoryContextType> result = (HashSet<RepositoryContextType>)this.reachableChildTypes.get(type);
        if (result == null) {
            result = new HashSet<RepositoryContextType>();
            List childTypes = this.getChildContextTypes();
            for (RepositoryContextType childType : childTypes) {
                if (!childType.getName().equals(type) && childType.findReachableChildrenTo(type).isEmpty() || childType.getName().equals("config")) continue;
                result.add(childType);
            }
            this.reachableChildTypes.put(type, result);
        }
        return result;
    }
}

